#include "Rscan.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"

#include "RTE_CAN.h"
#include "CAN_Communication_Matrix.h"
#include "CAN_Lib.h"
//#include "CAN_Signal_Tx.h"
#include "AlarmGeneralFilie.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"

#include "PowerManagement.h"
#include "UDS_Common.h"

#include "Watchdog.h"

static uint16_t Can_Init_Lock = 0U;

void Can_Lock_Clr(void)
{
    Can_Init_Lock = 0u;
}

/***Middle***/
void Can_Init(void)
{
    /* filter 变量声明 */
    uint32_t IDFilterNum;

    uint8_t CH0_IDFilterNum;
    uint32_t CANLLCCh0NMIDRange[2];
    uint32_t CANLLCCh0MsgIDList[ID_TOTAL_MAX + 2u];
    uint32_t CANLLCCh0OwnIDList[4];

    uint32_t i;
    CANFD_Filter_Init_st_t CANLLCCh0Filter;
    if (Can_Init_Lock != 0x55AAu)
    {
        /* Sys_Startup_Init */
        /*50304*/
        /* Channel0 Filter Data */

        for (i = 2u; i < (ID_TOTAL_MAX + 2u); i++)
        {
            CANLLCCh0MsgIDList[i] = CAN_MSG_CONST_ARRAY[i - 2].MSG_Identifier;
        }

        /* Channel0 Filter Data configeration */


        CH0_IDFilterNum = 24;

        IDFilterNum = (uint32_t)(CH0_IDFilterNum & 0xFFUL);
        IDFilterNum |= (uint32_t)((0 & 0xFFUL) << 8U);
        IDFilterNum |= (uint32_t)((0 & 0xFFUL) << 16U);

        CANLLCCh0Filter.pfCAN0DataIndCb = Can_Read_Msg;
        CANLLCCh0Filter.pfCAN0DataConfirmCb = Can_Confirm;

        CANLLCCh0Filter.pfCAN1DataIndCb = (void *)0;
        CANLLCCh0Filter.pfCAN1DataConfirmCb = (void *)0;

        CANLLCCh0Filter.pfCAN2DataIndCb = (void *)0;
        CANLLCCh0Filter.pfCAN2DataConfirmCb = (void *)0;

        CANLLCCh0Filter.CH0_Enable = 1u;
        CANLLCCh0Filter.CH1_Enable = 0u;
        CANLLCCh0Filter.CH2_Enable = 0u;

        CANLLCCh0Filter.CH0_Std_Ext = 0u;
        CANLLCCh0Filter.CH1_Std_Ext = 0u;
        CANLLCCh0Filter.CH2_Std_Ext = 0u;

        CANSTB_OUT = 0U; //CANSTB_OUT
        RSCAN0_CH_Init(&CANLLCCh0Filter, IDFilterNum);
        Can_Init_Lock = 0x55AAu;
    }
    CANSTB_OUT = 0U; //CANSTB_OUT
}

void Can_DeInit(void)
{
}

uint8_t Can_Write(_CAN_Msg *Msg)
{
    switch (Msg->MsgPro)
    {
    case 0:
        RSCAN0_SendCH0_TxBuf0(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 1:
        RSCAN0_SendCH0_TxBuf1(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 2:
        RSCAN0_SendCH0_TxBuf2(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 3:
        RSCAN0_SendCH0_TxBuf3(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 4:
        RSCAN0_SendCH0_TxBuf4(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 5:
        RSCAN0_SendCH0_TxBuf5(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 6:
        RSCAN0_SendCH0_TxBuf6(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 7:
        RSCAN0_SendCH0_TxBuf7(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 8:
        RSCAN0_SendCH0_TxBuf8(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 9:
        RSCAN0_SendCH0_TxBuf9(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 10:
        RSCAN0_SendCH0_TxBuf10(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 11:
        RSCAN0_SendCH0_TxBuf11(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 12:
        RSCAN0_SendCH0_TxBuf12(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 13:
        RSCAN0_SendCH0_TxBuf13(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 14:
        RSCAN0_SendCH0_TxBuf14(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    case 15:
        RSCAN0_SendCH0_TxBuf15(Msg->MsgID, Msg->MsgDLC, Msg->MsgStd, Msg->Msg);
        break;
    default:
        CAN_CH0_Data_Request(Msg->MsgID, Msg->MsgStd, Msg->MsgRTR, Msg->MsgDLC, Msg->Msg);
        break;
    }
    return 0;
}

void Can_Sleep_Fun(void)
{
}

void Can_SleepController_Fun(void)
{
}

void Can_Wakeup_Fun(void)
{
}

void Can_Uds_Abort(void)
{
    CANFD_SetTX_Abort();
}

void Can_Abort_All(void)
{
}

/*****Lower*******/
void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[])
{
    ReceivedMsg(m_id, m_dlc);

    Co_Can_Buff_Set(Co_Can_ConvertSubID(m_id), m_dlc, m_Msg);

    if ((m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY))
    {
        DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    }
}

void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
}


void CAN_BUSOFF_Recover(void)
{
    CH0_BusOff_Recovery();
}
