#ifndef SERVICE_MILEAGE_H
#define SERVICE_MILEAGE_H

/*
Platform_32Bit
Platform_16Bit
*/

#ifdef Platform_16Bit
    #define Millib_uint8_t  unsigned char
    #define Millib_uint16_t unsigned int
    #define Millib_uint32_t unsigned long

#else
    #define Millib_uint8_t  unsigned char
    #define Millib_uint16_t unsigned short
    #define Millib_uint32_t unsigned int
    #define Millib_uint64_t unsigned long long
#endif

#ifndef Millib_NULL
  #define Millib_NULL       (void *)0u
#endif /* NULL */

typedef enum
{
    EM_TRIP_A,
    EM_TRIP_B,
    EM_TRIP_JY,
    EM_TRIP_RY,
    EM_TRIP_BSX,
    EM_TRIP_CSQ,
    EM_TRIP_KQGZJ,
    EM_TRIP_DLZX,
    EM_TRIP_LT,

    EM_TRIP_MAX,
} DataTripEnum_t;

typedef enum
{
    EM_MILEAGE_BLOCK = 0u,
    EM_ODO_BLOCK,
    EM_TRIP_BLOCK,
    EM_Maintenance_BLOCK,
} Data_EEPROM_Enum_t;

typedef void (*EEPromWrite)(Data_EEPROM_Enum_t BlockID, Millib_uint32_t u32Data[], Millib_uint16_t u16Len);

typedef struct
{
    Millib_uint8_t (*Get_Sys_IG_Sts)(void);
    Millib_uint8_t (*Get_Act_V_Speed_Valid)(void);
    Millib_uint16_t (*Get_Act_V_Speed)(void);
    Millib_uint16_t (*Get_TireSize)(void);
    EEPromWrite     EEPromWrite_Cbk;
}Mileage_Func_t;

typedef struct
{
    Millib_uint32_t Mileage;
}Mileage_Init_t;

typedef struct
{
    Millib_uint32_t Stamp;
    Millib_uint32_t Offset;
}ODO_Init_t;

typedef struct
{
    Millib_uint32_t Stamp;
    Millib_uint32_t MaxValue;
    Millib_uint8_t  IsRestart;
}Trip_Init_t;

#define Data_MEM_Block_Mileage          ((Millib_uint8_t)12u)
#define Data_MEM_Block_ODO              ((Millib_uint8_t)12u)
#define Data_MEM_Block_Trip             ((Millib_uint8_t)16u)
/*
total size =Tel_MEM_Block_Size*LED_Max+Tel_MEM_Block_Addition
*/

void Data_Mileage_KL30_Init(Millib_uint8_t *pMemSpace, Mileage_Init_t *pInitData, Mileage_Func_t *pFunc);
void Data_Mileage_Wakeup_Init(Millib_uint8_t *pMemSpace, Mileage_Func_t *pFunc);
void Data_Mileage_ISR(void);
Millib_uint32_t Data_Mileage_Read(void);
Millib_uint8_t Data_Mileage_Write(Millib_uint32_t NewMileage);
void Data_Mileage_Clear(void);
void Data_Mileage_Write_EEPROM(void);

void Data_ODO_KL30_Init(Millib_uint8_t *pMemSpace, ODO_Init_t *pInitData, EEPromWrite Func);
void Data_ODO_Wakeup_Init(Millib_uint8_t *pMemSpace, EEPromWrite Func);
void Data_ODO_Processing ( void );
Millib_uint32_t Data_ODO_Read ( void );
Millib_uint32_t Data_Offset_Read ( void );
void Data_ODO_Modify ( Millib_uint32_t Offset );
void Data_ODO_Clear ( void );

void Data_Trip_KL30_Init(Millib_uint8_t *pMemSpace, Trip_Init_t *pInitData, Millib_uint8_t TotalTrip, EEPromWrite pFunc);
void Data_Trip_Wakeup_Init(Millib_uint8_t *pMemSpace, Millib_uint8_t TotalTrip, EEPromWrite pFunc);
void Data_Trip_Processing ( void );
void Data_Clear_Trip ( DataTripEnum_t TripN );
Millib_uint32_t Data_Read_Trip(DataTripEnum_t TripN);

#endif
