
#include "Key.h"
#include "Menu.h"
#include "Services_ODO_User.h"

#include "DisplaySch_user.h"
#include "Sound_Scheduler.h"
#include "System_Monitor.h"
#include "RTE_ADC.h"

#include "CAN_Communication_Matrix.h"
#include "GUI.h"

/*-------------------------------------------------------*/
/*无车速限制值*/
#define DISPSPEEDNULLMAX   66

/*----------按键具体功能执行的回调函数-----------------------*/


void Key_Operation_Enter(Key_Event_en_t enKeyEvent);
void Key_Operation_Return(Key_Event_en_t enKeyEvent);
void Key_Operation_Up(Key_Event_en_t enKeyEvent);
void Key_Operation_Down(Key_Event_en_t enKeyEvent);
void Key_Operation_Menu(Key_Event_en_t enKeyEvent);

Key_IGN_en_t Key_Get_IGN_Status(void);

struct
{
    /* data */
    uint8_t Up ;
    uint8_t Down ;
    uint8_t Enter ;
    uint8_t Menu ;
    uint8_t Return ;

} KeyTest;

/*******************************UP***********************************************
  Function： Key_Operation_Up
  Description：
  Input:
  Output:
 *******************************UP***********************************************/
void Key_Operation_Up(Key_Event_en_t enKeyEvent)
{
    uint8_t CanStatus1 = 0u;
    uint16_t DispVSpeed = 0u;
    KeyTest.Up ++ ;
    HMI_Set_KEY_UP(enKeyEvent);

    DispVSpeed =  Common_Get_Disp_V_Speed();
    CanStatus1 = CAN_MSG_Status(ID_CanMsg0CF00400_Msg_Count);

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
            /*主界面 一级菜单 二级菜单那*/
            if (((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_6_MENU_2)) ||
                    ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
            {
                /*故障码*/
                if ((CanStatus1 == CAN_SIG_LOST) && (bCurMenuIDX == _MN_DSP_LEVEL2MENU_2))
                {
                    NextMenu(_MN_DSP_LEVEL2MENU_1);
                }
                else
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_UP);
                }
            }
            /*保养通知设定 更换机油&机油滤清器*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_1)
            {
                if (User_set_Num.User_FDJYLQQ == (uint32_t)K_Line_Set.K_Line_LID4F * 1000u)
                    User_set_Num.User_FDJYLQQ = 0u ;
            }
            /*保养通知设定 更换燃油滤清器*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_2)
            {
                if (User_set_Num.User_RYLQQ == (uint32_t)K_Line_User_RYLQQ * 1000u)
                    User_set_Num.User_RYLQQ = 0u ;
            }
            /*保养通知设定 更换变速箱油*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_3)
            {
                if (User_set_Num.User_BSXY == (uint32_t)K_Line_Set.K_Line_LID4A * 1000u)
                    User_set_Num.User_BSXY = 0u;
            }
            /*保养通知设定 更换差速器右*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_4)
            {
                if (User_set_Num.User_CSQY == (uint32_t)K_Line_Set.K_Line_LID4B * 1000u)
                    User_set_Num.User_CSQY = 0u ;
            }
            /*保养通知设定 更换动力转向油*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_6)
            {
                if (User_set_Num.User_DLZXY == (uint32_t)K_Line_Set.K_Line_LID4D * 1000u)
                    User_set_Num.User_DLZXY = 0u ;
            }
            /*保养通知设定 轮胎换位.更换*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_7)
            {
                if (User_set_Num.User_LT == (uint32_t)K_Line_Set.K_Line_LID4E * 1000u)
                    User_set_Num.User_LT = 0u ;
            }
            /*设置日期-年*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_11)
            {
                User_set_Num.Year ++;

                if ( User_set_Num.Year > 99u)
                {
                    User_set_Num.Year = 0u;
                }
            }
            /*设置日期-月*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_12)
            {
                User_set_Num.Month++;

                if (User_set_Num.Month > 12u)
                {
                    User_set_Num.Month = 1u;
                }
            }
            /*设置日期-日*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_13)
            {
                User_set_Num.Date++;

                switch (User_set_Num.Month)
                {
                case 1:
                case 3:
                case 5:
                case 7:
                case 8:
                case 10:
                case 12:
                    if (User_set_Num.Date > 31u)
                    {
                        User_set_Num.Date = 1u;
                    }
                    break;
                case 4:
                case 6:
                case 9:
                case 11:
                    if (User_set_Num.Date > 30u)
                    {
                        User_set_Num.Date = 1u;
                    }
                    break;
                case 2:
                    if (((User_set_Num.Year % 4u == 0u) && (User_set_Num.Year % 100 != 0u)) || (User_set_Num.Year % 400u == 0u))
                    {
                        User_set_Num.LeapYear = 1u;
                    }
                    else
                    {
                        User_set_Num.LeapYear = 0u;
                    }

                    if (User_set_Num.LeapYear)
                    {
                        if (User_set_Num.Date > 29u)
                        {
                            User_set_Num.Date = 1u;
                        }
                    }
                    else
                    {
                        if (User_set_Num.Date > 28u)
                        {
                            User_set_Num.Date = 1u;
                        }
                    }
                    break;
                default:
                    break;
                }
            }
            /*设置时间-时*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_21)
            {
                User_set_Num.Hour++ ;

                if (User_set_Num.Hour > 23u)
                {
                    User_set_Num.Hour = 0u ;
                }
            }
            /*设置时间-分*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_22)
            {
                User_set_Num.Minute++;

                if (User_set_Num.Minute > 59u)
                {
                    User_set_Num.Minute = 0u ;
                }
            }
            /*语言设置 ----反*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_3)
            {
                if (User_set_Num.User_Language > 0u)
                    User_set_Num.User_Language-- ;
            }

        }
    }
    else
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
        }
    }
}

/*******************************DOWN***********************************************
  Function： Key_Operation_Down
  Description：
  Input:
  Output:
 *******************************DOWN***********************************************/
void Key_Operation_Down(Key_Event_en_t enKeyEvent)
{
    uint16_t DispVSpeed = 0u;
    KeyTest.Down ++ ;
    HMI_Set_KEY_DOWN(enKeyEvent);
    DispVSpeed =  Common_Get_Disp_V_Speed();

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
            /*主界面 一级菜单 二级菜单*/
            if (((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_6_MENU_2)) ||
                    ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
            {
                NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_DOWN);
            }
            /*保养通知设定 更换机油&机油滤清器*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_1)
            {
                if (User_set_Num.User_FDJYLQQ == 0u )
                    User_set_Num.User_FDJYLQQ = (uint32_t)K_Line_Set.K_Line_LID4F * 1000u ;
            }
            /*保养通知设定 更换燃油滤清器*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_2)
            {
                if (User_set_Num.User_RYLQQ == 0u )
                    User_set_Num.User_RYLQQ = (uint32_t)K_Line_User_RYLQQ * 1000u ;
            }
            /*保养通知设定 更换变速箱油*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_3)
            {
                if (User_set_Num.User_BSXY == 0u )
                    User_set_Num.User_BSXY = (uint32_t)K_Line_Set.K_Line_LID4A * 1000u ;
            }
            /*保养通知设定 更换差速器油*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_4)
            {
                if (User_set_Num.User_CSQY == 0u )
                    User_set_Num.User_CSQY = (uint32_t)K_Line_Set.K_Line_LID4B * 1000u ;
            }
            /*保养通知设定 更换动力转向液*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_6)
            {
                if (User_set_Num.User_DLZXY == 0u )
                    User_set_Num.User_DLZXY = (uint32_t)K_Line_Set.K_Line_LID4D * 1000u ;
            }
            /*保养通知设定 轮胎换位.更换*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_7)
            {
                if (User_set_Num.User_LT == 0u )
                    User_set_Num.User_LT = (uint32_t)K_Line_Set.K_Line_LID4E * 1000u ;
            }
            /*设置日期-年*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_11)
            {
                if ( User_set_Num.Year > 0u)
                {
                    User_set_Num.Year--;
                }
                else
                {
                    User_set_Num.Year = 99u;
                }
            }
            /*设置日期-月*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_12)
            {
                if (User_set_Num.Month > 1u)
                {
                    User_set_Num.Month--;
                }
                else
                {
                    User_set_Num.Month = 12u;
                }
            }
            /*设置日期-日*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_13)
            {
                User_set_Num.Date--;
                switch (User_set_Num.Month)
                {
                case 1:
                case 3:
                case 5:
                case 7:
                case 8:
                case 10:
                case 12:
                    if (User_set_Num.Date < 1u)
                    {
                        User_set_Num.Date = 31u;
                    }
                    break;
                case 4:
                case 6:
                case 9:
                case 11:
                    if (User_set_Num.Date < 1u)
                    {
                        User_set_Num.Date = 30u;
                    }
                    break;
                case 2:
                    if (((User_set_Num.Year % 4u == 0u) && (User_set_Num.Year % 100u != 0u)) || (User_set_Num.Year % 400u == 0u))
                    {
                        User_set_Num.LeapYear = 1u;
                    }
                    else
                    {
                        User_set_Num.LeapYear = 0u;
                    }

                    if (User_set_Num.LeapYear)
                    {
                        if (User_set_Num.Date < 1u)
                        {
                            User_set_Num.Date = 29u;
                        }
                    }
                    else
                    {
                        if (User_set_Num.Date < 1u)
                        {
                            User_set_Num.Date = 28u;
                        }
                    }
                    break;
                default:
                    break;
                }
            }
            /*设置时间-时*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_21)
            {
                if (User_set_Num.Hour > 0u)
                {
                    User_set_Num.Hour--;
                }
                else
                {
                    User_set_Num.Hour = 23u ;
                }
            }
            /*设置时间-分*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_22)
            {
                if (User_set_Num.Minute > 0u)
                {
                    User_set_Num.Minute-- ;
                }
                else
                {
                    User_set_Num.Minute = 59u ;
                }
            }
            /*语言设置 ----反*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_3)
            {
                if (User_set_Num.User_Language < 1 )
                    User_set_Num.User_Language++ ;
            }

        }
    }
    else
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
        }
    }
}
/*******************************ENTER***********************************************
  Function： Key_Operation_Enter
  Description：
  Input:
  Output:
 *******************************ENTER***********************************************/
void Key_Operation_Enter(Key_Event_en_t enKeyEvent)
{
    uint16_t DispVSpeed = 0u;
    KeyTest.Enter ++ ;
    HMI_Set_KEY_CONFIRM(enKeyEvent);

    DispVSpeed =  Common_Get_Disp_V_Speed();

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
            if (((bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_6_MENU_2)) ||
                    ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
            {
                NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
            }
            else if (((bCurMenuIDX >= _MN_DSP_LEVEL3_3_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_3)) ||
                     ((bCurMenuIDX >= _MN_DSP_LEVEL4_4_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL4_4_MENU_7)))
            {
                MenuFlag.Menu_Return = 1u;
                NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
            }
            /*轮胎匹配界面*/
            else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_5)
            {

            }
            /*Go Return*/
            else if (bCurMenuIDX == _MN_DSP_ENTER_MENU)
            {
                MenuFlag.Menu_Return = 1;
                NextMenu(_MN_DSP_RETURN_MENU);
            }
        }
        else if (enKeyEvent == KEY_EVENT_LONG_PRESS)
        {
            /*Go Enter*/
            if ((bCurMenuIDX >= _MN_DSP_LEVEL3_2_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL3_2_MENU_8))
            {
                MenuFlag.Menu_Enter_Return = bCurMenuIDX ;
                NextMenu(_MN_DSP_ENTER_MENU);
            }
        }
    }
    else
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
        }
        else if (enKeyEvent == KEY_EVENT_LONG_PRESS)
        {
        }
    }
}

/*******************************RETURN***********************************************
  Function： Key_Operation_Return
  Description：
  Input:
  Output:
 *******************************RETURN***********************************************/
void Key_Operation_Return(Key_Event_en_t enKeyEvent)
{
    uint16_t DispVSpeed = 0u;
    KeyTest.Return ++ ;
    HMI_Set_KEY_CANCEL(enKeyEvent);
    DispVSpeed =  Common_Get_Disp_V_Speed();

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
            if ((bCurMenuIDX >= _MN_DSP_LEVEL2_1_MENU_1) && (bCurMenuIDX < _MN_DSP_ENTER_MENU))
            {
                if (
                    ( bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_3 ) ||                                            /*语言设定*/
                    ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41 ) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47))  /*省油设定子菜单*/
                )
                {
                    MenuFlag.Menu_Return = 0;
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                }
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_5 )                /*胎压设置界面返回操作*/
                {
                    if (User_set_Num.User_TpmsStatus != 2)                      /*不是正在匹配状态*/
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                    }
                    else
                    {
                        User_set_Num.User_TpmsStatus  = 1;                      /*退出匹配界面*/
                        if (User_set_Num.User_Temp_Return == 0)
                        {
                            User_set_Num.User_Temp_Return = 1;                    /*取消配对标记*/
                            User_set_Num.User_TpmsSend = 3;                       /*报文外发次数*/
                        }
                        else
                        {
                            ; /* do nonthing*/
                        }
                    }
                }
                else
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                }
            }
            /*Enter Go*/
            else if (bCurMenuIDX == _MN_DSP_ENTER_MENU)
            {
                MenuFlag.Menu_Return = 0;
                NextMenu(MenuFlag.Menu_Enter_Return);
            }
            else
            {
                ;/*do nothing*/
            }
        }
    }
    else
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
        }
    }
}

/*******************************Menu***********************************************
  Function： Key_Operation_Menu
  Description：
  Input:
  Output:
 *******************************Menu***********************************************/
void Key_Operation_Menu(Key_Event_en_t enKeyEvent)
{
    uint8_t CanStatus1 = 0u;
    uint16_t DispVSpeed = 0u;
    KeyTest.Menu ++ ;

    HMI_Set_KEY_MENU(enKeyEvent);
    DispVSpeed =  Common_Get_Disp_V_Speed();

    CanStatus1 = CAN_MSG_Status(ID_CanMsg0CF00400_Msg_Count);

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
            /*记录进入menu菜单的位置*/
            if ((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL1MENU_6))
            {
                MenuFlag.Menu_Flag =  bCurMenuIDX;

                /*有故障码*/
                if (CanStatus1 == CAN_SIG_LOST)
                {
                    NextMenu(_MN_DSP_LEVEL2MENU_1);
                }
                /*无故障码*/
                else
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                }
            }
            /*无论从哪里都能回去*/
            else if ((bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1) && (bCurMenuIDX <= _MN_DSP_RETURN_MENU))
            {
                //if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_A) /*胎压设置界面*/
                //{
                //    NextMenu(_MN_DSP_LEVEL2MENU_4);           /*menu回到用户设置界面*/
                //}
                //else
                {
                    NextMenu(MenuFlag.Menu_Flag);
                }
            }
        }
    }
    else
    {
        if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
        {
        }
    }
}



/*------------读按键实时状态的回调函数-------------------------------------------*/
Key_Real_Status_en_t Key_Real_Status_Read_Enter(void);
Key_Real_Status_en_t Key_Real_Status_Read_Return(void);
Key_Real_Status_en_t Key_Real_Status_Read_Up(void);
Key_Real_Status_en_t Key_Real_Status_Read_Down(void);
Key_Real_Status_en_t Key_Real_Status_Read_Menu(void) ;
/*-------------------------------------------------*/

//Menu_R   = 24000*470 / (24000 + 470) =  460.97Ω
//Enter_R  = 24000*6800 / (24000 + 6800) =  5298.7Ω
//Return_R = 24000*15000 / (24000 + 15000) =  9230.77Ω
//Up_R     = 24000*1200 / (24000 + 1200) =  1142.86Ω
//Down_R   = 24000*3300 / (24000 + 3300) =  2901.1Ω

//Menu_R   = 16000*470 / (16000 + 470) =  456.59Ω
//Enter_R  = 16000*6800 / (16000 + 6800) =  4771.9Ω
//Return_R = 16000*15000 / (16000 + 15000) =  7741.94Ω
//Up_R     = 16000*1200 / (16000 + 1200) =  1116.28Ω
//Down_R   = 16000*3300 / (16000 + 3300) =  2736Ω

//实际按键测试
//无操作     21000~24000Ω
//Menu_R        640~680Ω
//Enter_R       5300~5700Ω
//Return_R      9000~9500Ω
//Up_R          1300~1400Ω
//Down_R        3000~3200Ω


/*上*/
Key_Real_Status_en_t Key_Real_Status_Read_Up(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
    }
    else
    {
        if ((Key_R >= (1200 - 400)) && (Key_R <= (1200 + 400)))
        {
            enKeyRealStatus = KEY_LINE_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_LINE_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*下*/
Key_Real_Status_en_t Key_Real_Status_Read_Down(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
    }
    else
    {
        if ((Key_R >= (2700 - 400)) && (Key_R <= (2700 + 400)))
        {
            enKeyRealStatus = KEY_LINE_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_LINE_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*Enter*/
Key_Real_Status_en_t Key_Real_Status_Read_Enter(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
    }
    else
    {
        if ((Key_R >= (4800 - 400)) && (Key_R <= (5000 + 400)))
        {
            enKeyRealStatus = KEY_LINE_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_LINE_LOOSEN;
        }
    }
    return enKeyRealStatus;
}

/*Return*/
Key_Real_Status_en_t Key_Real_Status_Read_Return(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
    }
    else
    {
        if ((Key_R >= (8000 - 400)) && (Key_R <= (8000 + 400)))
        {
            enKeyRealStatus = KEY_LINE_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_LINE_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*Menu*/
Key_Real_Status_en_t Key_Real_Status_Read_Menu(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
    }
    else
    {
        if ((Key_R >= (550 - 300)) && (Key_R <= (550 + 300)))
        {
            enKeyRealStatus = KEY_LINE_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_LINE_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Up, Key_Operation_Up},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Down, Key_Operation_Down},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Enter, Key_Operation_Enter},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Return, Key_Operation_Return},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Menu, Key_Operation_Menu},
};

Key_IGN_en_t Key_Get_IGN_Status(void)
{
    Key_IGN_en_t ret = KEY_IG_INVALID;
    if (SYS_OPR_STAT_IGN_ON)
    {
        ret = KEY_IG_ON;
    }
    else
    {
        ret = KEY_IG_OFF;
    }
    return ret;
}
