#include "Data_Voltmeter.h"
#include "RTE_ADC.h"
#include "GaugesInterface.h"
//-------------------------------------------
//电压计数据处理
//-------------------------------------------
//区域5显示逻辑
//-------------------------------------------
//344 - 3.4.2.2电压计显示画面
//-------------------------------------------
static struct
{
    uint8_t SumCnt ;
    uint32_t ActVoltage ;
    uint8_t Timer ;
    uint8_t Gui_Voltmeter ;
    uint8_t Valid ;
    uint16_t AvrVoltage ;
} VoltmeterVariable ;

static void Data_Voltmeter_2_Gui(void);
static uint16_t Get_VoltFilter(void);
static
/*-------------------------------------------------------------------------
 * Function Name  : Voltmeter_KL30_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Voltmeter_KL30_Init(void)
{
    VoltmeterVariable.SumCnt = 0 ;
    VoltmeterVariable.ActVoltage = 0 ;
    VoltmeterVariable.AvrVoltage = 0 ;
    VoltmeterVariable.Timer = 0 ;
    VoltmeterVariable.Gui_Voltmeter = 0 ;
    VoltmeterVariable.Valid = 0 ;
}
void Voltmeter_KL15_ON_Init(void)
{

}
void Voltmeter_KL15_OFF_Init(void)
{

}
void Voltmeter_Wakeup_Init(void)
{

}
void Voltmeter_Sleep_Init(void)
{

}
/*-------------------------------------------------------------------------
 * Function Name  : Voltmeter_Processing_Service
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Voltmeter_Processing_Service(void)
{
    Data_Voltmeter_2_Gui();
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_VoltFilter
 * Description    : 电压滤波
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static uint16_t Get_VoltFilter(void)
{
    uint8_t Valid = 0 ;
    uint16_t Voltage = 0 ;
    Valid = RTE_Read_KL30_Valid() ;
    if (Valid)
    {
        Voltage = (uint16_t)RTE_Read_KL30_Voltage();
        if (VoltmeterVariable.SumCnt < 10u)
        {
            VoltmeterVariable.ActVoltage += Voltage;
            VoltmeterVariable.SumCnt += 1u;
            Voltage = (uint16_t)(VoltmeterVariable.ActVoltage / VoltmeterVariable.SumCnt);
        }
        else
        {
            VoltmeterVariable.SumCnt = 0u;
            VoltmeterVariable.ActVoltage = 0u;
            VoltmeterVariable.ActVoltage += Voltage;
            VoltmeterVariable.SumCnt += 1u;
            Voltage = (uint16_t) (VoltmeterVariable.ActVoltage / VoltmeterVariable.SumCnt);
        }
    }

    return Voltage ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Data_Voltmeter_2_Gui
 * Description    : 电压计逻辑处理
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static void Data_Voltmeter_2_Gui(void)
{
    static uint8_t u8GuiMode = 0 ;

    VoltmeterVariable.AvrVoltage = Get_VoltFilter();
    VoltmeterVariable.AvrVoltage += 800u;/*增加二极管压降补偿*/


    if ((VoltmeterVariable.AvrVoltage >= 17000u) && (VoltmeterVariable.AvrVoltage <= 30500u))
    {
        VoltmeterVariable.Valid = 1 ;
        VoltmeterVariable.Timer = 0 ;
    }
    else
    {
        //检测出范围以外数据时的处理
        if (VoltmeterVariable.Timer < (2000 / 20))
        {
            //未到2sec前保持原图像
            VoltmeterVariable.Timer ++ ;
        }
        else
        {
            VoltmeterVariable.Valid = 0 ;
        }
    }

    if (VoltmeterVariable.Valid)
    {
        SetGaugesPara(VoltGauges, VoltmeterVariable.AvrVoltage);
        u8GuiMode = GetGaugesCurrentPos(VoltGauges);
    }
    else
    {

    }

    VoltmeterVariable.Gui_Voltmeter = u8GuiMode ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_Voltmeter_AvrVoltage
 * Description    : 平均电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint16_t Get_Voltmeter_AvrVoltage(void)
{
    uint16_t u16Result = 0 ;
    u16Result = VoltmeterVariable.AvrVoltage ;
    return u16Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_Voltmeter_DisplayMode
 * Description    : 电压计线段数
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint8_t Gui_Get_Voltmeter_DisplayMode(void)
{
    uint8_t u8Result = 0 ;
    u8Result = VoltmeterVariable.Gui_Voltmeter ;
    return u8Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_Voltmeter_Valid
 * Description    : 有效？
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint8_t Get_Voltmeter_Valid(void)
{
    uint8_t u8Result = 0 ;
    u8Result = VoltmeterVariable.Valid ;
    return u8Result ;
}





