#include "Data_ADAS.h"
#include "CAN_Communication_Matrix.h"
//-------------------------------------------
//ADAS数据处理 wangboyu
//-------------------------------------------
//区域4显示逻辑
//-------------------------------------------
//344 - 3.3 ADAS显示区域 
//-------------------------------------------

static struct
{
	uint8_t Gui_WorkshopScope ;
	uint8_t Gui_LDWS_Left ;
	uint8_t Gui_LDWS_Right ;
}ADASVariable ;

static void Data_WorkshopScope_2_Gui(void);
static void Data_LDWS_2_Gui(void);
/*-------------------------------------------------------------------------
 * Function Name  : ADAS_KL30_Init
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void ADAS_KL30_Init(void)
{
	ADASVariable.Gui_WorkshopScope = 0 ;
	ADASVariable.Gui_LDWS_Left = 0 ;
	ADASVariable.Gui_LDWS_Right = 0 ;	
}
void ADAS_KL15_ON_Init(void)
{

}
void ADAS_KL15_OFF_Init(void)
{

}
void ADAS_Wakeup_Init(void)
{

}
void ADAS_Sleep_Init(void)
{

}
/*-------------------------------------------------------------------------
 * Function Name  : ADAS_Processing_Service
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void ADAS_Processing_Service(void)
{
	Data_WorkshopScope_2_Gui();
	Data_LDWS_2_Gui();	
}
/*-------------------------------------------------------------------------
 * Function Name  : Data_WorkshopScope_2_Gui
 * Description    : 车间范围逻辑处理
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static void Data_WorkshopScope_2_Gui(void)
{
	uint8_t u8GuiMode = 0 ;
	
	uint8_t Msg_A1_AEBSS = 0 ;
	uint8_t Msg_2A_AEBSS = 0 ;
	uint8_t Msg_A0_AEBSS = 0 ;
	
	uint8_t Msg_A1_Ro_AEBSS = 0 ;
	uint8_t Msg_2A_Ro_AEBSS = 0 ;
	uint8_t Msg_A0_Ro_AEBSS = 0 ;
	
	Msg_A1_AEBSS = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();//Byte1,Bit1‐4
	Msg_2A_AEBSS = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();//Byte1,Bit1‐4
	Msg_A0_AEBSS = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();//Byte1,Bit1‐4
	
	Msg_A1_Ro_AEBSS = Get_ID_CF02FA1_Sig_Relevant_objected_for_AEBS();//Byte2,Bit1‐3
	Msg_2A_Ro_AEBSS = Get_ID_CF02F2A_Sig_Relevant_objected_for_AEBS();//Byte2,Bit1‐3
	Msg_A0_Ro_AEBSS = Get_ID_CF02FA0_Sig_Relevant_objected_for_AEBS();//Byte2,Bit1‐3
		
	if(Msg_A1_AEBSS == 0x01 || Msg_A1_AEBSS == 0x02 || Msg_A1_AEBSS == 0x0C || Msg_A1_AEBSS == 0x0F ||\
	   Msg_2A_AEBSS == 0x01 || Msg_2A_AEBSS == 0x02 || Msg_2A_AEBSS == 0x0C || Msg_2A_AEBSS == 0x0F ||\
	   Msg_A0_AEBSS == 0x01 || Msg_A0_AEBSS == 0x02 || Msg_A0_AEBSS == 0x0C || Msg_A0_AEBSS == 0x0F)  \
    {
	    u8GuiMode = 0 ;
    }
	
	if(Msg_A1_AEBSS == 0x00 || Msg_A1_AEBSS == 0x04 ||\
	   Msg_2A_AEBSS == 0x00 || Msg_2A_AEBSS == 0x04 ||\
	   Msg_A0_AEBSS == 0x00 || Msg_A0_AEBSS == 0x04   \
	   )
	{
		u8GuiMode = 1 ;
	}
	
	if(((Msg_A1_AEBSS == 0x03)&&(Msg_A1_Ro_AEBSS == 0x00 || Msg_A1_Ro_AEBSS == 0x02))|| \
	   ((Msg_2A_AEBSS == 0x03)&&(Msg_2A_Ro_AEBSS == 0x00 || Msg_2A_Ro_AEBSS == 0x02))|| \
	   ((Msg_A0_AEBSS == 0x03)&&(Msg_A0_Ro_AEBSS == 0x00 || Msg_A0_Ro_AEBSS == 0x02))   \
	  )
	{
		u8GuiMode = 2 ;
	}
	
	if((Msg_A1_AEBSS == 0x03 && Msg_A1_Ro_AEBSS == 0x01)|| \
	   (Msg_2A_AEBSS == 0x03 && Msg_2A_Ro_AEBSS == 0x01)|| \
	   (Msg_A0_AEBSS == 0x03 && Msg_A0_Ro_AEBSS == 0x01)   \
	  )
	{
		u8GuiMode = 3 ;
	}
	   
	ADASVariable.Gui_WorkshopScope = u8GuiMode ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Data_LDWS_2_Gui
 * Description    : LDWS逻辑处理
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static void Data_LDWS_2_Gui(void)
{
	uint8_t u8Left_GuiMode = 0 ;
	uint8_t u8Right_GuiMode = 0 ;
	
	uint8_t Msg_LDWS = 0 ;
	uint8_t Msg_Lane_Left = 0 ;
	uint8_t Msg_Lane_Right = 0 ;
	uint8_t Msg_Tracking_Left = 0 ;
	uint8_t Msg_Tracking_Right = 0 ;
	uint8_t Msg_Departure_Left = 0 ;
	uint8_t Msg_Departure_Right = 0 ;
	
	Msg_LDWS = Get_ID_18FE5BE8_Sig_Lane_Departure_Warning_Sys_Sta();
	Msg_Tracking_Left = Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Left_Side() ;
	Msg_Tracking_Right = Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Right_Side() ;
	Msg_Departure_Left = Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Left() ;
	Msg_Departure_Right = Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Right() ;
	if(Msg_LDWS == 0)
	{
		u8Left_GuiMode = 1 ;
		u8Right_GuiMode = 1 ;
	}
	else if(Msg_LDWS == 3)
	{
		if(Msg_Tracking_Left == 0)
		{
			u8Left_GuiMode = 2 ;
		}
		else if(Msg_Tracking_Left == 1)
		{
			u8Left_GuiMode = 3 ;
		}
		else
		{
			 u8Left_GuiMode = 0u;
		}
		
		if(Msg_Tracking_Right == 0)
		{
			u8Right_GuiMode = 2 ;
		}
		else if(Msg_Tracking_Right == 1)
		{
			u8Right_GuiMode = 3 ;
		}
		else
		{
			u8Right_GuiMode = 0u ;
		}
	}
	else if(Msg_LDWS == 5)
	{
		if(Msg_Departure_Left == 1)
		{
			u8Left_GuiMode = 4 ;
		}
		else
		{
			u8Left_GuiMode = 0u ;
		}
		
		if(Msg_Departure_Right == 1)
		{
			u8Right_GuiMode = 4 ;
		}
		else
		{
			u8Right_GuiMode = 0u ;
		}
	}
	else
	{
		u8Left_GuiMode = 0 ;
		u8Right_GuiMode = 0 ;
	}
	
	ADASVariable.Gui_LDWS_Left = u8Left_GuiMode ;
	ADASVariable.Gui_LDWS_Right = u8Right_GuiMode ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_WorkshopScope_DisplayMode
 * Description    : 车间范围显示模式
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint8_t Gui_Get_WorkshopScope_DisplayMode(void)
{
	uint8_t u8Result = 0 ;
	u8Result = ADASVariable.Gui_WorkshopScope ;
	return u8Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_LDWS_DisplayMode
 * Description    : LDWS显示模式_左车线
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint8_t Gui_Get_LDWS_Left_DisplayMode(void)
{
	uint8_t u8Result = 0 ;
	u8Result = ADASVariable.Gui_LDWS_Left ;
	
	return u8Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_LDWS_Right_DisplayMode
 * Description    : LDWS显示模式_右车线
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint8_t Gui_Get_LDWS_Right_DisplayMode(void)
{
	uint8_t u8Result = 0 ;
	u8Result = ADASVariable.Gui_LDWS_Right ;

	return u8Result ;
}



