#ifndef INDIVIDUAL_ECU_COMM_H
#define INDIVIDUAL_ECU_COMM_H


#include "TYW_stdint.h"

typedef enum
{
    ID_TripA_AvrFuelCost    =       0 ,//Trip A平均油耗
    ID_TripA_AvrSpeed                 ,//Trip A平均车速
    ID_TripA_ConsDyeingFee            ,//Trip A燃費消耗量
    ID_TripA_IdleSpeedTime            ,//Trip A怠速时间
    ID_TripA_RunTime                  ,//Trip A运行时间
    ID_TripB_AvrFuelCost              ,//Trip B平均油耗
    ID_TripB_AvrSpeed                 ,//Trip B平均车速
    ID_TripB_ConsDyeingFee            ,//Trip B燃费消耗量
    ID_TripB_IdleSpeedTime            ,//Trip B怠速时间
    ID_TripB_RunTime                  ,//Trip B运行时间
    ID_ResidualDistance               ,//发动机油＆滤清器残留距离 (m)
    ID_HowMany                        ,//起动机剩余次数(回)
    ID_AlarmThreshold                 ,//发动机油＆滤清器警报阈值 (m)
    ID18FEAE17_TYPE_MAX               ,
}ID18FEAE17_TYPE ;

extern const uint8_t IDAE17_TYTE_DATA[ID18FEAE17_TYPE_MAX];

typedef enum
{
	METER_CODE_DATA_T_REQ	=	0	,				//普通数据传输请求
	METER_CODE_DATA_CLR_REQ			,				//清除数据要求
	METER_CODE_DATA_W_REQ			,				//数据改写要求
	ECU_CODE_DATA_T_Y_RESPONSE		,				//常用数据发送肯定应答
	ECU_CODE_DATA_CLR_Y_RESPONSE	,				//清除数据的肯定应答
	ECU_CODE_DATA_W_Y_RESPONSE		,				//改写数据肯定应答
	ECU_CODE_DATA_N_RESPONSE		,				//否定应答
	COMM_CODE_MAX_NUM				,
}en_CommSta ;

extern void Individual_ECU_Comm_KL30_Init(void);
extern void Individual_ECU_Comm_KL15_ON_Init(void);
extern void Individual_ECU_Comm_KL15_OFF_Init(void);
extern void Individual_ECU_Comm_Wakeup_Init(void);
extern void Individual_ECU_Comm_Sleep_Init(void);
extern void Individual_ECU_Comm_Processing_Service(void);

extern void RevMsg_ID18EF1718_Cbk(void);
extern void Individual_ECU_Comm_Processing_Service(void);
extern void Set_Meter_RequestCode(en_CommSta Code,ID18FEAE17_TYPE Type,uint32_t Data) ;//应用发起
extern void Meter_RequestCode_Update(void);
extern en_CommSta Get_Meter_RequestID(void) ;
extern uint8_t Get_Meter_RequestCode(void);
extern ID18FEAE17_TYPE Get_Meter_RequestType(void);
extern uint32_t Get_Meter_RequestData(ID18FEAE17_TYPE Type);
extern uint8_t Get_ECU_RespErr(void);
extern uint8_t Get_ECU_RespSure(void);

extern uint32_t Get_ECU_Data(ID18FEAE17_TYPE Type);




#endif
