#include "GUI_VC66_Date.h"
#include "RTE_TIME.h"
/*ZH:*/

/*日期和星期 显示*/
static const uint16_t GUI_DISP_Year[4]   =  {568, 552, 538, 522};
static const uint16_t GUI_DISP_Month[2]  =  {617, 604};
static const uint16_t GUI_DISP_Date[2]   =  {669, 653};

typedef enum
{
    Monday = 1 , /*星期一*/
    Tuesday    , /*星期二*/
    Wednesday  , /*星期三*/
    Thursday   , /*星期四*/
    Friday     , /*星期五*/
    Saturday   , /*星期六*/
    Sunday       /*星期日*/
} GUI_Day;


void Gui_Display_Date(void)
{
    uint16_t Year  = 0u;/*年*/
    uint8_t Month = 0u;/*月*/
    uint8_t Date  = 0u;/*日*/
    uint8_t Day   = 0u;/*星期*/

    Year  = 2000 + Get_RTC_YEAR();
    Month = Get_RTC_MONTH();
    Date  = Get_RTC_DATE();
	Day   = Get_RTC_WEEK();



    GUI_Translate_Display(Calendar_Sprite, Nb_14_dian, 591u, 64u, GUI_BLENDMODE_SRC_OVER); /*显示年份后面的 “ . ”   */
    GUI_Translate_Display(Calendar_Sprite, Nb_14_dian, 642u, 64u, GUI_BLENDMODE_SRC_OVER); /*显示月份后面的 “ . ”   */

    GUI_General_Digit_Display(Calendar_Sprite, Year , Nb_14_0, 4u, 0u, GUI_DISP_Year, 48, GUI_BLENDMODE_SRC_OVER);/*显示年*/
    GUI_General_Digit_Display(Calendar_Sprite, Month, Nb_14_0, 2u, 0u, GUI_DISP_Month,48, GUI_BLENDMODE_SRC_OVER);/*显示月*/
    GUI_General_Digit_Display(Calendar_Sprite, Date , Nb_14_0, 2u, 0u, GUI_DISP_Date, 48, GUI_BLENDMODE_SRC_OVER);/*显示日*/

    switch (Day)
    {
        case Monday :   {
                            GUI_General_Display(Calendar_Sprite, CN_xingqiyi,GUI_BLENDMODE_SRC_OVER);
                        }
        break;

        case Tuesday :  {
                            GUI_General_Display(Calendar_Sprite, CN_xingqier,GUI_BLENDMODE_SRC_OVER);
                        }
        break;

        case Wednesday :{
                            GUI_General_Display(Calendar_Sprite, CN_xingqisan,GUI_BLENDMODE_SRC_OVER);
                        }
        break;

        case Thursday : {
                            GUI_General_Display(Calendar_Sprite, CN_xingqisi,GUI_BLENDMODE_SRC_OVER);
                        }
        break;

        case Friday :   {
                            GUI_General_Display(Calendar_Sprite, CN_xingqiwu,GUI_BLENDMODE_SRC_OVER);
                        }
        break;

        case Saturday : {
                            GUI_General_Display(Calendar_Sprite, CN_xingqiliu,GUI_BLENDMODE_SRC_OVER);
                        }
        break;

        case Sunday :   {
                            GUI_General_Display(Calendar_Sprite, CN_xingqiri,GUI_BLENDMODE_SRC_OVER);
                        }
        break;
    }

    
}


/*:ZH*/


