#include "Common_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "CAN_Lib.h"
#include "Data_VehicleSpeed.h"
#include "Data_EngineSpeed.h"
#include "System_Monitor.h"
#include "GaugesInterface.h"
#include "Gauges.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"

#include "Line_in.h"

#include "Maintenance.h"
#include "Menu.h"

#include "Emulated_EEPROM.h"
#include "Watchdog.h"

/*修饰变量static*/

/*ig on off时间线*/
static uint32_t PowerIgnOnTimeLine;
static uint32_t PowerIgnOffTimeLine;

static COMMON_PowerStatus_t PowerSts; /*1 ON ;  0 OFF*/
static uint16_t Act_V_Speed;          /*实际值,十倍的*/
static uint16_t Act_E_Speed;          /*实际值*/
static uint16_t Disp_V_Speed;         /*显示值,十倍的*/
static uint16_t Disp_E_Speed;         /*显示值*/

/*数据有效 1 ;数据无效 0 /0xff */
static DataValid_t PowerSts_Valid;
static DataValid_t Act_V_Speed_Valid;
static DataValid_t Act_E_Speed_Valid;
static DataValid_t Disp_V_Speed_Valid;
static DataValid_t Disp_E_Speed_Valid;

static void Common_Set_Act_V_Speed(uint16_t Val);
static void Common_Set_Act_E_Speed(uint16_t Val);
static void Common_Set_Disp_V_Speed(uint16_t Val);
static void Common_Set_Disp_E_Speed(uint16_t Val);

static void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
static void Common_Set_Act_E_Speed_Valid(DataValid_t Val);
static void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);
static void Common_Set_Disp_E_Speed_Valid(DataValid_t Val);

static uint16_t SysRollingCounter;
// wangboyu - begin
static uint8_t CanFirstEvent[ID_TOTAL_MAX];
static void Individual_ECU_Communication(void);
// wangboyu - end

_EOL_K_LINE_SET K_Line_Set;

/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = COMMON_POWER_UNKNOW;
    Act_V_Speed = 0xffffu;
    Act_E_Speed = 0xffffu;
    Disp_V_Speed = 0xffffu;
    Disp_E_Speed = 0xffffu;

    PowerSts_Valid = COMMON_Valid_UNKNOW;
    Act_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Act_E_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_E_Speed_Valid = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine = 0x0ul;
    PowerIgnOffTimeLine = 0x0ul;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

COMMON_PowerStatus_t Common_Get_IG_Sts(void)
{
    return PowerSts;
}

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;
}
uint16_t Common_Get_Act_E_Speed(void)
{
    return Act_E_Speed;
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}
uint16_t Common_Get_Disp_E_Speed(void)
{
    return Disp_E_Speed;
}

/*获取超速报警状态*/
uint8_t Common_Get_OverSpeed_Status(void)
{
    uint8_t OverSpeedStatus = 0u;
    uint16_t DispVSpeed = 0u;
    DispVSpeed = Common_Get_Disp_V_Speed();

    if (DispVSpeed >= 1000u)
    {
        OverSpeedStatus = 1u;
    }
    else if (DispVSpeed <= 960u)
    {
        OverSpeedStatus = 0u;
    }

    return OverSpeedStatus;
}

static void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
static void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
static void Common_Set_Act_E_Speed(uint16_t Val)
{
    Act_E_Speed = Val;
}
static void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}
static void Common_Set_Disp_E_Speed(uint16_t Val)
{
    Disp_E_Speed = Val;
}

DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}
DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return Act_V_Speed_Valid;
}
DataValid_t Common_Get_Act_E_Speed_Valid(void)
{
    return Act_E_Speed_Valid;
}
DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}
DataValid_t Common_Get_Disp_E_Speed_Valid(void)
{
    return Disp_E_Speed_Valid;
}

static void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}
static void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}
static void Common_Set_Act_E_Speed_Valid(DataValid_t Val)
{
    Act_E_Speed_Valid = Val;
}
static void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}
static void Common_Set_Disp_E_Speed_Valid(DataValid_t Val)
{
    Disp_E_Speed_Valid = Val;
}

/*2MS任务*/
static uint16_t wbyTest = 0;
void Common_Input_Para(void)
{
    /*    if (SYS_OPR_STAT_IGN_ON)
        {*/
    uint32_t V_Speed_Convert = 0ul;
    uint32_t u32IG_ON_Timer = 0u;
    uint16_t OilValue = 0u; /*机油压力数值*/
    uint32_t EBC2_Speed_Value = 0u;
    uint8_t LineStatus1 = 0u;
    uint8_t LineStatus2 = 0u;

    u32IG_ON_Timer = Common_GetIgnOnTime();

    if (SYS_OPR_STAT_IGN_ON)
    {
        Common_Set_IG_Sts(COMMON_POWER_ON);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        OilValue = Common_Get_Disp_E_Speed();

        //车速
        wbyTest = Speed_Get_Display_Value();
        Common_Set_Disp_V_Speed(wbyTest);
        Common_Set_Act_V_Speed(Speed_Get_ActualValue());

        if (Speed_Get_Valid())
        {
            Common_Set_Act_V_Speed_Valid(COMMON_Valid);
            Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
        }
        else
        {
            Common_Set_Act_V_Speed_Valid(COMMON_InValid);
            Common_Set_Disp_V_Speed_Valid(COMMON_InValid);
        }

        Common_Set_Act_E_Speed(RevSpeedManage(Tacho_Get_ActualValue()));

        PowerIgnOffTimeLine = 0ul;
        if (PowerIgnOnTimeLine < 0x7ffffffful)
        {
            PowerIgnOnTimeLine += 2u;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if (PowerIgnOffTimeLine < 0x7ffffffful)
        {
            PowerIgnOffTimeLine += 2u;
        }

        Common_Set_IG_Sts(COMMON_POWER_OFF);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        /*车转真实值OFF为0*/
        Common_Set_Act_V_Speed(0u);
        Common_Set_Act_E_Speed(0u);
        Common_Set_Disp_V_Speed(0u);
        Common_Set_Disp_E_Speed(0u);
    }
}

void Set_Can18FF5510_FirstRecv_Event(void)
{
    CanFirstEvent[ID_CanMsg18FF5510_Msg_Count] = 1;
}

void Set_Can18FF2300_FirstRecv_Event(void)
{
    CanFirstEvent[ID_CanMsg18FF2300_Msg_Count] = 1;
}

uint8_t Get_CanFirstRecv_Event(uint8_t ID)
{
    return CanFirstEvent[ID];
}

void Common_RollingCounterAdd(void)
{
    SysRollingCounter++;
}

void Common_RollingCounterClear(void)
{
    SysRollingCounter = 0u;
}

uint16_t Common_ReadRollingCounter(void)
{
    return SysRollingCounter;
}

void Common_BlockDelay(uint16_t m_MS)
{
    uint16_t RocBackup;
    uint16_t Counter;
    uint16_t DIMCounter;

    DIMCounter = m_MS * 20u;
    Common_RollingCounterClear();
    RocBackup = Common_ReadRollingCounter();
    do
    {
        Counter = Common_ReadRollingCounter();

        if (Counter >= RocBackup)
        {
            Counter -= RocBackup;
        }
        else
        {
            Counter = 65535u - RocBackup + Counter + 1u;
        }

    }
    while (Counter < DIMCounter);
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

#pragma diag_suppress = Pm064
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char *sFormat, ...);
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char *sFormat, ...)
{
    return 0;
}

void K_LINE_EOL_InitVal(void)
{
    K_Line_Set.K_Line_LID20 = 0x00u; /* 00 应对ECE R13      //0：非应对、1：应对 */
    K_Line_Set.K_Line_LID21 = 0x00u; /* 00 EBS/ABS         //0：无、1：EBS、2：ABS(CAN应对) 3：ABS (CAN非应对) */
    K_Line_Set.K_Line_LID22 = 0x00u; /* 00 EVSC            //0：无、1：有 */
    K_Line_Set.K_Line_LID23 = 0x00u; /* 00 驻车锁定         //0：无、1：有 */
    K_Line_Set.K_Line_LID24 = 0x00u; /* 00 HSA             //0：无、1：有 */
    K_Line_Set.K_Line_LID25 = 0x00u; /* 00 AEBS            //0：无、1：有 */
    K_Line_Set.K_Line_LID26 = 0x00u; /* 00 ACC             //0：无、1：有 */
    K_Line_Set.K_Line_LID27 = 0x00u; /* 00 LDWS            //0：无、1：有 */
    K_Line_Set.K_Line_LID28 = 0x00u; /* 00 车辆间报警        //0：无、1：有 */
    K_Line_Set.K_Line_LID29 = 0x01u; /* 01 有无巡航          //0：无、1：有          /*初值1*/
    K_Line_Set.K_Line_LID2A = 0x00u; /* 00 气悬             //0：Reef、1：Rear air、2：Full air */
    K_Line_Set.K_Line_LID2B = 0x00u; /* 00 ISS             //0：无、1： eco stop、 2：Idle Stop */
    K_Line_Set.K_Line_LID2C = 0x00u; /* 00 装货台工作警报蜂鸣 //0：无、1：有             */
    K_Line_Set.K_Line_LID2D = 0x00u; /* 00 ROWS            //0：无、1：ROWS有、2LOCAL警报有 */
    K_Line_Set.K_Line_LID2E = 0x00u; /* 00 行车记录仪        //0：模拟记录仪、１：数字记录仪或行车记录仪 */
    K_Line_Set.K_Line_LID2F = 0x00u; /* 00 车型             //0：单车、1：拖车、2：全拖车 */
    K_Line_Set.K_Line_LID30 = 0x00u; /* 00 缓速器           //0：无、1：有(C&E)、2：有(F) */
    K_Line_Set.K_Line_LID31 = 0x01u; /* -- 定速巡航         //0：无、1：有 */
    K_Line_Set.K_Line_LID32 = 0x00u; /* 00 装货台种类       //0：一般、1：侧翼、2：倾倒 */
    K_Line_Set.K_Line_LID33 = 0x01u; /* 01 SCR?DPD         //0：SCR无/DPD有、1：SCR有/DPD有、2：SCR无/DPD无、3：SCR有/DPD无    /*初值1*/
    K_Line_Set.K_Line_LID34 = 0x00u; /* 00 驻车种类         //0：FULL AIR、1：AOH                     /*初值1*/
    K_Line_Set.K_Line_LID35 = 0x00u; /* -- 气压计           //0：2针式、1：1针式 */
    K_Line_Set.K_Line_LID36 = 0x00u; /* -- 低压警报压       //0：一般输出（539kPa）、1：ADR（588kPa） */
    K_Line_Set.K_Line_LID37 = 0x01u; /* -- 超限警报         //0：无、1：有 */
    K_Line_Set.K_Line_LID38 = 0x01u; /* -- 速度警报         //0：无、1：有 */
    K_Line_Set.K_Line_LID39 = 0x00u; /* 00 可变SLD          //0：无、1：1车速、2：2车速            /*初值1*/
    K_Line_Set.K_Line_LID3A = 0x00u; /* -- OEM             //0：ISZ、1：UDT */
    K_Line_Set.K_Line_LID3B = 0x00u; /* -- 预留 */
    K_Line_Set.K_Line_LID3C = 0x00u; /* -- 预留 */
    K_Line_Set.K_Line_LID3D = 0x00u; /* -- 预留 */
    K_Line_Set.K_Line_LID3E = 0x01u; /* 01 预留             //0：胎压功能未匹配    1：匹配 */
    K_Line_Set.K_Line_LID3F = 0x00u; /* -- 预留 */
    K_Line_Set.K_Line_LID40 = 0x00u; /* 00 发动机种类 */
    K_Line_Set.K_Line_LID41 = 0x10u; /* 10 变速器种类＆控制                                /*初值50*/
    K_Line_Set.K_Line_LID42 = 0x00u; /* 00 驻车管道                                       /*初值 0*/
    K_Line_Set.K_Line_LID43 = 0x82u; /* 82 车型                                           /*初值44*/
    K_Line_Set.K_Line_LID44 = 0xFFu; /* FF 速度警报                                       /*初值FF*/
    K_Line_Set.K_Line_LID45 = 0xFFu; /* FF 发动机转速                                     /*初值FF*/
    K_Line_Set.K_Line_LID46 = 0xFFu; /* FF 急加速                                         /*初值FF*/
    K_Line_Set.K_Line_LID47 = 0xFFu; /* FF 急减速                                         /*初值FF*/
    K_Line_Set.K_Line_LID48 = 0xFFu; /* FF 长时间怠速                                     /*初值FF*/
    K_Line_Set.K_Line_LID49 = 0xFFu; /* FF 辅助驻车                                       /*初值FF*/
    K_Line_Set.K_Line_LID4A = 0x32u; /* 32 变速箱油              5000 */
    K_Line_Set.K_Line_LID4B = 0x32u; /* 32 差速器油              5000 */
    K_Line_Set.K_Line_LID4C = 0x32u; /* 32 离合器油                     */
    K_Line_Set.K_Line_LID4D = 0x64u; /* 64 动力转向油             10000 */
    K_Line_Set.K_Line_LID4E = 0x78u; /* 78 轮胎                  12000 */
    K_Line_Set.K_Line_LID4F = 0x32u; /* 32 机油＆滤清器            5000 */
    K_Line_Set.K_Line_LID50 = 0x00u; /* -- 预留 */
    K_Line_Set.K_Line_LID51 = 0x01u; /* 01 工作模式 */
    K_Line_Set.K_Line_LID52 = 0x00u; /* 00 电子部件设定 */
}