#include "Service_TPMS.h"
#include "CAN_Communication_Matrix.h"
#include "Flash_synchronizer.h"


/*** TPMS ***/
_USER_TPMS TPMS_Out[TPMSNumMax] = {0};

/******************************************************************************
  Function：Data_TPMS_KL30_Init
  Description：该服务函数首次KL30时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_KL30_Init(void)
{
    TPMS_Out[FirstLOut].TPMSTyreID  = FirstLOutID  ;
    TPMS_Out[FirstROut].TPMSTyreID  = FirstROutID  ;
    TPMS_Out[SecondLIn].TPMSTyreID  = SecondLInID  ;
    TPMS_Out[SecondRIn].TPMSTyreID  = SecondRInID  ;

    TPMS_Out[ThirdLOut].TPMSTyreID  = ThirdLOutID  ;
    TPMS_Out[ThirdLIn].TPMSTyreID   = ThirdLInID   ;
    TPMS_Out[ThirdROut].TPMSTyreID  = ThirdROutID  ;
    TPMS_Out[ThirdRIn].TPMSTyreID   = ThirdRInID   ;

    TPMS_Out[FourthLOut].TPMSTyreID = FourthLOutID ;
    TPMS_Out[FourthLIn].TPMSTyreID  = FourthLInID  ;
    TPMS_Out[FourthROut].TPMSTyreID = FourthROutID ;
    TPMS_Out[FourthRIn].TPMSTyreID  = FourthRInID  ;



    TPMS_Out[FirstLOut].TPMSDataInvalidTime  = 600u;

    TPMS_Out[FirstROut].TPMSDataInvalidTime  = 600u;
    TPMS_Out[SecondLIn].TPMSDataInvalidTime  = 600u;
    TPMS_Out[SecondRIn].TPMSDataInvalidTime  = 600u;

    TPMS_Out[ThirdLOut].TPMSDataInvalidTime  = 600u;
    TPMS_Out[ThirdLIn].TPMSDataInvalidTime   = 600u;
    TPMS_Out[ThirdROut].TPMSDataInvalidTime  = 600u;
    TPMS_Out[ThirdRIn].TPMSDataInvalidTime   = 600u;

    TPMS_Out[FourthLOut].TPMSDataInvalidTime = 600u;
    TPMS_Out[FourthLIn].TPMSDataInvalidTime  = 600u;
    TPMS_Out[FourthROut].TPMSDataInvalidTime = 600u;
    TPMS_Out[FourthRIn].TPMSDataInvalidTime  = 600u;

    TPMS_Out[FirstLOut].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[FirstROut].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[SecondLIn].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[SecondRIn].TPMSGuiSta  = SOLID_GRAY;

    TPMS_Out[ThirdLOut].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[ThirdLIn].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[ThirdROut].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[ThirdRIn].TPMSGuiSta  = SOLID_GRAY;

    TPMS_Out[FourthLOut].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[FourthLIn].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[FourthROut].TPMSGuiSta  = SOLID_GRAY;
    TPMS_Out[FourthRIn].TPMSGuiSta  = SOLID_GRAY;
}
/******************************************************************************
  Function：Data_TPMS_KL15_ON_Init
  Description：该服务函数首次KL15时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_KL15_ON_Init(void)
{

}
/******************************************************************************
  Function：Data_TPMS_Value_Processing
  Description：数据处理总接口
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_Value_Processing(void)
{
    /*报文数据获取，处理*/
    Get_Data_TPMS_Value(FirstLOut);
 
    Get_Data_TPMS_Value(FirstROut);



    Get_Data_TPMS_Value(SecondLIn);

    Get_Data_TPMS_Value(SecondRIn);

    Get_Data_TPMS_Value(ThirdLOut);
    Get_Data_TPMS_Value(ThirdLIn);
    Get_Data_TPMS_Value(ThirdROut);
    Get_Data_TPMS_Value(ThirdRIn);

    Get_Data_TPMS_Value(FourthLOut);
    Get_Data_TPMS_Value(FourthLIn);
    Get_Data_TPMS_Value(FourthROut);
    Get_Data_TPMS_Value(FourthRIn);

    /*报文状态获取*/
    Get_Data_TPMS_Status(FirstLOut);
 
    Get_Data_TPMS_Status(FirstROut);


    Get_Data_TPMS_Status(SecondLIn);

    Get_Data_TPMS_Status(SecondRIn);

    Get_Data_TPMS_Status(ThirdLOut);
    Get_Data_TPMS_Status(ThirdLIn);
    Get_Data_TPMS_Status(ThirdROut);
    Get_Data_TPMS_Status(ThirdRIn);

    Get_Data_TPMS_Status(FourthLOut);
    Get_Data_TPMS_Status(FourthLIn);
    Get_Data_TPMS_Status(FourthROut);
    Get_Data_TPMS_Status(FourthRIn);
}

/******************************************************************************
  Function：Get_Data_TPMS_Value
  Description：胎压数据获取 数据精度在获取数据函数进行处理
  Input: 输入枚举编号
  Output:
 ******************************************************************************/
void Get_Data_TPMS_Value(TPMSNUM_t TPMSTyreID)
{
    uint16_t TyrePressure = 0u ;
    uint32_t TyreTemp = 0ul;
    if(TPMS_Out[TPMSTyreID].TPMSTyreID == Get_ID_18011733_Sig_Tire_Index())
    {
        TPMS_Out[TPMSTyreID].TPMSPressure = Get_ID_18011733_Sig_Tire_Pressure();
        TPMS_Out[TPMSTyreID].TPMSTempSign = Get_ID_18011733_Sig_Tire_Temperature_Sign();
        if(TPMS_Out[TPMSTyreID].TPMSTempSign)
        {//' - '
            TPMS_Out[TPMSTyreID].TPMSTemp = 128 - (Get_ID_18011733_Sig_Tire_Temperature()&0x7F) ;
        }
        else
        {//' + '
            TPMS_Out[TPMSTyreID].TPMSTemp = Get_ID_18011733_Sig_Tire_Temperature() ;
        }         
    }
}

/******************************************************************************
  Function：Get_Data_TPMS_Status
  Description：胎压状态获取
  Input:输入枚举编号
  Output:
 ******************************************************************************/
void Get_Data_TPMS_Status(TPMSNUM_t TPMSTyreID)
{
    if(TPMS_Out[TPMSTyreID].TPMSTyreID == Get_ID_18011733_Sig_Tire_Index())
    {
        /*低气压报警          */
        TPMS_Out[TPMSTyreID].TPMSLowpressure = Get_ID_18011733_Sig_Low_Presure_Alarm();
        /*高气压报警          */
        TPMS_Out[TPMSTyreID].TPMSHighpressure = Get_ID_18011733_Sig_High_Presure_Alarm();
        /*高温报警            */
        TPMS_Out[TPMSTyreID].TPMSHightemperature = Get_ID_18011733_Sig_High_Temperature_Alarm();
        /*快速漏气报警        */
        TPMS_Out[TPMSTyreID].TPMSRapidleakage = Get_ID_18011733_Sig_Fast_air_leakage_alarm();
        /*低电压报警          */
        TPMS_Out[TPMSTyreID].TPMSLowvoltage = Get_ID_18011733_Sig_Low_Voltage_Alarm();
        /*无信号报警           */
        TPMS_Out[TPMSTyreID].TPMSNosignal = Get_ID_18011733_Sig_No_signal_Alarm();
        /*传感器故障信息       */
        TPMS_Out[TPMSTyreID].TPMSSensorfault = Get_ID_18011733_Sig_Sensor_fault_information();
    }
}
/******************************************************************************
  Function：Get_Data_TPMS_Pair
  Description：胎压配对获取
  Input:输入枚举编号
  Output:
 ******************************************************************************/
void Get_Data_TPMS_Pair(TPMSNUM_t TPMSTyreID)
{
    if(TPMS_Out[TPMSTyreID].CurPoxID)
    {
        if(TPMS_Out[TPMSTyreID].PairEn)
        {
            TPMS_Out[TPMSTyreID].PairTimer ++ ;
            TPMS_Out[TPMSTyreID].TPMSGuiSta = YELLOW_FLASH ;
            if(Get_ID_18021733_Sig_Setup_cmd() == 0x61u)
            {
                TPMS_Out[TPMSTyreID].PairSuccess = 1u ;
                TPMS_Out[TPMSTyreID].TPMSGuiSta = SOLID_GREEN ;
                TPMS_Out[TPMSTyreID].PairEn = 0 ;
            }
            else if(Get_ID_18021733_Sig_Setup_cmd() == 0xffu)
            {
                TPMS_Out[TPMSTyreID].PairSuccess = 0u ;
            }
        }
    }
}

/******************************************************************************
  Function： Get_DataTPMS_Pressure_Value
  Description：获取某个编号轮胎胎压
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据
 ******************************************************************************/
uint16_t Get_DataTPMS_Pressure_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint16_t)TPMS_Out[TPMSTyreID].TPMSPressure ;
}

/******************************************************************************
  Function： Get_DataTPMS_Pressure_Sta
  Description：获取某个编号轮胎胎压状态
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据状态 有效无效等
 ******************************************************************************/
uint16_t Get_DataTPMS_Pressure_Sta(TPMSNUM_t TPMSTyreID)
{
    uint16_t  Pressure_Sta = 0u;

    if ( (TPMS_Out[TPMSTyreID].TPMSDataInvalidTime) >= 600u )    /*数据超时 掉线或轮刷超时*/
    {
        Pressure_Sta = (uint16_t)STATUS_TIMEOUT;
    }
    else if ((TPMS_Out[TPMSTyreID].TPMSPressure) >= 0xFAu )     /*超出最大范围*/
    {
        Pressure_Sta =  (uint16_t)STATUS_UNSUPPORTED ;
    }
    else
    {
        Pressure_Sta = (uint16_t)STATUS_SUCCESS ;
    }

    return Pressure_Sta ;
}
/******************************************************************************
  Function： Get_DataTPMS_Pressure_FLashSta
  Description：获取某个编号轮胎胎压状态
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据的闪烁状态
 ******************************************************************************/
uint8_t Get_DataTPMS_Pressure_FLashSta(TPMSNUM_t TPMSTyreID)
{
    uint8_t   Pressure_Sta = 0u ;
    uint16_t  Get_Pressure_Sta = 0u;

    Get_Pressure_Sta = Get_DataTPMS_Pressure_Sta(TPMSTyreID) ;

    if ( Get_Pressure_Sta == STATUS_TIMEOUT )
    {
        Pressure_Sta  = FLASH_SYNC_1Hz ;
    }

    return (uint8_t)Pressure_Sta ;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_Value
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint16_t Get_DataTPMS_Temp_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint16_t)TPMS_Out[TPMSTyreID].TPMSTemp ;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_Sta
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output: 输出胎温数据状态，有效无效正数负数等
 ******************************************************************************/
uint16_t Get_DataTPMS_Temp_Sta(TPMSNUM_t TPMSTyreID)
{
    uint16_t  Temp_Value = 0u;
    uint16_t  Get_Temp_Value = 0u;

    Get_Temp_Value = Get_DataTPMS_Temp_Value(TPMSTyreID) ;

    if ( TPMS_Out[TPMSTyreID].TPMSDataInvalidTime >= 600u )                        /*数据超时 掉线或轮刷超时*/
    {
        Temp_Value = (uint16_t)STATUS_TIMEOUT;
    }
    else if ( Get_Temp_Value >= 0xFFFFu )                                         /*超出最大范围*/
    {
        Temp_Value = (uint16_t)STATUS_UNSUPPORTED ;
    }
    //else if (TPMS_Out[TPMSTyreID].TPMSTempSigStat == 1u )      /*正数 零 返回状态*/
    //{
    //    Temp_Value = (uint16_t)STATUS_NONNEGATIVE;
    //}
    //else if (TPMS_Out[TPMSTyreID].TPMSTempSigStat == 0u )       /*负数 返回状态*/
    //{
    //    Temp_Value = (uint16_t)STATUS_NEGATIVE;
    //}
    else
    {
        Temp_Value = (uint16_t)STATUS_SUCCESS ;
    }
    return  (uint16_t)Temp_Value;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_FLashSta
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output: 输出胎温闪烁状态
 ******************************************************************************/
uint8_t Get_DataTPMS_Temp_FLashSta(TPMSNUM_t TPMSTyreID)
{
    uint8_t   TEMP_Sta = 0u ;
    uint16_t  Get_Temp_Sta = 0u;

    Get_Temp_Sta = Get_DataTPMS_Temp_Sta(TPMSTyreID) ;

    if ( Get_Temp_Sta == (uint16_t)STATUS_TIMEOUT)
    {
        TEMP_Sta = FlashSync1Hz ;
    }

    return (uint8_t)TEMP_Sta ;
}



/******************************************************************************
  Function：Get_DataTPMS_TPMSHighpressure_Value
  Description：获取某个编号轮胎气压高
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_Highpressure_Value(TPMSNUM_t TPMSTyreID)
{
    uint8_t Highpressure_Value = 0u;
    uint8_t Get_Highpressure_Value = 0u;

    /*0 极限高压  1 高压  2 正常压力 3 欠压 4 极限欠压 5 无定义 6 错误 7 无效*/
    Get_Highpressure_Value = (uint8_t)TPMS_Out[TPMSTyreID].TPMSPressureThresholdDetection ;

    if ( Get_Highpressure_Value == 1u)
    {
        Highpressure_Value = 1u;
    }
    else if ( Get_Highpressure_Value == 0u)
    {
        Highpressure_Value = 2u;
    }
    else
    {
        Highpressure_Value = 0u;
    }
    return (uint8_t)Highpressure_Value ;
}

/******************************************************************************
 Function：Get_DataTPMS_Lowpressure_Value
 Description：获取某个编号轮胎气压低
 Input:输入枚举编号
 Output:
******************************************************************************/
uint8_t Get_DataTPMS_Lowpressure_Value(TPMSNUM_t TPMSTyreID)
{
    uint8_t Lowpressure_Value = 0u;
    uint8_t Get_Lowpressure_Value = 0u;

    /*0 极限高压  1 高压  2 正常压力 3 欠压 4 极限欠压 5 无定义 6 错误 7 无效*/
    Get_Lowpressure_Value = (uint8_t)TPMS_Out[TPMSTyreID].TPMSPressureThresholdDetection;

    if ( Get_Lowpressure_Value == 3u)
    {
        Lowpressure_Value = 1u;
    }
    else if (Get_Lowpressure_Value == 4u)
    {
        Lowpressure_Value = 2u;
    }
    else
    {
        Lowpressure_Value = 0u;
    }

    return (uint8_t)Lowpressure_Value ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎传感器故障信息
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_SensorErrorWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSSensorfault ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎轮胎被盗报警信号
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TyresLostWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    //return (uint8_t)TPMS_Out[TPMSTyreID].TPMSLostWarningSig ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎低气压报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_SensorVoltWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSLowpressure ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎标准温度设置状态
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TireStandarTemperatureSettingSts_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSStandarTempSetSts ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎快速漏气报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_RapidLeakWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return  (uint8_t)TPMS_Out[TPMSTyreID].TPMSRapidleakage ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎高温报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TyreTempWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSHightemperature ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎短时无信号
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TemporaryNoSignal_Value(TPMSNUM_t TPMSTyreID)
{
    //return (uint8_t)TPMS_Out[TPMSTyreID].TPMSTemporaryNoSignal ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎是否换色
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_Tyre_Red_Sta(TPMSNUM_t TPMSTyreID)
{
    uint8_t  TPMS_Tyre_Status = 0u;

    return (uint8_t)TPMS_Tyre_Status;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎闪烁状态
  Input:输入枚举编号
  Output: 0--不显示；1--闪烁
 ******************************************************************************/
uint8_t Get_DataTPMS_Tyre_FLASH_Sta(TPMSNUM_t TPMSTyreID)
{
    uint8_t  TPMS_Tyre_Status = 0u;

    TPMS_Tyre_Status = FLASH_SYNC_1Hz;

    return (uint8_t)TPMS_Tyre_Status;
}

/******************************************************************************
  Function：按键切换 选择轮胎
  Description：选择某个轮胎
  Input:输入枚举编号
  Output: 
  UP/DOWN 按键
 ******************************************************************************/
void ChooseKey_TPMS_Event(TPMSNUM_t TPMSTyreID)
{
    uint8_t i = 0 ;
    for(i = 0 ;i < TPMSNumMax ;i ++ )
    {
        if(TPMS_Out[i].TPMSGuiSta == WHITEBOX_GRAY)
        {
            TPMS_Out[i].TPMSGuiSta = SOLID_GRAY ;
            TPMS_Out[i].CurPoxID = 0 ;
        }        
    }
    if(TPMS_Out[TPMSTyreID].TPMSGuiSta == SOLID_GRAY)
    {
        TPMS_Out[TPMSTyreID].TPMSGuiSta = WHITEBOX_GRAY ;
    } 

    TPMS_Out[TPMSTyreID].CurPoxID = 1 ;      
}
/******************************************************************************
  Function：配对轮胎
  Description：选择某个轮胎
  Input:输入枚举编号
  Output: 
  ENTER 按键
 ******************************************************************************/
void EnterKey_TPMS_Event(TPMSNUM_t TPMSTyreID)
{
    TPMS_Out[TPMSTyreID].TPMSGuiSta = YELLOW_FLASH ;
    TPMS_Out[TPMSTyreID].PairCmd = 0x61 ;
    TPMS_Out[TPMSTyreID].TireNumber = TPMS_Out[TPMSTyreID].TPMSTyreID ;
    TPMS_Out[TPMSTyreID].PairEn = 1 ;
    TPMS_Out[TPMSTyreID].PairTimer = 0 ;
}
/******************************************************************************
  Function：退出配对
  Description：选择某个轮胎
  Input:输入枚举编号
  Output: 
  RETURN 按键
 ******************************************************************************/
void ReturnKey_TPMS_Event(TPMSNUM_t TPMSTyreID)
{
    TPMS_Out[TPMSTyreID].PairCmd = 0x91 ;
    TPMS_Out[TPMSTyreID].PairEn = 0 ;
    TPMS_Out[TPMSTyreID].PairTimer = 0 ;
}
/******************************************************************************
  Function：Get_TPMSSetGui_Sta
  Description：胎压设定界面：某个轮胎的式样
  Input:输入枚举编号
  Output: 
  RETURN 按键
 ******************************************************************************/
en_TPMSGUI Get_TPMSSetGui_Sta(TPMSNUM_t TPMSTyreID)
{
    return TPMS_Out[TPMSTyreID].TPMSGuiSta ;
}
/******************************************************************************
  Function：Get_PairSuccess
  Description：配对是否成功
  Input:输入枚举编号
  Output:  0 - 失败     1 - 成功
 ******************************************************************************/
uint8_t Get_PairSuccess(TPMSNUM_t TPMSTyreID)
{
    return TPMS_Out[TPMSTyreID].PairSuccess ;
}


