/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Operatingsystem abstraction
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 3935 $
 *  $Date: 2014-09-23 10:52:32 +0200 (Di, 23. Sep 2014) $
 *  $LastChangedBy: golczewskim $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_OS_H_INCLUDED
#define DAVEHD_OS_H_INCLUDED

#include "davehd_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* User mode allocation type.*/
/**/
typedef enum tagdhd_alloc_element {
  E_DHD_ALLOC_CLINE,  
  E_DHD_ALLOC_BUFFER,
  E_DHD_ALLOC_GPUJOB,
  E_DHD_ALLOC_CMDLIST,

  E_DHD_ALLOC_QUANTITY
} dhd_alloc_element_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Control structure for a user side CPU pool.*/
/**/
typedef struct tagdhd_alloc_pool {  
  void           *m_memory;                                         /* Start of memory to be used for pool*/
  dhd_uint32_t    m_size;                                           /* Size of memory block in bytes*/
  dhd_uint32_t    m_align;                                          /* Alignment in bytes to be guaranteed*/

} dhd_alloc_pool_t;


/*----------------------------------------------------------------------------------------------------------*/

dhd_uint32_t dhd_get_alloc_size(dhd_alloc_element_t a_element, dhd_uint32_t a_count);

/*----------------------------------------------------------------------------------------------------------*/

void *dhd_alloc(dhd_alloc_element_t a_element, dhd_uint32_t a_count, dhd_uint32_t a_alignment);
void dhd_free(void *a_memory);
#ifdef DHD_USER_USE_POOLING
dhd_enum_t dhd_alloc_init(void);
dhd_enum_t dhd_alloc_shutdown(void);
dhd_enum_t dhd_alloc_setup_pool(dhd_alloc_element_t a_element, dhd_alloc_pool_t *a_out);
dhd_enum_t dhd_alloc_shutdown_pool(dhd_alloc_element_t a_element, dhd_alloc_pool_t *a_out);
#endif

#ifdef DHD_PROFILE_MEM_USAGE
typedef struct {
  dhd_uint32_t    m_allocatedBytes;
  dhd_uint32_t    m_allocatedObjects;
  dhd_uint32_t    m_maxAllocatedBytes;
  dhd_uint32_t    m_maxAllocatedObjects;
  dhd_uint32_t    m_totalAllocatedBytes;
  dhd_uint32_t    m_totalAllocatedObjects;

  dhd_uint32_t    m_mallocCalls;
  dhd_uint32_t    m_freeCalls;

  dhd_uint32_t    m_mallocFails;
  dhd_uint32_t    m_allocationsInUse[64];
  dhd_uint32_t    m_nextAllocation;
} dhd_mem_info_t;

void dhd_dump_mem_heap_info(void);
void dhd_clear_mem_heap_info(void);
const dhd_mem_info_t* dhd_get_mem_heap_info();
#endif

/*----------------------------------------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif

#endif /*DAVEHD_OS_H_INCLUDED*/
