
#ifndef _POPUP_MESSAGE_LIST_H_
#define _POPUP_MESSAGE_LIST_H_

#include "TYW_stdint.h"

/******************************************************************************
报警文字消息名称列表
******************************************************************************/
enum PopupMessageName
{
    POPUP1_MSG_BRAKE_BLACK          = 0           ,  /*00.紧急警报-刹车*/
    POPUP1_MSG_BRAKE_BRAKE                        ,  /*01.紧急警报-紧急制动*/
    POPUP1_MSG_BRAKE_SPACING_R                    ,  /*02.车间距警报-刹车(红字)*/
    POPUP1_MSG_BRAKE_SPACING_COLLISION            ,  /*03.车间距警报-碰撞报警*/
    POPUP1_MSG_BRAKE_SPACING_Y                    ,  /*04.车间距警报-刹车(黄字)*/
    POPUT1_MSG_ASR_OPERATE                        ,  /*05.ASR工作*/
    POPUT2_MSG_PTO                                ,  /*06.PTO紧急警报-刹车*/
    POPUP2_MSG_PARKING_BRAKE                      ,  /*07.忘记松手刹车*/
    POPUP2_MSG_AIRMATIC_HIGHT                     ,  /*08.遥控调整车辆高度(有车速)*/
    POPUP3_MSG_CRUISE                             ,  /*09.自动巡航模式*/
    POPUP3_MSG_VARIABLE_SLD                       ,  /*10.可变SLD 模式*/
    POPUT4_MSG_ABNORMAL_CHARGE                    ,  /*11.充电异常（系统检测）*/
    POPUP4_MSG_OIL_PRESSURE                       ,  /*12.油压（系统检测）*/
    POPUP4_MSG_AMT_INIT_EXCE                      ,  /*13.AMT初始化异常*/
    POPUP4_MSG_ADBLUE_QUALITY                     ,  /*14.尿素品质异常（系统检测）*/
    POPUP4_MSG_ADBLUE_SPRAY                       ,  /*15.尿素喷射异常（系统检测）*/
    POPUP4_MSG_ADBLUE_SUPPLY                      ,  /*16.尿素水补给（系统检测）*/
    POPUP4_MSG_START_ENG                          ,  /*17.AMT初始化结束*/
    POPUP4_MSG_DPD_AUTO                           ,  /*18.DPD自动再生*/
    POPUP5_MSG_OVER_HEAT                          ,  /*19.过热（冷却液温度过高）*/
    POPUP5_MSG_LOW_COOLANT                        ,  /*20.冷却水（冷却水不足）*/
    POPUP5_MSG_ENGINE_OIL_PRESSURE                ,  /*21.油压异常*/
    POPUP5_MSG_METER_FAILURE                      ,  /*22.仪表故障-请与五十铃公司联系*/
    POPUP5_MSG_CAN_ERROR                          ,  /*23.通信系统-请与五十铃公司联系*/
    POPUP5_MSG_SPEED_LIMIT                        ,  /*24.车速限制*/
    POPUP5_MSG_TORQUE_REDUCTION                   ,  /*25.扭矩限制*/
    POPUP5_MSG_INCORRECT_ADBLUE                   ,  /*26.尿素品质异常*/
    POPUP5_MSG_CRITICAL_EMISSION                  ,  /*27.临界排放故障*/
    POPUP5_MSG_AMT_SPANNER_WARNING                ,  /*28.AMT异常-请重启发动机*/
    POPUP5_MSG_AMT_LOW_AIR_WARNING                ,  /*29.AMT异常(气压低下)*/
    POPUP5_MSG_LOW_PRESSURE_ALARM                 ,  /*30.胎压报警-快速漏气*/
    POPUP5_MSG_APP_ADBLUE                         ,  /*31.尿素补给-补充尿素溶液*/
    POPUP5_MSG_ADBLUE_LEVEL_LOW                   ,  /*32.尿素余量少-无车速*/
    POPUP5_MSG_LOW_FAILURE                        ,  /*33.胎压报警-气压低*/
    POPUP5_MSG_CAMERA_POLLUTION                   ,  /*34.摄像头有污染-请与五十铃公司联系*/
    POPUP5_MSG_AdBlue_INJ_SYSTEM                  ,  /*35.尿素喷射异常（停止）*/
    POPUP5_MSG_AdBlue_DOS_MALFUNC                 ,  /*36.尿素喷射异常（消耗量）*/
    POPUP5_MSG_TPMS_HIGH_AIR                      ,  /*37.高圧警報-轮胎高压警告*/
    POPUP5_MSG_TPMS_HIGH_TEMP                     ,  /*38.高温警報-轮胎高温警告*/
    POPUP5_MSG_PUSH_DPD_SWITCH1                   ,  /*39.DPD手动再生要求1-请按下DPD开关*/
    POPUP5_MSG_PUSH_DPD_SWITCH2                   ,  /*40.DPD手动再生要求2-请按下DPD开关*/
    POPUP5_MSG_TPMS_FAILURE                       ,  /*41.TPMS故障*/
    POPUP5_MSG_TPMS_MONITOR_DROP                  ,  /*42.TPMS電池低下-轮胎监控传感器电压下降*/
    POPUP6_MSG_HEIGHT_CONTROL                     ,  /*43.遥控车辆高度调整中(无车速)*/
    POPUP6_MSG_PTO_STOP                           ,  /*44.PTO(停车中)*/
    POPUP7_MSG_CHARGE_ABNORMAL                    ,  /*45.充电异常-请与五十铃公司联系*/
    POPUP7_MSG_AMT_ERROR                          ,  /*46.AMT異常-请联系经销商*/
    POPUP8_MSG_REFUEL                             ,  /*47.补充燃料-油箱单位*/
    POPUP8_MSG_ATM_CLUCH_OVERHEATING              ,  /*48.AMT过热-选择合适的档位*/
    POPUP8_MSG_ATM_WORN_OUT                       ,  /*49.AMT磨耗-离合器磨损*/
    POPUP8_MSG_LOWVOLTAGE                         ,  /*50.低电压报警*/
    POPUP8_MSG_OVERVOLTAGE                        ,  /*51.过电压报警*/
    POPUP8_MSG_BRAKE_BLOCKR                       ,  /*52.后蹄片磨损*/
    POPUP8_MSG_BRAKE_BLOCKF                       ,  /*53.前蹄片磨损*/

    POPUP8_MSG_TemperatureThigh                   ,  /*   变速箱温度高*/
    POPUP8_MSG_TBOX_GW_Sta                        ,  /*   未检测到GW*/
    POPUP8_MSG_TBOX_Sta                           ,  /*   未检测到TBOX*/
    POPUP8_MSG_TBOX_Sig                           ,  /*   TBOX通信异常*/
    POPUP8_MSG_TBOX_Sig_Error                     ,  /*   平台通信异常*/

    POPUP8_MSG_DPD_AUTO                           ,  /*54.DPD自动再生-再生将自动完成，不需要操作开关*/
    POPUP9_MSG_AIR_PRESSURE                       ,  /*55.气压过低-请冲入空气*/
    POPUP9_MSG_EBS_ERROR                          ,  /*56.EBS故障（红）-请与五十铃公司联系*/
    POPUP10_MSG_RAPID_ACC                         ,  /*57.省油耗建议-急加速*/
    POPUP10_MSG_RAPID_SUB                         ,  /*58.省油耗建议-急减速*/
    POPUP10_MSG_REVAL_ENGINE                      ,  /*59.省油耗建议-请降低发动机转速*/
    POPUP10_MSG_REVAL_SPEED                       ,  /*60.省油耗建议-请降低速度*/
    POPUP11_MSG_ENGINE_OIL_FILTER                 ,  /*61.发动机机油＆滤清器*/
    POPUP11_MSG_FUEL_FILTER                       ,  /*62.燃油滤清器*/
    POPUP11_MSG_T_MISSION_OIL                     ,  /*63.变速箱油*/
    POPUP11_MSG_DIFF_OIL                          ,  /*64.差速器油*/
    POPUP11_MSG_CLUTCH_OIL                        ,  /*65.顺畅系统离合器油*/
    POPUP11_MSG_P_STEERING_FRUID                  ,  /*66.动力转向液*/
    POPUP11_MSG_TIRE_ROTATION                     ,  /*67.更换轮胎・轮胎位置*/

    POPUP_MSG_MAX                                 ,

};
/******************************************************************************
消息类型定义
******************************************************************************/
#define   POPUP_TYPE_GENERAL                0x00u  /*一般消息*/
#define   POPUP_TYPE_TPMS                   0x01u  /*胎压消息*/
#define   POPUP_TYPE_DOOR                   0x02u  /*门开消息*/
#define   POPUP_TYPE_RADAR                  0x03u  /*雷达消息*/
#define   POPUP_TYPE_SERVICE                0x04u  /*保养消息*/
#define   POPUP_TYPE_OVSPD                  0x05u  /*超速消息*/
#define   POPUP_TYPE_KEYS                   0x06u  /*按键激活消息*/
#define   POPUP_TYPE_HOOVES                 0x07u  /*蹄片磨损*/
#define   POPUP_TYPE_ADDFUEL                0x08u  /*是否已加油*/
#define   POPUP_TYPE_KEYBATLOW              0x09u  /*钥匙电量低*/
#define   POPUP_TYPE_GOHOME                 0x0Au  /*伴我回家*/
#define   POPUP_TYPE_ADASLDSHW              0x0Bu  /*方向盘脱手*/
#define   POPUP_TYPE_TSR_TR                 0x0Cu  /*限速标识提醒*/
#define   POPUP_TYPE_DRIVING                0x0Du  /*本次行驶信息*/
#define   POPUP_TYPE_MENU                   0x0Eu

/******************************************************************************
伪文字消息列表
******************************************************************************/
#define   POPUP_MSG_NONE                    0xFFFFu

/******************************************************************************
报警文字消息属性
******************************************************************************/
typedef struct
{
    uint8_t   Type;   /*类型*/
} PopupMsgAttributeStruct;




static const PopupMsgAttributeStruct PopupMsgAttributeTable[] =
{
    /*=============================================================
                报警文字消息名称           |       消息类型
    -------------------------------------------------------------*/
    { /* POPUP1_MSG_BRAKE_BLACK                 */  POPUP_TYPE_GENERAL,},     /*00.紧急警报-刹车*/
    { /* POPUP1_MSG_BRAKE_BRAKE                 */  POPUP_TYPE_GENERAL,},     /*01.紧急警报-紧急制动*/
    { /* POPUP1_MSG_BRAKE_SPACING_R             */  POPUP_TYPE_GENERAL,},     /*02.车间距警报-刹车(红字)*/
    { /* POPUP1_MSG_BRAKE_SPACING_COLLISION     */  POPUP_TYPE_GENERAL,},     /*03.车间距警报-碰撞报警*/
    { /* POPUP1_MSG_BRAKE_SPACING_Y             */  POPUP_TYPE_GENERAL,},     /*04.车间距警报-刹车(黄字)*/
    { /* POPUT1_MSG_ASR_OPERATE                 */  POPUP_TYPE_GENERAL,},     /*05.ASR工作*/
    { /* POPUT2_MSG_PTO                         */  POPUP_TYPE_GENERAL,},     /*06.PTO紧急警报-刹车*/
    { /* POPUP2_MSG_PARKING_BRAKE               */  POPUP_TYPE_GENERAL,},     /*07.忘记松手刹车*/
    { /* POPUP2_MSG_AIRMATIC_HIGHT              */  POPUP_TYPE_GENERAL,},     /*08.遥控调整车辆高度(有车速)*/
    { /* POPUP3_MSG_CRUISE                      */  POPUP_TYPE_GENERAL,},     /*09.自动巡航模式*/
    { /* POPUP3_MSG_VARIABLE_SLD                */  POPUP_TYPE_GENERAL,},     /*10.可变SLD 模式*/
    { /* POPUT4_MSG_ABNORMAL_CHARGE             */  POPUP_TYPE_GENERAL,},     /*11.充电异常（系统检测）*/
    { /* POPUP4_MSG_OIL_PRESSURE                */  POPUP_TYPE_GENERAL,},     /*12.油压（系统检测）*/
    { /* POPUP4_MSG_AMT_INIT_EXCE               */  POPUP_TYPE_GENERAL,},     /*13.AMT初始化异常*/
    { /* POPUP4_MSG_ADBLUE_QUALITY              */  POPUP_TYPE_GENERAL,},     /*14.尿素品质异常（系统检测）*/
    { /* POPUP4_MSG_ADBLUE_SPRAY                */  POPUP_TYPE_GENERAL,},     /*15.尿素喷射异常（系统检测）*/
    { /* POPUP4_MSG_ADBLUE_SUPPLY               */  POPUP_TYPE_GENERAL,},     /*16.尿素水补给（系统检测）*/
    { /* POPUP4_MSG_START_ENG                   */  POPUP_TYPE_GENERAL,},     /*17.AMT初始化结束*/
    { /* POPUP4_MSG_DPD_AUTO                    */  POPUP_TYPE_GENERAL,},     /*18.DPD自动再生*/
    { /* POPUP5_MSG_OVER_HEAT                   */  POPUP_TYPE_GENERAL,},     /*19.过热（冷却液温度过高）*/
    { /* POPUP5_MSG_LOW_COOLANT                 */  POPUP_TYPE_GENERAL,},     /*20.冷却水（冷却水不足）*/
    { /* POPUP5_MSG_ENGINE_OIL_PRESSURE         */  POPUP_TYPE_GENERAL,},     /*21.油压异常*/
    { /* POPUP5_MSG_METER_FAILURE               */  POPUP_TYPE_GENERAL,},     /*22.仪表故障-请与五十铃公司联系*/
    { /* POPUP5_MSG_CAN_ERROR                   */  POPUP_TYPE_GENERAL,},     /*23.通信系统-请与五十铃公司联系*/
    { /* POPUP5_MSG_SPEED_LIMIT                 */  POPUP_TYPE_GENERAL,},     /*24.车速限制*/
    { /* POPUP5_MSG_TORQUE_REDUCTION            */  POPUP_TYPE_GENERAL,},     /*25.扭矩限制*/
    { /* POPUP5_MSG_INCORRECT_ADBLUE            */  POPUP_TYPE_GENERAL,},     /*26.尿素品质异常*/
    { /* POPUP5_MSG_CRITICAL_EMISSION           */  POPUP_TYPE_GENERAL,},     /*27.临界排放故障*/
    { /* POPUP5_MSG_AMT_SPANNER_WARNING         */  POPUP_TYPE_GENERAL,},     /*28.AMT异常-请重启发动机*/
    { /* POPUP5_MSG_AMT_LOW_AIR_WARNING         */  POPUP_TYPE_GENERAL,},     /*29.AMT异常(气压低下)*/
    { /* POPUP5_MSG_LOW_PRESSURE_ALARM          */  POPUP_TYPE_GENERAL,},     /*30.胎压报警-快速漏气*/
    { /* POPUP5_MSG_APP_ADBLUE                  */  POPUP_TYPE_GENERAL,},     /*31.尿素补给-补充尿素溶液*/
    { /* POPUP5_MSG_ADBLUE_LEVEL_LOW            */  POPUP_TYPE_GENERAL,},     /*32.尿素余量少-无车速*/
    { /* POPUP5_MSG_LOW_FAILURE                 */  POPUP_TYPE_GENERAL,},     /*33.胎压报警-气压低*/
    { /* POPUP5_MSG_CAMERA_POLLUTION            */  POPUP_TYPE_GENERAL,},     /*34.摄像头有污染-请与五十铃公司联系*/
    { /* POPUP5_MSG_AdBlue_INJ_SYSTEM           */  POPUP_TYPE_GENERAL,},     /*35.尿素喷射异常（停止）*/
    { /* POPUP5_MSG_AdBlue_DOS_MALFUNC          */  POPUP_TYPE_GENERAL,},     /*36.尿素喷射异常（消耗量）*/
    { /* POPUP5_MSG_TPMS_HIGH_AIR               */  POPUP_TYPE_GENERAL,},     /*37.高圧警報-轮胎高压警告*/
    { /* POPUP5_MSG_TPMS_HIGH_TEMP              */  POPUP_TYPE_GENERAL,},     /*38.高温警報-轮胎高温警告*/
    { /* POPUP5_MSG_PUSH_DPD_SWITCH1            */  POPUP_TYPE_GENERAL,},     /*39.DPD手动再生要求1-请按下DPD开关*/
    { /* POPUP5_MSG_PUSH_DPD_SWITCH2            */  POPUP_TYPE_GENERAL,},     /*40.DPD手动再生要求2-请按下DPD开关*/
    { /* POPUP5_MSG_TPMS_FAILURE                */  POPUP_TYPE_GENERAL,},     /*41.TPMS故障*/
    { /* POPUP5_MSG_TPMS_MONITOR_DROP           */  POPUP_TYPE_GENERAL,},     /*42.TPMS電池低下-轮胎监控传感器电压下降*/
    { /* POPUP6_MSG_HEIGHT_CONTROL              */  POPUP_TYPE_GENERAL,},     /*43.遥控车辆高度调整中(无车速)*/
    { /* POPUP6_MSG_PTO_STOP                    */  POPUP_TYPE_GENERAL,},     /*44.PTO(停车中)*/
    { /* POPUP7_MSG_CHARGE_ABNORMAL             */  POPUP_TYPE_GENERAL,},     /*45.充电异常-请与五十铃公司联系*/
    { /* POPUP7_MSG_AMT_ERROR                   */  POPUP_TYPE_GENERAL,},     /*46.AMT異常-请联系经销商*/
    { /* POPUP8_MSG_REFUEL                      */  POPUP_TYPE_GENERAL,},     /*47.补充燃料-油箱单位*/
    { /* POPUP8_MSG_ATM_CLUCH_OVERHEATING       */  POPUP_TYPE_GENERAL,},     /*48.AMT过热-选择合适的档位*/
    { /* POPUP8_MSG_ATM_WORN_OUT                */  POPUP_TYPE_GENERAL,},     /*49.AMT磨耗-离合器磨损*/
    { /* POPUP8_MSG_LOWVOLTAGE                  */  POPUP_TYPE_GENERAL,},     /*50.低电压报警*/
    { /* POPUP8_MSG_OVERVOLTAGE                 */  POPUP_TYPE_GENERAL,},     /*51.过电压报警*/
    { /* POPUP8_MSG_BRAKE_BLOCKR                */  POPUP_TYPE_GENERAL,},     /*52.后蹄片磨损*/
    { /* POPUP8_MSG_BRAKE_BLOCKF                */  POPUP_TYPE_GENERAL,},     /*53.前蹄片磨损*/

    { /* POPUP8_MSG_TemperatureThigh            */  POPUP_TYPE_GENERAL,},     /*   变速箱温度高*/
    { /* POPUP8_MSG_TBOX_GW_Sta                 */  POPUP_TYPE_GENERAL,},     /*   未检测到GW*/
    { /* POPUP8_MSG_TBOX_Sta                    */  POPUP_TYPE_GENERAL,},     /*   未检测到TBOX*/
    { /* POPUP8_MSG_TBOX_Sig                    */  POPUP_TYPE_GENERAL,},     /*   TBOX通信异常*/
    { /* POPUP8_MSG_TBOX_Sig_Error              */  POPUP_TYPE_GENERAL,},     /*   平台通信异常*/

    { /* POPUP8_MSG_DPD_AUTO                    */  POPUP_TYPE_GENERAL,},     /*54.DPD自动再生-再生将自动完成，不需要操作开关*/
    { /* POPUP9_MSG_AIR_PRESSURE                */  POPUP_TYPE_GENERAL,},     /*55.气压过低-请冲入空气*/
    { /* POPUP9_MSG_EBS_ERROR                   */  POPUP_TYPE_GENERAL,},     /*56.EBS故障（红）-请与五十铃公司联系*/
    { /* POPUP10_MSG_RAPID_ACC                  */  POPUP_TYPE_GENERAL,},     /*57.省油耗建议-急加速*/
    { /* POPUP10_MSG_RAPID_SUB                  */  POPUP_TYPE_GENERAL,},     /*58.省油耗建议-急减速*/
    { /* POPUP10_MSG_REVAL_ENGINE               */  POPUP_TYPE_GENERAL,},     /*59.省油耗建议-请降低发动机转速*/
    { /* POPUP10_MSG_REVAL_SPEED                */  POPUP_TYPE_GENERAL,},     /*60.省油耗建议-请降低速度*/
    { /* POPUP11_MSG_ENGINE_OIL_FILTER          */  POPUP_TYPE_GENERAL,},     /*61.发动机机油＆滤清器*/
    { /* POPUP11_MSG_FUEL_FILTER                */  POPUP_TYPE_GENERAL,},     /*62.燃油滤清器*/
    { /* POPUP11_MSG_T_MISSION_OIL              */  POPUP_TYPE_GENERAL,},     /*63.变速箱油*/
    { /* POPUP11_MSG_DIFF_OIL                   */  POPUP_TYPE_GENERAL,},     /*64.差速器油*/
    { /* POPUP11_MSG_CLUTCH_OIL                 */  POPUP_TYPE_GENERAL,},     /*65.顺畅系统离合器油*/
    { /* POPUP11_MSG_P_STEERING_FRUID           */  POPUP_TYPE_GENERAL,},     /*66.动力转向液*/
    { /* POPUP11_MSG_TIRE_ROTATION              */  POPUP_TYPE_GENERAL,},     /*67.更换轮胎・轮胎位置*/

};

#define   POPUP_MSG_NUMBER_TOTAL            (sizeof(PopupMsgAttributeTable) / sizeof(PopupMsgAttributeStruct))

#endif
