#ifndef DISP_SCH
#define DISP_SCH

#ifdef Platform_16Bit
    #define UElib_uint8_t  unsigned char
    #define UElib_uint16_t unsigned int
    #define UElib_uint32_t unsigned long
#else

    #define UElib_uint8_t  unsigned char
    #define UElib_uint16_t unsigned short
    #define UElib_uint32_t unsigned int
    #define UElib_uint64_t unsigned long long
#endif

#define UE_LIB_BlockSize (( UElib_uint8_t )4u)

typedef UElib_uint8_t (*pfnGet_Power)(void);
typedef UElib_uint32_t (*pfnGet_IG_ON_Timer)(void);
typedef UElib_uint32_t (*pfnGet_IG_OFF_Timer)(void);

typedef void (*pfnLogic_Process)(void);
typedef void (*pfnEnter_Process)(UElib_uint16_t EnterIdx);

typedef struct
{
    pfnGet_Power        Get_Power;
    pfnGet_IG_ON_Timer  Get_IG_ON_Timer;
    pfnGet_IG_OFF_Timer Get_IG_OFF_Timer;
    UElib_uint32_t      TotalSize;
} DispSch_Ext_st;

typedef struct
{
    UElib_uint8_t *  ProcessEn;
    UElib_uint8_t    WorkStatus;
    UElib_uint16_t   HMI_Idx;
    pfnLogic_Process Init_process;
    pfnEnter_Process Enter_process;
    pfnLogic_Process Logic_process;
    pfnEnter_Process Exit_process;
} DispSch_Attr_st;

void           DispSch_xxxMs_Logic(UElib_uint16_t xxMs);
void           DispSch_Init(UElib_uint8_t *Mem, const DispSch_Attr_st *mAttr, DispSch_Ext_st *ExtPara, UElib_uint8_t FirstInit);
UElib_uint16_t Get_Cur_HMI(void);
UElib_uint16_t Get_HMI_Version(void);
#endif
