#include "Popups.h"
#include "Popup_List.h"
#include "Popup_Message_List.h"
#include "Sound_List.h"
#include "Sound_Scheduler.h"

#include "GUI.h"
#include "Common_Interface.h"
#include "Sound_Scheduler.h"
#include "Gauges.h"
#include "GaugesInterface.h"
#include "CAN_Communication_Matrix.h"

#include "Data_Gear.h"
#include "Line_in.h"
#include "CD4051.h"
#include "Telltales_user.h"
#include "Data_CoolantTemperature.h"
#include "Data_VehicleSpeed.h"
#include "Data_Voltmeter.h"
#include "Data_Fuel_User.h"
#include "FuelConfig.h"
#include "Service_TPMS.h"
#include "Telltales.h"

#include "kwp2000_service.h"
#include "CAN_FUNC.h"

/*-------------------------------------------------------------------------
 * Function Name  : Popups_Management_Service
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Popups_Management_Service(void)
{
    Popups_Polling();
}

/*-------------------------------------------------------------------------
 * Function Name  : Popups_Polling
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Popups_Polling(void)
{
    uint16_t i = 0x00u;
    COMMON_PowerStatus_t u8IG_st;
    uint32_t u32IG_OFF_Timer = 0x00u;
    uint32_t u32IG_ON_Timer = 0x00u;
    uint8_t Can_BusOFF = 0x00u;
    uint8_t variable_1 = 0x00u;
    uint8_t variable_2 = 0x00u;
    uint8_t variable_3 = 0x00u;
    uint32_t variable_4 = 0x00u;
    uint16_t variable_5 = 0x00u;
    uint16_t V_Speed = 0u;
    uint16_t E_Speed = 0u;

    u32IG_ON_Timer = Common_GetIgnOnTime();
    u32IG_OFF_Timer = Common_GetIgnOffTime();
    u8IG_st = Common_Get_IG_Sts();

    V_Speed = Common_Get_Disp_V_Speed(); /*车速*/
    E_Speed = Common_Get_Act_E_Speed();  /*转速*/

    /*CAN 通讯异常*/
    for (i = 0u; i < ID_TOTAL_MAX; i++)
    {
        if (CAN_MSG_Status(i) == CAN_SIG_LOST)
        {
            Can_BusOFF++;
        }
    }

    if ((u32IG_ON_Timer <= PopupStart) && (u32IG_ON_Timer >= 2u))
    {
        ;
    }
    else
    {
        if (u8IG_st == COMMON_POWER_ON)
        {
            /*----第一组---------------------------------------------------------------------*/
            if (K_Line_Set.K_Line_LID28 == 0x01u)
            {
                /*0.--1--紧急警报-刹车*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x07u) || (variable_2 == 0x07u))
                {
                    Popup_Request(POPUP1_BRAKE_BLACK);
                    Popup_Clear(POPUP1_BRAKE_BRAKE);
                    Popup_Clear(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BLACK);
                }

                /*1.--1--紧急警报-紧急制动*/
                variable_1 = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if (variable_1 == 0x07u)
                {
                    Popup_Request(POPUP1_BRAKE_BRAKE);
                    Popup_Clear(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BRAKE);
                }

                /*2.--2--车间距警报-刹车(红字)*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x06u) || (variable_2 == 0x06u))
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_R);
                }

                /*3.--2--车间距警报-碰撞报警*/
                variable_1 = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if (variable_1 == 0x06u)
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_COLLISION);
                }

                /*4.--3--车间距警报-刹车(黄字)*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x05u) || (variable_2 == 0x05u))
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_Y);
                }
            }
            else
            {
                Popup_Clear(POPUP1_BRAKE_BLACK);
                Popup_Clear(POPUP1_BRAKE_BRAKE);
                Popup_Clear(POPUP1_BRAKE_SPACING_R);
                Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                Popup_Clear(POPUP1_BRAKE_SPACING_Y);
            }

            /*5.--4--ASR工作*/
            variable_1 = Get_ID_18F0010B_Sig_ATC_or_ASR_Lamp_State();

            if ((variable_1 == 0x01u) && (K_Line_Set.K_Line_LID21 == 0x01u))
            {
                Popup_Request(POPUT1_ASR_OPERATE);
                return;
            }
            else
            {
                Popup_Delete(POPUT1_ASR_OPERATE);
            }

            /*----第二组---------------------------------------------------------------------*/
            /*6.--1--PTO紧急警报-刹车*/
            variable_1 = Get_ID_18FED900_Sig_PTO_SW();
            variable_2 = Line_In_Get_Status(LINE_IN_PTO); // B01

            if (((variable_1 == 0x01u) || (variable_2 == LINE_IN_LOGIC_VALID)) && (V_Speed >= 66u))
            {
                Popup_Request(POPUT2_PTO);
            }
            else
            {
                Popup_Delete(POPUT2_PTO);
            }

            /*7.--2--忘记松手刹车    LINE_IN_Get_PARK_BRAKE 驻车制动*/
            variable_1 = Line_In_Get_Status(LINE_IN_PARK_BRAKE);

            if ((variable_1 == LINE_IN_LOGIC_VALID) && (V_Speed >= 66u)) // 6.67Km
            {
                Popup_Request(POPUP2_PARKING_BRAKE);
            }
            else
            {
                Popup_Delete(POPUP2_PARKING_BRAKE);
            }

            /*8.--3--遥控调整车辆高度(有车速)*/
            variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);

            if ((variable_1 == LINE_IN_LOGIC_VALID) && (V_Speed > 5u)) // 0.5Km
            {
                Popup_Request(POPUP2_AIRMATIC_HIGHT);
            }
            else
            {
                Popup_Delete(POPUP2_AIRMATIC_HIGHT);
            }

            /*----第三组---------------------------------------------------------------------*/
            /*9.--1--自动巡航模式*/
            variable_1 = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();
            variable_2 = Common_Get_Cruise_TimeSta();

            if ((variable_1 == 0x01u) && (variable_2 == 1u))
            {
                Popup_Request(POPUP3_CRUISE);
            }
            else
            {
                Popup_Delete(POPUP3_CRUISE);
            }

            /*10.--2--可变SLD 模式*/
            variable_1 = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();
            variable_2 = Common_Get_Cruise_SLD_TimeSta();

            if ((variable_1 == 0x03u) && (variable_2 == 1u))
            {
                Popup_Request(POPUP3_VARIABLE_SLD);
            }
            else
            {
                Popup_Delete(POPUP3_VARIABLE_SLD);
            }

            /*----第四组---------------------------------------------------------------------*/
            if (E_Speed < 350u)
            {
                /*11.--1--充电异常（系统检测）*/
                variable_1 = Line_In_Get_Status(LINE_IN_CHARGE);
                variable_2 = Gui_Get_Voltmeter_DisplayMode(); /*当前电压格数*/
                variable_3 = Get_Voltmeter_Valid();

                if ((variable_1 == 1u) || ((variable_2 < 4u) && (variable_3 == 1u)))
                {
                    Popup_Request(POPUT4_ABNORMAL_CHARGE);
                }
                else
                {
                    Popup_Delete(POPUT4_ABNORMAL_CHARGE);
                }

                /*12.--2--油压（系统检测）*/
                variable_1 = Line_In_Get_Status(LINE_IN_ENG_OIL);
                variable_2 = Gui_Get_Voltmeter_DisplayMode(); /*当前电压格数*/
                variable_3 = Get_Voltmeter_Valid();

                if ((variable_1 == LINE_IN_LOGIC_VALID) || ((variable_2 < 4u) && (variable_3 == 1u)))
                {
                    Popup_Request(POPUP4_OIL_PRESSURE);
                }
                else
                {
                    Popup_Delete(POPUP4_OIL_PRESSURE);
                }

                /*14.--4--尿素品质异常（系统检测）*/
                if (0)
                {
                    Popup_Request(POPUP4_ADBLUE_QUALITY);
                }
                else
                {
                    Popup_Delete(POPUP4_ADBLUE_QUALITY);
                }

                /*15.--5--尿素喷射异常（系统检测）*/
                if (0)
                {
                    Popup_Request(POPUP4_ADBLUE_SPRAY);
                }
                else
                {
                    Popup_Delete(POPUP4_ADBLUE_SPRAY);
                }

                /*16.--6--尿素水补给（系统检测）*/
                if (0)
                {
                    Popup_Request(POPUP4_ADBLUE_SUPPLY);
                }
                else
                {
                    Popup_Delete(POPUP4_ADBLUE_SUPPLY);
                }

                /*18.--8--DPD自动再生*/
                if (0)
                {
                    Popup_Request(POPUP4_DPD_AUTO);
                }
                else
                {
                    Popup_Delete(POPUP4_DPD_AUTO);
                }
            }
            else
            {
                Popup_Clear(POPUT4_ABNORMAL_CHARGE);
                Popup_Clear(POPUP4_OIL_PRESSURE);
                Popup_Clear(POPUP4_ADBLUE_QUALITY);
                Popup_Clear(POPUP4_ADBLUE_SPRAY);
                Popup_Clear(POPUP4_ADBLUE_SUPPLY);
                Popup_Clear(POPUP4_DPD_AUTO);
            }

            /*13.--3--AMT初始化异常           DM1 SPN4220 Key On時*/
            variable_4 = Get_ID_18FECA03_Sig_SPN();

            if ((variable_4 == 4220u) && (E_Speed > 350u) && (K_Line_Set.K_Line_LID41 == 0x13u))
            {
                Popup_Request(POPUP4_AMT_INIT_EXCE);
            }
            else
            {
                Popup_Delete(POPUP4_AMT_INIT_EXCE);
            }

            /*17.--7--AMT初始化结束               DM1 SPN4021  Key On時*/
            variable_4 = Get_ID_18FECA03_Sig_SPN();

            if ((variable_4 == 4021u) && (E_Speed > 350u) && (K_Line_Set.K_Line_LID41 == 0x13u))
            {
                Popup_Request(POPUP4_START_ENG);
            }
            else
            {
                Popup_Delete(POPUP4_START_ENG);
            }

            /*----第五组---------------------------------------------------------------------*/
            /*19.--1--过热（过热，请在安全的场所停车）有车速     LID $43 :0x82*/
            variable_1 = Common_Get_Water_Temp_Level_Flag();

            if ((variable_1 == 1u) && (K_Line_Set.K_Line_LID43 == 0x82))
            {
                Popup_Request(POPUP5_OVER_HEAT);
            }
            else
            {
                Popup_Delete(POPUP5_OVER_HEAT);
            }

            /*20.--2--冷却水（冷却液不足） B32 GND*/
            variable_1 = Line_In_Get_Status(LINE_IN_LOW_COOLANT);

            if (variable_1 == LINE_IN_LOGIC_VALID)
            {
                Popup_Request(POPUP5_LOW_COOLANT);
            }
            else
            {
                Popup_Delete(POPUP5_LOW_COOLANT);
            }

            /*21.--3--油压(机油)请在安全场所停车 发动机启动(350r/min)后、350r/min持续5秒以上时，A32信号（10ms周期监测），连续20次检出Lo时。*/
            variable_1 = Line_In_Get_Status(LINE_IN_ENG_OIL);

            if ((E_Speed > 350u) && (variable_1 == LINE_IN_LOGIC_VALID))
            {
                Popup_Request(POPUP5_ENGINE_OIL_PRESSURE);
            }
            else
            {
                Popup_Delete(POPUP5_ENGINE_OIL_PRESSURE);
            }

            /*22.--4--仪表故障-请与五十铃公司联系*/
            Popup_Clear(POPUP5_METER_FAILURE);

            /*23.--5--通信系统-请与五十铃公司联系*/
            if (Can_BusOFF == ID_TOTAL_MAX)
            {
                Popup_Request(POPUP5_CAN_ERROR);
            }
            else
            {
                Popup_Delete(POPUP5_CAN_ERROR);
            }

            /*24.--6--车速限制-图1   ID：18FF2300 Byte：7 Bit：4,3   10(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Engine_Derate();

            if ((variable_1 == 0x02u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_SPEED_LIMIT);
            }
            else
            {
                Popup_Delete(POPUP5_SPEED_LIMIT);
            }

            /*25.--7--扭矩限制-图2 ID：18FF2300 Byte：7 Bit：4,3   01(B)*/
            if ((variable_1 == 0x01u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_TORQUE_REDUCTION);
            }
            else
            {
                Popup_Delete(POPUP5_TORQUE_REDUCTION);
            }

            /*26.--8--尿素品质异常-图1 ID：18FF2300 Byte：3 Bit：6,5  01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber3();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUP5_INCORRECT_ADBLUE);
            }
            else
            {
                Popup_Delete(POPUP5_INCORRECT_ADBLUE);
            }

            /*27.--9--临界排放故障-图1 ID：18FF2300 Byte：7 Bit：6,5  01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_EXH_System();

            if (variable_1 == 1)
            {
                Popup_Request(POPUP5_CRITICAL_EMISSION);
            }
            else
            {
                Popup_Delete(POPUP5_CRITICAL_EMISSION);
            }

            if (K_Line_Set.K_Line_LID41 == 0x13u)
            {
                /*28.--10--AMT异常-图1 ID：18FF8503 Byte：1 Bit：4,3 01(B) LID $41 : 0x13          PGN：65413  TC2DIS*/
                variable_1 = Get_ID_18FF8503_Sig_Spanner_Warning();

                if (variable_1 == 1)
                {
                    Popup_Request(POPUP5_AMT_SPANNER_WARNING);
                }
                else
                {
                    Popup_Delete(POPUP5_AMT_SPANNER_WARNING);
                }

                /*29.--11--AMT异常(气压低下)-图1 ID：18FF8503 Byte：2 Bit：6,5 01(B) LID $41 : 0x13  PGN：65413  TC2DIS*/
                variable_1 = Get_ID_18FF8503_Sig_Low_air_warning();

                if (variable_1 == 1)
                {
                    Popup_Request(POPUP5_AMT_LOW_AIR_WARNING);
                }
                else
                {
                    Popup_Delete(POPUP5_AMT_LOW_AIR_WARNING);
                }
            }
            else
            {
                Popup_Clear(POPUP5_AMT_SPANNER_WARNING);
                Popup_Clear(POPUP5_AMT_LOW_AIR_WARNING);
            }

            /*30.--12--胎压 低圧警報-轮胎漏气警告 ID：18011733  Byte：5 Bit：5 01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSFast_air_leakage();

            if ((K_Line_Set.K_Line_LID3E == 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_LOW_PRESSURE_ALARM);
            }
            else
            {
                Popup_Delete(POPUP5_LOW_PRESSURE_ALARM);
            }

            /*31.--13--尿素补给-补充尿素溶液-图1 ID：18FF2300 Byte：3 Bit：4,3 01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber2();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUP5_APP_ADBLUE);
            }
            else
            {
                Popup_Delete(POPUP5_APP_ADBLUE);
            }

            /*32.--14--尿素余量少-无车速-图2 ID：18FF2300 Byte：3 Bit：4,3 10(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber2();

            if (variable_1 == 0x02u)
            {
                Popup_Request(POPUP5_ADBLUE_LEVEL_LOW);
            }
            else
            {
                Popup_Delete(POPUP5_ADBLUE_LEVEL_LOW);
            }

            /*33.--15--低圧警報（低下）ID：18011733  Byte：5 Bit：8 01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSLow_Presure_Sta();

            if ((K_Line_Set.K_Line_LID3E == 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_LOW_FAILURE);
            }
            else
            {
                Popup_Delete(POPUP5_LOW_FAILURE);
            }

            /*34.--16--摄像头有污染-请与五十铃公司联系 ID：18FE5BE8 Byte7  Bit5-8 0010(B) 0011(B) LID $27: 0x01*/
            variable_1 = Get_ID_18FE5BE8_Sig_Camera_Status();

            if ((K_Line_Set.K_Line_LID27 == 0x01u) && ((variable_1 == 0x02u) || (variable_1 == 0x03u)))
            {
                Popup_Request(POPUP5_CAMERA_POLLUTION);
            }
            else
            {
                Popup_Delete(POPUP5_CAMERA_POLLUTION);
            }

            /*35.--17尿素喷射异常（停止）-图1 ID：18FF2300 Byte：3 Bit：2,1 01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber1();

            if ((variable_1 == 0x01u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_AdBlue_INJ_SYSTEM);
            }
            else
            {
                Popup_Delete(POPUP5_AdBlue_INJ_SYSTEM);
            }

            /*36.--18--尿素喷射异常（消耗量）-图1  ID：18FF2300 Byte：3 Bit：2,1 10(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber1();

            if ((variable_1 == 0x02u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_AdBlue_DOS_MALFUNC);
            }
            else
            {
                Popup_Delete(POPUP5_AdBlue_DOS_MALFUNC);
            }

            /*37.--19--高圧警報-轮胎高压警告 ID：18011733  Byte：5 Bit：7  01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSHigh_Presure_Sta();

            if ((K_Line_Set.K_Line_LID3E == 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_TPMS_HIGH_AIR);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_HIGH_AIR);
            }

            /*38.--20--高温警報-轮胎高温警告 ID：18011733  Byte：5 Bit：6  01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSHigh_Temperature_Sta();

            if ((K_Line_Set.K_Line_LID3E == 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_TPMS_HIGH_TEMP);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_HIGH_TEMP);
            }

            /*39.--22--DPD手动再生要求1-DPD需要再生 18FD7C00 Byte：1 Bit：3-1  001：On – solid*/
            variable_1 = Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUP5_PUSH_DPD_SWITCH1);
            }
            else
            {
                Popup_Delete(POPUP5_PUSH_DPD_SWITCH1);
            }

            /*40.--23--DPD手动再生要求2-DPD需要再生 18FD7C00 Byte：1 Bit：3-1     100：On – fast blink (1 HZ)*/
            variable_1 = Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber();

            if (variable_1 == 0x04u)
            {
                Popup_Request(POPUP5_PUSH_DPD_SWITCH2);
            }
            else
            {
                Popup_Delete(POPUP5_PUSH_DPD_SWITCH2);
            }

            /*41.--24--TPMS故障-轮胎监控失败  ID：18011733  Byte：6 Bit：ALL 0111(B) or 1000(B) or 1001(B)*/
            variable_1 = Get_TPMSSensor_fault_Sta();
            variable_2 = CAN_MSG_Status(ID_CanMsg18011733_Msg_Count);

            if ((K_Line_Set.K_Line_LID3E == 0x01u) && ((variable_1 == 0x01u) || (variable_2 == CAN_SIG_LOST)))
            {
                Popup_Request(POPUP5_TPMS_FAILURE);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_FAILURE);
            }

            /*42.--25--TPMS電池低下-轮胎监控传感器电压下降  ID：18011733  Byte：5 Bit：4  01(B)  LID $3E : 0x01*/
            variable_1 = Get_TPMSLow_Voltage_Sta();

            if ((K_Line_Set.K_Line_LID3E == 0x01u) && (variable_1 == 1))
            {
                Popup_Request(POPUP5_TPMS_MONITOR_DROP);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_MONITOR_DROP);
            }

            /*----第六组---------------------------------------------------------------------*/
            if (V_Speed < 66u)
            {
                /*43.--1--遥控车辆高度调整中(无车速) B30 28V*/
                variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);

                if (variable_1 == 0x01u)
                {
                    Popup_Request(POPUP6_HEIGHT_CONTROL);
                }
                else
                {
                    Popup_Delete(POPUP6_HEIGHT_CONTROL);
                }

                /*44.--2--PTO(停车中)(无车速)  /ID：18FED900  Byte：2 Bit：8,7  01(B)   OR  B01 28V*/
                variable_1 = Get_ID_18FED900_Sig_PTO_SW();
                variable_2 = Line_In_Get_Status(LINE_IN_PTO);

                if ((variable_1 == 0x01u) || (variable_2 == 0x01u))
                {
                    Popup_Request(POPUP6_PTO_STOP);
                }
                else
                {
                    Popup_Delete(POPUP6_PTO_STOP);
                }
            }
            else
            {
                Popup_Clear(POPUP6_HEIGHT_CONTROL);
                Popup_Clear(POPUP6_PTO_STOP);
            }

            /*----第七组---------------------------------------------------------------------*/
            /*45.--1--充电异常-请与五十铃公司联系*/
            variable_1 = Line_In_Get_Status(LINE_IN_CHARGE);
            variable_2 = Common_Get_VolWarning_Sta();

            if (((variable_1 == 0x01u) || (variable_2 == 0x01u)) && (E_Speed > 350u))
            {
                Popup_Request(POPUP7_CHARGE_ABNORMAL);
            }
            else
            {
                Popup_Delete(POPUP7_CHARGE_ABNORMAL);
            }

            /*46.--2--AMT異常-AMT异常  ID：18FF8503　Bite：1 Bit：2,1   LID $41 : 0x13*/
            variable_1 = Get_ID_18FF8503_Sig_Stop_Warning();

            if ((K_Line_Set.K_Line_LID41 == 0x13u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP7_AMT_ERROR);
            }
            else
            {
                Popup_Delete(POPUP7_AMT_ERROR);
            }

            /*----第八组---------------------------------------------------------------------*/
            /*47.--1--补充燃料-油箱单位*/
            variable_1 = Fuel_Get_CurSeg();    /*格*/
            variable_2 = GetFuelSensorState(); /*燃油状态*/
            variable_5 = GetFuelResistance();  /*采集的阻值*/

            if (K_Line_Set.K_Line_LID43 == 0x82u)
            {
                if ((variable_1 <= 1) && (variable_2 == FuelSensorNormal) && (variable_5 != 65535))
                {
                    Popup_Request(POPUP8_REFUEL);
                }
                else
                {
                    Popup_Delete(POPUP8_REFUEL);
                }
            }
            else
            {
                Popup_Clear(POPUP8_REFUEL);
            }

            if (K_Line_Set.K_Line_LID41 == 0x13u)
            {
                /*48.--2--AMT过热-离合器过载 ID：18FF8503　Bite：2 Bit：4,3  001(B)  LID $41 : 0x13*/
                variable_1 = Get_ID_18FF8503_Sig_Clutch_Overload_warning();

                if (variable_1 == 0x01u)
                {
                    Popup_Request(POPUP8_ATM_CLUCH_OVERHEATING);
                }
                else
                {
                    Popup_Delete(POPUP8_ATM_CLUCH_OVERHEATING);
                }

                /*49.--3--AMT磨耗-离合器磨损 ID：18FF8503　Bite：2 Bit：2,1  001(B)  LID $41 : 0x13*/
                variable_1 = Get_ID_18FF8503_Sig_Manouvering_mode();

                if (variable_1 == 0x01u)
                {
                    Popup_Request(POPUP1_BRAKE_BRAKE);
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BRAKE);
                }
            }
            else
            {
                Popup_Clear(POPUP8_ATM_CLUCH_OVERHEATING);
                Popup_Clear(POPUP1_BRAKE_BRAKE);
            }

            /*50.--4--低电压报警 显示条件：发动机启动(350r/min)后，7秒检测到23.5V时 显示消失条件：10秒检测到25V以上时*/
            variable_1 = Common_Get_LOW_VOLTAGE();

            if ((variable_1 == 0x01u) && (E_Speed > 350)) // 23.5V
            {
                Popup_Request(POPUP8_LOWVOLTAGE);
            }
            else if (variable_1 == 0x00u)
            {
                Popup_Delete(POPUP8_LOWVOLTAGE);
            }

            /*51.--5--过电压报警 显示条件：发动机启动(350r/min)后，7秒检测到30.4V以上时 显示消失条件：10秒检测到29.4V以下时*/
            variable_1 = Common_Get_HIGH_VOLTAGE();

            if ((variable_1 == 0x01u) && (E_Speed > 350)) // 30.44V
            {
                Popup_Request(POPUP8_OVERVOLTAGE);
            }
            else if (variable_1 == 0x00u)
            {
                Popup_Delete(POPUP8_OVERVOLTAGE);
            }

            /*52.--6--后蹄片磨损*/
            variable_1 = Line_In_Get_Status(LINE_IN_WEAR2);

            if (variable_1 == LINE_IN_LOGIC_VALID)
            {
                Popup_Request(POPUP8_BRAKE_BLOCKR);
            }
            else
            {
                Popup_Delete(POPUP8_BRAKE_BLOCKR);
            }

            /*53.--7--前蹄片磨损*/
            variable_1 = Line_In_Get_Status(LINE_IN_WEAR_IND);

            if (variable_1 == LINE_IN_LOGIC_VALID)
            {
                Popup_Request(POPUP8_BRAKE_BLOCKF);
            }
            else
            {
                Popup_Delete(POPUP8_BRAKE_BLOCKF);
            }

            /*54.--8--DPD自动再生-DPD自动再生中  ID：18FED900 (AUXIO)  Byte：8  bit：5,4  01(B)  Engine Speed ： 350rpm以上*/
            variable_1 = Get_ID_18FED900_Sig_DPF_Regeneration_Status();

            if ((E_Speed >= 350) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP8_DPD_AUTO);
            }
            else
            {
                Popup_Delete(POPUP8_DPD_AUTO);
            }

            /*----第九组---------------------------------------------------------------------*/
            /*55.--1--气压过低-请冲入空气*/
            variable_1 = (uint8_t)Line_In_Get_Status(LINE_IN_BRAKE_AIR_EBS);
            variable_2 = Common_Get_L12_Air_Sta();

            if ((variable_1 == LINE_IN_LOGIC_VALID) || (variable_2 == 0X01U))
            {
                Popup_Request(POPUP9_AIR_PRESSURE);
            }
            else
            {
                Popup_Delete(POPUP9_AIR_PRESSURE);
            }

            /*56.--2--EBS故障（红）-请与五十铃公司联系*/
            variable_1 = Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State();
            variable_2 = CAN_MSG_Status(ID_CanMsg18F0010B_Msg_Count);

            if (K_Line_Set.K_Line_LID21 == 0x01u)
            {
                if ((variable_1 == 0x01u) || (variable_2 == CAN_SIG_LOST))
                {
                    Popup_Request(POPUP9_EBS_ERROR);
                }
                else
                {
                    Popup_Delete(POPUP9_EBS_ERROR);
                }
            }
            else
            {
                Popup_Clear(POPUP9_EBS_ERROR);
            }

            /*----第十组---------------------------------------------------------------------*/
            /*57.--1--省油耗建议-急加速*/
            if ((AccSubSpeed.AccSpeed_Flag == 1) && (User_App.User_JADD != 0xFF))
            {
                Popup_Request(POPUP10_RAPID_ACC);
            }
            else
            {
                Popup_Delete(POPUP10_RAPID_ACC);
            }

            /*58.--2--省油耗建议-急减速*/
            if ((AccSubSpeed.SubSpeed_Flag == 1) && (User_App.User_JSUB != 0xFF))
            {
                Popup_Request(POPUP10_RAPID_SUB);
            }
            else
            {
                Popup_Delete(POPUP10_RAPID_SUB);
            }

            /*59.--3--省油耗建议-请降低发动机转速*/
            variable_1 = Common_Get_OverSpeed_Status();

            if ((variable_1 == 1) && (User_App.User_Speed != 0xFF))
            {
                Popup_Request(POPUP10_REVAL_ENGINE);
            }
            else
            {
                Popup_Delete(POPUP10_REVAL_ENGINE);
            }

            /*60.--4--省油耗建议-请降低速度*/
            variable_1 = Common_Get_OverSpeedLine_Status();

            if (
                ((variable_1 == 1) && (K_Line_Set.K_Line_LID44 != 0xFF)) ||
                ((AccSubSpeed.GslSpeed_Flag == 0x01u) && (User_App.User_Gsl == 0x01u)) ||
                ((AccSubSpeed.YblSpeed_Flag == 0x01u) && (User_App.User_Ybl == 0x01u)))
            {
                Popup_Request(POPUP10_REVAL_SPEED);
            }
            else
            {
                Popup_Delete(POPUP10_REVAL_SPEED);
            }

            /*----第十一组---------------------------------------------------------------------*/
            /*61.--1--发动机机油＆滤清器*/
            if (((State_Flag.User_FDJYLQQ_FLAG == 1) || (State_Flag.User_FDJYLQQ_FLAG == 2)) && (Common_Get_FDJYLQQ_Sta() == 0x01u))
            {
                Popup_Request(POPUP11_ENGINE_OIL_FILTER);
            }
            else
            {
                Popup_Delete(POPUP11_ENGINE_OIL_FILTER);
            }

            /*62.--2--燃油滤清器*/
            if (((State_Flag.User_RYLQQ_FLAG == 1) || (State_Flag.User_RYLQQ_FLAG == 2)) && (Common_Get_RYLQQ_Sta() == 0x01u))
            {
                Popup_Request(POPUP11_FUEL_FILTER);
            }
            else
            {
                Popup_Delete(POPUP11_FUEL_FILTER);
            }

            /*63.--3--变速箱油*/
            if (((State_Flag.User_BSXY_FLAG == 1) || (State_Flag.User_BSXY_FLAG == 2)) && (Common_Get_BSXY_Sta() == 0x01u))
            {
                Popup_Request(POPUP11_T_MISSION_OIL);
            }
            else
            {
                Popup_Delete(POPUP11_T_MISSION_OIL);
            }

            /*64.--4--差速器油*/
            if (((State_Flag.User_CSQY_FLAG == 1) || (State_Flag.User_CSQY_FLAG == 2)) && (Common_Get_CSQY_Sta() == 0x01u))
            {
                Popup_Request(POPUP11_DIFF_OIL);
            }
            else
            {
                Popup_Delete(POPUP11_DIFF_OIL);
            }

            /*65.--5--顺畅系统离合器油*/
            // if(((State_Flag.User_LHQY_FLAG   == 1) || (State_Flag.User_LHQY_FLAG   == 2))&&(Common_Get_LHQY_Sta() ==0x01u))
            if (0)
            {
                Popup_Request(POPUP11_CLUTCH_OIL);
            }
            else
            {
                Popup_Delete(POPUP11_CLUTCH_OIL);
            }

            /*66.--6--动力转向液*/
            if (((State_Flag.User_DLZXY_FLAG == 1) || (State_Flag.User_DLZXY_FLAG == 2)) && (Common_Get_DLZXY_Sta() == 0x01u))
            {
                Popup_Request(POPUP11_P_STEERING_FRUID);
            }
            else
            {
                Popup_Delete(POPUP11_P_STEERING_FRUID);
            }

            /*67.--7--更换轮胎・轮胎位置*/
            if (((State_Flag.User_LT_FLAG == 1) || (State_Flag.User_LT_FLAG == 2)) && (Common_Get_LT_Sta() == 0x01u))
            {
                Popup_Request(POPUP11_TIRE_ROTATION);
            }
            else
            {
                Popup_Delete(POPUP11_TIRE_ROTATION);
            }
        }
        else /*ig off*/
        {
            Popup_Clear(POPUP1_BRAKE_BLACK);             /*00.紧急警报-刹车*/
            Popup_Clear(POPUP1_BRAKE_BRAKE);             /*01.紧急警报-紧急制动*/
            Popup_Clear(POPUP1_BRAKE_SPACING_R);         /*02.车间距警报-刹车(红字)*/
            Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION); /*03.车间距警报-碰撞报警*/
            Popup_Clear(POPUP1_BRAKE_SPACING_Y);         /*04.车间距警报-刹车(黄字)*/
            Popup_Clear(POPUT1_ASR_OPERATE);             /*05.ASR工作*/
            Popup_Clear(POPUT2_PTO);                     /*06.PTO紧急警报-刹车*/
            Popup_Clear(POPUP2_PARKING_BRAKE);           /*07.忘记松手刹车*/
            Popup_Clear(POPUP2_AIRMATIC_HIGHT);          /*08.遥控调整车辆高度(有车速)*/
            Popup_Clear(POPUP3_CRUISE);                  /*09.自动巡航模式*/
            Popup_Clear(POPUP3_VARIABLE_SLD);            /*10.可变SLD 模式*/
            Popup_Clear(POPUT4_ABNORMAL_CHARGE);         /*11.充电异常（系统检测）*/
            Popup_Clear(POPUP4_OIL_PRESSURE);            /*12.油压（系统检测）*/
            Popup_Clear(POPUP4_AMT_INIT_EXCE);           /*13.AMT初始化异常*/
            Popup_Clear(POPUP4_ADBLUE_QUALITY);          /*14.尿素品质异常（系统检测）*/
            Popup_Clear(POPUP4_ADBLUE_SPRAY);            /*15.尿素喷射异常（系统检测）*/
            Popup_Clear(POPUP4_ADBLUE_SUPPLY);           /*16.尿素水补给（系统检测）*/
            Popup_Clear(POPUP4_START_ENG);               /*17.AMT初始化结束*/
            Popup_Clear(POPUP4_DPD_AUTO);                /*18.DPD自动再生*/
            Popup_Clear(POPUP5_OVER_HEAT);               /*19.过热（过热，请在安全的场所停车）*/
            Popup_Clear(POPUP5_LOW_COOLANT);             /*20.冷却水（冷却水不足）*/
            Popup_Clear(POPUP5_ENGINE_OIL_PRESSURE);     /*21.油压异常*/
            Popup_Clear(POPUP5_METER_FAILURE);           /*22.仪表故障-请与五十铃公司联系*/
            Popup_Clear(POPUP5_CAN_ERROR);               /*23.通信系统-请与五十铃公司联系*/
            Popup_Clear(POPUP5_SPEED_LIMIT);             /*24.车速限制*/
            Popup_Clear(POPUP5_TORQUE_REDUCTION);        /*25.扭矩限制*/
            Popup_Clear(POPUP5_INCORRECT_ADBLUE);        /*26.尿素品质异常*/
            Popup_Clear(POPUP5_CRITICAL_EMISSION);       /*27.临界排放故障*/
            Popup_Clear(POPUP5_AMT_SPANNER_WARNING);     /*28.AMT异常-请重启发动机*/
            Popup_Clear(POPUP5_AMT_LOW_AIR_WARNING);     /*29.AMT异常(气压低下)*/
            Popup_Clear(POPUP5_LOW_PRESSURE_ALARM);      /*30.胎压报警-快速漏气*/
            Popup_Clear(POPUP5_APP_ADBLUE);              /*31.尿素补给-补充尿素溶液*/
            Popup_Clear(POPUP5_ADBLUE_LEVEL_LOW);        /*32.尿素余量少-无车速*/
            Popup_Clear(POPUP5_LOW_FAILURE);             /*33.胎压报警-气压低*/
            Popup_Clear(POPUP5_CAMERA_POLLUTION);        /*34.摄像头有污染-请与五十铃公司联系*/
            Popup_Clear(POPUP5_AdBlue_INJ_SYSTEM);       /*35.尿素喷射异常（停止）*/
            Popup_Clear(POPUP5_AdBlue_DOS_MALFUNC);      /*36.尿素喷射异常（消耗量）*/
            Popup_Clear(POPUP5_TPMS_HIGH_AIR);           /*37.高圧警報-轮胎高压警告*/
            Popup_Clear(POPUP5_TPMS_HIGH_TEMP);          /*38.高温警報-轮胎高温警告*/
            Popup_Clear(POPUP5_PUSH_DPD_SWITCH1);        /*39.DPD手动再生要求1-请按下DPD开关*/
            Popup_Clear(POPUP5_PUSH_DPD_SWITCH2);        /*40.DPD手动再生要求2-请按下DPD开关*/
            Popup_Clear(POPUP5_TPMS_FAILURE);            /*41.TPMS故障*/
            Popup_Clear(POPUP5_TPMS_MONITOR_DROP);       /*42.TPMS電池低下-轮胎监控传感器电压下降*/
            Popup_Clear(POPUP6_HEIGHT_CONTROL);          /*43.遥控车辆高度调整中(无车速)*/
            Popup_Clear(POPUP6_PTO_STOP);                /*44.PTO(停车中)*/
            Popup_Clear(POPUP7_CHARGE_ABNORMAL);         /*45.充电异常-请与五十铃公司联系*/
            Popup_Clear(POPUP7_AMT_ERROR);               /*46.AMT異常-请联系经销商*/
            Popup_Clear(POPUP8_REFUEL);                  /*47.补充燃料-油箱单位*/
            Popup_Clear(POPUP8_ATM_CLUCH_OVERHEATING);   /*48.AMT过热-选择合适的档位*/
            Popup_Clear(POPUP8_ATM_WORN_OUT);            /*49.AMT磨耗-离合器磨损*/
            Popup_Clear(POPUP8_LOWVOLTAGE);              /*50.低电压报警*/
            Popup_Clear(POPUP8_OVERVOLTAGE);             /*51.过电压报警*/
            Popup_Clear(POPUP8_BRAKE_BLOCKR);            /*52.后蹄片磨损*/
            Popup_Clear(POPUP8_BRAKE_BLOCKF);            /*53.前蹄片磨损*/
            Popup_Clear(POPUP8_DPD_AUTO);                /*54.DPD自动再生-再生将自动完成，不需要操作开关*/
            Popup_Clear(POPUP9_AIR_PRESSURE);            /*55.气压过低-请冲入空气*/
            Popup_Clear(POPUP9_EBS_ERROR);               /*56.EBS故障（红）-请与五十铃公司联系*/
            Popup_Clear(POPUP10_RAPID_ACC);              /*57.省油耗建议-急加速*/
            Popup_Clear(POPUP10_RAPID_SUB);              /*58.省油耗建议-急减速*/
            Popup_Clear(POPUP10_REVAL_ENGINE);           /*59.省油耗建议-请降低发动机转速*/
            Popup_Clear(POPUP10_REVAL_SPEED);            /*60.省油耗建议-请降低速度*/
            Popup_Clear(POPUP11_ENGINE_OIL_FILTER);      /*61.发动机机油＆滤清器*/
            Popup_Clear(POPUP11_FUEL_FILTER);            /*62.燃油滤清器*/
            Popup_Clear(POPUP11_T_MISSION_OIL);          /*63.变速箱油*/
            Popup_Clear(POPUP11_DIFF_OIL);               /*64.差速器油*/
            Popup_Clear(POPUP11_CLUTCH_OIL);             /*65.顺畅系统离合器油*/
            Popup_Clear(POPUP11_P_STEERING_FRUID);       /*66.动力转向液*/
            Popup_Clear(POPUP11_TIRE_ROTATION);          /*67.更换轮胎・轮胎位置*/
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Popups_Displaying
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Popups_Displaying(uint16_t PopupMsg)
{
    if (PopupMsg < POPUP_MSG_NUMBER_TOTAL)
    {
        switch (PopupMsgAttributeTable[PopupMsg].Type)
        {
        case POPUP_TYPE_GENERAL:
            GUI_General_Popup_Display(PopupMsg);
            break;

        default:
            break;
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Popups_Sound_Playing
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Popups_Sound_Playing(uint8_t PopupSnd)
{
    uint8_t ReqCode = 0u;

    ReqCode = Popup_Get_Current_Sound_Req_Code();

    switch (PopupSnd)
    {
    default:
        if (ReqCode)
            Sound_Request(PopupSnd, ReqCode);
        else
            Sound_Delete(PopupSnd);
        break;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Popup_Alone_Sound_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
//uint16_t Sound_test = 0;
void Popup_Alone_Sound_Server(void)
{
    COMMON_PowerStatus_t u8IG_st;
    uint32_t u32IG_OFF_Timer = 0x00u;
    uint32_t u32IG_ON_Timer = 0x00u;
    uint8_t variable_1 = 0u;
    uint8_t variable_2 = 0u;
    uint16_t V_Speed = 0u;
    uint8_t EVSC1 = 0u;
    uint8_t EVSC2 = 0u;
    uint8_t EVSC3 = 0u;
    uint8_t EVSC4 = 0u;
    uint8_t EVSC5 = 0u;
    uint8_t EVSC6 = 0u;
    uint8_t EVSC7 = 0u;
    uint8_t EVSC8 = 0u;
    uint8_t EVSC9 = 0u;

    u32IG_ON_Timer = Common_GetIgnOnTime();
    u32IG_OFF_Timer = Common_GetIgnOffTime();
    u8IG_st = Common_Get_IG_Sts();

    if ((u32IG_ON_Timer <= PopupStart) && (u32IG_ON_Timer >= 2u))
    {
        /*00 忘拔钥匙*/
        Sound_Delete(SND_Key_Notremoved);
    }
    else
    {
        if (u8IG_st == COMMON_POWER_ON)
        {
            /*00 忘拔钥匙*/
            Sound_Delete(SND_Key_Notremoved);

            /*01 制动*/
            if ((CD4051_COM1_X4_IN == 0u) && (CD4051_COM1_X7_IN == 1u))
            {
                Sound_Request(SND_Braking, 1u);
            }
            else
            {
                Sound_Delete(SND_Braking);
            }

            /*02 制动气压*/
            variable_1 = Common_Get_L12_Air_Sta();
            if ((variable_1 == 1u) || (CD4051_COM2_X7_IN == 0u))
            {
                Sound_Request(SND_Air_Brake, 1u);
            }
            else
            {
                Sound_Delete(SND_Air_Brake);
            }

            /*03 BRAKE LOCK*/
            if (0)
            {
                Sound_Request(SND_BRAKE_LOCK, 1u);
            }
            else
            {
                Sound_Delete(SND_BRAKE_LOCK);
            }

            /*04 停车制动忘记复位*/
            if (0)
            {
                Sound_Request(SND_Parking_Brake, 1u);
            }
            else
            {
                Sound_Delete(SND_Parking_Brake);
            }

            /*05 车厢报警自卸蜂鸣器*/
            if (0)
            {
                Sound_Request(SND_Car_Dump_SPEED, 1u);
            }
            else
            {
                Sound_Delete(SND_Car_Dump_SPEED);
            }

            /*06 水温过热*/
            variable_1 = Common_Get_Water_Temp_Level_Flag();
            if ((variable_1 == 1) && (K_Line_Set.K_Line_LID43 == 0x82))
            {
                Sound_Request(SND_Temp_High, 1u);
            }
            else
            {
                Sound_Delete(SND_Temp_High);
            }

            /*07 冷却水量*/
            if (CD4051_COM5_X4_IN == 0u)
            {
                Sound_Request(SND_Coolant_Low, 1u);
            }
            else
            {
                Sound_Delete(SND_Coolant_Low);
            }

            /*08 -(预留：油压)*/
            if (CD4051_COM2_X1_IN == 0u)
            {
                Sound_Request(SND_Oil_pressure_Low, 1u);
            }
            else
            {
                Sound_Delete(SND_Oil_pressure_Low);
            }

            /*09 ACC AIR*/
            if ((CD4051_COM7_X0_IN == 0u) && (CD4051_COM1_X7_IN == 1u))
            {
                Sound_Request(SND_ACC_AIR, 1u);
            }
            else
            {
                Sound_Delete(SND_ACC_AIR);
            }

            /*10 倒车警报*/
            if (CD4051_COM3_X0_IN == 1u)
            {
                Sound_Request(SND_BackUP_SPEED, 1u);
            }
            else
            {
                Sound_Delete(SND_BackUP_SPEED);
            }

            /*11 DS 警报 */
            if (0)
            {
                Sound_Request(SND_DS_SPEED, 1u);
            }
            else
            {
                Sound_Delete(SND_DS_SPEED);
            }

            /*12 ROWS 警报 */
            if (0)
            {
                Sound_Request(SND_ROWS_SPEED, 1u);
            }
            else
            {
                Sound_Delete(SND_ROWS_SPEED);
            }

            /*13 Roll 警报 */
            if (0)
            {
                Sound_Request(SND_Roll_SPEED, 1u);
            }
            else
            {
                Sound_Delete(SND_Roll_SPEED);
            }

            /*14 EVSC*/
            EVSC1 = Get_ID_18FE4F0B_Sig_ROP_Engine_Control_Active();
            EVSC2 = Get_ID_18FE4F0B_Sig_ROP_Brake_Control_Active();
            EVSC3 = Get_ID_18FE4F0B_Sig_YC_Engine_Control_Active();
            EVSC4 = Get_ID_18FE4F0B_Sig_YC_Brake_Control_Active();
            EVSC5 = Get_ID_C0320C8_Sig_ID0C0320C8_byte2_bit1_2();
            EVSC6 = Get_ID_C0320C0_Sig_ID0C0320C0_byte2_bit1_2();
            EVSC7 = Get_ID_C0320B8_Sig_ID0C0320B8_byte2_bit1_2();
            EVSC8 = Get_ID_C0320B0_Sig_ID0C0320B0_byte2_bit1_2();
            EVSC9 = Get_ID_C0320A8_Sig_ID0C0320A8_byte2_bit1_2();
            if (K_Line_Set.K_Line_LID22 == 0X01u)
            {
                if ((EVSC1 == 1u) || (EVSC2 == 1u) || (EVSC3 == 1u) || (EVSC4 == 1u) ||
                        (EVSC5 == 1u) || (EVSC6 == 1u) || (EVSC7 == 1u) || (EVSC8 == 1u) || (EVSC9 == 1u))
                {
                    Sound_Request(SND_EVSC_SPEED, 1u);
                }
                else
                {
                    Sound_Delete(SND_EVSC_SPEED);
                }
            }
            else
            {
                Sound_Delete(SND_EVSC_SPEED);
            }

            /*15 DPD 手动再生*/
            //variable_1 = Get_ID_18FE5BE8_Sig_Camera_Status();
            //if (variable_1 == 2u)
            if (0)
            {
                Sound_Request(SND_DPD_SPEED1, 1u);
            }
            else
            {
                Sound_Delete(SND_DPD_SPEED1);
            }

            /*15 DPD 手动再生    SXI-VC66-342_36ページ訂正 20220418*/
            //variable_1 = Get_ID_18FE5BE8_Sig_Camera_Status();
            variable_1 = Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber();
            if (variable_1 == 4u)
            {
                Sound_Request(SND_DPD_SPEED2, 1u);
            }
            else
            {
                Sound_Delete(SND_DPD_SPEED2);
            }

            /*15 DPD 手动再生*/
            //variable_1 = Get_ID_18FE5BE8_Sig_Camera_Status();
            //if (variable_1 == 3u)
            if (0)
            {
                Sound_Request(SND_DPD_SPEED4, 1u);
            }
            else
            {
                Sound_Delete(SND_DPD_SPEED4);
            }

            /*16 NEES */
            if (0)
            {
                Sound_Request(SND_NEES, 1u);
            }
            else
            {
                Sound_Delete(SND_NEES);
            }

            /*17 eco stop */
            if (0)
            {
                Sound_Request(SND_ECO_STOP, 1u);
            }
            else
            {
                Sound_Delete(SND_ECO_STOP);
            }

            if ((K_Line_Set.K_Line_LID2A == 0X01u) || (K_Line_Set.K_Line_LID2A == 0X02u))
            {
                /*18 气悬车高调整  SXI-VC66-342_36ページ訂正 20220418*/
                //variable_1 = Get_ID_CFF0F15_Sig_ID0CFF0F15_byte1_bit4_5();
                variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);
                variable_2 = Common_Get_Disp_V_Speed();
                if ((variable_1 == 1u) && (variable_2 == 0u))
                {
                    Sound_Request(SND_Cyclone_High4HZ, 1u);
                }
                else
                {
                    Sound_Delete(SND_Cyclone_High4HZ);
                }

                /*18 气悬车高调整  SXI-VC66-342_36ページ訂正 20220418*/
                //variable_1 = Get_ID_CFF0F15_Sig_ID0CFF0F15_byte1_bit4_5();
                variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);
                variable_2 = Common_Get_Disp_V_Speed();
                if ((variable_1 == 1u) && (variable_2 >= 5u))
                {
                    Sound_Request(SND_Cyclone_High0_5, 1u);
                }
                else
                {
                    Sound_Delete(SND_Cyclone_High0_5);
                }
            }
            else
            {
                Sound_Delete(SND_Cyclone_High4HZ);
                Sound_Delete(SND_Cyclone_High0_5);
            }

            /*19 安全带*/
            V_Speed = Common_Get_Disp_V_Speed(); /*车速*/
            if ((CD4051_COM2_X3_IN == 0u) && (V_Speed >= 67))
            {
                Sound_Request(SND_SEATBELT_SPEED, 1u);
            }
            else
            {
                Sound_Delete(SND_SEATBELT_SPEED);
            }

            /*20 省油耗建议*/
            variable_1 = Get_ID_18FF4925_Sig_ID18FF4925_byte3_bit1_2();
            variable_2 = Get_ID_18FF4925_Sig_ID18FF4925_byte3_bit3_4();
            if ((variable_1 == 1u) || (variable_2 == 1u))
            {
                Sound_Request(SND_Fuel_Saving, 1u);
            }
            else
            {
                Sound_Delete(SND_Fuel_Saving);
            }

            /*音源测试程序*/
            //if (Sound_test & 0x001) Sound_Request ( SND_Key_Notremoved,   1 ); else Sound_Delete( SND_Key_Notremoved   );
            //if (Sound_test & 0x002) Sound_Request ( SND_Braking,          1 ); else Sound_Delete( SND_Braking          );
            //if (Sound_test & 0x004) Sound_Request ( SND_Air_Brake,        1 ); else Sound_Delete( SND_Air_Brake        );
            //if (Sound_test & 0x008) Sound_Request ( SND_BRAKE_LOCK,       1 ); else Sound_Delete( SND_BRAKE_LOCK       );
            //if (Sound_test & 0x010) Sound_Request ( SND_Parking_Brake,    1 ); else Sound_Delete( SND_Parking_Brake    );
            //if (Sound_test & 0x020) Sound_Request ( SND_Car_Dump_SPEED,   1 ); else Sound_Delete( SND_Car_Dump_SPEED   );
            //if (Sound_test & 0x040) Sound_Request ( SND_Temp_High,        1 ); else Sound_Delete( SND_Temp_High        );
            //if (Sound_test & 0x080) Sound_Request ( SND_Coolant_Low,      1 ); else Sound_Delete( SND_Coolant_Low      );
            //if (Sound_test & 0x100) Sound_Request ( SND_Oil_pressure_Low, 1 ); else Sound_Delete( SND_Oil_pressure_Low );
            //if (Sound_test & 0x200) Sound_Request ( SND_ACC_AIR,          1 ); else Sound_Delete( SND_ACC_AIR          );
            //if (Sound_test & 0x400) Sound_Request ( SND_BackUP_SPEED,     1 ); else Sound_Delete( SND_BackUP_SPEED     );
            //if (Sound_test & 0x800) Sound_Request ( SND_DS_SPEED,         1 ); else Sound_Delete( SND_DS_SPEED         );
            //if (CD4051_COM7_X0_IN == 0u) Sound_Request ( SND_Key_Notremoved,   1 ); else Sound_Delete( SND_Key_Notremoved   );/*B15 = 0*/
            //if (CD4051_COM7_X1_IN == 1u) Sound_Request ( SND_Braking,          1 ); else Sound_Delete( SND_Braking          );/*B16 = 1*/
            //if (CD4051_COM7_X2_IN == 1u) Sound_Request ( SND_Air_Brake,        1 ); else Sound_Delete( SND_Air_Brake        );/*B17 = 1*/
            //if (CD4051_COM7_X3_IN == 1u) Sound_Request ( SND_BRAKE_LOCK,       1 ); else Sound_Delete( SND_BRAKE_LOCK       );/*B14 = 1*/
            //if (CD4051_COM7_X4_IN == 1u) Sound_Request ( SND_Parking_Brake,    1 ); else Sound_Delete( SND_Parking_Brake    );/*B10 = 1*/
            //if (CD4051_COM7_X5_IN == 1u) Sound_Request ( SND_Car_Dump_SPEED,   1 ); else Sound_Delete( SND_Car_Dump_SPEED   );/*B13 = 1*/
            //if (CD4051_COM7_X6_IN == 1u) Sound_Request ( SND_Temp_High,        1 ); else Sound_Delete( SND_Temp_High        );/*B11 = 1*/
            //if (CD4051_COM7_X7_IN == 1u) Sound_Request ( SND_Coolant_Low,      1 ); else Sound_Delete( SND_Coolant_Low      );/*B12 = 1*/
            //if (CD4051_COM6_X5_IN == 1u) Sound_Request ( SND_Oil_pressure_Low, 1 ); else Sound_Delete( SND_Oil_pressure_Low );/*B04 = 1*/
            //if (CD4051_COM6_X6_IN == 1u) Sound_Request ( SND_ACC_AIR,          1 ); else Sound_Delete( SND_ACC_AIR          );/*B02 = 1*/
            //if (CD4051_COM6_X7_IN == 0u) Sound_Request ( SND_BackUP_SPEED,     1 ); else Sound_Delete( SND_BackUP_SPEED     );/*B03 = 0*/
        }
        else /*IG-OFF*/
        {
            /*A3-28 A20-GND B39-OPEN  A2-OPEN*/
            variable_1 = Line_In_Get_Status(LINE_IN_ACC);
            if ((CD4051_COM3_X7_IN == 1u) && (CD4051_COM3_X5_IN == 0u) && (variable_1 == 0u))
            {
                Sound_Request(SND_Key_Notremoved, 1u); /*00 忘拔钥匙*/
            }
            else
            {
                Sound_Delete(SND_Key_Notremoved);
            }

            Sound_Delete(SND_Braking);          /*01 制动*/
            Sound_Delete(SND_Air_Brake);        /*02 制动气压*/
            Sound_Delete(SND_BRAKE_LOCK);       /*03 BRAKE LOCK*/
            Sound_Delete(SND_Parking_Brake);    /*04 停车制动忘记复位*/
            Sound_Delete(SND_Car_Dump_SPEED);   /*05 车厢报警自卸蜂鸣器*/
            Sound_Delete(SND_Temp_High);        /*06 水温过热*/
            Sound_Delete(SND_Coolant_Low);      /*07 冷却水量*/
            Sound_Delete(SND_Oil_pressure_Low); /*08 -(预留：油压)*/
            Sound_Delete(SND_ACC_AIR);          /*09 ACC AIR*/
            Sound_Delete(SND_BackUP_SPEED);     /*10 倒车警报*/
            Sound_Delete(SND_DS_SPEED);         /*11 DS 警报*/
            Sound_Delete(SND_ROWS_SPEED);       /*12 ROWS 警报*/
            Sound_Delete(SND_Roll_SPEED);       /*13 Roll 警报*/
            Sound_Delete(SND_EVSC_SPEED);       /*14 EVSC*/
            Sound_Delete(SND_DPD_SPEED1);       /*15 DPD 手动再生*/
            Sound_Delete(SND_DPD_SPEED2);       /*15 DPD 手动再生*/
            Sound_Delete(SND_DPD_SPEED4);       /*15 DPD 手动再生*/
            Sound_Delete(SND_NEES);             /*16 NEES*/
            Sound_Delete(SND_ECO_STOP);         /*17 eco stop*/
            Sound_Delete(SND_Cyclone_High4HZ);  /*18 气悬车高调整*/
            Sound_Delete(SND_Cyclone_High0_5);  /*18 气悬车高调整*/
            Sound_Delete(SND_SEATBELT_SPEED);   /*19 安全带*/
            Sound_Delete(SND_Fuel_Saving);      /*20 省油耗建议*/
        }
    }
}


