/**

* @file    Gauges.h
* @details Gauges management.
* @author     TYW_YuTian
* @date       2021-2-22
* @version A001
* @par Copyright (c):
*   TIANYOUWEI
* @par History:
*   version: author, date, desc\n

*/
#ifndef _GAUGES_H_
#define _GAUGES_H_

#include "TYW_stdint.h"
/* --- Data  Type Define --- */
/*#define uint8_t unsigned char */
/*#define uint16_t unsigned short//3360 324 */
/*#define uint16_t unsigned int*/ /*Freesecale */
/*#define uint32_t unsigned long*/

/*??Struct*/
typedef enum
{
    StepperMotor = 0u,
    MotorGasType,
    MotorTempType,
    LCDGasType,
    LEDOtherType,
    LEDGasType,
    LEDTempType,
    IndicatTypeTOtal,
    FreeMoveType,

} _GaugesType;
/**@struct _GaugesInfoInit
*this is _GaugesInfoInit
*/

typedef struct
{

    uint8_t          SectorNum;
    uint8_t          GaugesType;
    uint16_t         ReferenceDataInUp[20];
    uint16_t         ReferenceDataInDown[20];
    uint16_t         ReferenceDataInOut[20];
    uint16_t         *GaugesDataIn;
    uint16_t         GaugesStartTime;
    uint8_t          GaugesTestFlag;

} _GaugesInfoInit;

extern uint8_t  QuerySector(_GaugesInfoInit *GParam, uint8_t  DirecSignPara, uint8_t SubAscf, uint16_t  FunGaugesDataIn);
extern uint16_t GetGaugestargetPosSub( _GaugesInfoInit *GParam, uint8_t SubAscf, uint8_t SectorID, uint8_t DirecSignPara, uint16_t FunGaugesDataIn );
extern uint16_t GetGaugestargetPos( _GaugesInfoInit *GParam, uint8_t  DirecSignPara);
extern void GaugesForwardParaManage( _GaugesInfoInit *GParam, uint8_t DirecSignPara );
extern void GaugesInversionParaManage( _GaugesInfoInit *GParam, uint8_t DirecSignPara );
extern void GaugeMoveing(uint8_t GaugesNum);
extern void GetGaugesDisplayMode (uint8_t GaugesNum);
/*外部调用接口*/
/*仪表IGON调用*/
extern void GaugesK15Init_ON(void) ;
/*仪表IGOFF调用*/
extern void GaugesK15Init_OFF(void) ;
/*得到显示步*/
extern uint16_t GetGaugesCurrentPos(uint8_t GaugesNum) ;
/*表头处理函数*/
extern void GaugeSchedule(uint8_t GaugesNum, _GaugesInfoInit *GParam);
/*表头时间函数放在ms定时中*/
extern void Gauges_Time_Xms_Count(uint8_t Xms);
/*得到格的内部小步*/
extern uint16_t GetGaugesCurrentStep(uint8_t GaugesNum);
/*通过车速目标步得到实际车速*/
extern uint16_t GetVehDisVal(uint16_t VehCurPos, _GaugesInfoInit *GParam);
/*设置FreeMoveType模式仪表走动时间*/
extern void SetFreeMoveTimes(uint16_t GaugesMoveTimes);
/*得到上下行方向  返回值：1  2*/
extern uint8_t GetGaugesDirec(uint8_t GaugesNum) ;

extern void SeftTest_GaugeMoveing(uint8_t GaugesNum) ;
#endif