/*
 * includes.h
 *
 *  Created on: 2014-7-31
 *      Author: qitiancun
 */

#ifndef _UDS_INCLUDES_H_
#define _UDS_INCLUDES_H_
#include "TYW_stdint.h"
/*
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
*/
#define MaxBuff 266
typedef enum
{
    STATE0 = 1,
    N_OK_2,
    CTS,
    WAIT,
    OVFLW,
    N_TIMEOUT_Bs_6,
    N_ERROR_7,
    N_INVALID_FS_8,
    N_WRONG_SN_9
} Enum_Result;

typedef enum
{
    empoty,
    full
} TransSt;
typedef struct
{
    uint32_t Identifier; //Fun--PGN--
    uint8_t DLC;
    uint8_t Data[8];
    TransSt TransferStatus;
} _LinkData;

typedef struct
{
    struct
    {
        uint16_t pos;
        uint16_t Length;
        uint16_t N_FC_Num;
        uint16_t N_RecSN_L;
        uint8_t N_SendSN;
        uint8_t N_BS_CNT;
        uint8_t N_BS;
        uint8_t N_SA;
        uint8_t N_TA;
        uint8_t N_PCI;
        uint8_t N_SID;
    } ind;
} _N_US_Data_FF;

typedef struct
{
    struct
    {
        uint32_t N_TAtype;
        uint16_t Length;
        uint8_t N_SA;
        uint8_t N_TA;
        uint8_t N_AE;
        uint8_t N_PCI;
        uint8_t MsgData[8];
        Enum_Result N_Result;
    } ind;
} _N_USSFData;


typedef struct
{
    struct
    {
        uint32_t N_TAtype; //PGN  55808--0xDA00
        uint16_t Length;
        uint8_t N_SA;
        uint8_t N_TA;
        uint8_t N_AE;
        uint8_t N_PCI;
        uint8_t MsgData[MaxBuff];
        Enum_Result N_Result;
    } ind;
} _N_USData;

typedef struct
{
    struct
    {
        uint8_t len;
        uint8_t MsgData[8];
        uint8_t N_Result;
    } ind;
} _N_RSPData;


typedef union
{
    struct
    {
        uint8_t SubFunBit0_6 : 7;
        uint8_t SubFunBit7_7 : 1;
    } SubBits;
    uint8_t SubData;
} _SubFun;


typedef struct
{
    uint8_t SessionType;
    uint8_t AccessLock;
    uint8_t AccessCount;
    uint8_t key[4];
    uint8_t SubFunction;
    uint8_t w27_Sequence;
    uint8_t A5_Sequence;
    uint8_t DTCSettingType;
    uint8_t tDiagStart;
    uint8_t tDiagKL30ONStart;
    uint8_t N_STmin_0;
    uint8_t N_REV_MAX_BS;
    uint8_t CommType;
    uint8_t CommCtl;
    uint8_t DTCByStatusMask;
} _DiagnoCtl;

typedef struct
{
    uint16_t N_TAtype; //PGN--55808--DA00
    uint8_t FrameErr;
    uint8_t RespSerId;
} _ErrorFrame;

typedef struct
{
    uint32_t OverBsTime;
    uint32_t BsTime;

    uint32_t OverSTminTime;
    uint32_t STminTime;

    uint32_t OverCrTime;
    uint32_t CrTime;

    uint32_t OverSessionTime;
    uint32_t SessionTime;

    uint32_t OverSequenceTime;
    uint32_t SequenceTime;

    uint32_t OverUnlockTime;
    uint32_t UnlockTime;

    uint8_t TT_BsEnable;

    uint8_t TT_STminEnable;

    uint8_t TT_CrEnable;

    uint8_t TT_SessionEnable;

    uint8_t TT_SequenceEnable;

    uint8_t TT_UnlockEnable;

    uint8_t E2_WriteTime;

} _DiagClock;
typedef union
{
    struct
    {
        uint32_t StructDTC[25];
    } SubDTC;
    uint8_t UnionDTC[100];
} _DiagReciveDTC;
typedef struct
{
    uint8_t CoolantTemp[20];
    uint8_t MilLamp;
} _DiagReciveGaugePara;


#include "UDS_Def.h"
#include "UDS_CFG.h"
#include "TP_Layer.h"
#include "Link_Layer.h"
#include "app_ServiceProc.h"
#include "app_Service.h"
extern _DiagReciveDTC  DiagReciveDTC   ;

extern _DiagReciveDTC  DiagReciveDTCEngine;
extern _DiagReciveDTC  DiagReciveDTCBrake;
extern _DiagReciveDTC  DiagReciveDTCAMT;
extern _DiagReciveDTC  DiagReciveDTCRadar;
extern _DiagReciveDTC  DiagReciveDTCCamera;
extern _DiagReciveDTC  DiagReciveDTCRetarder;

extern _DiagReciveGaugePara DiagReciveGaugePara;
#endif /* _UDS_INCLUDES_H_ */
