#include "Seatbelt.h"
#include "CAN_Lib.h"
#include "Common_Interface.h"
#include "TYW_stdint.h"
#include "CAN_Communication_Matrix.h"
#include "Common_Interface.h"

#define SELTBELT_SELF_CHK 0u

#define VSPEED_STOP_THTRSHOLD 250u

#define ESPEED_STOP_THTRSHOLD 300u

#define TOP_THTRSHOLD 0u

#define SND_FASTEN_SEATBELT_Level_1 1u

static uint8_t  CurIGSt(void);          /*��Դ״̬  0 off 1 on*/
static uint8_t  Get_Gear_R(void);       /*R��  1R�� 0��R��*/
static uint8_t  SelectSeatbeltPopupLevel(void);
uint8_t setbeltsig_Dr = 0u;
uint8_t setbeltsig_Pa = 0u;
uint8_t GET_SystemVal_CheckFinishBool(void);
uint8_t GET_SystemVal_CheckFinishBool(void)
{
    uint8_t selfSts = 0u;
    return selfSts;
}
uint8_t Get_CANMsg234_Sts(void);
uint8_t Get_CANMsg234_Sts(void)
{
    uint8_t selfSts = 0u;
    return selfSts;
}
uint16_t Get_SigVCU_VehSpd(void);
uint16_t Get_SigVCU_VehSpd(void)
{
    uint16_t vAct = 0u;
    return vAct;
}
uint8_t Get_SigACU_DrvSeatbeltBucklestatus(void);
uint8_t Get_SigACU_DrvSeatbeltBucklestatus(void)
{
    uint8_t DrvSeatbelt = 0u;
    return DrvSeatbelt;
}
uint8_t Get_SigACU_PassSeatbeltBucklestatus(void);
uint8_t Get_SigACU_PassSeatbeltBucklestatus(void)
{
    uint8_t DrvSeatbelt = 0u;
    return DrvSeatbelt;
}
uint8_t Get_SoundScheduling_Current(void);
uint8_t Get_SoundScheduling_Current(void)/*��ȡ���ڲ��ű�����*/
{
    uint8_t Sound = 0u;
    return Sound;
}


uint8_t GetVoiceCFG_Setbelt(void);
uint8_t GetVoiceCFG_Setbelt(void)
{
    uint8_t VoiceSts = 0u;
    return VoiceSts;
}

/*** ���ݰ�ȫ�� ***/

volatile uint8_t  WarningSeatbeltDrTel;
volatile uint8_t  WarningSeatbeltDrPopup;
volatile WarningSeatbeltStruct WarningSeatbeltDr;

/*** ���ݰ�ȫ�� ***/

volatile uint8_t  WarningSeatbeltPaTel;
volatile uint8_t  WarningSeatbeltPaPopup;
volatile WarningSeatbeltStruct WarningSeatbeltPa;


/*ָʾ�Ƽ����˸Э��*/
static uint8_t Blink_Timer;
static uint8_t Blink_Sync;
static  void Blink_Sync_Process(void);


#define   WARNING_OFF       0x00u  /*�ޱ���*/
#define   WARNING_Lv1       0x01u  /*һ������*/
#define   WARNING_Lv2       0x02u  /*��������*/
#define   WARNING_Lv3       0x03u  /*��������*/
#define   WARNING_Lv4       0x04u  /*��Ч�ı����������ھ���*/


static   uint8_t   IGstatus;      /*��Դ״̬*/

static   uint16_t  DispVspeed;    /*��ʾ����*/
static   uint16_t  ActSpeed;      /*ʵ�ʳ���*/
static   uint16_t  DispEspeed;    /*��ʾ����*/
static   uint8_t   ReverseGear;   /*�����ź�*/

uint8_t   SeatbeltSelf4sTime;/*�Լ�ʱ�����*/

static uint8_t  CurIGSt(void)
{
    uint8_t temp;

    if (0u)/*(Common_Get_IG_Sts_Valid() == 1u)*/
    {
        temp = Common_Get_IG_Sts();
    }
    else
    {
        temp = 0u;
    }
    return temp ;
}

static uint8_t  Get_Gear_R(void)
{
    uint8_t RGear = 0u;

    /*��ΪGet_Gear_Display���ص�ֵû���ֶ�������Ҫ���д���*/
    if (0u)/*(Get_Sig_VCU_DispGear() == 0x09u)*/
    {
        RGear = 1u;
    }
    return RGear;
}


void SeatbeltSelfCheck(void)
{

    if (CurIGSt())
    {
        if (0u)/*(GET_SystemVal_CheckFinishBool() == 0u)*/ /*SeatbeltSelf4sTime<40u*/
        {
            SeatbeltSelf4sTime = 0u; /*SeatbeltSelf4sTime++*/
        }
        else
        {
            SeatbeltSelf4sTime = 30u; /* ��*/
        }
    }
    else
    {
        SeatbeltSelf4sTime = 0u;
    }

}

void SeatbeltInit(void)
{
    /*�Լ����ʱ��*/
    SeatbeltSelf4sTime = 0u;

    /*���ݰ�ȫ�� Dr*/
    WarningSeatbeltDrTel             = 0u;
    WarningSeatbeltDrPopup           = 0u;

    WarningSeatbeltDr.Poplevel       = 0u;
    WarningSeatbeltDr.LowSpeed300m   = 0u;
    WarningSeatbeltDr.Chk60s         = 0u;
    /*   WarningSeatbeltDr.ConsEnMileage  = Data_MileageRollingCounter_Read();*/
    WarningSeatbeltDr.Timer          = 0u;
    WarningSeatbeltDr.TelBlink.Duty  = 0u;
    WarningSeatbeltDr.TelBlink.En    = 0u;
    WarningSeatbeltDr.TelBlink.Sync  = 1u;


    /*���ݰ�ȫ�� Pa*/
    WarningSeatbeltPaTel             = 0u;
    WarningSeatbeltPaPopup           = 0u;

    WarningSeatbeltPa.Poplevel       = 0u;
    WarningSeatbeltPa.LowSpeed300m   = 0u;
    WarningSeatbeltPa.Chk60s         = 0u;
    /*  WarningSeatbeltPa.ConsEnMileage  = Data_MileageRollingCounter_Read();*/
    WarningSeatbeltPa.Timer          = 0u;
    WarningSeatbeltPa.TelBlink.Duty  = 0u;
    WarningSeatbeltPa.TelBlink.En    = 0u;
    WarningSeatbeltPa.TelBlink.Sync  = 1u;



}


void sigInput(void)
{
	#if 0
    IGstatus    = CurIGSt();  /*��Դ״̬*/

    DispVspeed = Common_Get_Disp_V_Speed();/*��ʾ����*/
    DispEspeed = Common_Get_Disp_E_Speed();/*��ʾת��*/
    if (Common_Get_Act_V_Speed_Valid())
    {
        ActSpeed = Get_SigVCU_VehSpd(); /*CAN�ź�*/
    }
    else
    {
        ActSpeed = 0u;
    }

    /*�������������Ĵ���ͬ���ź�*/
    ReverseGear = Get_Gear_R();/*R-��λ */

    if (IGstatus == 0u)
    {
        setbeltsig_Dr = 0u;
        setbeltsig_Pa = 0u;
    }
    else
    {
        if (Get_SigACU_DrvSeatbeltBucklestatus() == 0u)
        {
            setbeltsig_Dr = 1u;
        }
        else
        {
            setbeltsig_Dr = 0u;
        }

        if (Get_CANMsg234_Sts() != 0x55u) /*�Ǳ�����5֡��Ϣ�޷��յ�ACU���͵İ�����ָʾ��״̬���ź�֡���Ǳ��������ֵ��ʾ��*/
        {

            /*����ȫ�������ź�*/
            if (Get_SigACU_PassSeatbeltBucklestatus() == 1u)
            {
                setbeltsig_Pa = 1u;
            }
            else
            {
                setbeltsig_Pa = 0u;
            }

        }
    }

#endif
}
/********************************************************************
��ȫ����������
��������ȫ�������ṹ����
      ����λ��
      ����������0������,1���뵹��,2����ת�٣�
********************************************************************/

void ResetSeatbeltWarning(volatile WarningSeatbeltStruct *Seatbatile, volatile uint8_t *Popup, uint8_t Clear)
{

    uint8_t temp = 0u;

    switch (Clear)
    {
    case    0:   /*����������*/
    {
        *Popup = 0u;
        Seatbatile->Timer = 0u;
        Seatbatile->Poplevel = 0u;
        Seatbatile->TelBlink.En = 0u;
        Seatbatile->TelBlink.Duty = 0u;
        Seatbatile->TelBlink.Sync = 1u;
    }  break;

    case    1:
    {
        /*=========================================================
           Ϩ��   ���������忴����MT/AT/DCT/CVT
        =========================================================*/
        if ( DispEspeed > ESPEED_STOP_THTRSHOLD)
        {
            Seatbatile->EngineSpeed = DispEspeed;
            Seatbatile->EngineStoped = 0u;
        }
        else
        {
            if ( (Seatbatile->EngineSpeed) > ESPEED_STOP_THTRSHOLD)
            {
                Seatbatile->EngineSpeed = DispEspeed;
                Seatbatile->EngineStoped = 1u;
            }
        }
        temp = Seatbatile->EngineStoped;
        if ( (ReverseGear == 1u) || (temp == 1u))
        {
            *Popup = 0u;
            Seatbatile->Timer = 0u;
            Seatbatile->Poplevel = 0u;
            Seatbatile->TelBlink.En = 0u;
            Seatbatile->TelBlink.Duty = 0u;
            Seatbatile->TelBlink.Sync = 1u;
            Seatbatile->EngineStoped = 0u;
        }
    } break;

    default  : break;

    }

}



/********************************************************************
��ȫ����������
��������ȫ�������ṹ���ݣ�����λ��
********************************************************************/


void Seatbelt_logic(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup , uint16_t Second)
{


    uint8_t TempLv;
    uint8_t CurPopupSnd;

    TempLv = Seatbatile->Poplevel;
    CurPopupSnd = Get_SoundScheduling_Current();

    /*======================����>250km/h=========================*/

    if ((DispVspeed >= 250u) && (ActSpeed > 0x190u) )
    {
        if (Seatbatile->Timer < Second)     /*������ʱ*/
        {
            if (CurPopupSnd == SND_FASTEN_SEATBELT_Level_1) /*ֻ���ǰ�ȫ������������ʱ��ż���*/
            {
                Seatbatile->Timer++;
            }
            /*===============================�����ȼ�ֻ������==========================*/

            if (TempLv < WARNING_Lv1 )
            {
                if ((SelectSeatbeltPopupLevel()) < WARNING_Lv1)
                {
                    *Popup = WARNING_Lv1;         /*һ��1Hz*/
                }
                else
                {
                    *Popup = SelectSeatbeltPopupLevel();
                }
            }

            Seatbatile->Poplevel = *Popup;    /*��¼��ʱ�ı����ȼ�*/

        }
        else /*��ʱ����*/
        {
            *Popup = (uint8_t)WARNING_Lv4; /*ֻͣ����,��������*/
        }

    }
    /*========================================================================
    �ж��г��ٵ��ǲ���10km,��ʱ�Ѿ�����������,���������ʱ����120s������ʱ,
    �����ʱ��120s��������ֹͣ��ƽ̨��ȡ��((DispVspeed < 100u) && (DispVspeed >= 25u)��
    ========================================================================*/
    else
    {
        if (TempLv != 0u)
        {
            if (Seatbatile->Timer < Second) /*���ٺ��Ƿ�ֹͣ������������*/
            {
                if (CurPopupSnd == SND_FASTEN_SEATBELT_Level_1)
                {
                    Seatbatile->Timer++;
                }
            }
            else
            {
                *Popup = (uint8_t)WARNING_Lv4;
            }
        }

    }

    /*===========================������ֹͣ���� ====================================*/
    ResetSeatbeltWarning(Seatbatile, Popup, 1u); /*R�� ����Ϊ 0*/

}

/*��ȫ��ָʾ��*/
void SeatbeltTelltales(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup, volatile uint8_t  *WarningTel)
{
	#if 0
    uint8_t temp;
    uint8_t Temp1, Temp2;
    uint8_t UseSyncSig;/*ʹ�õ�ͬ���ź�*/
    uint8_t CurPopupSnd;/*��ǰ���ŵ�����*/
    switch (*Popup)
    {
    case 1u: temp = 1u; break;
    default:  temp = 0u; break;
    }

    CurPopupSnd = Get_SoundScheduling_Current();
    if (CurPopupSnd == SND_FASTEN_SEATBELT_Level_1)
    {
        UseSyncSig = Get_SND_SEATBELT_SYNC();
    }
    else
    {
        UseSyncSig = Blink_Sync;
    }

    if (temp)       /*��1,2,3��������ʾ��ʱָʾ����˸ͬ��*/
    {
        if (Seatbatile->Poplevel > 0u)
        {
            Seatbatile->TelBlink.En = 1u;     /*��˸״̬ʹ�ܣ�1����ָʾ��״ָ̬ʾ 2.������˸��ʱ�ı�־λ*/

            if (Seatbatile->Poplevel == 1u)
            {
                Seatbatile->TelBlink.Cyc = 10u;/*1HZ*/
            }

            if (UseSyncSig)      /*������������������ͬ���ź�Get_SND_SEATBELT_SYNC()*/
            {
                Seatbatile->TelBlink.Duty   = 0u;
                Seatbatile->TelBlink.Sync   = 1u;
            }

            if (Seatbatile->TelBlink.Sync)/*ִ����˸����*/
            {
                *WarningTel = 1u;
            }
            else
            {
                *WarningTel = 0u;
            }

        }
        else
        {
            Seatbatile->TelBlink.En = 0u;
            Seatbatile->TelBlink.Duty   = 0u;
            Seatbatile->TelBlink.Sync    = 1u;
            *WarningTel = 1u;   /*����������ʹָʾ�Ƶ���*/ /*831910-3 ,831910-4  823009-6  823009-7*/
        }


    }
    else                            /*û�����������Ĵ���*/
    {
        Seatbatile->TelBlink.En = 0u;
        Seatbatile->TelBlink.Duty   = 0u;
        Seatbatile->TelBlink.Sync   = 1u;
        *WarningTel = 1u;  /*831910-1  */
    }

    /*=======================ָʾ����˸ռ�ձ�==============================*/
    Temp1 = Seatbatile->TelBlink.Duty;
    Temp2 = Seatbatile->TelBlink.Cyc;


    if (Seatbatile->TelBlink.En == 1u)
    {
        if (Seatbatile->TelBlink.Duty < 4u)
        {
            Seatbatile->TelBlink.Sync = 1u;
        }
        else
        {
            Seatbatile->TelBlink.Sync = 0u;
        }

        if (Temp1  >= Temp2)
        {
            Seatbatile->TelBlink.Duty = 0u;
        }
        else
        {
            Seatbatile->TelBlink.Duty ++;
        }
    }
#endif
}

/*���ݰ�ȫ��*/
void Warning_Seatbelt_Dr_Processing ( void )
{
    if (IGstatus == 0u)
    {
        WarningSeatbeltDrTel   = 0u;  /*831905-2*/
        ResetSeatbeltWarning(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, 0u); /*��������λ*/
    }
    else  /*831905-1*/
    {
        /*�����Ǳ������Լ�� LED �� �� ��� Կ�� �� ON ʱ ��Ҫ���� �ź����� ������Ӧ ��ָʾ��*/
        if (setbeltsig_Dr == 1u)
        {
            SeatbeltTelltales(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, &WarningSeatbeltDrTel);
            Seatbelt_logic(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, 1000u);/*90801-1*/
        }
        else
        {
            WarningSeatbeltDrTel   = 0u;
            ResetSeatbeltWarning(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, 0u); /*��������λ*/
        }
    }

}
/*���ݰ�ȫ�� */
void Warning_Seatbelt_Pa_Processing ( void )
{

    if (IGstatus == 0u)
    {
        WarningSeatbeltPaTel   = 0u; /*831905-2*/
        ResetSeatbeltWarning(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, 0u); /*��������λ*/
    }
    else
    {

        if (setbeltsig_Pa == 1u)
        {
            SeatbeltTelltales(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, &WarningSeatbeltPaTel);
            Seatbelt_logic(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, 1200u);
        }
        else
        {
            WarningSeatbeltPaTel = 0u;
            ResetSeatbeltWarning(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, 0u); /*��������λ*/
        }

    }
}

/*========================================================
  ����ֵ�������������Ƶ�״̬ 0�� 1��
  ���ԣ�1.�ĸ��ź�ֵ��������˸ʱ��״̬������˸
        2.״̬��һ����ʱ�������ƾ�����ȫ������ʱϨ��
=========================================================*/

uint8_t Get_MainSetbeltTel(void)
{
    uint8_t u8;

    if (WarningSeatbeltDr.TelBlink.En) /*����λ*/
    {
        u8 = WarningSeatbeltDrTel;
    }
    else if (WarningSeatbeltPa.TelBlink.En) /*����λ*/
    {
        u8 = WarningSeatbeltPaTel;
    }

    else
    {
        if (WarningSeatbeltDrTel == 1u)
        {
            u8 = 1u;
        }
        else if (WarningSeatbeltPaTel == 1u)
        {
            u8 = 1u;
        }

        else
        {
            u8 = 0u; /*�ޱ���Ϩ��*/
        }

    }

    return u8;
}
/*����ֵ�� ����ʻ��ȫ��ָʾ��״̬ 0�� 1�� */
uint8_t Get_PassSetbeltTel(void)
{
    return WarningSeatbeltPaTel;
}

/*����ֵ����ȫ�����������ȼ� 1��2��3  �������ȼ�  0Ϊ�������������� */
uint8_t  Get_SeatbeltPopupLevel(void)
{
    uint8_t u8;

    if (WarningSeatbeltDr.TelBlink.En)          /*����λ                       */
    {
        /*                             */
        u8 = WarningSeatbeltDr.Poplevel ;       /*WarningSeatbeltDrPopup;      */
    }                                           /*                             */
    else if (WarningSeatbeltPa.TelBlink.En)     /*����ʻλ                     */
    {
        /*                             */
        u8 = WarningSeatbeltPa.Poplevel;        /*WarningSeatbeltPaPopup;      */
    }                                           /*                             */
    else
    {
        u8 = 0u;/*�ޱ���*/
    }

    return  u8;
}

/*
����������������������������һ������������
*/
static uint8_t  SelectSeatbeltPopupLevel(void)
{
    uint8_t Lv[5u], num = 0u; /*���ڱ����ȼ��Ƚϻ��棬��������������Ŀ*/
    uint8_t i = 0u, max = 0u; /*����*/

    Lv[0u] = (WarningSeatbeltDr.TelBlink.En) ? WarningSeatbeltDr.Poplevel : 0u ;
    Lv[1u] = (WarningSeatbeltPa.TelBlink.En) ? WarningSeatbeltPa.Poplevel : 0u ;
    num = 1u;

    for (i = 0u; i < num ; i++)
    {
        if (Lv[i] > Lv[i + 1u])
        {
            max = Lv[i];
            Lv[i] = Lv[i + 1u];
            Lv[i + 1u] = max;
        }
    }

    return  Lv[num];
}




static  void Blink_Sync_Process(void)
{

    if (SelectSeatbeltPopupLevel() == 1u)
    {
        if (Blink_Timer > 10u)
        {
            Blink_Sync = 1u;
            Blink_Timer = 0u;
        }
        else
        {
            Blink_Timer++;
        }
    }
}
/***************��ȫ��������ص�������100ms***************/
void SeatbeltService_CB100ms(void)
{
#if 0
    uint8_t Popup;

    sigInput(); /*�ź�����*/
#if SELTBELT_SELF_CHK
    SeatbeltSelfCheck();  /*�Լ�ʱ�����*/
#endif
    Warning_Seatbelt_Dr_Processing();
    Warning_Seatbelt_Pa_Processing();

    ReSet_SND_SEATBELT_SYNC();/*����ͬ���ź�*/
    Blink_Sync = 0u;
    Blink_Sync_Process();

    Popup = SelectSeatbeltPopupLevel();
    if (Popup == 1u)
    {
        if (GetVoiceCFG_Setbelt())
        {
            /*  Popup_Request(1u); */
        }
        else
        {
            /*  Popup_Request(2u); */
        }


    }
    else
    {
        if (GetVoiceCFG_Setbelt())
        {
            /*  Popup_Delate(1u); */
        }
        else
        {
            /*  Popup_Delate(2u); */
        }

    }
#endif 	
}

volatile uint8_t        SoundPlaySeatbeltSync;

uint8_t  Get_SND_SEATBELT_SYNC(void)
{
    return SoundPlaySeatbeltSync ;
}

void ReSet_SND_SEATBELT_SYNC(void)
{
    SoundPlaySeatbeltSync = 0u;
}
/*�������ź���������жϳ���ǰ���ŵ������ǰ�ȫ������������Ҫ���ô˺���*/
void Set_SND_SEATBELT_SYNC(void)
{
    SoundPlaySeatbeltSync = 1u;
}

