#include "Fuel_Calibration.h"


uint8_t Act_IGN;/*仪表电源状态*/
uint8_t Act_FuelStep;/*仪表燃油步数*/
uint8_t Act_FuelSeg;/*仪表燃油格数*/
uint8_t ACT_Vspeed;/*仪表车速*/
uint16_t ACT_Espeed;/*仪表转速*/
uint16_t ACT_SampleRes;/*仪表采样电阻*/
uint16_t Filter_SampleRes;/*仪表滤波电阻*/
uint16_t FuelLevelIndicated;/*仪表的显示油量*/
uint8_t ACT_DTEPJYH;/*平均油耗*/
uint16_t Disp_DTE; /*显示续航里程*/
uint32_t CurODO;  /*总里程*/

uint32_t Total_ConsumeFuel;  /*总喷油量-标准燃油库没有这项*/
uint16_t Filter_DIM;/*仪表滤波油量-标准库没有这项*/
uint16_t ReferenceFuelRawVolume;/*仪表停车后的参考油量-标准库没有这项*/
uint8_t ACT_PJYH;/*平均油耗-标准库没有这项*/
uint16_t ACT_DTE;  /*实际续航里程-标准库没有这项*/
uint8_t OngoingFillingFlag;/*加油标志-标准库没有这项*/
uint8_t EstimationFlag;/*预估模式标志-标准库没有这项*/

static uint8_t Fuel_Get_PJYH(void);
static uint8_t Fuel_Get_dtePJYH(void);
static uint8_t Fuel_Get_Filling(void);
static uint8_t Fuel_Get_EstimationFlag(void);
static uint8_t Fuel_Get_FuelSeg(void);
static uint8_t Fuel_Get_FuelStep(void);
static uint8_t Fuel_Get_ActVSpeed(void);
static uint16_t Fuel_Get_ActESpeed(void);
static uint16_t Fuel_Get_RefVol(void);
static uint16_t Fuel_Get_Ind_DIM(void);
static uint16_t Fuel_Get_Filter_DIM(void);
static uint16_t Fuel_Get_IGN(void);
static uint16_t Fuel_Get_ACT_Res(void);
static uint16_t Fuel_Get_Filter_Res(void);
static uint16_t Fuel_Get_DispDTE(void);
static uint16_t Fuel_Get_ACTDTE(void);
static uint32_t Fuel_Get_ODO(void);
static uint32_t Fuel_Get_TotalConsumeFuel(void);

/************Begin Vspeed Func*****************/
static uint8_t Fuel_Get_Filling(void)
{
    return OngoingFillingFlag;
}
void Fuel_Set_Filling(uint8_t Filling)
{
    OngoingFillingFlag = Filling;
}
/************End Vspeed Func******************/


/************Begin Vspeed Func*****************/
static uint8_t Fuel_Get_EstimationFlag(void)
{
    return EstimationFlag;
}
void Fuel_Set_EstimationFlag(uint8_t m_EstimationFlag)
{
    EstimationFlag = m_EstimationFlag;
}
/************End Vspeed Func******************/




/************Begin Filter_DIM Func*****************/
static uint16_t Fuel_Get_RefVol(void)
{
    return ReferenceFuelRawVolume;
}
void Fuel_Set_Ind_RefVol(uint16_t m_RefVol)
{
    ReferenceFuelRawVolume = m_RefVol;
}
/************End Vspeed Func******************/


/************Begin Filter_DIM Func*****************/
static uint16_t Fuel_Get_Ind_DIM(void)
{
    return FuelLevelIndicated;
}
void Fuel_Set_Ind_DIM(uint16_t m_Ind_DIM)
{
    FuelLevelIndicated = m_Filter_DIM;
}
/************End Vspeed Func******************/

/************Begin Filter_DIM Func*****************/
static uint16_t Fuel_Get_Filter_DIM(void)
{
    return Filter_DIM;
}
void Fuel_Set_Filter_DIM(uint16_t m_Filter_DIM)
{
    Filter_DIM = m_Filter_DIM;
}
/************End Vspeed Func******************/


/************Begin Vspeed Func*****************/
static uint8_t Fuel_Get_FuelSeg(void)
{
    return Act_FuelSeg;
}
void Fuel_Set_FuelSeg(uint8_t FuelSeg)
{
    Act_FuelSeg = FuelSeg;
}
/************End Vspeed Func******************/

/************Begin Vspeed Func*****************/
static uint8_t Fuel_Get_FuelStep(void)
{
    return Act_FuelStep;
}
void Fuel_Set_FuelStep(uint8_t FuelStep)
{
    Act_FuelStep = FuelStep;
}
/************End Vspeed Func******************/

/************Begin Vspeed Func*****************/
static uint8_t Fuel_Get_ActVSpeed(void)
{
    return ACT_Vspeed;
}
void Fuel_Set_ActVSpeed(uint8_t Vspeed)
{
    ACT_Vspeed = Vspeed;
}
/************End Vspeed Func******************/


/************Begin Espeed Func****************/
static uint16_t Fuel_Get_ActESpeed(void)
{
    return ACT_Espeed;
}
void Fuel_Set_ActESpeed(uint16_t Espeed)
{
    ACT_Espeed = Espeed;
}
/************End Espeed Func*****************/

/************Begin IGN Func******************/
static uint16_t Fuel_Get_IGN(void)
{
    return Act_IGN;
}
void Fuel_Set_ActIGN(uint8_t m_IGN)
{
    Act_IGN = m_IGN;
}
/************End IGN Func*********************/

/*Begin ACT_SampleRes Func*/
uint16_t Fuel_Get_ACT_Res(void)
{
    return ACT_SampleRes;
}
void Fuel_Set_ACT_Res(uint16_t m_Res)
{
    ACT_SampleRes = m_Res;
}
/*End IGN Func*/

/*Begin Filter_SampleRes Func*/
static uint16_t Fuel_Get_Filter_Res(void)
{
    return Filter_SampleRes;
}
void Fuel_Set_Filter_Res(uint16_t m_Res)
{
    Filter_SampleRes = m_Res;
}
/*End IGN Func*/

/************Begin DispDTE Func******************/
static uint16_t Fuel_Get_DispDTE(void)
{
    return Disp_DTE;
}
void Fuel_Set_DispDTe(uint16_t m_DTE)
{
    Disp_DTE = m_DTE;
}
/************End DispDTE Func*********************/

/************Begin DispDTE Func******************/
static uint16_t Fuel_Get_ACTDTE(void)
{
    return ACT_DTE;
}
void Fuel_Set_ACTDTE(uint16_t m_DTE)
{
    ACT_DTE = m_DTE;
}
/************End DispDTE Func*********************/

/************Begin ODO Func******************/
static uint32_t Fuel_Get_ODO(void)
{
    return CurODO;
}
void Fuel_Set_ODO(uint32_t m_ODO)
{
    CurODO = m_ODO;
}
/************End PJYH Func*********************/

/************Begin PJYH Func******************/
static uint8_t Fuel_Get_PJYH(void)
{
    return ACT_PJYH;
}
void Fuel_Set_PJYH(uint8_t m_PJYH)
{
    ACT_PJYH = m_PJYH;
}
/************End PJYH Func*********************/

/************Begin PJYH Func******************/
uint8_t Fuel_Get_dtePJYH(void)
{
    return ACT_DTEPJYH;
}
void Fuel_Set_dtePJYH(uint8_t m_PJYH)
{
    ACT_DTEPJYH = m_PJYH;
}
/************End PJYH Func*********************/


/************Begin Total Comp Func******************/
uint32_t Fuel_Get_TotalConsumeFuel(void)
{
    return Total_ConsumeFuel;
}
void Fuel_Set_TotalConsumeFuel(uint32_t m_TotalCon)
{
    Total_ConsumeFuel = m_TotalCon;
}
/************End PJYH Func*********************/



void Fuel_Can_Msg_Send(uint32_t m_ID, uint8_t m_DLC, uint8_t Msg[])
{

}

void Fuel_Calibration_01(void)
{
    uint8_t Msg[8];
    Msg[0] = Fuel_Get_ActVSpeed();
    Msg[1] = Fuel_Get_IGN();
    Msg[2] = (uint8_t)((Fuel_Get_ActESpeed() & 0xff00u) >> 8u);
    Msg[3] = (uint8_t)(Fuel_Get_ActESpeed() & 0x00ffu);
    Msg[4] = (uint8_t)((Fuel_Get_ACT_Res() & 0xff00u) >> 8u);
    Msg[5] = (uint8_t)(Fuel_Get_ACT_Res() & 0x00ffu);
    Msg[6] = (uint8_t)((Fuel_Get_Filter_Res() & 0xff00u) >> 8u);
    Msg[7] = (uint8_t)(Fuel_Get_Filter_Res() & 0x00ffu);
    Fuel_Can_Msg_Send(0X555u, 8u, Msg);
}


void Fuel_Calibration_02(void)
{
    uint8_t Msg[8];
    Msg[0] = (uint8_t)((Fuel_Get_ACTDTE() & 0xff00u) >> 8u);
    Msg[1] = (uint8_t)(Fuel_Get_ACTDTE() & 0x00ffu);
    Msg[2] = (uint8_t)((Fuel_Get_DispDTE() & 0xff00u) >> 8u);
    Msg[3] = (uint8_t)(Fuel_Get_DispDTE() & 0x00ffu);

    Msg[4] = (uint8_t)((Fuel_Get_ODO() & 0xFF000000ul) >> 24u);
    Msg[5] = (uint8_t)((Fuel_Get_ODO() & 0x00FF0000ul) >> 16u);
    Msg[6] = (uint8_t)((Fuel_Get_ODO() & 0x0000FF00ul) >> 8u);
    Msg[7] = (uint8_t)((Fuel_Get_ODO() & 0x000000FFul));
    Fuel_Can_Msg_Send(0X556u, 8u, Msg);
}

void Fuel_Calibration_03(void)
{
    uint8_t Msg[8];
    Msg[0] = (uint8_t)(Fuel_Get_PJYH());
    Msg[1] = (uint8_t)(Fuel_Get_dtePJYH());
    Msg[2] = (uint8_t)(Fuel_Get_FuelStep());
    Msg[3] = (uint8_t)(Fuel_Get_FuelSeg());

    Msg[4] = (uint8_t)((Fuel_Get_TotalConsumeFuel() & 0xFF000000ul) >> 24u);
    Msg[5] = (uint8_t)((Fuel_Get_TotalConsumeFuel() & 0x00FF0000ul) >> 16u);
    Msg[6] = (uint8_t)((Fuel_Get_TotalConsumeFuel() & 0x0000FF00ul) >> 8u);
    Msg[7] = (uint8_t)((Fuel_Get_TotalConsumeFuel() & 0x000000FFul));
    Fuel_Can_Msg_Send(0X557u, 8u, Msg);
}

void Fuel_Calibration_04(void)
{
    uint8_t Msg[8];
    Msg[0] = (uint8_t)((Fuel_Get_RefVol() & 0xff00u) >> 8u);
    Msg[1] = (uint8_t)(Fuel_Get_RefVol() & 0x00ffu);
    Msg[2] = (uint8_t)((Fuel_Get_Ind_DIM() & 0xff00u) >> 8u);
    Msg[3] = (uint8_t)(Fuel_Get_Ind_DIM() & 0x00ffu);

    Msg[4] = (uint8_t)((Fuel_Get_Filter_DIM() & 0xff00u) >> 8u);
    Msg[5] = (uint8_t)(Fuel_Get_Filter_DIM() & 0x00ffu);
    Msg[6] = (uint8_t)((Fuel_Get_Filling()));
    Msg[7] = (uint8_t)(Fuel_Get_EstimationFlag());

    Fuel_Can_Msg_Send(0X558u, 8u, Msg);
}
