#include <stddef.h>
#include "Data_Fuel_User.h"
#include "FuelConfig.h"
#include "Common_Interface.h"
#include "RTE_ADC.h"
#include "GPIO.h"
#include "Services_ODO_User.h"
#include "TYW_stdint.h"
#include "DisplaySch_user.h"
#include "DispSch.h"

static uint16_t Fuel_CurSeg;
static uint16_t Fuel_CyrStep;


#pragma ghs section bss=".myNonInitArea"
uint8_t FuelSaveData[1024]          ;// =  {0};
uint16_t FuelSaveLen                ;// = 0;
uint8_t DrivingRangeSaveData[1024]  ;// =  {0};
uint16_t DrivingRangeSaveLen        ;// = 0;
#pragma ghs section bss=default

/*-------------------------------------------------------------------------
 * Function Name  : Fuel_User_KL30_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Fuel_User_KL30_Init(void)
{
    Fuel_CurSeg = 0u;
    Fuel_CyrStep = 0u;
    FuelStruct FuelInitPara;
    AFC_INIT AFCInit;

    uint32_t ODO_Value = 0u;

    ODO_Value = Data_ODO_Read();

    FuelInitPara.FuelShortCircuitR = FUEL_R_MIN_VAL;
    FuelInitPara.FuelOpenCircuitR = FUEL_R_MAX_VAL;

    FuelInitPara.DisplayZoneBoundary[0] = DISPLAY_BOUNDARY_ES;  // 1500
    FuelInitPara.DisplayZoneBoundary[1] = DISPLAY_BOUNDARY_1;   // 1500
    FuelInitPara.DisplayZoneBoundary[2] = DISPLAY_BOUNDARY_2;   // 1373
    FuelInitPara.DisplayZoneBoundary[3] = DISPLAY_BOUNDARY_3;   // 1191
    FuelInitPara.DisplayZoneBoundary[4] = DISPLAY_BOUNDARY_4;   // 1009
    FuelInitPara.DisplayZoneBoundary[5] = DISPLAY_BOUNDARY_5;   // 848
    FuelInitPara.DisplayZoneBoundary[6] = DISPLAY_BOUNDARY_6;   // 697
    FuelInitPara.DisplayZoneBoundary[7] = DISPLAY_BOUNDARY_7;   // 545
    FuelInitPara.DisplayZoneBoundary[8] = DISPLAY_BOUNDARY_8;   // 436
    FuelInitPara.DisplayZoneBoundary[9] = DISPLAY_BOUNDARY_9;   // 345
    FuelInitPara.DisplayZoneBoundary[10] = DISPLAY_BOUNDARY_10; // 254
    FuelInitPara.DisplayZoneBoundary[11] = DISPLAY_BOUNDARY_11; // 188
    FuelInitPara.DisplayZoneBoundary[12] = DISPLAY_BOUNDARY_12; // 132
    FuelInitPara.DisplayZoneBoundary[13] = DISPLAY_BOUNDARY_13; //  40
    FuelInitPara.DisplayZoneBoundary[14] = DISPLAY_BOUNDARY_FS; //  30

    AFCInit.CalcAFCMaxNum = 100;      /*50公里或者100公里已更新*/
    AFCInit.AFCMin = 30;              /*油耗最小值十倍*/
    AFCInit.AFCMax = 300;             /*油耗最大值*/
    AFCInit.AFCPreinstall = 80;       /*油耗初始值*/
    AFCInit.CurODO = ODO_Value * 100; /*总共里数100倍*/
    AFCInit.MaxDRMileage = 69900;     /*续航里程最大值*/

    SetFuelSaveData(FuelSaveData, FuelSaveLen);/*新增 ----20220503----*/

    InitFuelParamter(&FuelInitPara);
    InitAFC(&AFCInit);

    /*----燃油上涨为下降的0.6----*/
    SetIgnOffRefuelThreshold(6);

    SetPowerDnStep(0);

    SetFuelSensorRecoverGroupCnt(10);
    SetFuelSensorOpenCircuitGroupCnt(120);
    SetFuelSensorShortCircuitGroupCnt(120);

    SetDrivingRangeSaveData(DrivingRangeSaveData, DrivingRangeSaveLen);
}
void Fuel_User_KL15_ON_Init(void)
{
}

void Fuel_User_KL15_OFF_Init(void)
{
}
void Fuel_User_Wakeup_Init(void)
{
    /*每次唤醒都要调用 ----20220503----*/
    SetFuelSaveData(FuelSaveData, FuelSaveLen);
    SetDrivingRangeSaveData(DrivingRangeSaveData, DrivingRangeSaveLen);
}

void *memcpy_new(void *to, void *from, size_t size)
{
    char *tempFrom = NULL;
    char *tempTo   = NULL;
    //assert( to && from );
    /*先转型为字符指针，字符为一个字节*/
    tempFrom = (char*)from;
    tempTo   = (char*)to;
    while (size-- > 0)
    {
        *tempTo++ = *tempFrom++;
    }
    return to;
}

void Fuel_User_Sleep_Init(void)
{
    uint8_t *p;
    p = GetFuelSaveData(&FuelSaveLen);

    if (FuelSaveLen < 1024)
    {
        memcpy_new(FuelSaveData, p, FuelSaveLen);
    }
    p = GetDrivingRangeSaveData(&DrivingRangeSaveLen);

    if (DrivingRangeSaveLen < 1024)
    {
        memcpy_new(DrivingRangeSaveData, p, DrivingRangeSaveLen);
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_User_KL15_ON_Processing_Service
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 10Ms调用
 --------------------------------------------------------------------------*/
void Fuel_User_KL15_ON_Processing_Service(void)
{
    AFC_PARA AFCPara;
    uint8_t FuelR_Valid = 0u;
    uint8_t Vspeed_Valid = 0u;
    uint8_t Espeed_Valid = 0u;
    uint8_t FuelMode = 0u;
    uint8_t Step = 0u;
    uint16_t FuelR = 0u;
    uint16_t Vspeed = 0u;
    uint16_t Espeed = 0u;
    uint16_t FuelResistanceV = 0u;
    uint32_t ODO_Value = 0u;

    FuelR_Valid = RTE_Read_FUEL_R_Valid();
    Vspeed_Valid = Common_Get_Act_V_Speed_Valid();
    Espeed_Valid = Common_Get_Act_E_Speed_Valid();

    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Common_Get_IG_Sts_Valid() == COMMON_Valid))
    {
        if (FuelR_Valid)
        {
            FuelR = RTE_Read_FUEL_R();
        }
        else
        {
            FuelR = 0;
        }

        if (Vspeed_Valid)
        {
            Vspeed = Common_Get_Act_V_Speed();
        }
        else
        {
            Vspeed = 0;
        }

        if (Espeed_Valid)
        {
            Espeed = Common_Get_Act_E_Speed();
        }
        else
        {
            Espeed = 0;
        }

        SetPowerSt(1);
        AFCTimerCall();

        ODO_Value = Data_ODO_Read();

        AFCPara.CurODO = ODO_Value * 100u;
        AFCPara.FuleConsume = 0u;
        AFCPara.RPM = Espeed;
        AFCPara.Speed = (Vspeed / 10u);

        SetAFCPara((AFC_PARA *)&AFCPara);
        FuelFSM(FuelR); /*新版增加系数*/

        FuelResistanceV = GetFuelResistance(); /*燃油电阻获取*/

        FuelMode = GetFuelSensorState(); /*燃油状态获取*/

        if (FuelMode == FuelSensorNormal)
        {
            Fuel_CurSeg = (uint16_t)GetFuelSeg();   /*段*/
            Fuel_CyrStep = (uint16_t)GetFuelStep(); /*步*/
        }
        else
        {
            Fuel_CurSeg = 0u;
            Fuel_CyrStep = 0u;
        }
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_User_KL15_OFF_Processing_Service
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 嵌入到100Ms中断中
 --------------------------------------------------------------------------*/
void Fuel_User_KL15_OFF_Processing_Service(void)
{
    uint8_t i;
    uint8_t FuelR_Valid = 0;
    uint16_t FuelR = 0;

    FuelR_Valid = RTE_Read_FUEL_R_Valid();
    FuelR = RTE_Read_FUEL_R();

    if (Common_Get_IG_Sts_Valid() == COMMON_Valid)
    {
        if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
        {
            SetPowerSt(0);
            for (i = 0; i < 10; i++)
            {
                AFCTimerCall();
            }
            FuelFSM(FuelR);
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Fuel_Get_CurSeg
 * Description    : 燃油当前格
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
uint8_t Fuel_Get_CurSeg(void)
{
    return Fuel_CurSeg;
}

/*返回燃油库电阻值*/
uint16_t Fuel_Get_Res(void)
{
    return GetFuelResistance();
}

uint16_t Fuel_Get_Step(void)
{
    uint16_t FuelStep = 0u;

    FuelStep = GetFuelStep();

    return FuelStep;
}

uint8_t Fuel_Get_Popup_Sta(void)
{
    uint8_t variable_1 = 0x00u;
    uint8_t variable_2 = 0x00u;
    uint16_t variable_5 = 0x00u;

    uint8_t Popup_Sta = 0u;
    UElib_uint16_t HMI_MENU_Sta = 0u;

    variable_1 = Fuel_Get_CurSeg();/*格*/
    variable_2 = GetFuelSensorState();/*燃油状态*/
    variable_5 = GetFuelResistance(); /*采集的阻值*/

    HMI_MENU_Sta = Get_Cur_HMI();

    if (
        (variable_1 <= 1 ) &&
        (variable_2 == FuelSensorNormal) &&
        (variable_5 != 65535) &&
        ((HMI_MENU_Sta == Display_Menu) || (HMI_MENU_Sta == Display_Alarm))
    )
    {
        Popup_Sta = 1u;
    }
    else
    {
        Popup_Sta = 0u;
    }

    return Popup_Sta;
}