

#ifndef _KWP2000_SERVICE_H
#define _KWP2000_SERVICE_H

/*
*********************************************************************
* defines
*********************************************************************
*/
/* KWP2000 keybytes for initialization */
#define KWP2000_KEYBYTE1                                        0xE9u      /* Both Len type - Both header type - Normal timing */
#define KWP2000_KEYBYTE2                                        0x8Fu

/* Request Service Id */
#define KWP2000_STARTDIAGNOSTICSESSION_REQUEST                  0x10u
#define KWP2000_ECURESET_REQUEST                                0x11u
#define KWP2000_READFREEZEFRAMEDATA_REQUEST                     0x12u
#define KWP2000_READDIAGNOSTICTROUBLECODES_REQUEST              0x13u
#define KWP2000_CLEARDIAGNOSTICINFORMATION_REQUEST              0x14u
#define KWP2000_READNUMBEROFDIAGNOSTICTROUBLECODES_REQUEST      0x15u
#define KWP2000_READSTATUSOFDIAGNOSTICTROUBLECODES_REQUEST      0x17u
#define KWP2000_READDIAGNOSTICTROUBLECODESBYSTATUS_REQUEST      0x18u
#define KWP2000_READECUIDENTIFICATION_REQUEST                   0x1Au
#define KWP2000_STOPDIAGNOSTICSESSION_REQUEST                   0x20u
#define KWP2000_READDATABYLOCALIDENTIFIER_REQUEST               0x21u
#define KWP2000_READDATABYCOMMONIDENTIFIER_REQUEST              0x22u
#define KWP2000_READMEMORYBYADDRESS_REQUEST                     0x23u
#define KWP2000_SETDATARATES_REQUEST                            0x26u
#define KWP2000_SECURITYACCESS_REQUEST                          0x27u
#define KWP2000_DYNAMICALLYDEFINELOCALIDENTIFIER_REQUEST        0x2Cu
#define KWP2000_WRITEDATABYCOMMONIDENTIFIER_REQUEST             0x2Eu
#define KWP2000_INPUTOUTPUTCONTROLBYCOMMONIDENTIFIER_REQUEST    0x2Fu
#define KWP2000_INPUTOUTPUTCONTROLBYLOCALIDENTIFIER_REQUEST     0x30u
#define KWP2000_STARTROUTINEBYLOCALIDENTIFIER_REQUEST           0x31u
#define KWP2000_STOPROUTINEBYLOCALIDENTIFIER_REQUEST            0x32u
#define KWP2000_REQUESTROUTINERESULTSBYLOCALIDENTIFIER_REQUEST  0x33u
#define KWP2000_REQUESTDOWNLOAD_REQUEST                         0x34u
#define KWP2000_REQUESTUPLOAD_REQUEST                           0x35u
#define KWP2000_TRANSFERDATA_REQUEST                            0x36u
#define KWP2000_REQUESTTRANSFEREXIT_REQUEST                     0x37u
#define KWP2000_STARTROUTINEBYADDRESS_REQUEST                   0x38u
#define KWP2000_STOPROUTINEBYADDRESS_REQUEST                    0x39u
#define KWP2000_REQUESTROUTINERESULTSBYADDRESS_REQUEST          0x3Au
#define KWP2000_WRITEDATABYLOCALIDENTIFIER_REQUEST              0x3Bu
#define KWP2000_WRITEMEMORYBYADDRESS_REQUEST                    0x3Du
#define KWP2000_TESTERPRESENT_REQUEST                           0x3Eu
#define KWP2000_ESCCODE_REQUEST                                 0x80u
#define KWP2000_STARTCOMMUNICATION_REQUEST                      0x81u
#define KWP2000_STOPCOMMUNICATION_REQUEST                       0x82u
#define KWP2000_ACCESSTIMINGPARAMETER_REQUEST                   0x83u
#define KWP2000_STARTAPPLICATION_REQUEST                        0xA2u

/**/
#define KWP2000_POSITIVE_RESPONSE_OFFSET                        0x40

/* negative response */
#define KWP_NEGATIVE_RESPONSE                                   0x7F

/* Response codes for KWP2000 services */
#define KWP2000_generalReject                                   0x10u
#define KWP2000_serviceNotSupported                             0x11u
#define KWP2000_subFunctionNotSupported                         0x12u
#define KWP2000_busy_RepeatRequest                              0x21u
#define KWP2000_conditionsNotCorrect                            0X22u
#define KWP2000_routineNotComplete                              0x23u
#define KWP2000_requestOutOfRange                               0x31u
#define KWP2000_securityAccessDenied                            0x33u
#define KWP2000_invalidKey                                      0x35u
#define KWP2000_exceedNumberOfAttempts                          0x36u
#define KWP2000_requiredTimeDelayNotExpired                     0x37u
#define KWP2000_downloadNotAccepted                             0x40u
#define KWP2000_improperDownloadType                            0x41u
#define KWP2000_cannotDownloadToSpecifiedAddress                0x42u
#define KWP2000_cannotDownloadNumberOfBytesRequested            0x43u
#define KWP2000_uploadNotAccepted                               0x50u
#define KWP2000_improperUploadType                              0x51u
#define KWP2000_cannotUploadFromSpecifiedAddress                0x52u
#define KWP2000_cannotUploadNumberOfBytesRequested              0x53u
#define KWP2000_transferSuspended                               0x71u
#define KWP2000_transferAborted                                 0x72u
#define KWP2000_illegalAddressInBlockTransfer                   0x74u
#define KWP2000_illegalByteCountInBlockTransfer                 0x75u
#define KWP2000_illegalBlockTransferType                        0x76u
#define KWP2000_blockTransferDataChecksumError                  0x77u
#define KWP2000_reqCorrectlyRcvd_RspPending                     0x78u
#define KWP2000_incorrectByteCountDuringBlockTransfer           0x79u
#define KWP2000_serviceNotSupportedInActiveDiagnosticSession    0x80u
/*
*********************************************************************
* structure
*********************************************************************
*/
typedef struct
{
    unsigned char  ResponseCode;
} Kwp2000_Negative_t;

/*
*********************************************************************
* variable
*********************************************************************
*/
extern Kwp2000_Negative_t  Kwp2000_Negative;

/*
*********************************************************************
* function
*********************************************************************
*/
extern unsigned char kwp_NegativeResponse(unsigned char sId_u8, unsigned char NegRC_u8, unsigned char *blockByte);
extern unsigned char kwp_EcuReset(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_TesterPresent(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_StartCommunication(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_StopCommunication(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readEcuIdentification(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_writeDataByLocalIdentifier(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readDataByLocalIdentifier(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readDataByCommonIdentifier(unsigned char *TxData, unsigned char *RequestData);

extern unsigned char kwp_readDataStatusofDTC(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readDataAccessMode(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_StartroutInebykocalIdentifier(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_ClearDiagnosticInformation(unsigned char *TxData, unsigned char *RequestData);

/******************************************************************************
K-LINE下线配置
******************************************************************************/
typedef struct
{
    unsigned long Flag       ; /*初始化标记位*/
    // HEX
    unsigned char K_Line_LID20; /* 00 应对ECE R13     //0：非应对、1：应对 */
    unsigned char K_Line_LID21; /* 00 EBS/ABS         //0：无、1：EBS、2：ABS(CAN应对) 3：ABS (CAN非应对) */
    unsigned char K_Line_LID22; /* 00 EVSC            //0：无、1：有 */
    unsigned char K_Line_LID23; /* 00 驻车锁定        //0：无、1：有 */

    unsigned char K_Line_LID24; /* 00 HSA             //0：无、1：有 */
    unsigned char K_Line_LID25; /* 00 AEBS            //0：无、1：有 */
    unsigned char K_Line_LID26; /* 00 ACC             //0：无、1：有 */
    unsigned char K_Line_LID27; /* 00 LDWS            //0：无、1：有 */

    unsigned char K_Line_LID28; /* 00 车辆间报警      //0：无、1：有 */
    unsigned char K_Line_LID29; /* 01 有无巡航        //0：无、1：有          /*初值1*/
    unsigned char K_Line_LID2A; /* 00 气悬            //0：Reef、1：Rear air、2：Full air */
    unsigned char K_Line_LID2B; /* 00 ISS             //0：无、1： eco stop、 2：Idle Stop */

    unsigned char K_Line_LID2C; /* 00 装货台工作警报蜂鸣//0：无、1：有             */
    unsigned char K_Line_LID2D; /* 00 ROWS            //0：无、1：ROWS有、2LOCAL警报有 */
    unsigned char K_Line_LID2E; /* 00 行车记录仪      //0：模拟记录仪、１：数字记录仪或行车记录仪 */
    unsigned char K_Line_LID2F; /* 00 车型            //0：单车、1：拖车、2：全拖车 */

    unsigned char K_Line_LID30; /* 00 缓速器          //0：无、1：有(C&E)、2：有(F) */
    unsigned char K_Line_LID31; /* -- 定速巡航        //0：无、1：有 */
    unsigned char K_Line_LID32; /* 00 装货台种类      //0：一般、1：侧翼、2：倾倒 */
    unsigned char K_Line_LID33; /* 01 SCR?DPD         //0：SCR无/DPD有、1：SCR有/DPD有、2：SCR无/DPD无、3：SCR有/DPD无    /*初值1*/

    unsigned char K_Line_LID34; /* 00 驻车种类        //0：FULL AIR、1：AOH                     /*初值1*/
    unsigned char K_Line_LID35; /* -- 气压计          //0：2针式、1：1针式 */
    unsigned char K_Line_LID36; /* -- 低压警报压      //0：一般输出（539kPa）、1：ADR（588kPa） */
    unsigned char K_Line_LID37; /* -- 超限警报        //0：无、1：有 */

    unsigned char K_Line_LID38; /* -- 速度警报        //0：无、1：有 */
    unsigned char K_Line_LID39; /* 00 可变SLD         //0：无、1：1车速、2：2车速            /*初值1*/
    unsigned char K_Line_LID3A; /* -- OEM             //0：ISZ、1：UDT */
    unsigned char K_Line_LID3B; /* -- 预留 */

    unsigned char K_Line_LID3C; /* -- 预留 */
    unsigned char K_Line_LID3D; /* -- 预留 */
    unsigned char K_Line_LID3E; /* 01 预留            //0：胎压功能未匹配    1：匹配 */
    unsigned char K_Line_LID3F; /* -- 预留 */

    unsigned char K_Line_LID40; /* 00 发动机种类 */
    unsigned char K_Line_LID41; /* 10 变速器种类＆控制                                /*初值50*/
    unsigned char K_Line_LID42; /* 00 驻车管道                                       /*初值 0*/
    unsigned char K_Line_LID43; /* 82 车型                                           /*初值44*/

    unsigned char K_Line_LID44; /* FF 速度警报                                       /*初值FF*/
    unsigned char K_Line_LID45; /* FF 发动机转速                                     /*初值FF*/
    unsigned char K_Line_LID46; /* FF 急加速                                         /*初值FF*/
    unsigned char K_Line_LID47; /* FF 急减速                                         /*初值FF*/

    unsigned char K_Line_LID48; /* FF 长时间怠速                                     /*初值FF*/
    unsigned char K_Line_LID49; /* FF 辅助驻车                                       /*初值FF*/
    unsigned char K_Line_LID4A; /* 32 变速箱油              5000 */
    unsigned char K_Line_LID4B; /* 32 差速器油              5000 */

    unsigned char K_Line_LID4C; /* 32 离合器油 */
    unsigned char K_Line_LID4D; /* 64 动力转向油            10000 */
    unsigned char K_Line_LID4E; /* 78 轮胎                  12000 */
    unsigned char K_Line_LID4F; /* 32 机油＆滤清器          5000 */

    unsigned char K_Line_LID50; /* -- 预留 */
    unsigned char K_Line_LID51; /* 01 工作模式              0-工厂模式  1-通常模式  2-销售模式*/
    unsigned char K_Line_LID52; /* 00 电子部件设定           0-500K    1-250k*/
    unsigned char KLINE;

    unsigned char No_Digit1;          //01
    unsigned char No_Digit2;          //02
    unsigned char No_Digit3;          //03
    unsigned char No_Digit4;          //04

    unsigned char No_Digit5;          //05
    unsigned char No_Digit6;          //06
    unsigned char No_Digit7;          //07
    unsigned char No_Digit8;          //08

    unsigned char No_Digit9;          //09
    unsigned char No_Digit10;         //10
    unsigned char ECUStatus1;         //11
    unsigned char ECUStatus2;         //12

    unsigned char ECUStatus3;         //13
    unsigned char ECUStatus4;         //14
    unsigned char ECUStatus5;         //15
    unsigned char METERCOUNT;         //16

    unsigned char NoOfDTCFF00;        //17
    unsigned char NoOfDTC8000;        //18
    unsigned char TesterECU;          //19
    unsigned char TesterECUCAN;       //20

    unsigned char User_Light1;
    unsigned char User_Light2;
    unsigned char User_Language;
    unsigned char reserve4;
} _EOL_K_LINE_SET;

extern _EOL_K_LINE_SET K_Line_Set;
typedef union
{
    unsigned char SendSeedEQUSRecvSeed;        /*密钥配对成功标识 0-失败 1-成功*/
    unsigned char RecvStart           ;        /*通讯开始标识    0-结束 1-开始*/
    unsigned char S_Regist            ;        /*是否注册标识*/
    unsigned char AccessMode2701      ;        /*27服务进入计时标志*/
} _K_LINE_SIGNAL_FLAG;

extern _K_LINE_SIGNAL_FLAG   K_LINE_SIGNAL_FLAG;

typedef union
{
    unsigned char ActiveSecurityAccess ;   /*修正值状态   0-未实施 1-实施后*/
    unsigned char SensorStatus         ;   /*传感器输入状态 0-LOW    1-HIGH*/
    unsigned char Security_Active      ;   /*锁定状态      0-未锁定 1-锁定*/
    unsigned char reserve              ;
} _ECUStatus;

extern    _ECUStatus        ECUStatusONE;

#define   ECUSTATUST_F      00             /*修正系数 EOL系数*2048*/

extern unsigned char        Sendseed1;      /*仪表计算*/
extern unsigned char        Sendseed2;
extern unsigned char        Sendseed3;
extern unsigned char        Sendseed4;

extern unsigned char        Recvseed1;      /*仪表接收*/
extern unsigned char        Recvseed2;
extern unsigned char        Recvseed3;
extern unsigned char        Recvseed4;

extern unsigned char Seed1, Seed2, Seed3, Seed4;

//extern unsigned long        SeedKey;
extern unsigned char        AccessMode2701KeyTimeFlag;
extern unsigned char        AccessMode2701KeyTime;

extern unsigned char Common_Get_DTCstatusCHGFFK_Flag(void);
extern void Common_Set_DTCstatusCHGFFK_Flag(unsigned char Val);
extern void K_LINE_EOL_InitVal(void);

extern void App_Uds_Calc_Key(void);
extern unsigned char Cup_Key(unsigned char KLineseed, unsigned char Num, unsigned char Seed);
extern unsigned char BitReplace (unsigned char Data);
extern void sendkey(void);
#endif
