
#define   GLOBALS_MEU_PROCESS

#include "Menu.h"
#include "GUI.h"
#include "Services_Mileage.h"
#include "Data_FuelConsump.h"
#include "CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "RTE_TIME.h"

uint8_t     bMenuSwFlag;
uint8_t     g_ClearWin1;
uint8_t     bNextMenuIDX;
uint8_t     bCurMenuIDX;
uint8_t     bMainMenuIDX;
uint8_t     bOldMenuIDX;

_MenuFlag    MenuFlag   ;

const _MenuOptTab   MenuOptTab[] =
{
    /*---------ENTER---------------------UP-----------------------DOWN----------------------EXIT------------------ENTER------------------DO-----------------EXIT------------*/
    /*主循环界面*/
    /*00*/{ _MN_DSP_LEVEL2MENU_1,     _MN_DSP_LEVEL1MENU_6,     _MN_DSP_LEVEL1MENU_2,     _MN_IDX_NULL,             Level1Menu_1Enter,       Level1Menu_1Do,       Level1Menu_1Exit},
    /*01*/{ _MN_DSP_LEVEL2MENU_1,     _MN_DSP_LEVEL1MENU_1,     _MN_DSP_LEVEL1MENU_3,     _MN_IDX_NULL,             Level1Menu_2Enter,       Level1Menu_2Do,       Level1Menu_2Exit},
    /*02*/{ _MN_DSP_LEVEL2MENU_1,     _MN_DSP_LEVEL1MENU_2,     _MN_DSP_LEVEL1MENU_4,     _MN_IDX_NULL,             Level1Menu_3Enter,       Level1Menu_3Do,       Level1Menu_3Exit},
    /*03*/{ _MN_DSP_LEVEL2MENU_1,     _MN_DSP_LEVEL1MENU_3,     _MN_DSP_LEVEL1MENU_5,     _MN_IDX_NULL,             Level1Menu_4Enter,       Level1Menu_4Do,       Level1Menu_4Exit},
    /*04*/{ _MN_DSP_LEVEL2MENU_1,     _MN_DSP_LEVEL1MENU_4,     _MN_DSP_LEVEL1MENU_6,     _MN_IDX_NULL,             Level1Menu_5Enter,       Level1Menu_5Do,       Level1Menu_5Exit},
    /*05*/{ _MN_DSP_LEVEL2MENU_1,     _MN_DSP_LEVEL1MENU_5,     _MN_DSP_LEVEL1MENU_1,     _MN_IDX_NULL,             Level1Menu_6Enter,       Level1Menu_6Do,       Level1Menu_6Exit},
    /*06*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelPopup_Enter,        LevelPopup_Do,        LevelPopup_Exit },

    /*一级菜单 */
    /*07*/{ _MN_DSP_LEVEL2_1_MENU_1,  _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_2,     _MN_IDX_NULL,             Level2Menu_1Enter,       Level2Menu_1Do,       Level2Menu_1Exit},
    /*08*/{ _MN_DSP_LEVEL2_2_MENU_1,  _MN_DSP_LEVEL2MENU_1,     _MN_DSP_LEVEL2MENU_3,     _MN_IDX_NULL,             Level2Menu_2Enter,       Level2Menu_2Do,       Level2Menu_2Exit},
    /*09*/{ _MN_DSP_LEVEL2_3_MENU_1,  _MN_DSP_LEVEL2MENU_2,     _MN_DSP_LEVEL2MENU_4,     _MN_IDX_NULL,             Level2Menu_3Enter,       Level2Menu_3Do,       Level2Menu_3Exit},
    /*10*/{ _MN_DSP_LEVEL2_4_MENU_1,  _MN_DSP_LEVEL2MENU_3,     _MN_DSP_LEVEL2MENU_5,     _MN_IDX_NULL,             Level2Menu_4Enter,       Level2Menu_4Do,       Level2Menu_4Exit},
    /*11*/{ _MN_DSP_LEVEL2_5_MENU_1,  _MN_DSP_LEVEL2MENU_4,     _MN_DSP_LEVEL2MENU_6,     _MN_IDX_NULL,             Level2Menu_5Enter,       Level2Menu_5Do,       Level2Menu_5Exit},
    /*12*/{ _MN_DSP_LEVEL2_6_MENU_1,  _MN_DSP_LEVEL2MENU_5,     _MN_IDX_NULL,             _MN_IDX_NULL,             Level2Menu_6Enter,       Level2Menu_6Do,       Level2Menu_6Exit},

    /*二级菜单 */
    /*13*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_1,     Level2_1Menu_1Enter,     Level2_1Menu_1Do,     Level2_1Menu_1Exit},

    /*14*/{ _MN_DSP_LEVEL3_2_MENU_1,  _MN_IDX_NULL,             _MN_DSP_LEVEL2_2_MENU_2,  _MN_DSP_LEVEL2MENU_2,     Level2_2Menu_1Enter,     Level2_2Menu_1Do,     Level2_2Menu_1Exit},
    /*15*/{ _MN_DSP_LEVEL3_2_MENU_2,  _MN_DSP_LEVEL2_2_MENU_1,  _MN_DSP_LEVEL2_2_MENU_3,  _MN_DSP_LEVEL2MENU_2,     Level2_2Menu_2Enter,     Level2_2Menu_2Do,     Level2_2Menu_2Exit},
    /*16*/{ _MN_DSP_LEVEL3_2_MENU_3,  _MN_DSP_LEVEL2_2_MENU_2,  _MN_DSP_LEVEL2_2_MENU_4,  _MN_DSP_LEVEL2MENU_2,     Level2_2Menu_3Enter,     Level2_2Menu_3Do,     Level2_2Menu_3Exit},
    /*17*/{ _MN_DSP_LEVEL3_2_MENU_4,  _MN_DSP_LEVEL2_2_MENU_3,  _MN_DSP_LEVEL2_2_MENU_7,  _MN_DSP_LEVEL2MENU_2,     Level2_2Menu_4Enter,     Level2_2Menu_4Do,     Level2_2Menu_4Exit},
    /*18*/{ _MN_DSP_LEVEL3_2_MENU_7,  _MN_DSP_LEVEL2_2_MENU_4,  _MN_DSP_LEVEL2_2_MENU_8,  _MN_DSP_LEVEL2MENU_2,     Level2_2Menu_7Enter,     Level2_2Menu_7Do,     Level2_2Menu_7Exit},
    /*19*/{ _MN_DSP_LEVEL3_2_MENU_8,  _MN_DSP_LEVEL2_2_MENU_7,  _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_2,     Level2_2Menu_8Enter,     Level2_2Menu_8Do,     Level2_2Menu_8Exit},

    /*20*/{ _MN_DSP_LEVEL3_3_MENU_1,  _MN_IDX_NULL,             _MN_DSP_LEVEL2_3_MENU_2,  _MN_DSP_LEVEL2MENU_3,     Level2_3Menu_1Enter,     Level2_3Menu_1Do,     Level2_3Menu_1Exit},
    /*21*/{ _MN_DSP_LEVEL3_3_MENU_2,  _MN_DSP_LEVEL2_3_MENU_1,  _MN_DSP_LEVEL2_3_MENU_3,  _MN_DSP_LEVEL2MENU_3,     Level2_3Menu_2Enter,     Level2_3Menu_2Do,     Level2_3Menu_2Exit},
    /*22*/{ _MN_DSP_LEVEL3_3_MENU_3,  _MN_DSP_LEVEL2_3_MENU_2,  _MN_DSP_LEVEL2_3_MENU_4,  _MN_DSP_LEVEL2MENU_3,     Level2_3Menu_3Enter,     Level2_3Menu_3Do,     Level2_3Menu_3Exit},
    /*23*/{ _MN_DSP_LEVEL3_3_MENU_4,  _MN_DSP_LEVEL2_3_MENU_3,  _MN_DSP_LEVEL2_3_MENU_6,  _MN_DSP_LEVEL2MENU_3,     Level2_3Menu_4Enter,     Level2_3Menu_4Do,     Level2_3Menu_4Exit},
    /*24*/{ _MN_DSP_LEVEL3_3_MENU_6,  _MN_DSP_LEVEL2_3_MENU_4,  _MN_DSP_LEVEL2_3_MENU_7,  _MN_DSP_LEVEL2MENU_3,     Level2_3Menu_6Enter,     Level2_3Menu_6Do,     Level2_3Menu_6Exit},
    /*25*/{ _MN_DSP_LEVEL3_3_MENU_7,  _MN_DSP_LEVEL2_3_MENU_6,  _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_3,     Level2_3Menu_7Enter,     Level2_3Menu_7Do,     Level2_3Menu_7Exit},

    /*26*/{ _MN_DSP_LEVEL3_4_MENU_11, _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_2,  _MN_DSP_LEVEL2MENU_4,     Level2_4Menu_1Enter,     Level2_4Menu_1Do,     Level2_4Menu_1Exit},
    /*27*/{ _MN_DSP_LEVEL3_4_MENU_21, _MN_DSP_LEVEL2_4_MENU_1,  _MN_DSP_LEVEL2_4_MENU_7,  _MN_DSP_LEVEL2MENU_4,     Level2_4Menu_2Enter,     Level2_4Menu_2Do,     Level2_4Menu_2Exit},
    /*28*/{ _MN_DSP_LEVEL3_7_MENU_1,  _MN_DSP_LEVEL2_4_MENU_2,  _MN_DSP_LEVEL2_4_MENU_3,  _MN_DSP_LEVEL2MENU_4,     Level2_4Menu_7Enter,     Level2_4Menu_7Do,     Level2_4Menu_7Exit},
    /*29*/{ _MN_DSP_LEVEL3_4_MENU_3,  _MN_DSP_LEVEL2_4_MENU_7,  _MN_DSP_LEVEL2_4_MENU_4,  _MN_DSP_LEVEL2MENU_4,     Level2_4Menu_3Enter,     Level2_4Menu_3Do,     Level2_4Menu_3Exit},
    /*30*/{ _MN_DSP_LEVEL3_4_MENU_41, _MN_DSP_LEVEL2_4_MENU_3,  _MN_DSP_LEVEL2_4_MENU_5,  _MN_DSP_LEVEL2MENU_4,     Level2_4Menu_4Enter,     Level2_4Menu_4Do,     Level2_4Menu_4Exit},
    /*31*/{ _MN_DSP_LEVEL3_4_MENU_5,  _MN_DSP_LEVEL2_4_MENU_4,  _MN_DSP_LEVEL2_4_MENU_6,  _MN_DSP_LEVEL2MENU_4,     Level2_4Menu_5Enter,     Level2_4Menu_5Do,     Level2_4Menu_5Exit},
    /*32*/{ _MN_IDX_NULL           ,  _MN_DSP_LEVEL2_4_MENU_5,  _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_4,     Level2_4Menu_6Enter,     Level2_4Menu_6Do,     Level2_4Menu_6Exit},

    /*33*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_6_MENU_2,  _MN_DSP_LEVEL2MENU_6,     Level2_6Menu_1Enter,     Level2_6Menu_1Do,     Level2_6Menu_1Exit},
    /*34*/{ _MN_IDX_NULL,             _MN_DSP_LEVEL2_6_MENU_1,  _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_6,     Level2_6Menu_2Enter,     Level2_6Menu_2Do,     Level2_6Menu_2Exit},

    /*35*/{ _MN_DSP_LEVEL3_5_MENU_1,  _MN_IDX_NULL,             _MN_DSP_LEVEL2_5_MENU_2,  _MN_DSP_LEVEL2MENU_5,     Level2_5Menu_1Enter,     Level2_5Menu_1Do,     Level2_5Menu_1Exit},
    /*36*/{ _MN_DSP_LEVEL3_5_MENU_2,  _MN_DSP_LEVEL2_5_MENU_1,  _MN_DSP_LEVEL2_5_MENU_3,  _MN_DSP_LEVEL2MENU_5,     Level2_5Menu_2Enter,     Level2_5Menu_2Do,     Level2_5Menu_2Exit},
    /*37*/{ _MN_DSP_LEVEL3_5_MENU_3,  _MN_DSP_LEVEL2_5_MENU_2,  _MN_DSP_LEVEL2_5_MENU_4,  _MN_DSP_LEVEL2MENU_5,     Level2_5Menu_3Enter,     Level2_5Menu_3Do,     Level2_5Menu_3Exit},
    /*38*/{ _MN_DSP_LEVEL3_5_MENU_4,  _MN_DSP_LEVEL2_5_MENU_3,  _MN_IDX_NULL,             _MN_DSP_LEVEL2MENU_5,     Level2_5Menu_4Enter,     Level2_5Menu_4Do,     Level2_5Menu_4Exit},

    /*三级菜单*/
    /*39*/{_MN_DSP_ENTER_MENU,        _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_2_MENU_1,  Level3_2Menu_1Enter,     Level3_2Menu_1Do,     Level3_2Menu_1Exit},
    /*40*/{_MN_DSP_ENTER_MENU,        _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_2_MENU_2,  Level3_2Menu_2Enter,     Level3_2Menu_2Do,     Level3_2Menu_2Exit},
    /*41*/{_MN_DSP_ENTER_MENU,        _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_2_MENU_3,  Level3_2Menu_3Enter,     Level3_2Menu_3Do,     Level3_2Menu_3Exit},
    /*42*/{_MN_DSP_ENTER_MENU,        _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_2_MENU_4,  Level3_2Menu_4Enter,     Level3_2Menu_4Do,     Level3_2Menu_4Exit},
    /*43*/{_MN_DSP_ENTER_MENU,        _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_2_MENU_7,  Level3_2Menu_7Enter,     Level3_2Menu_7Do,     Level3_2Menu_7Exit},
    /*44*/{_MN_DSP_ENTER_MENU,        _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_2_MENU_8,  Level3_2Menu_8Enter,     Level3_2Menu_8Do,     Level3_2Menu_8Exit},

    /*45*/{ _MN_DSP_LEVEL2_3_MENU_1,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_3_MENU_1,  Level3_3Menu_1Enter,     Level3_3Menu_1Do,     Level3_3Menu_1Exit},
    /*46*/{ _MN_DSP_LEVEL2_3_MENU_2,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_3_MENU_2,  Level3_3Menu_2Enter,     Level3_3Menu_2Do,     Level3_3Menu_2Exit},
    /*47*/{ _MN_DSP_LEVEL2_3_MENU_3,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_3_MENU_3,  Level3_3Menu_3Enter,     Level3_3Menu_3Do,     Level3_3Menu_3Exit},
    /*48*/{ _MN_DSP_LEVEL2_3_MENU_4,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_3_MENU_4,  Level3_3Menu_4Enter,     Level3_3Menu_4Do,     Level3_3Menu_4Exit},
    /*49*/{ _MN_DSP_LEVEL2_3_MENU_6,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_3_MENU_6,  Level3_3Menu_6Enter,     Level3_3Menu_6Do,     Level3_3Menu_6Exit},
    /*50*/{ _MN_DSP_LEVEL2_3_MENU_7,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_3_MENU_7,  Level3_3Menu_7Enter,     Level3_3Menu_7Do,     Level3_3Menu_7Exit},

    /*51*/{ _MN_DSP_LEVEL3_4_MENU_12, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_1,  Level3_4Menu_1Enter_1,   Level3_4Menu_1Do_1,   Level3_4Menu_1Exit_1},
    /*52*/{ _MN_DSP_LEVEL3_4_MENU_13, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_1,  Level3_4Menu_1Enter_2,   Level3_4Menu_1Do_2,   Level3_4Menu_1Exit_2},
    /*53*/{ _MN_DSP_LEVEL2_4_MENU_1,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_1,  Level3_4Menu_1Enter_3,   Level3_4Menu_1Do_3,   Level3_4Menu_1Exit_3},
    /*54*/{ _MN_DSP_LEVEL3_4_MENU_22, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_2,  Level3_4Menu_2Enter_1,   Level3_4Menu_2Do_1,   Level3_4Menu_2Exit_1},
    /*55*/{ _MN_DSP_LEVEL2_4_MENU_2,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_2,  Level3_4Menu_2Enter_2,   Level3_4Menu_2Do_2,   Level3_4Menu_2Exit_2},
    /*56*/{ _MN_DSP_LEVEL2_4_MENU_3,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_3,  Level3_4Menu_3Enter,     Level3_4Menu_3Do,     Level3_4Menu_3Exit},
    /*57*/{ _MN_DSP_LEVEL4_4_MENU_1,  _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_42, _MN_DSP_LEVEL2_4_MENU_4,  Level3_4Menu_4Enter_1,   Level3_4Menu_4Do_1,   Level3_4Menu_4Exit_1},
    /*58*/{ _MN_DSP_LEVEL4_4_MENU_2,  _MN_DSP_LEVEL3_4_MENU_41, _MN_DSP_LEVEL3_4_MENU_43, _MN_DSP_LEVEL2_4_MENU_4,  Level3_4Menu_4Enter_2,   Level3_4Menu_4Do_2,   Level3_4Menu_4Exit_2},
    /*59*/{ _MN_DSP_LEVEL4_4_MENU_3,  _MN_DSP_LEVEL3_4_MENU_42, _MN_DSP_LEVEL3_4_MENU_44, _MN_DSP_LEVEL2_4_MENU_4,  Level3_4Menu_4Enter_3,   Level3_4Menu_4Do_3,   Level3_4Menu_4Exit_3},
    /*60*/{ _MN_DSP_LEVEL4_4_MENU_4,  _MN_DSP_LEVEL3_4_MENU_43, _MN_DSP_LEVEL3_4_MENU_45, _MN_DSP_LEVEL2_4_MENU_4,  Level3_4Menu_4Enter_4,   Level3_4Menu_4Do_4,   Level3_4Menu_4Exit_4},
    /*61*/{ _MN_DSP_LEVEL4_4_MENU_5,  _MN_DSP_LEVEL3_4_MENU_44, _MN_DSP_LEVEL3_4_MENU_46, _MN_DSP_LEVEL2_4_MENU_4,  Level3_4Menu_4Enter_5,   Level3_4Menu_4Do_5,   Level3_4Menu_4Exit_5},
    /*62*/{ _MN_DSP_LEVEL4_4_MENU_6,  _MN_DSP_LEVEL3_4_MENU_45, _MN_DSP_LEVEL3_4_MENU_47, _MN_DSP_LEVEL2_4_MENU_4,  Level3_4Menu_4Enter_6,   Level3_4Menu_4Do_6,   Level3_4Menu_4Exit_6},
    /*63*/{ _MN_DSP_LEVEL4_4_MENU_7,  _MN_DSP_LEVEL3_4_MENU_46, _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_4,  Level3_4Menu_4Enter_7,   Level3_4Menu_4Do_7,   Level3_4Menu_4Exit_7},
    /*64*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_5,  Level3_4Menu_5Enter,     Level3_4Menu_5Do,     Level3_4Menu_5Exit},
    /*65*/{ _MN_DSP_LEVEL3_7_MENU_2,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_4_MENU_7,  Level3_4Menu_7Enter_1,   Level3_4Menu_7Do_1,   Level3_4Menu_7Exit_1},
    /*66*/{ _MN_DSP_LEVEL2_4_MENU_7,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_7_MENU_1,  Level3_4Menu_7Enter_2,   Level3_4Menu_7Do_2,   Level3_4Menu_7Exit_2},

    /*四级菜单*/
    /*67*/{ _MN_DSP_LEVEL3_4_MENU_41, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_41, Level4_4Menu_1Enter,     Level4_4Menu_1Do,     Level4_4Menu_1Exit},
    /*68*/{ _MN_DSP_LEVEL3_4_MENU_42, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_42, Level4_4Menu_2Enter,     Level4_4Menu_2Do,     Level4_4Menu_2Exit},
    /*69*/{ _MN_DSP_LEVEL3_4_MENU_43, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_43, Level4_4Menu_3Enter,     Level4_4Menu_3Do,     Level4_4Menu_3Exit},
    /*70*/{ _MN_DSP_LEVEL3_4_MENU_44, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_44, Level4_4Menu_4Enter,     Level4_4Menu_4Do,     Level4_4Menu_4Exit},
    /*71*/{ _MN_DSP_LEVEL3_4_MENU_45, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_45, Level4_4Menu_5Enter,     Level4_4Menu_5Do,     Level4_4Menu_5Exit},
    /*72*/{ _MN_DSP_LEVEL3_4_MENU_46, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_46, Level4_4Menu_6Enter,     Level4_4Menu_6Do,     Level4_4Menu_6Exit},
    /*73*/{ _MN_DSP_LEVEL3_4_MENU_47, _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL3_4_MENU_47, Level4_4Menu_7Enter,     Level4_4Menu_7Do,     Level4_4Menu_7Exit},

    /*74*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             Level_Enter_Menu_Enter,  Level_Enter_Menu_Do,  Level_Enter_Menu_Exit},
    /*75*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             Level_Return_Menu_Enter, Level_Return_Menu_Do, Level_Return_Menu_Exit},

    /*76*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_5_MENU_1,  Level3_5Menu_1Enter,     Level3_5Menu_1Do,     Level3_5Menu_1Exit},
    /*77*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_5_MENU_2,  Level3_5Menu_2Enter,     Level3_5Menu_2Do,     Level3_5Menu_2Exit},
    /*78*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_5_MENU_3,  Level3_5Menu_3Enter,     Level3_5Menu_3Do,     Level3_5Menu_3Exit},
    /*79*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_DSP_LEVEL2_5_MENU_4,  Level3_5Menu_4Enter,     Level3_5Menu_4Do,     Level3_5Menu_4Exit},

    /*80*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelMenuOFF_Enter,      LevelMenuOFF_Do,      LevelMenuOFF_Exit},
    /*81*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelMenuTest_Enter,     LevelMenuTest_Do,     LevelMenuTest_Exit},

    /*工厂模式*/
    /*82*/{ _FAC_DSP_LEVEL1MENU_1,    _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelF0Menu_1Enter,      LevelF0Menu_1Do,      LevelF0Menu_1Exit},

    /*83*/{ _FAC_DSP_LEVEL1_1MENU_1,  _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_2,    _MN_IDX_NULL,             LevelF1Menu_1Enter,      LevelF1Menu_1Do,      LevelF1Menu_1Exit},
    /*84*/{ _FAC_DSP_LEVEL1_2MENU_1,  _FAC_DSP_LEVEL1MENU_1,    _FAC_DSP_LEVEL1MENU_3,    _MN_IDX_NULL,             LevelF1Menu_2Enter,      LevelF1Menu_2Do,      LevelF1Menu_2Exit},
    /*85*/{ _FAC_DSP_LEVEL1_3MENU_1,  _FAC_DSP_LEVEL1MENU_2,    _FAC_DSP_LEVEL1MENU_4,    _MN_IDX_NULL,             LevelF1Menu_3Enter,      LevelF1Menu_3Do,      LevelF1Menu_3Exit},
    /*86*/{ _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_3,    _FAC_DSP_LEVEL1MENU_5,    _MN_IDX_NULL,             LevelF1Menu_4Enter,      LevelF1Menu_4Do,      LevelF1Menu_4Exit},
    /*87*/{ _FAC_DSP_LEVEL2_5MENU_1,  _FAC_DSP_LEVEL1MENU_4,    _FAC_DSP_LEVEL1MENU_6,    _MN_IDX_NULL,             LevelF1Menu_5Enter,      LevelF1Menu_5Do,      LevelF1Menu_5Exit},
    /*88*/{ _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_5,    _MN_IDX_NULL,             _MN_IDX_NULL,             LevelF1Menu_6Enter,      LevelF1Menu_6Do,      LevelF1Menu_6Exit},

    /*89*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_1,    LevelF1_1Menu_1Enter,    LevelF1_1Menu_1Do,    LevelF1_1Menu_1Exit},

    /*90*/{ _FAC_DSP_LEVEL1_2MENU_2,  _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_2,    LevelF1_2Menu_1Enter,    LevelF1_2Menu_1Do,    LevelF1_2Menu_1Exit},
    /*91*/{ _FAC_DSP_LEVEL1_2MENU_3,  _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1_2MENU_1,  LevelF1_2Menu_2Enter,    LevelF1_2Menu_2Do,    LevelF1_2Menu_2Exit},
    /*92*/{ _FAC_DSP_LEVEL1_2MENU_4,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelF1_2Menu_3Enter,    LevelF1_2Menu_3Do,    LevelF1_2Menu_3Exit},
    /*93*/{ _FAC_DSP_LEVEL0MENU_1,    _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelF1_2Menu_4Enter,    LevelF1_2Menu_4Do,    LevelF1_2Menu_4Exit},

    /*94*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1_3MENU_2,  _FAC_DSP_LEVEL1MENU_3,    LevelF1_3Menu_1Enter,    LevelF1_3Menu_1Do,    LevelF1_3Menu_1Exit},
    /*95*/{ _MN_IDX_NULL,             _FAC_DSP_LEVEL1_3MENU_1,  _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_3,    LevelF1_3Menu_2Enter,    LevelF1_3Menu_2Do,    LevelF1_3Menu_2Exit},

    /*96*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_1,    LevelF1_1Menu_1Enter,    LevelF1_1Menu_1Do,    LevelF1_1Menu_1Exit},
    /*97*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_1,    LevelF1_1Menu_2Enter,    LevelF1_1Menu_2Do,    LevelF1_1Menu_2Exit},
    /*98*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_1,    LevelF1_1Menu_3Enter,    LevelF1_1Menu_3Do,    LevelF1_1Menu_3Exit},
    /*99*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_1,    LevelF1_1Menu_4Enter,    LevelF1_1Menu_4Do,    LevelF1_1Menu_4Exit},

    /*99*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _FAC_DSP_LEVEL1MENU_5,    LevelF2_5Menu_1Enter,    LevelF2_5Menu_1Do,    LevelF2_5Menu_1Exit},

    /*经销商模式*/
    /*00*/{ _DEA_DSP_LEVEL1MENU_1,    _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelD0Menu_1Enter,      LevelD0Menu_1Do,      LevelD0Menu_1Exit},

    /*01*/{ _DEA_DSP_LEVEL1_1MENU_1,  _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_2,    _MN_IDX_NULL,             LevelD1Menu_1Enter,      LevelD1Menu_1Do,      LevelD1Menu_1Exit},
    /*02*/{ _DEA_DSP_LEVEL1_2MENU_1,  _DEA_DSP_LEVEL1MENU_1,    _DEA_DSP_LEVEL1MENU_3,    _MN_IDX_NULL,             LevelD1Menu_2Enter,      LevelD1Menu_2Do,      LevelD1Menu_2Exit},
    /*03*/{ _DEA_DSP_LEVEL1_3MENU_1,  _DEA_DSP_LEVEL1MENU_2,    _DEA_DSP_LEVEL1MENU_4,    _MN_IDX_NULL,             LevelD1Menu_3Enter,      LevelD1Menu_3Do,      LevelD1Menu_3Exit},
    /*04*/{ _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_3,    _DEA_DSP_LEVEL1MENU_5,    _MN_IDX_NULL,             LevelD1Menu_4Enter,      LevelD1Menu_4Do,      LevelD1Menu_4Exit},
    /*05*/{ _DEA_DSP_LEVEL2_5MENU_1,  _DEA_DSP_LEVEL1MENU_4,    _DEA_DSP_LEVEL1MENU_6,    _MN_IDX_NULL,             LevelD1Menu_5Enter,      LevelD1Menu_5Do,      LevelD1Menu_5Exit},
    /*06*/{ _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_5,    _MN_IDX_NULL,             _MN_IDX_NULL,             LevelD1Menu_6Enter,      LevelD1Menu_6Do,      LevelD1Menu_6Exit},

    /*07*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_1,    LevelD1_1Menu_1Enter,    LevelD1_1Menu_1Do,    LevelD1_1Menu_1Exit},

    /*08*/{ _DEA_DSP_LEVEL1_2MENU_2,  _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_2,    LevelD1_2Menu_1Enter,    LevelD1_2Menu_1Do,    LevelD1_2Menu_1Exit},
    /*09*/{ _DEA_DSP_LEVEL1_2MENU_3,  _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1_2MENU_1,  LevelD1_2Menu_2Enter,    LevelD1_2Menu_2Do,    LevelD1_2Menu_2Exit},
    /*10*/{ _DEA_DSP_LEVEL1_2MENU_4,  _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelD1_2Menu_3Enter,    LevelD1_2Menu_3Do,    LevelD1_2Menu_3Exit},
    /*11*/{ _DEA_DSP_LEVEL0MENU_1,    _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             LevelD1_2Menu_4Enter,    LevelD1_2Menu_4Do,    LevelD1_2Menu_4Exit},

    /*12*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1_3MENU_2,  _DEA_DSP_LEVEL1MENU_3,    LevelD1_3Menu_1Enter,    LevelD1_3Menu_1Do,    LevelD1_3Menu_1Exit},
    /*13*/{ _MN_IDX_NULL,             _DEA_DSP_LEVEL1_3MENU_1,  _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_3,    LevelD1_3Menu_2Enter,    LevelD1_3Menu_2Do,    LevelD1_3Menu_2Exit},

    /*14*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_1,    LevelF1_1Menu_1Enter,    LevelF1_1Menu_1Do,    LevelF1_1Menu_1Exit},
    /*15*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_1,    LevelF1_1Menu_2Enter,    LevelF1_1Menu_2Do,    LevelF1_1Menu_2Exit},
    /*16*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_1,    LevelF1_1Menu_3Enter,    LevelF1_1Menu_3Do,    LevelF1_1Menu_3Exit},
    /*17*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_1,    LevelF1_1Menu_4Enter,    LevelF1_1Menu_4Do,    LevelF1_1Menu_4Exit},

    /*17*/{ _MN_IDX_NULL,             _MN_IDX_NULL,             _MN_IDX_NULL,             _DEA_DSP_LEVEL1MENU_5,    LevelD2_5Menu_1Enter,    LevelD2_5Menu_1Do,    LevelD2_5Menu_1Exit},
};
void NextMenu(_MENU_IDX idx)
{
    if ((idx) != _MN_IDX_NULL)
    {
        bNextMenuIDX = (idx);
    }
    else
    {
    }
    bOldMenuIDX = 0xFF;
}
void MenuInit(void)
{
    bCurMenuIDX = 0;
    bNextMenuIDX = 0;
    bMenuSwFlag = 1;

    if (bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1)
    {
        bCurMenuIDX = MenuFlag.Menu_Flag; /*记录上次位置*/
        bNextMenuIDX = bCurMenuIDX;
    }
    else
    {
        ;/*do nothing*/
    }

    /*数据初始化*/
    MenuFlag.Key_Menu_Popup_time = 0u;
}
void MenuManage(void)
{
    if (bMenuSwFlag)
    {
        if (MenuOptTab[bCurMenuIDX].Enter)
        {
            MenuOptTab[bCurMenuIDX].Enter();
        }
        else
        {
            ;/*do nothing*/
        }
    }
    else
    {
        ;/*do nothing*/
    }

    if (MenuOptTab[bCurMenuIDX].Do)
    {
        MenuOptTab[bCurMenuIDX].Do();
    }
    else
    {
        ;/*do nothing*/
    }

    bMenuSwFlag = (bCurMenuIDX != bNextMenuIDX) ? 1 : 0;
    if (bMenuSwFlag)
    {
        if (MenuOptTab[bCurMenuIDX].Exit && MenuOptTab[bCurMenuIDX].VK_IDX_EXIT)
        {
            MenuOptTab[bCurMenuIDX].Exit();
        }
        else
        {
            ;/*do nothing*/
        }
    }

    bCurMenuIDX = bNextMenuIDX;
}

/*主界面1   平均油耗，平均车速*/
void Level1Menu_1Enter(void)
{}
void Level1Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_AVG_FuelSpeed_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_1Exit(void)
{}

/*主界面2 电池显示*/
void Level1Menu_2Enter(void)
{}
void Level1Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_Battery_Display_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_2Exit(void)
{}

/*主界面3 DPD*/
void Level1Menu_3Enter(void)
{}
void Level1Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_DPD_Display_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_3Exit(void)
{}

/*主界面4 油温时间*/
void Level1Menu_4Enter(void)
{}
void Level1Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_Time_OilTemp_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_4Exit(void)
{}

/*主界面5 万年历*/
void Level1Menu_5Enter(void)
{}
void Level1Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_Year_Month_Data_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_5Exit(void)
{}

/*主界面6  空白*/
void Level1Menu_6Enter(void)
{}
void Level1Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_block_NULL_Display(GUI_DISP_MODE_NORMAL);
}
void Level1Menu_6Exit(void)
{}

/*主界面 报警界面*/
void LevelPopup_Enter(void)
{}
void LevelPopup_Do(void)
{
    GUI_General_Popup();
}
void LevelPopup_Exit(void)
{}

/*----MENU----*/
/*二级菜单 故障码*/
void Level2Menu_1Enter(void)
{}
void Level2Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_1Exit(void)
{}

/*二级菜单 维修通知*/
void Level2Menu_2Enter(void)
{}
void Level2Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_2Exit(void)
{}

/*二级菜单 维修通知设定*/
void Level2Menu_3Enter(void)
{}
void Level2Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_3Exit(void)
{}

/*二级菜单 用户设定*/
void Level2Menu_4Enter(void)
{}
void Level2Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_4Exit(void)
{}

/*二级界面 系统演示*/
void Level2Menu_5Enter(void)
{}
void Level2Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu5_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_5Exit(void)
{}

/*二级界面 胎压显示*/
void Level2Menu_6Enter(void)
{}
void Level2Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_Menu6_Display(GUI_DISP_MODE_NORMAL);
}
void Level2Menu_6Exit(void)
{}

/*----二级菜单----故障代码----子菜单系列*/
/*发动机故障*/
void Level2_1Menu_1Enter(void)
{}
static uint8_t DTCNumDis = 0u;
void Level2_1Menu_1Do(void)
{
    //uint8_t DTCNumDis = 0u;

    //DTCNumDis = 0u;

    GUI_OftenShow_Display();

    if (DTCNumDis == 1u) /*故障码轮显*/
    {
        GUI_Display_DTC_Server();
    }
    else /*故障码读取中*/
    {
        GUI_BG_DTCReading_Display(GUI_DISP_MODE_NORMAL);
    }
}
void Level2_1Menu_1Exit(void)
{}

/*----二级菜单----保养通知----子菜单系列*/
/*发动机油滤清器*/
void Level2_2Menu_1Enter(void)
{}
void Level2_2Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_1Exit(void)
{}

/*----二级菜单----保养通知----子菜单系列*/
/*燃油滤清器*/
void Level2_2Menu_2Enter(void)
{}
void Level2_2Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_2Exit(void)
{}

/*----二级菜单----保养通知----子菜单系列*/
/*变速箱油*/
void Level2_2Menu_3Enter(void)
{}
void Level2_2Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_3Exit(void)
{}

/*----二级菜单----保养通知----子菜单系列*/
/*差速器油*/
void Level2_2Menu_4Enter(void)
{}
void Level2_2Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_4Exit(void)
{}

/*----二级菜单----保养通知----子菜单系列*/
/*动力转向油*/
void Level2_2Menu_7Enter(void)
{}
void Level2_2Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu7_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_7Exit(void)
{}

/*----二级菜单----保养通知----子菜单系列*/
/*轮胎*/
void Level2_2Menu_8Enter(void)
{}
void Level2_2Menu_8Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Rep_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu8_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_2Menu_8Exit(void)
{}

/*----二级菜单----保养通知设定----系列子菜单*/
/*更换发动机滤清器*/
void Level2_3Menu_1Enter(void)
{}
void Level2_3Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_1Exit(void)
{}

/*----二级菜单----保养通知设定----系列子菜单*/
/*更换燃油滤清器*/
void Level2_3Menu_2Enter(void)
{}
void Level2_3Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_2Exit(void)
{}

/*----二级菜单----保养通知设定----系列子菜单*/
/*更换变速箱油*/
void Level2_3Menu_3Enter(void)
{}
void Level2_3Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_3Exit(void)
{}

/*----二级菜单----保养通知设定----系列子菜单*/
/*更换差速器油*/
void Level2_3Menu_4Enter(void)
{}
void Level2_3Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_4Exit(void)
{}

/*----二级菜单----保养通知设定----系列子菜单*/
/*更换动力转向油*/
void Level2_3Menu_6Enter(void)
{}
void Level2_3Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu6_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_6Exit(void)
{}

/*----二级菜单----保养通知设定----系列子菜单*/
/*更换轮胎轮胎*/
void Level2_3Menu_7Enter(void)
{}
void Level2_3Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu7_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_3Menu_7Exit(void)
{}

/*----二级菜单----用户设定----系列子菜单*/
/*日期设定*/
void Level2_4Menu_1Enter(void)
{}
void Level2_4Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_1Exit(void)
{}

/*----二级菜单----用户设定----系列子菜单*/
/*时间设定*/
void Level2_4Menu_2Enter(void)
{}
void Level2_4Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_2Exit(void)
{}

/*----二级菜单----用户设定----系列子菜单*/
/*语言设定*/
void Level2_4Menu_3Enter(void)
{}
void Level2_4Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_3Exit(void)
{}

/*----二级菜单----用户设定----系列子菜单*/
/*亮度调节*/
void Level2_4Menu_7Enter(void)
{}
void Level2_4Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu8_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_7Exit(void)
{}
/*----二级菜单----用户设定----系列子菜单*/
/*设定节油驾驶建议*/
void Level2_4Menu_4Enter(void)
{}
void Level2_4Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_4Exit(void)
{}

/*----二级菜单----用户设定----系列子菜单*/
/*TPMS轮胎设定*/
void Level2_4Menu_5Enter(void)
{}
void Level2_4Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu5_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_5Exit(void)
{}

/*----二级菜单----用户设定----系列子菜单*/
/*显示设定*/
void Level2_4Menu_6Enter(void)
{}
void Level2_4Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSetMenu6_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_4Menu_6Exit(void)
{}

/*----二级菜单----系统演示----系列子菜单*/
/*LDWS 警报演示*/
void Level2_5Menu_1Enter(void)
{}
void Level2_5Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Demo_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DemoMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_5Menu_1Exit(void)
{}

/*----二级菜单----系统演示----系列子菜单*/
/*AEBS第1警报演示*/
void Level2_5Menu_2Enter(void)
{}
void Level2_5Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Demo_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DemoMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_5Menu_2Exit(void)
{}

/*----二级菜单----系统演示----系列子菜单*/
/*AEBS第1警报演示*/
void Level2_5Menu_3Enter(void)
{}
void Level2_5Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Demo_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DemoMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_5Menu_3Exit(void)
{}

/*----二级菜单----系统演示----系列子菜单*/
/*AEBS全力制动警报演示*/
void Level2_5Menu_4Enter(void)
{}
void Level2_5Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_Demo_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DemoMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_5Menu_4Exit(void)
{}

/*----二级菜单----轮胎状态----系列子菜单*/
/*轮胎气压*/
void Level2_6Menu_1Enter(void)
{}
void Level2_6Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_TPMS_GasPIC_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_TPMS_GasNUM_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_6Menu_1Exit(void)
{}

/*----二级菜单----轮胎状态----系列子菜单*/
/*轮胎温度*/
void Level2_6Menu_2Enter(void)
{}
void Level2_6Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_TPMS_TempPIC_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_TPMS_TempNUM_Display(GUI_DISP_MODE_NORMAL);
}
void Level2_6Menu_2Exit(void)
{}

/*----三级菜单----保养通知----系列子菜单*/
/*发动机机油滤清器*/
void Level3_2Menu_1Enter(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_FDJYLQQ = (uint32_t)K_Line_Set.K_Line_LID4F * 1000;

        State_Flag.User_FDJYLQQ_FLAG = 0;
        MenuFlag.Menu_Return = 0;

        Data_Clear_Trip(EM_TRIP_JY);
    }
}
void Level3_2Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu_3_1_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_2Menu_1Exit(void)
{}

/*----三级菜单----保养通知----系列子菜单*/
/*燃油滤清器*/
void Level3_2Menu_2Enter(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_RYLQQ = (uint32_t)K_Line_User_RYLQQ * 1000;

        State_Flag.User_RYLQQ_FLAG = 0;
        MenuFlag.Menu_Return = 0;

        Data_Clear_Trip(EM_TRIP_RY);
    }
}
void Level3_2Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu_3_2_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_2Menu_2Exit(void)
{}

/*----三级菜单----保养通知----系列子菜单*/
/*变速箱油*/
void Level3_2Menu_3Enter(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_BSXY = (uint32_t)K_Line_Set.K_Line_LID4A * 1000;

        State_Flag.User_BSXY_FLAG = 0;
        MenuFlag.Menu_Return = 0;

        Data_Clear_Trip(EM_TRIP_BSX);
    }
}
void Level3_2Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu_3_3_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_2Menu_3Exit(void)
{}

/*----三级菜单----保养通知----系列子菜单*/
/*差速器油*/
void Level3_2Menu_4Enter(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_CSQY = (uint32_t)K_Line_Set.K_Line_LID4B * 1000;

        State_Flag.User_CSQY_FLAG = 0;
        MenuFlag.Menu_Return = 0;

        Data_Clear_Trip(EM_TRIP_CSQ);
    }
}
void Level3_2Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu_3_4_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_2Menu_4Exit(void)
{}

/*----三级菜单----保养通知----系列子菜单*/
/*动力转向油*/
void Level3_2Menu_7Enter(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_DLZXY = (uint32_t)K_Line_Set.K_Line_LID4D * 1000;

        State_Flag.User_DLZXY_FLAG = 0;
        MenuFlag.Menu_Return = 0;

        Data_Clear_Trip(EM_TRIP_DLZX);
    }
}
void Level3_2Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu_3_7_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_2Menu_7Exit(void)
{}

/*----三级菜单----保养通知----系列子菜单*/
/*轮胎*/
void Level3_2Menu_8Enter(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_LT = (uint32_t)K_Line_Set.K_Line_LID4E * 1000;

        State_Flag.User_LT_FLAG = 0;
        MenuFlag.Menu_Return = 0;

        Data_Clear_Trip(EM_TRIP_LT);
    }
}
void Level3_2Menu_8Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepMenu_3_8_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_2Menu_8Exit(void)
{}

/*----三级菜单----保养通知设定----系列子菜单*/
/*更换机油机油滤清器*/
void Level3_3Menu_1Enter(void)
{
    //if (User_App.User_FDJYLQQ == 0u)
    //{
    //    User_set_Num.User_FDJYLQQ = 0u;
    //}
    //else
    //{
    //    User_set_Num.User_FDJYLQQ = (uint32_t)K_Line_Set.K_Line_LID4F * 1000u;
    //}
}
void Level3_3Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenuSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu_3_1_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_3Menu_1Exit(void)
{
    if (MenuFlag.Menu_Return == 1u)
    {
        User_App.User_FDJYLQQ = User_set_Num.User_FDJYLQQ ;

        MenuFlag.Menu_Return = 0u;

        if (User_set_Num.User_FDJYLQQ != 0u)
        {
            State_Flag.User_FDJYLQQ_FLAG = 0u;
            Data_Clear_Trip(EM_TRIP_JY);
        }
        else
        {
            State_Flag.User_FDJYLQQ_FLAG = 3u;
        }
    }
}

/*----三级菜单----保养通知设定----系列子菜单*/
/*更换燃油滤清器*/
void Level3_3Menu_2Enter(void)
{
    //if (User_App.User_RYLQQ == 0u)
    //{
    //    User_set_Num.User_RYLQQ = 0u;
    //}
    //else
    //{
    //    User_set_Num.User_RYLQQ = (uint32_t)K_Line_User_RYLQQ * 1000u;
    //}
}
void Level3_3Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenuSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu_3_2_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_3Menu_2Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_RYLQQ = User_set_Num.User_RYLQQ ;

        MenuFlag.Menu_Return = 0;

        if (User_set_Num.User_RYLQQ != 0)
        {
            State_Flag.User_RYLQQ_FLAG = 0;
            Data_Clear_Trip(EM_TRIP_RY);
        }
        else
        {
            State_Flag.User_RYLQQ_FLAG = 3;
        }
    }
}

/*----三级菜单----保养通知设定----系列子菜单*/
/*更换变速箱油*/
void Level3_3Menu_3Enter(void)
{
    //if (User_App.User_BSXY == 0u)
    //{
    //    User_set_Num.User_BSXY = 0u;
    //}
    //else
    //{
    //    User_set_Num.User_BSXY = (uint32_t)K_Line_Set.K_Line_LID4A * 1000;
    //}
}
void Level3_3Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenuSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu_3_3_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_3Menu_3Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_BSXY = User_set_Num.User_BSXY ;

        MenuFlag.Menu_Return = 0;

        if (User_set_Num.User_BSXY != 0)
        {
            State_Flag.User_BSXY_FLAG = 0;
            Data_Clear_Trip(EM_TRIP_BSX);
        }
        else
        {
            State_Flag.User_BSXY_FLAG = 3;
        }
    }
}

/*----三级菜单----保养通知设定----系列子菜单*/
/*更换差速器油*/
void Level3_3Menu_4Enter(void)
{
    //if (User_App.User_CSQY == 0u)
    //{
    //    User_set_Num.User_CSQY = 0u;
    //}
    //else
    //{
    //    User_set_Num.User_CSQY = (uint32_t)K_Line_Set.K_Line_LID4B * 1000;
    //}
}
void Level3_3Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenuSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu_3_4_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_3Menu_4Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_CSQY = User_set_Num.User_CSQY ;

        MenuFlag.Menu_Return = 0;

        if (User_set_Num.User_CSQY != 0)
        {
            State_Flag.User_CSQY_FLAG = 0;
            Data_Clear_Trip(EM_TRIP_CSQ);
        }
        else
        {
            State_Flag.User_CSQY_FLAG = 3;
        }
    }
}

/*----三级菜单----保养通知设定----系列子菜单*/
/*更换离合器油*/
//void Level3_3Menu_5Enter(void)
//{}
//void Level3_3Menu_5Do(void)
//{
//    GUI_OftenShow_Display();
//    GUI_BG_RepMenuSet_Menu_Display(GUI_DISP_MODE_NORMAL);
//    GUI_BG_RepSetMenu_3_5_Display(GUI_DISP_MODE_NORMAL);
//}
//void Level3_3Menu_5Exit(void)
//{}

/*----三级菜单----保养通知设定----系列子菜单*/
/*更换动力转向液*/
void Level3_3Menu_6Enter(void)
{
    //if (User_App.User_DLZXY == 0u)
    //{
    //    User_set_Num.User_DLZXY = 0u;
    //}
    //else
    //{
    //    User_set_Num.User_DLZXY = (uint32_t)K_Line_Set.K_Line_LID4D * 1000;
    //}
}
void Level3_3Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenuSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu_3_6_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_3Menu_6Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_DLZXY = User_set_Num.User_DLZXY ;

        MenuFlag.Menu_Return = 0;

        if (User_set_Num.User_DLZXY != 0)
        {
            State_Flag.User_DLZXY_FLAG = 0;
            Data_Clear_Trip(EM_TRIP_DLZX);
        }
        else
        {
            State_Flag.User_DLZXY_FLAG = 3;
        }
    }
}

/*----三级菜单----保养通知设定----系列子菜单*/
/*更换轮胎*/
void Level3_3Menu_7Enter(void)
{
    //if (User_App.User_LT == 0u)
    //{
    //    User_set_Num.User_LT = 0u;
    //}
    //else
    //{
    //    User_set_Num.User_LT = (uint32_t)K_Line_Set.K_Line_LID4E * 1000;
    //}
}
void Level3_3Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_RepMenuSet_Menu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_RepSetMenu_3_7_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_3Menu_7Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_LT = User_set_Num.User_LT ;

        MenuFlag.Menu_Return = 0;

        if (User_set_Num.User_LT != 0)
        {
            State_Flag.User_LT_FLAG = 0;
            Data_Clear_Trip(EM_TRIP_LT);
        }
        else
        {
            State_Flag.User_LT_FLAG = 3;
        }
    }
}

/*----三级菜单----用户设定----系列子选项*/
/*日期设定 ----- 年*/
void Level3_4Menu_1Enter_1(void)
{
    User_set_Num.Year  = Get_RTC_YEAR();
    User_set_Num.Month = Get_RTC_MONTH();
    User_set_Num.Date  = Get_RTC_DATE();
}
void Level3_4Menu_1Do_1(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_Date_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_1Exit_1(void)
{}

/*----三级菜单----用户设定----系列子选项*/
/*日期设定 ---- 月*/
void Level3_4Menu_1Enter_2(void)
{}
void Level3_4Menu_1Do_2(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_Date_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_1Exit_2(void)
{}

/*----三级菜单----用户设定----系列子选项*/
/*日期设定 ---- 日*/
void Level3_4Menu_1Enter_3(void)
{}
void Level3_4Menu_1Do_3(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_Date_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_1Exit_3(void)
{
    if (MenuFlag.Menu_Return)
    {
        RTE_RTC_Set_Year (User_set_Num.Year + 2000u);
        RTE_RTC_Set_Month(User_set_Num.Month);
        RTE_RTC_Set_Date (User_set_Num.Date);

        RTE_RTC_Set_Hour(Get_RTC_HOUR());
        RTE_RTC_Set_Minute(Get_RTC_MINUTE());

        MenuFlag.Menu_Return = 0;

        RTE_RTC_Confirm_Overwrite();
    }
}

/*----三级菜单----用户设定----系列子选项*/
/*时间设定 ---- 时*/
void Level3_4Menu_2Enter_1(void)
{
    User_set_Num.Hour = Get_RTC_HOUR();
    User_set_Num.Minute = Get_RTC_MINUTE();
}
void Level3_4Menu_2Do_1(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_Time_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_2Exit_1(void)
{}

/*----三级菜单----用户设定----系列子选项*/
/*时间设定 ---- 分*/
void Level3_4Menu_2Enter_2(void)
{}
void Level3_4Menu_2Do_2(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_Time_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_2Exit_2(void)
{
    if (MenuFlag.Menu_Return)
    {
        RTE_RTC_Set_Year ( Get_RTC_YEAR() + 2000u );
        RTE_RTC_Set_Month( Get_RTC_MONTH() );
        RTE_RTC_Set_Date ( Get_RTC_DATE() );

        RTE_RTC_Set_Hour(User_set_Num.Hour);
        RTE_RTC_Set_Minute(User_set_Num.Minute);

        MenuFlag.Menu_Return = 0;

        RTE_RTC_Confirm_Overwrite();
    }
}

/*----三级菜单----用户设定----系列子选项*/
/*语言设定*/
void Level3_4Menu_3Enter(void)
{
    User_set_Num.User_Language   = User_App.User_Language;
}
void Level3_4Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_Language_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_3Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_Language    =  User_set_Num.User_Language  ;
        MenuFlag.Menu_Return = 0;
    }
}

/*----三级菜单----省油建议----系列子菜单*/
/*速度设定-高速路*/
void Level3_4Menu_4Enter_1(void)
{}
void Level3_4Menu_4Do_1(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_SYSD_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_1_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_4Exit_1(void)
{}

/*----三级菜单----省油建议----系列子菜单*/
/*速度设定-一般路*/
void Level3_4Menu_4Enter_2(void)
{}
void Level3_4Menu_4Do_2(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_SYSD_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_2_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_4Exit_2(void)
{}

/*----三级菜单----省油建议----系列子菜单*/
/*发送机转速设定*/
void Level3_4Menu_4Enter_3(void)
{}
void Level3_4Menu_4Do_3(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_SYSD_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_3_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_4Exit_3(void)
{}

/*----三级菜单----省油建议----系列子菜单*/
/*急加速设定*/
void Level3_4Menu_4Enter_4(void)
{}
void Level3_4Menu_4Do_4(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_SYSD_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_4_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_4Exit_4(void)
{}

/*----三级菜单----省油建议----系列子菜单*/
/*急减速设定*/
void Level3_4Menu_4Enter_5(void)
{}
void Level3_4Menu_4Do_5(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_SYSD_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_5_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_4Exit_5(void)
{}

/*----三级菜单----省油建议----系列子菜单*/
/*长时间怠速设定*/
void Level3_4Menu_4Enter_6(void)
{}
void Level3_4Menu_4Do_6(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_SYSD_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_6_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_4Exit_6(void)
{}

/*----三级菜单----省油建议----系列子菜单*/
/*辅助驻车解除设定*/
void Level3_4Menu_4Enter_7(void)
{}
void Level3_4Menu_4Do_7(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_SYSD_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_7_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_4Exit_7(void)
{}

/*----三级菜单----TPMS轮胎设定----系列子菜单*/
/*TPMS  轮胎设定*/
void Level3_4Menu_5Enter(void)
{
    User_set_Num.User_Tpms = 0 ;             /*当前是哪个轮子*/
    User_set_Num.User_TpmsStatus = 0 ;       /*当前胎压匹配界面状态*/
    User_set_Num.User_Temp_Return = 0 ;      /*取消胎压匹配*/
}
void Level3_4Menu_5Do(void)
{
    GUI_BG_TPMS_PictureSet_Display(GUI_DISP_MODE_NORMAL);

    /*匹配完成，调整配置界面*/
    if (User_set_Num.User_Tpms == 0x0du)
    {
        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
    }
}
void Level3_4Menu_5Exit(void)
{}

/*----三级菜单----TPMS轮胎设定----系列子菜单*/
/*亮度调节设定*/
void Level3_4Menu_7Enter_1(void)
{}
void Level3_4Menu_7Do_1(void)
{
    GUI_OftenShow_Display();
    GUI_BG_User_Light1_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_7Exit_1(void)
{}

void Level3_4Menu_7Enter_2(void)
{}
void Level3_4Menu_7Do_2(void)
{
    GUI_OftenShow_Display();
    GUI_BG_User_Light2_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_4Menu_7Exit_2(void)
{}

/*----三级菜单----系统演示----系列子菜单*/
/*LDWS 警报演示*/
void Level3_5Menu_1Enter(void)
{}
void Level3_5Menu_1Do(void)
{
    GUI_OftenShow_Display(); /*1238*/
    Gui_ADAS_Test_Display(GUI_DISP_MODE_NORMAL);/*4*/
    GUI_AVG_FuelSpeed_Display(GUI_DISP_MODE_NORMAL);/*5*/
    Gui_DrivingSupport_Display(GUI_DISP_MODE_NORMAL);/*6*/
    Gui_Gear_Display(GUI_DISP_MODE_NORMAL);/*7*/
}
void Level3_5Menu_1Exit(void)
{}

/*----三级菜单----系统演示----系列子菜单*/
/*AEBS第1警报演示*/
void Level3_5Menu_2Enter(void)
{}
void Level3_5Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_AEBS_Test1_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_5Menu_2Exit(void)
{}

/*----三级菜单----系统演示----系列子菜单*/
/*AEBS第2警报演示*/
void Level3_5Menu_3Enter(void)
{}
void Level3_5Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_AEBS_Test2_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_5Menu_3Exit(void)
{}

/*----三级菜单----系统演示----系列子菜单*/
/*AEBS全力制动警报演示*/
void Level3_5Menu_4Enter(void)
{}
void Level3_5Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();
    GUI_AEBS_Test3_Display(GUI_DISP_MODE_NORMAL);
}
void Level3_5Menu_4Exit(void)
{}

/*----四级菜单----省油建议设定----系列子菜单*/
/*速度设定-高速路子菜单*/
void Level4_4Menu_1Enter(void)
{
    User_set_Num.User_Gsl = User_App.User_Gsl ;
}
void Level4_4Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_GSL_Display(GUI_DISP_MODE_NORMAL);
}
void Level4_4Menu_1Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_Gsl = User_set_Num.User_Gsl ;

        MenuFlag.Menu_Return = 0;
    }
}

/*----四级菜单----省油建议设定----系列子菜单*/
/*速度设定-一般路子菜单*/
void Level4_4Menu_2Enter(void)
{
    User_set_Num.User_Ybl = User_App.User_Ybl ;
}
void Level4_4Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_Ybl_Display(GUI_DISP_MODE_NORMAL);
}
void Level4_4Menu_2Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_Ybl = User_set_Num.User_Ybl ;

        MenuFlag.Menu_Return = 0;
    }
}

/*----四级菜单----省油建议设定----系列子菜单*/
/*发动机转速设定子菜单*/
void Level4_4Menu_3Enter(void)
{
    User_set_Num.User_Speed = User_App.User_Speed ;
}
void Level4_4Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_Speed_Display(GUI_DISP_MODE_NORMAL);
}
void Level4_4Menu_3Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_Speed = User_set_Num.User_Speed ;

        MenuFlag.Menu_Return = 0;
    }
}

/*----四级菜单----省油建议设定----系列子菜单*/
/*急加速设定子菜单*/
void Level4_4Menu_4Enter(void)
{
    User_set_Num.User_JADD = User_App.User_JADD ;
}
void Level4_4Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_JADD_Display(GUI_DISP_MODE_NORMAL);
}
void Level4_4Menu_4Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_JADD = User_set_Num.User_JADD ;

        MenuFlag.Menu_Return = 0;
    }
}

/*----四级菜单----省油建议设定----系列子菜单*/
/*急减速子菜单*/
void Level4_4Menu_5Enter(void)
{
    User_set_Num.User_JSUB = User_App.User_JSUB ;
}
void Level4_4Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_JSUB_Display(GUI_DISP_MODE_NORMAL);
}
void Level4_4Menu_5Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_JSUB = User_set_Num.User_JSUB ;
        MenuFlag.Menu_Return = 0;
    }
}

/*----四级菜单----省油建议设定----系列子菜单*/
/*长时间怠速设定子菜单*/
void Level4_4Menu_6Enter(void)
{
    User_set_Num.User_IDLING = User_App.User_IDLING ;
}
void Level4_4Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_IDLING_Display(GUI_DISP_MODE_NORMAL);
}
void Level4_4Menu_6Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_IDLING = User_set_Num.User_IDLING ;
        MenuFlag.Menu_Return = 0;
    }
}

/*----四级菜单----省油建议设定----系列子菜单*/
/*辅助驻车解除设定*/
void Level4_4Menu_7Enter(void)
{
    User_set_Num.User_Parking = User_App.User_Parking ;
}
void Level4_4Menu_7Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_UserSet_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_UserSet_SYSD_Parking_Display(GUI_DISP_MODE_NORMAL);
}
void Level4_4Menu_7Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        User_App.User_Parking = User_set_Num.User_Parking ;
        MenuFlag.Menu_Return = 0;
    }
}

/*----Enter----*/
void Level_Enter_Menu_Enter(void)
{}
void Level_Enter_Menu_Do(void)
{
    GUI_BG_Enter_Return_Display(GUI_DISP_MODE_NORMAL);
}
void Level_Enter_Menu_Exit(void)
{
    if (MenuFlag.Menu_Return)
    {
        State_Flag.ENTER_RETURN = 1;
        MenuFlag.Menu_Return = 0;
    }
}

/*----Return----*/
void Level_Return_Menu_Enter(void)
{}
void Level_Return_Menu_Do(void)
{
    GUI_BG_Enter_Return_Display(GUI_DISP_MODE_NORMAL);
    if (MenuFlag.Menu_Time_Flag < 30)
    {
        MenuFlag.Menu_Time_Flag++;
    }
    else
    {
        MenuFlag.Menu_Time_Flag = 0;
        MenuFlag.Menu_Return = 1;
        NextMenu(MenuFlag.Menu_Enter_Return);
    }
}
void Level_Return_Menu_Exit(void)
{
    State_Flag.ENTER_RETURN = 0;
}

/*OFF档运行时间显示*/
void LevelMenuOFF_Enter(void)
{}
void LevelMenuOFF_Do(void)
{
    GUI_OftenShowOFF_Display();
    GUI_Time_OilTemp_OFF_Display(GUI_DISP_MODE_NORMAL);
}
void LevelMenuOFF_Exit(void)
{}

/*自检*/
void LevelMenuTest_Enter(void)
{}
void LevelMenuTest_Do(void)
{
    GUI_OftenShowOFF_Display();
    GUI_Test_Display(GUI_DISP_MODE_NORMAL);
}
void LevelMenuTest_Exit(void)
{}

/*----工厂模式----*/
/*----工厂模式----MENU----*/
void LevelF0Menu_1Enter(void)
{}
void LevelF0Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_FacMenu_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF0Menu_1Exit(void)
{}

/*----工厂模式----DTC显示-----*/
void LevelF1Menu_1Enter(void)
{}
void LevelF1Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_FacMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1Menu_1Exit(void)
{}

/*----工厂模式----DTC清除-----*/
void LevelF1Menu_2Enter(void)
{}
void LevelF1Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_FacMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1Menu_2Exit(void)
{}

/*----工厂模式----仪表设定显示-----*/
void LevelF1Menu_3Enter(void)
{}
void LevelF1Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_FacMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1Menu_3Exit(void)
{}

/*----工厂模式----D暂时通常模式-----*/
void LevelF1Menu_4Enter(void)
{}
void LevelF1Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_FacMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1Menu_4Exit(void)
{}

/*----工厂模式----结束工厂模式-----*/
void LevelF1Menu_5Enter(void)
{}
void LevelF1Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_FacMenu5_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1Menu_5Exit(void)
{}

/*----工厂模式----HID自动水平初始化-----*/
void LevelF1Menu_6Enter(void)
{}
void LevelF1Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_FacMenu6_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1Menu_6Exit(void)
{}

/**/
/*----工厂模式----DTC显示----发动机故障*-----*/
void LevelF1_1Menu_1Enter(void)
{}
void LevelF1_1Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DTCEngine_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_1Menu_1Exit(void)
{}

/*----工厂模式----DTC显示----SCR系统故障*-----*/
void LevelF1_1Menu_2Enter(void)
{}
void LevelF1_1Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DTCSCR_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_1Menu_2Exit(void)
{}

/*----工厂模式----DTC显示----AMT故障*-----*/
void LevelF1_1Menu_3Enter(void)
{}
void LevelF1_1Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DTCAMT_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_1Menu_3Exit(void)
{}

/*----工厂模式----DTC显示----仪表故障*-----*/
void LevelF1_1Menu_4Enter(void)
{}
void LevelF1_1Menu_4Do(void)
{
    GUI_OftenShow_Display();
}
void LevelF1_1Menu_4Exit(void)
{}

/*----工厂模式----DTC清除1----所有DTC全部清除-----*/
void LevelF1_2Menu_1Enter(void)
{}
void LevelF1_2Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacDTCClear1_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_2Menu_1Exit(void)
{}

/*----工厂模式----DTC清除2----清除DTC全部-----*/
void LevelF1_2Menu_2Enter(void)
{}
void LevelF1_2Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacDTCClear2_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_2Menu_2Exit(void)
{}

/*----工厂模式----DTC清除3----清除DTC全部-----*/
void LevelF1_2Menu_3Enter(void)
{}
void LevelF1_2Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacDTCClear3_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_2Menu_3Exit(void)
{}

/*----工厂模式----DTC清除4----清除DTC全部-----*/
void LevelF1_2Menu_4Enter(void)
{}
void LevelF1_2Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacDTCClear4_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_2Menu_4Exit(void)
{}

/*----工厂模式----仪表设定显示----L0-7 H2-A-----*/
void LevelF1_3Menu_1Enter(void)
{}
void LevelF1_3Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMeter_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_3Menu_1Exit(void)
{}

/*----工厂模式----仪表设定显示----L8-F H2-A-----*/
void LevelF1_3Menu_2Enter(void)
{}
void LevelF1_3Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMeter_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF1_3Menu_2Exit(void)
{}

/*----工厂模式----是否结束工厂模式-----*/
void LevelF2_5Menu_1Enter(void)
{}
void LevelF2_5Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_FacMeterExit_Display(GUI_DISP_MODE_NORMAL);
}
void LevelF2_5Menu_1Exit(void)
{}

/*----经销商模式----*/
/*----经销商模式----MENU----*/
void LevelD0Menu_1Enter(void)
{}
void LevelD0Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_DeaMenu_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD0Menu_1Exit(void)
{}

/*----经销商模式----DTC显示----*/
void LevelD1Menu_1Enter(void)
{}
void LevelD1Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DeaMenu1_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1Menu_1Exit(void)
{}

/*----经销商模式----DTC清除----*/
void LevelD1Menu_2Enter(void)
{}
void LevelD1Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DeaMenu2_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1Menu_2Exit(void)
{}

/*----经销商模式----仪表设定显示----*/
void LevelD1Menu_3Enter(void)
{}
void LevelD1Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DeaMenu3_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1Menu_3Exit(void)
{}

/*----经销商模式----一般，通常模式显示----*/
void LevelD1Menu_4Enter(void)
{}
void LevelD1Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DeaMenu4_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1Menu_4Exit(void)
{}

/*----经销商模式----经销商模式结束----*/
void LevelD1Menu_5Enter(void)
{}
void LevelD1Menu_5Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DeaMenu5_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1Menu_5Exit(void)
{}

/*----经销商模式----HID自动水平初始化----*/
void LevelD1Menu_6Enter(void)
{}
void LevelD1Menu_6Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMenu_Display(GUI_DISP_MODE_NORMAL);
    GUI_BG_DeaMenu6_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1Menu_6Exit(void)
{}

/*----经销商模式----DTC显示----*/
void LevelD1_1Menu_1Enter(void)
{}
void LevelD1_1Menu_1Do(void)
{
    GUI_OftenShow_Display();
}
void LevelD1_1Menu_1Exit(void)
{}

/*----经销商模式----DTC清除1----*/
void LevelD1_2Menu_1Enter(void)
{}
void LevelD1_2Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaDTCClear1_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1_2Menu_1Exit(void)
{}

/*----经销商模式----DTC清除2----*/
void LevelD1_2Menu_2Enter(void)
{}
void LevelD1_2Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaDTCClear2_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1_2Menu_2Exit(void)
{}

/*----经销商模式----DTC清除3----*/
void LevelD1_2Menu_3Enter(void)
{}
void LevelD1_2Menu_3Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaDTCClear3_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1_2Menu_3Exit(void)
{}

/*----经销商模式----DTC清除4----*/
void LevelD1_2Menu_4Enter(void)
{}
void LevelD1_2Menu_4Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaDTCClear4_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1_2Menu_4Exit(void)
{}

/*----经销商模式----L0-7 H2-A----*/
void LevelD1_3Menu_1Enter(void)
{}
void LevelD1_3Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMeter_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1_3Menu_1Exit(void)
{}

/*----经销商模式----L8-F H2-A*/
void LevelD1_3Menu_2Enter(void)
{}
void LevelD1_3Menu_2Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMeter_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD1_3Menu_2Exit(void)
{}

/*----经销商模式----结束经销商模式----*/
void LevelD2_5Menu_1Enter(void)
{}
void LevelD2_5Menu_1Do(void)
{
    GUI_OftenShow_Display();
    GUI_BG_DeaMeterExit_Display(GUI_DISP_MODE_NORMAL);
}
void LevelD2_5Menu_1Exit(void)
{}