#include "Data_Gear.h"
#include "Flash_synchronizer.h"
#include "CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "images.h"
#include "CAN_Lib.h"

#include "GaugesInterface.h"


#include "Gauges.h"



/******************************************************************************
  Function：Data_Gear_KL30_Init
  Description：该服务函数首次KL30时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_Gear_KL30_Init(void)
{

}
/******************************************************************************
  Function：Data_Gear_KL15_Init
  Description：该服务函数首次KL15时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_Gear_KL15_Init(void)
{

}

/******************************************************************************
  Function：Data_Service_Gear_Processing
  Description：如果有特殊数据处理在此函数中进行处理
  Input:
  Output:
 ******************************************************************************/
void Data_Service_Gear_Processing(void)
{
    Gear_Processing_Service();
}
/******************************************************************************
  Function：Get_Gear_Mode_Type
  Description：Get Gear  P/R/N/D/M/S
  Input:
  Output: P/R/N/D/M/S
 ******************************************************************************/
uint8_t Get_Gear_Mode_Type(void)
{
}

/******************************************************************************
  Get_Gear_Mode_UPDOWN_Number
  Description：Get Gear  1/2/3/4/...
  Input:
  Output:   1/2/3/4/...
 ******************************************************************************/
uint8_t Get_Gear_Mode_UPDOWN_Number(void)
{
}
/******************************************************************************
  Function：Get_Gear_Mode_Up_Down
  Description：Get Gear  UP/DOWN
  Input:
  Output:   UP/DOWN
 ******************************************************************************/
uint8_t Get_Gear_Mode_Up_Down(void)
{

}
/******************************************************************************
  Function：Gear_Mode_Display
  Description：
  Input:
  Output:
 ******************************************************************************/
uint8_t  Get_Gear_Mode_Display_Flash(void)
{
    uint8_t Gear_Status = 0u;

    Gear_Status = FlashSync1Hz;
    return  (uint8_t)Gear_Status ;
}

uint8_t Get_Gear_Mode_M_A_Display(void)
{

}

uint8_t Get_Gear_Mode_P_E_Display(void)
{

}

uint8_t Get_Gear_Mode_L_C_Display(void)
{

}

//-------------------------------------------
//档位 数据处理
//-------------------------------------------
//区域7显示逻辑
//-------------------------------------------
//344 - 3.2.档位显示
//-------------------------------------------

static struct
{
    uint8_t Number ;//档位编号
    en_GEAR_Sta Manual ;//是否 M A N U A L
} GearVariable ;

/*-------------------------------------------------------------------------
 * Function Name  : Gear_KL30_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Gear_KL30_Init(void)
{
    GearVariable.Number = 0u;
    GearVariable.Manual = GEAR_MANUAL_OFF;
}
void Gear_KL15_ON_Init(void)
{
    GearVariable.Number = 0u;
    GearVariable.Manual = GEAR_MANUAL_OFF;
}
void Gear_KL15_OFF_Init(void)
{
    GearVariable.Number = 0u;
    GearVariable.Manual = GEAR_MANUAL_OFF;
}
void Gear_Wakeup_Init(void)
{
    GearVariable.Number = 0u;
    GearVariable.Manual = GEAR_MANUAL_OFF;
}
void Gear_Sleep_Init(void)
{
    GearVariable.Number = 0u;
    GearVariable.Manual = GEAR_MANUAL_OFF;
}
/*-------------------------------------------------------------------------
 * Function Name  : Gear_Processing_Service
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Gear_Processing_Service(void)
{
    uint8_t can1_4_1_8 = 0 ; //***************************************** 接收报文的变量
    uint8_t can2_1_5_2 = 0 ; //***************************************** 接收报文的变量
    uint8_t can3_3_7_2 = 0 ; //***************************************** 接收报文的变量
    uint8_t can4_5_1_8 = 0 ; //***************************************** 接收报文的变量
    uint8_t can5_1_7_2 = 0 ; //***************************************** 接收报文的变量

    uint8_t u8Number = 0 ; //************************************** 档位 编号
    en_GEAR_Sta u8Manual = GEAR_MANUAL_OFF ; //******************** 是否MANUAL

    can1_4_1_8 = Get_ID_18F00503_Sig_Current_Gear(); //can1_4_1_8含义是: byte 4     bit 1    length 8
    can2_1_5_2 = Get_ID_18FF8503_Sig_Manouvering_mode();
    can3_3_7_2 = Get_ID_18FE4A03_Sig_TransmissionSiftMode1_Indicator();
    can4_5_1_8 = Get_ID_18F00503_Sig_ID18F00503_byte5();
    can5_1_7_2 = Get_ID_18FF8503_Sig_Automatic_or_Manual_Mode();

    if (/*Get_CanFirstRecv_Event(ID_CanMsg18F00503_Msg_Count) == 0*/  0u)
    {
        u8Number = 0u;
        u8Manual = GEAR_MANUAL_OFF;
    }
    else if (CAN_MSG_Status(ID_CanMsg18F00503_Msg_Count) == CAN_SIG_LOST)
    {
        u8Number = 20u;
        u8Manual = GEAR_MANUAL_OFF;
    }
    else
    {
        if ((can1_4_1_8 == 0x7E) && (can2_1_5_2 != 0x01)) //档位1
        {
            u8Number = 1u;
        }
        else if (can1_4_1_8 == 0x7F) //档位2
        {
            u8Number = 2u;
        }
        else if (can1_4_1_8 == 0x80) //档位3
        {
            u8Number = 3u;
        }
        else if (can1_4_1_8 == 0x81) //档位4
        {
            u8Number = 4u;
        }
        else if (can1_4_1_8 == 0x82) //档位5
        {
            u8Number = 5u;
        }
        else if (can1_4_1_8 == 0x83) //档位6
        {
            u8Number = 6u;
        }
        else if (can1_4_1_8 == 0x84) //档位7
        {
            u8Number = 7u;
        }
        else if (can1_4_1_8 == 0x85) //档位8
        {
            u8Number = 8u;
        }
        else if (can1_4_1_8 == 0x86) //档位9
        {
            u8Number = 9u;
        }
        else if (can1_4_1_8 == 0x87) //档位10
        {
            u8Number = 10u;
        }
        else if (can1_4_1_8 == 0x88) //档位11
        {
            u8Number = 11u;
        }
        else if (can1_4_1_8 == 0x89) //档位12
        {
            u8Number = 12u;
        }
        else if (can1_4_1_8 == 0x7B) //档位R2
        {
            u8Number = 13u;
        }

        else if ((can1_4_1_8 == 0x7C) && (can2_1_5_2 != 0x01)) //档位R1
        {
            u8Number = 14u;
        }

        else if ((can1_4_1_8 == 0x7D) && (can3_3_7_2 != 0x01)) //档位N
        {
            u8Number = 15u;
        }
        else if ((can1_4_1_8 == 0x7C) && (can2_1_5_2 == 0x01)) //档位RM
        {
            u8Number = 16u;
        }
        else if ((can1_4_1_8 == 0x7E) && (can2_1_5_2 == 0x01)) //档位DM
        {
            u8Number = 17u;
        }
        else if ((can1_4_1_8 == 0x7D) && (can3_3_7_2 == 0x01)) //档位E
        {
            u8Number = 18u;
        }
        else if ((can4_5_1_8 == 0x7D) && (can3_3_7_2 == 0x01)) //档位NE
        {
            u8Number = 19u;
        }
        else//档位——
        {
            u8Number = 20u;
        }


        if (CAN_MSG_Status(ID_CanMsg18FF8503_Msg_Count) == CAN_SIG_LOST)
        {
            u8Manual = GEAR_MANUAL_OFF;
        }
        else if (can5_1_7_2 == 0x00)
        {
            u8Manual = GEAR_MANUAL_ON;
        }
        else
        {
            u8Manual = GEAR_MANUAL_OFF;
        }
    }

    GearVariable.Number = u8Number ;
    GearVariable.Manual = u8Manual ;
}

/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_Gear
 * Description    : 返回当前 档位
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Gui_Get_Gear(void)
{
    uint8_t u8Result = 0u;
    u8Result = GearVariable.Number;
    return u8Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_Gear_MANUAL
 * Description    : 返回当前档位栏MANUAL标志是否点亮
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
en_GEAR_Sta Gui_Get_Gear_MANUAL(void)
{
    en_GEAR_Sta u8Result = GEAR_MANUAL_OFF;
    u8Result = GearVariable.Manual;
    return u8Result;
}


