#ifndef MEMU_H__
#define MEMU_H__

#include "TYW_stdint.h"

#ifdef GLOBALS_MEU_PROCESS
#define EXTERN_MEU_PROCESS
#else
#define EXTERN_MEU_PROCESS extern
#endif

#define K_Line_User_RYLQQ 44
#define K_Line_User_KQGZJ 100

#define _MN_IDX_NULL 0xff
#define _MN_IDX_NULL0 0x00
#define _MN_OPR_NULL (void *)0

typedef enum
{
    /*主界面*/
    _MN_DSP_LEVEL1MENU_1 = 0, /* 00 平均车速，平均油耗*/
    _MN_DSP_LEVEL1MENU_2,     /* 01 电池电量*/
    _MN_DSP_LEVEL1MENU_3,     /* 02 DPD*/
    _MN_DSP_LEVEL1MENU_4,     /* 03 油温-转速时间*/
    _MN_DSP_LEVEL1MENU_5,     /* 04 日历*/
    _MN_DSP_LEVEL1MENU_6,     /* 05 空白*/
    _MN_DSP_LEVEPOPUP,        /* 06 报警界面显示*/

    /*一级菜单*/
    _MN_DSP_LEVEL2MENU_1, /* 07 故障码*/
    _MN_DSP_LEVEL2MENU_2, /* 08 保养通知*/
    _MN_DSP_LEVEL2MENU_3, /* 09 保养通知设定*/
    _MN_DSP_LEVEL2MENU_4, /* 10 用户设定*/
    _MN_DSP_LEVEL2MENU_5, /* 11 系统演示模式*/
    _MN_DSP_LEVEL2MENU_6, /* 12 轮胎状态显示*/

    /*二级菜单*/
    _MN_DSP_LEVEL2_1_MENU_1, /* 13 发动机*/
    _MN_DSP_LEVEL2_1_MENU_2, /* 14 刹车EBS*/
    _MN_DSP_LEVEL2_1_MENU_3, /* 15 变速箱AMT*/
    _MN_DSP_LEVEL2_1_MENU_4, /* 16 雷达*/
    _MN_DSP_LEVEL2_1_MENU_5, /* 17 摄像头*/
    _MN_DSP_LEVEL2_1_MENU_6, /* 18 液缓*/

    _MN_DSP_LEVEL2_2_MENU_1, /* 19 发动机机油&滤清器*/
    _MN_DSP_LEVEL2_2_MENU_2, /* 20 燃油滤清器*/
    _MN_DSP_LEVEL2_2_MENU_3, /* 21 变速箱油*/
    _MN_DSP_LEVEL2_2_MENU_4, /* 22 差速器油*/
    _MN_DSP_LEVEL2_2_MENU_7, /* 23 动力转向液*/
    _MN_DSP_LEVEL2_2_MENU_8, /* 24 轮胎*/

    _MN_DSP_LEVEL2_3_MENU_1, /* 25 更换机油＆机油滤清器*/
    _MN_DSP_LEVEL2_3_MENU_2, /* 26 更换燃油滤清器*/
    _MN_DSP_LEVEL2_3_MENU_3, /* 27 更换变速箱油*/
    _MN_DSP_LEVEL2_3_MENU_4, /* 28 更换差速器油*/
    _MN_DSP_LEVEL2_3_MENU_6, /* 29 更换动力转向液*/
    _MN_DSP_LEVEL2_3_MENU_7, /* 30 轮胎换位・更换*/

    _MN_DSP_LEVEL2_4_MENU_1, /* 31 设定日期*/
    _MN_DSP_LEVEL2_4_MENU_2, /* 32 设定时间*/
    _MN_DSP_LEVEL2_4_MENU_7, /* 33 亮度调节*/
    _MN_DSP_LEVEL2_4_MENU_3, /* 34 语言设定*/
    _MN_DSP_LEVEL2_4_MENU_4, /* 35 设定节油驾驶建议*/
    _MN_DSP_LEVEL2_4_MENU_5, /* 36 TPMS轮胎设定*/
    _MN_DSP_LEVEL2_4_MENU_6, /* 37 显示设定*/

    _MN_DSP_LEVEL2_6_MENU_1, /* 38 轮胎气压*/
    _MN_DSP_LEVEL2_6_MENU_2, /* 39 轮胎温度*/

    _MN_DSP_LEVEL2_5_MENU_1, /* 40 LDWS 警报演示*/
    _MN_DSP_LEVEL2_5_MENU_2, /* 41 AEBS第1警报演示*/
    _MN_DSP_LEVEL2_5_MENU_3, /* 42 AEBS第2警报演示*/
    _MN_DSP_LEVEL2_5_MENU_4, /* 43 AEBS全力制动警报演示*/

    /*三级菜单*/
    _MN_DSP_LEVEL3_1_MENU_1, /* 44 发动机*/
    _MN_DSP_LEVEL3_1_MENU_2, /* 45 刹车EBS*/
    _MN_DSP_LEVEL3_1_MENU_3, /* 46 变速箱AMT*/
    _MN_DSP_LEVEL3_1_MENU_4, /* 47 雷达*/
    _MN_DSP_LEVEL3_1_MENU_5, /* 48 摄像头*/
    _MN_DSP_LEVEL3_1_MENU_6, /* 49 液缓*/

    _MN_DSP_LEVEL3_2_MENU_1, /* 50 发动机机油＆滤清器*/
    _MN_DSP_LEVEL3_2_MENU_2, /* 51 燃油滤清器*/
    _MN_DSP_LEVEL3_2_MENU_3, /* 52 变速箱油*/
    _MN_DSP_LEVEL3_2_MENU_4, /* 53 差速器油*/
    _MN_DSP_LEVEL3_2_MENU_7, /* 54 动力转向液*/
    _MN_DSP_LEVEL3_2_MENU_8, /* 55 轮胎*/

    _MN_DSP_LEVEL3_3_MENU_1, /* 56 更换机油＆机油滤清器*/
    _MN_DSP_LEVEL3_3_MENU_2, /* 57 更换燃油滤清器*/
    _MN_DSP_LEVEL3_3_MENU_3, /* 58 更换变速箱油*/
    _MN_DSP_LEVEL3_3_MENU_4, /* 59 更换差速器油*/
    _MN_DSP_LEVEL3_3_MENU_6, /* 60 更换动力转向液*/
    _MN_DSP_LEVEL3_3_MENU_7, /* 61 轮胎换位・更换*/

    _MN_DSP_LEVEL3_4_MENU_11, /* 62 设定日期-年*/
    _MN_DSP_LEVEL3_4_MENU_12, /* 63 设定日期-月*/
    _MN_DSP_LEVEL3_4_MENU_13, /* 64 设定日期-日*/
    _MN_DSP_LEVEL3_4_MENU_21, /* 65 设定时间-时*/
    _MN_DSP_LEVEL3_4_MENU_22, /* 66 设定时间-分*/
    _MN_DSP_LEVEL3_4_MENU_3,  /* 67 设定语言*/
    _MN_DSP_LEVEL3_4_MENU_41, /* 68 速度设定－高速路*/
    _MN_DSP_LEVEL3_4_MENU_42, /* 69 速度设定－一般路*/
    _MN_DSP_LEVEL3_4_MENU_43, /* 70 发动机转速设定*/
    _MN_DSP_LEVEL3_4_MENU_44, /* 71 急加速设定*/
    _MN_DSP_LEVEL3_4_MENU_45, /* 72 急减速设定*/
    _MN_DSP_LEVEL3_4_MENU_46, /* 73 长时间怠速设定*/
    _MN_DSP_LEVEL3_4_MENU_47, /* 74 辅助驻车解除设定*/
    _MN_DSP_LEVEL3_4_MENU_5,  /* 75 轮胎匹配画面*/
    _MN_DSP_LEVEL3_7_MENU_1,  /* 76 亮度调节*/
    _MN_DSP_LEVEL3_7_MENU_2,  /* 77 亮度调节*/

    /*四级菜单*/
    _MN_DSP_LEVEL4_4_MENU_1, /* 78 速度设定-高速路*/
    _MN_DSP_LEVEL4_4_MENU_2, /* 79 速度设定-一般路*/
    _MN_DSP_LEVEL4_4_MENU_3, /* 80 发动机转速设定*/
    _MN_DSP_LEVEL4_4_MENU_4, /* 81 急加速设定*/
    _MN_DSP_LEVEL4_4_MENU_5, /* 82 急减速设定*/
    _MN_DSP_LEVEL4_4_MENU_6, /* 83 长时间怠速设定*/
    _MN_DSP_LEVEL4_4_MENU_7, /* 84 辅助驻车解除设定*/

    /*特殊界面*/
    _MN_DSP_ENTER_MENU,  /* 85 确认*/
    _MN_DSP_RETURN_MENU, /* 86 返回*/

    _MN_DSP_LEVEL3_5_MENU_1, /* 87 LDWS 警报演示*/
    _MN_DSP_LEVEL3_5_MENU_2, /* 88 AEBS第1警报演示*/
    _MN_DSP_LEVEL3_5_MENU_3, /* 89 AEBS第2警报演示*/
    _MN_DSP_LEVEL3_5_MENU_4, /* 90 AEBS全力制动警报演示*/

    _MN_DSP_Menu_OFF,  /* 91 */
    _MN_DSP_Menu_Test, /* 92 */

    /*工厂模式*/
    _FAC_DSP_LEVEL0MENU_1, /* 93 */

    _FAC_DSP_LEVEL1MENU_1, /* 94 DTC显示*/
    _FAC_DSP_LEVEL1MENU_2, /* 95 DTC清除*/
    _FAC_DSP_LEVEL1MENU_3, /* 96 仪表设定显示*/
    _FAC_DSP_LEVEL1MENU_4, /* 97 暂时通常模式*/
    _FAC_DSP_LEVEL1MENU_5, /* 98 结束工厂模式*/
    _FAC_DSP_LEVEL1MENU_6, /* 99 HID自动水平初始化*/

    _FAC_DSP_LEVEL1_1MENU_1, /* 100 发动机*/
    _FAC_DSP_LEVEL1_1MENU_2, /* 101 刹车EBS */
    _FAC_DSP_LEVEL1_1MENU_3, /* 102 变速箱AMT */
    _FAC_DSP_LEVEL1_1MENU_4, /* 103 雷达 */
    _FAC_DSP_LEVEL1_1MENU_5, /* 104 摄像头 */
    _FAC_DSP_LEVEL1_1MENU_6, /* 105 液缓 */

    _FAC_DSP_LEVEL1_2MENU_1, /* 106 发动机*/
    _FAC_DSP_LEVEL1_2MENU_2, /* 107 刹车EBS */
    _FAC_DSP_LEVEL1_2MENU_3, /* 108 变速箱AMT */
    _FAC_DSP_LEVEL1_2MENU_4, /* 109 雷达 */
    _FAC_DSP_LEVEL1_2MENU_5, /* 110 摄像头 */
    _FAC_DSP_LEVEL1_2MENU_6, /* 111 液缓 */

    //_FAC_DSP_LEVEL1_2MENU_1, /* 1 清除所有DTC*/
    //_FAC_DSP_LEVEL1_2MENU_2, /* 1 清除所有DTC*/
    //_FAC_DSP_LEVEL1_2MENU_3, /* 1 清除所有DTC*/
    //_FAC_DSP_LEVEL1_2MENU_4, /* 1 清除所有DTC*/
    _FAC_DSP_LEVEL1_3MENU_1, /* 112 L0-7 H2-A*/
    _FAC_DSP_LEVEL1_3MENU_2, /* 113 L8-F H2-A*/
    _FAC_DSP_LEVEL1_6MENU_1, /* 114 HID自动标准初始化*/
    _FAC_DSP_LEVEL1_6MENU_2, /* 115 HID自动标准初始化*/

    _FAC_DSP_LEVEL2_1MENU_1, /* 116 发动机*/
    _FAC_DSP_LEVEL2_1MENU_2, /* 117 刹车EBS*/
    _FAC_DSP_LEVEL2_1MENU_3, /* 118 变速箱AMT*/
    _FAC_DSP_LEVEL2_1MENU_4, /* 119 雷达*/
    _FAC_DSP_LEVEL2_1MENU_5, /* 120 摄像头*/
    _FAC_DSP_LEVEL2_1MENU_6, /* 121 液缓*/

    _FAC_DSP_LEVEL2_2MENU_1, /* 122 是否清除白发动机*/
    _FAC_DSP_LEVEL2_2MENU_2, /* 123 是否清除白刹车EBS*/
    _FAC_DSP_LEVEL2_2MENU_3, /* 124 是否清除白变速箱AMT*/
    _FAC_DSP_LEVEL2_2MENU_4, /* 125 是否清除白雷达*/
    _FAC_DSP_LEVEL2_2MENU_5, /* 126 是否清除白摄像头*/
    _FAC_DSP_LEVEL2_2MENU_6, /* 127 是否清除白液缓*/

    _FAC_DSP_LEVEL3_2MENU_1, /* 128 是灰发动机*/
    _FAC_DSP_LEVEL3_2MENU_2, /* 129 是灰刹车EBS*/
    _FAC_DSP_LEVEL3_2MENU_3, /* 130 是灰变速箱AMT*/
    _FAC_DSP_LEVEL3_2MENU_4, /* 131 是灰雷达*/
    _FAC_DSP_LEVEL3_2MENU_5, /* 132 是灰摄像头*/
    _FAC_DSP_LEVEL3_2MENU_6, /* 133 是灰液缓*/

    _FAC_DSP_LEVEL4_2MENU_1, /* 134 已清除灰发动机*/
    _FAC_DSP_LEVEL4_2MENU_2, /* 135 已清除灰刹车EBS*/
    _FAC_DSP_LEVEL4_2MENU_3, /* 136 已清除灰变速箱AMT*/
    _FAC_DSP_LEVEL4_2MENU_4, /* 137 已清除灰雷达*/
    _FAC_DSP_LEVEL4_2MENU_5, /* 138 已清除灰摄像头*/
    _FAC_DSP_LEVEL4_2MENU_6, /* 139 已清除灰液缓*/

    _FAC_DSP_LEVEL2_5MENU_1, /* 140 是否结束工厂模式*/

    /*经销商模式*/
    _DEA_DSP_LEVEL0MENU_1,  /* 135 */

    _DEA_DSP_LEVEL1MENU_1, /* 136 DTC显示*/
    _DEA_DSP_LEVEL1MENU_2, /* 137 DTC清除*/
    _DEA_DSP_LEVEL1MENU_3, /* 138 仪表设定显示*/
    _DEA_DSP_LEVEL1MENU_4, /* 139 暂时通常模式*/
    _DEA_DSP_LEVEL1MENU_5, /* 140 结束经销商模式*/
    _DEA_DSP_LEVEL1MENU_6, /* 141 HID自动水平初始化*/

    _DEA_DSP_LEVEL1_1MENU_1, /* 142 发动机*/
    _DEA_DSP_LEVEL1_1MENU_2, /* 143 刹车EBS */
    _DEA_DSP_LEVEL1_1MENU_3, /* 144 变速箱AMT */
    _DEA_DSP_LEVEL1_1MENU_4, /* 145 雷达 */
    _DEA_DSP_LEVEL1_1MENU_5, /* 146 摄像头 */
    _DEA_DSP_LEVEL1_1MENU_6, /* 147 液缓 */

    _DEA_DSP_LEVEL1_2MENU_1, /* 148 发动机*/
    _DEA_DSP_LEVEL1_2MENU_2, /* 149 刹车EBS */
    _DEA_DSP_LEVEL1_2MENU_3, /* 150 变速箱AMT */
    _DEA_DSP_LEVEL1_2MENU_4, /* 151 雷达 */
    _DEA_DSP_LEVEL1_2MENU_5, /* 152 摄像头 */
    _DEA_DSP_LEVEL1_2MENU_6, /* 153 液缓 */

    //_DEA_DSP_LEVEL1_2MENU_1, /* 1 清除所有DTC*/
    //_DEA_DSP_LEVEL1_2MENU_2, /* 1 清除所有DTC*/
    //_DEA_DSP_LEVEL1_2MENU_3, /* 1 清除所有DTC*/
    //_DEA_DSP_LEVEL1_2MENU_4, /* 1 清除所有DTC*/
    _DEA_DSP_LEVEL1_3MENU_1, /* 154 L0-7 H2-A*/
    _DEA_DSP_LEVEL1_3MENU_2, /* 155 L8-F H2-A*/
    _DEA_DSP_LEVEL1_6MENU_1, /* 156 HID自动标准初始化*/
    _DEA_DSP_LEVEL1_6MENU_2, /* 157 HID自动标准初始化*/

    _DEA_DSP_LEVEL2_1MENU_1, /* 158 发动机*/
    _DEA_DSP_LEVEL2_1MENU_2, /* 159 刹车EBS*/
    _DEA_DSP_LEVEL2_1MENU_3, /* 160 变速箱AMT*/
    _DEA_DSP_LEVEL2_1MENU_4, /* 161 雷达*/
    _DEA_DSP_LEVEL2_1MENU_5, /* 162 摄像头*/
    _DEA_DSP_LEVEL2_1MENU_6, /* 163 液缓*/

    _DEA_DSP_LEVEL2_2MENU_1, /* 164 是否白发动机*/
    _DEA_DSP_LEVEL2_2MENU_2, /* 165 是否白刹车EBS*/
    _DEA_DSP_LEVEL2_2MENU_3, /* 166 是否白变速箱AMT*/
    _DEA_DSP_LEVEL2_2MENU_4, /* 167 是否白雷达*/
    _DEA_DSP_LEVEL2_2MENU_5, /* 168 是否白摄像头*/
    _DEA_DSP_LEVEL2_2MENU_6, /* 169 是否白液缓*/

    _DEA_DSP_LEVEL3_2MENU_1, /* 170 是灰发动机*/
    _DEA_DSP_LEVEL3_2MENU_2, /* 171 是灰刹车EBS*/
    _DEA_DSP_LEVEL3_2MENU_3, /* 172 是灰变速箱AMT*/
    _DEA_DSP_LEVEL3_2MENU_4, /* 173 是灰雷达*/
    _DEA_DSP_LEVEL3_2MENU_5, /* 174 是灰摄像头*/
    _DEA_DSP_LEVEL3_2MENU_6, /* 175 是灰液缓*/

    _DEA_DSP_LEVEL4_2MENU_1, /* 176 已清除发动机*/
    _DEA_DSP_LEVEL4_2MENU_2, /* 177 已清除刹车EBS*/
    _DEA_DSP_LEVEL4_2MENU_3, /* 178 已清除变速箱AMT*/
    _DEA_DSP_LEVEL4_2MENU_4, /* 179 已清除雷达*/
    _DEA_DSP_LEVEL4_2MENU_5, /* 180 已清除摄像头*/
    _DEA_DSP_LEVEL4_2MENU_6, /* 181 已清除液缓*/

    _DEA_DSP_LEVEL2_5MENU_1, /* 182 是否结束经销商模式*/

    _MN_DSP_MENU_MAX,

} _MenuCode;

typedef uint8_t _MENU_IDX;
typedef struct
{
    _MENU_IDX VK_IDX_ENTER;
    _MENU_IDX VK_IDX_UP;
    _MENU_IDX VK_IDX_DOWN;
    _MENU_IDX VK_IDX_EXIT;

    void (*Enter)(void);
    void (*Do)(void);
    void (*Exit)(void);
} _MenuOptTab;

typedef struct
{
    uint8_t Menu_Flag;             /*主界面标记*/
    uint8_t Menu_Time_Flag;        /*从Enter界面确认退出计时*/
    uint8_t Menu_Enter_Return;     /*进入Enter之前界面*/
    uint8_t Menu_Return;           /*Enter Return界面切换标记*/

    uint16_t Key_Menu_Popup_time;  /*报警状态持续时间*/
    uint8_t Menu_Key_Time;         /*按键长按时间记录*/
    uint8_t Key_Menu_Popup_Flag;   /*报警界面menu按键长按 */

    uint8_t Menu_Popup_Flag;       /*界面状态 0-通常 1-报警 2-工厂 3-经销商 4-仪表自我诊断*/
    uint8_t Key_MenuTest_Long;     /**/
    uint8_t Key_MenuTest_ShortNum; /**/
    uint8_t Menu_Factory;          /*工厂模式*/

    uint8_t Menu_Dealer;           /*经销商模式*/
    uint8_t Menu_Test;             /*仪表自我诊断模式*/
    uint8_t Meun_Test_Dealer;      /*自我诊断模式进入经销商模式标记*/
    uint8_t Menu_StaFlag;          /**/

} _MenuFlag;

EXTERN_MEU_PROCESS _MenuFlag MenuFlag;

EXTERN_MEU_PROCESS uint8_t bMenuSwFlag;
EXTERN_MEU_PROCESS uint8_t g_ClearWin1;
EXTERN_MEU_PROCESS uint8_t bNextMenuIDX; /* the next index of menu. */
EXTERN_MEU_PROCESS uint8_t bCurMenuIDX;  /* the current index of menu. */
EXTERN_MEU_PROCESS uint8_t bMainMenuIDX; /* the current index of menu. */
EXTERN_MEU_PROCESS uint8_t bOldMenuIDX;  /* the Old index of menu. */

EXTERN_MEU_PROCESS const _MenuOptTab MenuOptTab[];
EXTERN_MEU_PROCESS void NextMenu(_MENU_IDX idx);
EXTERN_MEU_PROCESS void MenuInit(void);
EXTERN_MEU_PROCESS void MenuManage(void);

EXTERN_MEU_PROCESS void Level1Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_1Do(void);
EXTERN_MEU_PROCESS void Level1Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_2Do(void);
EXTERN_MEU_PROCESS void Level1Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_3Do(void);
EXTERN_MEU_PROCESS void Level1Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_4Do(void);
EXTERN_MEU_PROCESS void Level1Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_5Do(void);
EXTERN_MEU_PROCESS void Level1Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_6Do(void);
EXTERN_MEU_PROCESS void Level1Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelPopup_Enter(void);
EXTERN_MEU_PROCESS void LevelPopup_Do(void);
EXTERN_MEU_PROCESS void LevelPopup_Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_5Do(void);
EXTERN_MEU_PROCESS void Level2Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level2Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level2Menu_6Do(void);
EXTERN_MEU_PROCESS void Level2Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level2_1Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_1Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_1Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_1Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_1Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_1Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_1Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_1Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_1Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_1Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_1Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_1Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_1Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level2_1Menu_5Do(void);
EXTERN_MEU_PROCESS void Level2_1Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level2_1Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level2_1Menu_6Do(void);
EXTERN_MEU_PROCESS void Level2_1Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_7Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level2_2Menu_8Enter(void);
EXTERN_MEU_PROCESS void Level2_2Menu_8Do(void);
EXTERN_MEU_PROCESS void Level2_2Menu_8Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_6Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level2_3Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level2_3Menu_7Do(void);
EXTERN_MEU_PROCESS void Level2_3Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_7Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_5Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level2_4Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level2_4Menu_6Do(void);
EXTERN_MEU_PROCESS void Level2_4Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_3Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level2_5Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level2_5Menu_4Do(void);
EXTERN_MEU_PROCESS void Level2_5Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level2_6Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level2_6Menu_1Do(void);
EXTERN_MEU_PROCESS void Level2_6Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level2_6Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level2_6Menu_2Do(void);
EXTERN_MEU_PROCESS void Level2_6Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_1Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level3_1Menu_1Do(void);
EXTERN_MEU_PROCESS void Level3_1Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level3_1Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level3_1Menu_2Do(void);
EXTERN_MEU_PROCESS void Level3_1Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_1Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_1Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_1Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_1Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level3_1Menu_4Do(void);
EXTERN_MEU_PROCESS void Level3_1Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level3_1Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level3_1Menu_5Do(void);
EXTERN_MEU_PROCESS void Level3_1Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level3_1Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level3_1Menu_6Do(void);
EXTERN_MEU_PROCESS void Level3_1Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_1Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_2Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_4Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_6Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_7Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level3_2Menu_8Enter(void);
EXTERN_MEU_PROCESS void Level3_2Menu_8Do(void);
EXTERN_MEU_PROCESS void Level3_2Menu_8Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_1Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_2Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_4Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_4Exit(void);

// EXTERN_MEU_PROCESS void Level3_3Menu_5Enter(void);
// EXTERN_MEU_PROCESS void Level3_3Menu_5Do(void);
// EXTERN_MEU_PROCESS void Level3_3Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_6Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level3_3Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level3_3Menu_7Do(void);
EXTERN_MEU_PROCESS void Level3_3Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level3_4Menu_1Enter_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Do_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Exit_1(void);

EXTERN_MEU_PROCESS void Level3_4Menu_1Enter_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Do_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Exit_2(void);

EXTERN_MEU_PROCESS void Level3_4Menu_1Enter_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Do_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_1Exit_3(void);

EXTERN_MEU_PROCESS void Level3_4Menu_2Enter_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Do_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Exit_1(void);

EXTERN_MEU_PROCESS void Level3_4Menu_2Enter_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Do_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_2Exit_2(void);

EXTERN_MEU_PROCESS void Level3_4Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_4Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_4Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_1(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_2(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_3(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_3(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_4(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_4(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_4(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_5(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_5(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_5(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_6(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_6(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_6(void);

EXTERN_MEU_PROCESS void Level3_4Menu_4Enter_7(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Do_7(void);
EXTERN_MEU_PROCESS void Level3_4Menu_4Exit_7(void);

EXTERN_MEU_PROCESS void Level3_4Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level3_4Menu_5Do(void);
EXTERN_MEU_PROCESS void Level3_4Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level3_4Menu_7Enter_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_7Do_1(void);
EXTERN_MEU_PROCESS void Level3_4Menu_7Exit_1(void);

EXTERN_MEU_PROCESS void Level3_4Menu_7Enter_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_7Do_2(void);
EXTERN_MEU_PROCESS void Level3_4Menu_7Exit_2(void);

EXTERN_MEU_PROCESS void Level3_5Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_1Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level3_5Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_2Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level3_5Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_3Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level3_5Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level3_5Menu_4Do(void);
EXTERN_MEU_PROCESS void Level3_5Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_1Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_2Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_3Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_4Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_5Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_6Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level4_4Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level4_4Menu_7Do(void);
EXTERN_MEU_PROCESS void Level4_4Menu_7Exit(void);

EXTERN_MEU_PROCESS void Level_Enter_Menu_Enter(void);
EXTERN_MEU_PROCESS void Level_Enter_Menu_Do(void);
EXTERN_MEU_PROCESS void Level_Enter_Menu_Exit(void);

EXTERN_MEU_PROCESS void Level_Return_Menu_Enter(void);
EXTERN_MEU_PROCESS void Level_Return_Menu_Do(void);
EXTERN_MEU_PROCESS void Level_Return_Menu_Exit(void);

EXTERN_MEU_PROCESS void LevelMenuOFF_Enter(void);
EXTERN_MEU_PROCESS void LevelMenuOFF_Do(void);
EXTERN_MEU_PROCESS void LevelMenuOFF_Exit(void);

EXTERN_MEU_PROCESS void LevelMenuTest_Enter(void);
EXTERN_MEU_PROCESS void LevelMenuTest_Do(void);
EXTERN_MEU_PROCESS void LevelMenuTest_Exit(void);

/*工厂模式*/
EXTERN_MEU_PROCESS void LevelF0Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF0Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF0Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF1Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF1Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF1Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF1Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF1Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF1Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF1Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelF1Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelF1Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelF1Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelF1Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelF1Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelF1Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelF1Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelF1Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelF1Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelF1Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelF1Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelF1_1Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF1_1Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF1_1Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelF1_1Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelF1_1Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelF1_1Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelF1_1Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelF1_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF1_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF1_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelF1_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelF1_2Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelF1_2Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelF1_2Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelF1_3Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF1_3Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF1_3Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF1_3Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF1_3Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF1_3Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF1_6Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF1_6Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF1_6Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF1_6Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF1_6Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF1_6Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF2_1Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF2_1Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF2_1Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelF2_1Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelF2_1Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelF2_1Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelF2_1Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelF2_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF2_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF2_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelF2_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelF2_2Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelF2_2Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelF2_2Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelF3_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF3_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF3_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelF3_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelF3_2Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelF3_2Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelF3_2Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelF4_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelF4_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelF4_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelF4_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelF4_2Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelF4_2Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelF4_2Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelF2_5Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelF2_5Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelF2_5Menu_1Exit(void);

/*经销商模式*/
EXTERN_MEU_PROCESS void LevelD0Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelD0Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelD0Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelD1Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelD1Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelD1Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelD1Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelD1Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelD1Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelD1Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelD1Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelD1Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelD1Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelD1Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelD1Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelD1Menu_5Enter(void);
EXTERN_MEU_PROCESS void LevelD1Menu_5Do(void);
EXTERN_MEU_PROCESS void LevelD1Menu_5Exit(void);

EXTERN_MEU_PROCESS void LevelD1Menu_6Enter(void);
EXTERN_MEU_PROCESS void LevelD1Menu_6Do(void);
EXTERN_MEU_PROCESS void LevelD1Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelD1_1Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelD1_1Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelD1_1Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelD1_2Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelD1_2Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelD1_2Menu_3Enter(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_3Do(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_3Exit(void);

EXTERN_MEU_PROCESS void LevelD1_2Menu_4Enter(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_4Do(void);
EXTERN_MEU_PROCESS void LevelD1_2Menu_4Exit(void);

EXTERN_MEU_PROCESS void LevelD1_3Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelD1_3Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelD1_3Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelD1_3Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelD1_3Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelD1_3Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelD1_6Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelD1_6Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelD1_6Menu_1Exit(void);

EXTERN_MEU_PROCESS void LevelD1_6Menu_2Enter(void);
EXTERN_MEU_PROCESS void LevelD1_6Menu_2Do(void);
EXTERN_MEU_PROCESS void LevelD1_6Menu_2Exit(void);

EXTERN_MEU_PROCESS void LevelD2_5Menu_1Enter(void);
EXTERN_MEU_PROCESS void LevelD2_5Menu_1Do(void);
EXTERN_MEU_PROCESS void LevelD2_5Menu_1Exit(void);

#endif
