/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : C type declarations
 ****************************************************************************
 * Version Control Information :
 * DO NOT EDIT THIS FILE - This file will be automatically generated by
 * 'gen_type_headers_sw.py'
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_REGISTERTYPES_H_INCLUDED
#define DAVEHD_REGISTERTYPES_H_INCLUDED

#include <davehd_types.h>

/*-------------------------------------------------------------------------*/

/* Type ALPHA_MASK_MODE: Alpha mask mode selection*/
typedef enum {
  E_ALPHA_MASK_MODE_MULTIPLY = 0,  /* Multiply pixel coverage value with value from global alpha mask*/
  E_ALPHA_MASK_MODE_REPLACE,       /* Replace pixel coverage value with value from global alpha mask*/
  E_ALPHA_MASK_MODE_ENUM_COUNT     
} dhd_reg_alpha_mask_mode_t;

/* Type ALPHA_MASK_WRITE_MODE: Alpha mask write mode*/
typedef enum {
  E_ALPHA_MASK_WRITE_MODE_KEEP = 0,   /* Alpha mask is not modified*/
  E_ALPHA_MASK_WRITE_MODE_MAXIMIZE,   /* Maximize coverage in alpha mask*/
  E_ALPHA_MASK_WRITE_MODE_CLEAR,      /* Clear coverage to 0*/
  E_ALPHA_MASK_WRITE_MODE_ANTIALIAS,  /* Special polygon anti-aliasing mode*/
  E_ALPHA_MASK_WRITE_MODE_ENUM_COUNT  
} dhd_reg_alpha_mask_write_mode_t;

/* Type Alpha_Blend_Mode: Alpha Blend mode*/
typedef enum {
  E_ALPHA_BLEND_MODE_BLEND = 0,     /* normal blending: out = src * f_src + dst * f_dst*/
  E_ALPHA_BLEND_MODE_MULTIPLY_ADD,  /* add 2nd factor only: out = src * f_src + f_dst*/
  E_ALPHA_BLEND_MODE_ENUM_COUNT     
} dhd_reg_alpha_blend_mode_t;

/* Type Alpha_Test_Op: Alpha Test Operation*/
typedef enum {
  E_ALPHA_TEST_OP_NEVER = 0,         /* never pass, always drop*/
  E_ALPHA_TEST_OP_LESS,              /* pass if alpha < alpha_ref*/
  E_ALPHA_TEST_OP_EQUAL,             /* pass if alpha == alpha_ref*/
  E_ALPHA_TEST_OP_LESS_OR_EQUAL,     /* pass if alpha less or equal*/
  E_ALPHA_TEST_OP_GREATER,           /* pass if alpha > alpha_ref*/
  E_ALPHA_TEST_OP_NOT_EQUAL,         /* pass if alpha != alpha_ref*/
  E_ALPHA_TEST_OP_GREATER_OR_EQUAL,  /* pass if alpha >= alpha_ref*/
  E_ALPHA_TEST_OP_ALWAYS,            /* always pass*/
  E_ALPHA_TEST_OP_ENUM_COUNT         
} dhd_reg_alpha_test_op_t;

/* Type Blend_Factor_Select: Blend factor selection*/
typedef enum {
  E_BLEND_FACTOR_SELECT_SRC = 0,    /* use source alpha resp. color*/
  E_BLEND_FACTOR_SELECT_DST,        /* use destination alpha resp. color*/
  E_BLEND_FACTOR_SELECT_ZERO,       /* use 0.0*/
  E_BLEND_FACTOR_SELECT_ENUM_COUNT  
} dhd_reg_blend_factor_select_t;

/* Type Col_Op_Invert_Mode: Select inversion mode for Op*/
typedef enum {
  E_COL_OP_INVERT_MODE_NO_INVERSION = 0,  /* No inversion*/
  E_COL_OP_INVERT_MODE_INVERT_ALL_9,      /* Invert all 9 bits*/
  E_COL_OP_INVERT_MODE_INVERT_8_LSBS,     /* Invert the 8 LSBs (all but the MSB bit 8)*/
  E_COL_OP_INVERT_MODE_INVERT_SUB_128,    /* Invert bit 7 and sign extend to bit 8 (unsigned 8 bit value-128)*/
  E_COL_OP_INVERT_MODE_ENUM_COUNT         
} dhd_reg_col_op_invert_mode_t;

/* Type Col_Op_Select_Argb: Select A, R, G or B for Alpha Op*/
typedef enum {
  E_COL_OP_SELECT_ARGB_USE_A = 0,  /* Use A from the selected input*/
  E_COL_OP_SELECT_ARGB_USE_R,      /* Use R from the selected input*/
  E_COL_OP_SELECT_ARGB_USE_G,      /* Use G from the selected input*/
  E_COL_OP_SELECT_ARGB_USE_B,      /* Use B from the selected input*/
  E_COL_OP_SELECT_ARGB_ENUM_COUNT  
} dhd_reg_col_op_select_argb_t;

/* Type Col_Op_Select_Input: Select input for Op*/
typedef enum {
  E_COL_OP_SELECT_INPUT_CONST_0 = 0,  /* Select constant value 0x00*/
  E_COL_OP_SELECT_INPUT_COVERAGE,     /* Select coverage_alpha*/
  E_COL_OP_SELECT_INPUT_PREVIOUS,     /* Select previous result*/
  E_COL_OP_SELECT_INPUT_COLOR_0,      /* Select constant color 0*/
  E_COL_OP_SELECT_INPUT_COLOR_1,      /* Select constant color 1*/
  E_COL_OP_SELECT_INPUT_COLOR_2,      /* Select constant color 2*/
  E_COL_OP_SELECT_INPUT_COLOR_3,      /* Select constant color 3*/
  E_COL_OP_SELECT_INPUT_COLOR_4,      /* Select constant color 4*/
  E_COL_OP_SELECT_INPUT_COLOR_5,      /* Select constant color 5*/
  E_COL_OP_SELECT_INPUT_COLOR_6,      /* Select constant color 6*/
  E_COL_OP_SELECT_INPUT_COLOR_7,      /* Select constant color 7*/
  E_COL_OP_SELECT_INPUT_COLOR_8,      /* Select constant color 8*/
  E_COL_OP_SELECT_INPUT_COLOR_9,      /* Select constant color 9*/
  E_COL_OP_SELECT_INPUT_COLOR_10,     /* Select constant color 10*/
  E_COL_OP_SELECT_INPUT_COLOR_11,     /* Select constant color 11*/
  E_COL_OP_SELECT_INPUT_COLOR_12,     /* Select constant color 12*/
  E_COL_OP_SELECT_INPUT_COLOR_13,     /* Select constant color 13*/
  E_COL_OP_SELECT_INPUT_COLOR_14,     /* Select constant color 14*/
  E_COL_OP_SELECT_INPUT_COLOR_15,     /* Select constant color 15*/
  E_COL_OP_SELECT_INPUT_TEXTURE_0,    /* Select texel color value from texture unit 0*/
  E_COL_OP_SELECT_INPUT_TEXTURE_1,    /* Select texel color value from texture unit 1*/
  E_COL_OP_SELECT_INPUT_TEXTURE_2,    /* Select texel color value from texture unit 2*/
  E_COL_OP_SELECT_INPUT_TEXTURE_3,    /* Select texel color value from texture unit 3*/
  E_COL_OP_SELECT_INPUT_TEXTURE_4,    /* Select texel color value from texture unit 4*/
  E_COL_OP_SELECT_INPUT_TEXTURE_5,    /* Select texel color value from texture unit 5*/
  E_COL_OP_SELECT_INPUT_TEXTURE_6,    /* Select texel color value from texture unit 6*/
  E_COL_OP_SELECT_INPUT_TEXTURE_7,    /* Select texel color value from texture unit 7*/
  E_COL_OP_SELECT_INPUT_ENUM_COUNT    
} dhd_reg_col_op_select_input_t;

/* Type Col_Scale_Out: Select scale mode for output value*/
typedef enum {
  E_COL_SCALE_OUT_SR_1 = 0,   /* Shift right 1 (/2)*/
  E_COL_SCALE_OUT_NO_SHIFT,   /* No shift (*1)*/
  E_COL_SCALE_OUT_SL_1,       /* Shift left 1 (*2)*/
  E_COL_SCALE_OUT_SL_2,       /* Shift left 2 (*4)*/
  E_COL_SCALE_OUT_ENUM_COUNT  
} dhd_reg_col_scale_out_t;

/* Type Color_Blend_Mode: Color Blend mode*/
typedef enum {
  E_COLOR_BLEND_MODE_BLEND = 0,     /* normal blending: out = src * f_src + dst * f_dst*/
  E_COLOR_BLEND_MODE_MULTIPLY_ADD,  /* add 2nd factor only: out = src * f_src + f_dst*/
  E_COLOR_BLEND_MODE_MULTIPLY,      /* OVG multiply: out = src * (f_src+dst) + dst * f_dst*/
  E_COLOR_BLEND_MODE_DARKEN,        /* OVG darken: out = min( src+dst*f_dst, dst+src*f_src )*/
  E_COLOR_BLEND_MODE_LIGHTEN,       /* OVG lighten: out = max( src+dst*f_dst, dst+src*f_src )*/
  E_COLOR_BLEND_MODE_ENUM_COUNT     
} dhd_reg_color_blend_mode_t;

/* Type DEPTH_FUNC: Depth test function selection*/
typedef enum {
  E_DEPTH_FUNC_NEVER = 0,  /* Never pass*/
  E_DEPTH_FUNC_LESS,       /* Pass if pixel depth value < depth buffer value*/
  E_DEPTH_FUNC_EQUAL,      /* Pass if pixel depth value == depth buffer value*/
  E_DEPTH_FUNC_LEQUAL,     /* Pass if pixel depth value <= depth buffer value*/
  E_DEPTH_FUNC_GREATER,    /* Pass if pixel depth value > depth buffer value*/
  E_DEPTH_FUNC_NOTEQUAL,   /* Pass if pixel depth value != depth buffer value*/
  E_DEPTH_FUNC_GEQUAL,     /* Pass if pixel depth value >= depth buffer value*/
  E_DEPTH_FUNC_ALWAYS,     /* Always pass*/
  E_DEPTH_FUNC_ENUM_COUNT  
} dhd_reg_depth_func_t;

/* Type Filter_Sample_Shape: Texture filter sample shape/form (enum)*/
typedef enum {
  E_FILTER_SAMPLE_SHAPE_QUAD = 0,   /* 2x2 samples (for bilinear filtering or general convolution filtering using a n x m kernel)*/
  E_FILTER_SAMPLE_SHAPE_ROW,        /* 1x4 samples (for horizontal convolution filtering using a n x 1 kernel)*/
  E_FILTER_SAMPLE_SHAPE_COLUMN,     /* 4x1 samples (for vertical convolution filtering using a 1 x m kernel)*/
  E_FILTER_SAMPLE_SHAPE_ENUM_COUNT  
} dhd_reg_filter_sample_shape_t;

/* Type MBI_Read_Master_ID: MBI master types*/
typedef enum {
  E_MBI_READ_MASTER_ID_FBC = 0,    /* Framebuffer cache read side*/
  E_MBI_READ_MASTER_ID_TXC,        /* Texture cache*/
  E_MBI_READ_MASTER_ID_RLD,        /* Run-Length decoder*/
  E_MBI_READ_MASTER_ID_ZSC,        /* ZSA cache read side*/
  E_MBI_READ_MASTER_ID_STR,        /* Stream reader*/
  E_MBI_READ_MASTER_ID_ENUM_COUNT  
} dhd_reg_mbi_read_master_id_t;

/* Type MBI_Write_Master_ID: MBI master types*/
typedef enum {
  E_MBI_WRITE_MASTER_ID_STW = 0,    /* Stream writer*/
  E_MBI_WRITE_MASTER_ID_CLR,        /* Clear unit*/
  E_MBI_WRITE_MASTER_ID_FBC,        /* Framebuffer cache write side*/
  E_MBI_WRITE_MASTER_ID_ZSC,        /* ZSA cache write side*/
  E_MBI_WRITE_MASTER_ID_ENUM_COUNT  
} dhd_reg_mbi_write_master_id_t;

/* Type Mat: Memory access type selection*/
typedef enum {
  E_MAT_ACCESS_8BIT = 0,  /* Access has a word size of 8 bits*/
  E_MAT_ACCESS_16BIT,     /* Access has a word size of 16 bits*/
  E_MAT_ACCESS_32BIT,     /* Access has a word size of 32 bits*/
  E_MAT_ACCESS_64BIT,     /* Access has a word size of 64 bits*/
  E_MAT_ENUM_COUNT        
} dhd_reg_mat_t;

/* Type Pfc_Event: Enum of the different performance counter events*/
typedef enum {
  E_PFC_EVENT_STR_FETCH_START = 0,        /* Stream reader start of fetch event*/
  E_PFC_EVENT_STR_BURST_READ,             /* Stream reader did a burst read on MBI*/
  E_PFC_EVENT_STR_WORD_READ,              /* Stream reader received a word from MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_STW_BURST_WRITE,            /* Stream writer did a burst write on MBI*/
  E_PFC_EVENT_STW_WORD_WRITE,             /* Stream writer did a word write on MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_CLR_BURST_WRITE,            /* Clear unit did a burst write on MBI*/
  E_PFC_EVENT_CLR_WORD_WRITE,             /* Clear unit did a word write on MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_PSU_PRIMITIVE,              /* New primitive enumerated*/
  E_PFC_EVENT_PSU_STRIPE,                 /* New stripe enumerated*/
  E_PFC_EVENT_PSU_VISIBLE_PIXEL,          /* Visible pixel enumerated: A visible pixel may nevertheless have an 8-bit coverage value of 0 due to rounding. Potential bezier post-process is not considered, i.e. pixels discarded by the bezier function are still counted as visible.*/
  E_PFC_EVENT_PSU_INVISIBLE_PIXEL,        /* Invisible pixel enumerated: Potential bezier post-process is not considered, i.e. pixels discarded by the bezier function are not counted as invisible, but as visible instead.)*/
  E_PFC_EVENT_ZSS_SPAN_LENGTH_LIMIT,      /* ZSA buffer span split due to span length limit reached*/
  E_PFC_EVENT_ZSC_BURST_READ,             /* ZSA buffer cache did a burst read on MBI*/
  E_PFC_EVENT_ZSC_BURST_WRITE,            /* ZSA buffer cache did a burst write on MBI*/
  E_PFC_EVENT_ZSC_WORD_READ,              /* ZSA buffer cache received a word from MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_ZSC_WORD_WRITE,             /* ZSA buffer cache did a word write on MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_ZSC_PIXEL_READ,             /* ZSA buffer cache processed a pixel read*/
  E_PFC_EVENT_ZSC_PIXEL_READ_HIT,         /* ZSA buffer cache processed a read without any wait cycle*/
  E_PFC_EVENT_ZSC_PIXEL_READ_WAIT,        /* ZSA buffer cache wait cycles on read side (>= 1 event per miss)*/
  E_PFC_EVENT_ZSC_PIXEL_WRITE,            /* ZSA buffer cache processed a pixel write*/
  E_PFC_EVENT_ZSC_SPAN_CONFLICT,          /* ZSA buffer span conflict occured between new job requiring a read and a line already in the ZSA cache: Read range of new job overlaps write range of open line.*/
  E_PFC_EVENT_ZSC_SPAN_CONFLICT_WAIT,     /* Wait cycles at ZSA buffer prefetch queue interface due to span conflict.*/
  E_PFC_EVENT_ZSC_CACHE_FULL_WAIT,        /* Wait cycles at ZSA buffer prefetch queue interface because line could not be allocated as there is no unused line available.*/
  E_PFC_EVENT_ZSU_DEPTH_TEST_FAILED,      /* Pixel failed depth test*/
  E_PFC_EVENT_ZSU_STENCIL_TEST_FAILED,    /* Pixel failed stencil test*/
  E_PFC_EVENT_FBD_ALPHA_TEST_FAILED,      /* Pixel dropped through alpha test*/
  E_PFC_EVENT_FBS_SPAN_LENGTH_LIMIT,      /* Span split due to span length limit reached*/
  E_PFC_EVENT_FBS_READ_GAP_LIMIT,         /* Span split due to read gap limit reached*/
  E_PFC_EVENT_FBC_BURST_READ,             /* Framebuffer cache did a burst read on MBI*/
  E_PFC_EVENT_FBC_BURST_WRITE,            /* Framebuffer cache did a burst write on MBI*/
  E_PFC_EVENT_FBC_WORD_READ,              /* Framebuffer cache received a word from MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_FBC_WORD_WRITE,             /* Framebuffer cache did a word write on MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_FBC_PIXEL_READ,             /* Framebuffer cache processed a pixel read*/
  E_PFC_EVENT_FBC_PIXEL_READ_HIT,         /* Framebuffer cache processed a read without any wait cycle*/
  E_PFC_EVENT_FBC_PIXEL_READ_WAIT,        /* Framebuffer cache wait cycles on read side (>= 1 event per miss)*/
  E_PFC_EVENT_FBC_PIXEL_WRITE,            /* Framebuffer cache processed a pixel write*/
  E_PFC_EVENT_FBC_SPAN_CONFLICT,          /* Span conflict occured between new job requiring a read and a line already in the framebuffer cache: Read range of new job overlaps write range of open line.*/
  E_PFC_EVENT_FBC_SPAN_CONFLICT_WAIT,     /* Wait cycles at prefetch queue interface due to span conflict.*/
  E_PFC_EVENT_FBC_CACHE_FULL_WAIT,        /* Wait cycles at prefetch queue interface because line could not be allocated as there is no unused line available.*/
  E_PFC_EVENT_TXS_PREFETCH_MISS,          /* Cache miss in the prefetching texture cache scheduler*/
  E_PFC_EVENT_TXS_REFRESH,                /* Line refresh job sent from texel schedule to texture cache*/
  E_PFC_EVENT_TXC_BURST_READ,             /* Texture cache did a burst read on MBI*/
  E_PFC_EVENT_TXC_WORD_READ,              /* Texture cache received a word from MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_TXC_PIXEL_READ,             /* Texture cache processed a pixel read (i.e. potentially multiple texel reads, still only a single event)*/
  E_PFC_EVENT_TXC_PIXEL_READ_HIT,         /* Texture cache processed a pixel read without the need to wait for a fetch.*/
  E_PFC_EVENT_TXC_PIXEL_READ_FETCH_WAIT,  /* Wait cycles at pipeline read interface because of wait for line to be fetched.*/
  E_PFC_EVENT_TXC_PIXEL_READ_RAM_WAIT,    /* Wait cycles inserted in pipeline read path because read RAM needed to be accessed more than once and prefetch was not successful.*/
  E_PFC_EVENT_TXC_JOB_LINE_READY,         /* A job was taken from the prefetch queue without the need to wait for the access count to reach the replace count.*/
  E_PFC_EVENT_TXC_JOB_LINE_WAIT,          /* Wait cycles at prefetch queue interface because job could not be fetched as the access count had not yet reached the replace count.*/
  E_PFC_EVENT_RLD_BURST_READ,             /* RLD did a burst read on MBI*/
  E_PFC_EVENT_RLD_WORD_READ,              /* RLD did a word read on MBI (1 event for every word in a burst)*/
  E_PFC_EVENT_RLD_REWIND,                 /* RLD rewinds to start of texture code*/
  E_PFC_EVENT_TXP_CLUT_ACCESS_WAIT,       /* Wait cycles when accessing CLUT: Count every additional cycle of CLUT access which exceeds the optimal throughput of 1 cycle/pixel.*/
  E_PFC_EVENT_STC_COMMAND,                /* Finished execution of a stream command*/
  E_PFC_EVENT_STC_STR_WAIT,               /* Wait cycles when STC waits for data from STR*/
  E_PFC_EVENT_STC_REG_WAIT,               /* Wait cycles when STC waits for register write acknowledge from register file*/
  E_PFC_EVENT_STC_COMMAND_WAIT,           /* Wait cycles when STC waits because of wait command*/
  E_PFC_EVENT_STC_ACTIVE,                 /* Active cycles of the STC while not in pause-reached mode*/
  E_PFC_EVENT_STC_CORE_ACTIVE,            /* Active cycles of the STC-Core only when the ACG would be enabled*/
  E_PFC_EVENT_STC_BUSY,                   /* Busy cycles of STC*/
  E_PFC_EVENT_STR_BUSY,                   /* Busy cycles of STR*/
  E_PFC_EVENT_STW_BUSY,                   /* Busy cycles of STW*/
  E_PFC_EVENT_REG_BUSY,                   /* Busy cycles of REG*/
  E_PFC_EVENT_PSU_BUSY,                   /* Busy cycles of PSU*/
  E_PFC_EVENT_TXI_BUSY,                   /* Busy cycles of modules after PSU, up to ZSS*/
  E_PFC_EVENT_TEX_BUSY,                   /* Busy cycles of modules after ZSS, up to TXS*/
  E_PFC_EVENT_COL_BUSY,                   /* Busy cycles of modules after TXS, up to FBS*/
  E_PFC_EVENT_BLEND_BUSY,                 /* Busy cycles of modules after FBS, up to FBC*/
  E_PFC_EVENT_CLEAR_BUSY,                 /* Busy cycles of clear unit*/
  E_PFC_EVENT_CLOCK,                      /* Every clock cycle*/
  E_PFC_EVENT_ENUM_COUNT                  
} dhd_reg_pfc_event_t;

/* Type Pixel_Org: Pixel data organization*/
typedef enum {
  E_PIXEL_ORG_ARGB_8888 = 0,  /* 4 channel 8888, 32 bit*/
  E_PIXEL_ORG_RGBA_8888,      /* 4 channel 8888, 32 bit*/
  E_PIXEL_ORG_ARGB_4444,      /* 4 channel 4444, 16 bit*/
  E_PIXEL_ORG_RGBA_4444,      /* 4 channel 4444, 16 bit*/
  E_PIXEL_ORG_ARGB_1555,      /* 4 channel 1555, 16 bit*/
  E_PIXEL_ORG_RGBA_5551,      /* 4 channel 5551, 16 bit*/
  E_PIXEL_ORG_RGB_565,        /* 3 channel 565, 16 bit*/
  E_PIXEL_ORG_AL_88,          /* 2 channel 88, 16 bit (L=blue channel)*/
  E_PIXEL_ORG_AL_44,          /* 2 channel 44, 8 bit (L=blue channel)*/
  E_PIXEL_ORG_A_8,            /* 1 channel, 8 bit*/
  E_PIXEL_ORG_L_8,            /* 1 channel, 8 bit (L=blue channel)*/
  E_PIXEL_ORG_AL_17,          /* 2 channel 17, 8 bit (L=blue channel)*/
  E_PIXEL_ORG_ENUM_COUNT      
} dhd_reg_pixel_org_t;

/* Type Psu_Action: Enumeration step/restore action*/
typedef enum {
  E_PSU_ACTION_STEP_UP = 0,    /* Step_Up*/
  E_PSU_ACTION_STEP_DOWN,      /* Step_Down*/
  E_PSU_ACTION_STEP_RIGHT,     /* Step_Right*/
  E_PSU_ACTION_DUMMY0,         /* dummy*/
  E_PSU_ACTION_RESTORE_UP,     /* Restore_Up*/
  E_PSU_ACTION_RESTORE_DOWN,   /* Restore_Down*/
  E_PSU_ACTION_RESTORE_RIGHT,  /* Restore_Right*/
  E_PSU_ACTION_INIT,           /* Init*/
  E_PSU_ACTION_ENUM_COUNT      
} dhd_reg_psu_action_t;

/* Type Register_Groups: register file groups*/
typedef enum {
  E_REGISTER_GROUPS_0 = 0,      /* STC registers (implemented outside the register file)*/
  E_REGISTER_GROUPS_1,          /* (reserved)*/
  E_REGISTER_GROUPS_2,          /* PSU Pixel Selection registers*/
  E_REGISTER_GROUPS_3,          /* Texture U/V Interpolation Registers*/
  E_REGISTER_GROUPS_4,          /* ZSS, Texture RHW and Z Interpolation Registers*/
  E_REGISTER_GROUPS_5,          /* (reserved)*/
  E_REGISTER_GROUPS_6,          /* ZSA Pipeline + TXA Registers*/
  E_REGISTER_GROUPS_7,          /* (reserved)*/
  E_REGISTER_GROUPS_8,          /* TEX/COL (Global), FBD/FBS and RLD Registers */
  E_REGISTER_GROUPS_9,          /* (reserved)*/
  E_REGISTER_GROUPS_10,         /* TEX+TXP Registers*/
  E_REGISTER_GROUPS_11,         /* COL Pass Registers*/
  E_REGISTER_GROUPS_12,         /* Blending Pipeline Registers*/
  E_REGISTER_GROUPS_13,         /* (reserved)*/
  E_REGISTER_GROUPS_14,         /* PFC registers*/
  E_REGISTER_GROUPS_15,         /* CLR registers*/
  E_REGISTER_GROUPS_ENUM_COUNT  
} dhd_reg_register_groups_t;

/* Type Register_Groups_Wait_Mask: wait mask for register file groups*/
typedef enum {
  E_REGISTER_GROUPS_WAIT_MASK_0 = 0,      /* 0*/
  E_REGISTER_GROUPS_WAIT_MASK_1,          /* 0*/
  E_REGISTER_GROUPS_WAIT_MASK_2,          /* PSU*/
  E_REGISTER_GROUPS_WAIT_MASK_3,          /* PSU | TXI*/
  E_REGISTER_GROUPS_WAIT_MASK_4,          /* PSU | TXI*/
  E_REGISTER_GROUPS_WAIT_MASK_5,          /* PSU | TXI | TEX*/
  E_REGISTER_GROUPS_WAIT_MASK_6,          /* PSU | TXI | TEX*/
  E_REGISTER_GROUPS_WAIT_MASK_7,          /* PSU | TXI | TEX*/
  E_REGISTER_GROUPS_WAIT_MASK_8,          /* PSU | TXI | TEX | COL*/
  E_REGISTER_GROUPS_WAIT_MASK_9,          /* PSU | TXI | TEX | COL*/
  E_REGISTER_GROUPS_WAIT_MASK_10,         /* PSU | TXI | TEX | COL*/
  E_REGISTER_GROUPS_WAIT_MASK_11,         /* PSU | TXI | TEX | COL*/
  E_REGISTER_GROUPS_WAIT_MASK_12,         /* PSU | TXI | TEX | COL | BLEND*/
  E_REGISTER_GROUPS_WAIT_MASK_13,         /* 0*/
  E_REGISTER_GROUPS_WAIT_MASK_14,         /* 0*/
  E_REGISTER_GROUPS_WAIT_MASK_15,         /* CLEAR*/
  E_REGISTER_GROUPS_WAIT_MASK_ENUM_COUNT  
} dhd_reg_register_groups_wait_mask_t;

/* Type STENCIL_FUNC: Stencil test function selection*/
typedef enum {
  E_STENCIL_FUNC_NEVER = 0,  /* Never pass*/
  E_STENCIL_FUNC_LESS,       /* Pass if stencil reference value < stencil buffer value*/
  E_STENCIL_FUNC_EQUAL,      /* Pass if stencil reference value == stencil buffer value*/
  E_STENCIL_FUNC_LEQUAL,     /* Pass if stencil reference value <= stencil buffer value*/
  E_STENCIL_FUNC_GREATER,    /* Pass if stencil reference value > stencil buffer value*/
  E_STENCIL_FUNC_NOTEQUAL,   /* Pass if stencil reference value != stencil buffer value*/
  E_STENCIL_FUNC_GEQUAL,     /* Pass if stencil reference value >= stencil buffer value*/
  E_STENCIL_FUNC_ALWAYS,     /* Always pass*/
  E_STENCIL_FUNC_ENUM_COUNT  
} dhd_reg_stencil_func_t;

/* Type STENCIL_OP: Stencil operation selection*/
typedef enum {
  E_STENCIL_OP_ZERO = 0,   /* Set the stencil buffer value to zero*/
  E_STENCIL_OP_REPLACE,    /* Replace the stencil buffer value with the stencil reference value*/
  E_STENCIL_OP_INCR,       /* Increment and saturate the stencil buffer value*/
  E_STENCIL_OP_DECR,       /* Decrement and saturate the stencil buffer value*/
  E_STENCIL_OP_INVERT,     /* Invert the bits of the stencil buffer value*/
  E_STENCIL_OP_KEEP,       /* Do not modify the stencil buffer value*/
  E_STENCIL_OP_ENUM_COUNT  
} dhd_reg_stencil_op_t;

/* Type Stop_IRQ_Code: Enum of the D/AVE HD Stop codes.*/
typedef enum {
  E_STOP_IRQ_CODE_STREAM_END = 0,    /* Normal end of stream*/
  E_STOP_IRQ_CODE_STREAM_HALT,       /* Halt reached, after halt request*/
  E_STOP_IRQ_CODE_START_WHEN_BUSY,   /* Start signal received while still busy*/
  E_STOP_IRQ_CODE_INVALID_COMMAND,   /* Invalid command (decode error)*/
  E_STOP_IRQ_CODE_STACK_OVERFLOW,    /* Call stack overflow (nesting limit reached)*/
  E_STOP_IRQ_CODE_INVALID_REGISTER,  /* Attempt to write invalid register*/
  E_STOP_IRQ_CODE_CHECKSUM_ERROR,    /* Checksum error detected*/
  E_STOP_IRQ_CODE_STREAM_DATACOUNT,  /* Wrong data count for given opcode*/
  E_STOP_IRQ_CODE_ENUM_COUNT         
} dhd_reg_stop_irq_code_t;

/* Type Swizzle_Mode: Texture swizzle mode*/
typedef enum {
  E_SWIZZLE_MODE_LINEAR = 0,              /* Linear: Normal linear storage*/
  E_SWIZZLE_MODE_INTERLEAVED_4,           /* Interleaved 4: Limitations regarding pitch/height and start address alignment apply!*/
  E_SWIZZLE_MODE_INTERLEAVED_16,          /* Interleaved 16: Limitations regarding pitch/height and start address alignment apply!*/
  E_SWIZZLE_MODE_INTERLEAVED_FULL,        /* Interleaved Full: Limitations regarding pitch/height and start address alignment apply!*/
  E_SWIZZLE_MODE_INVERSE_INTERLEAVED_4,   /* Inverse Interleaved 4: Check TRM regarding usage of this mode!*/
  E_SWIZZLE_MODE_INVERSE_INTERLEAVED_16,  /* Inverse Interleaved 16: Check TRM regarding usage of this mode!*/
  E_SWIZZLE_MODE_VIRTUAL_TILED,           /* Virtual Tiled: Limitations regarding pitch/height and start address alignment apply!*/
  E_SWIZZLE_MODE_ENUM_COUNT               
} dhd_reg_swizzle_mode_t;

/* Type Tex_CLUT_Mode: Texel processing CLUT mode*/
typedef enum {
  E_TEX_CLUT_MODE_OFF = 0,             /* don't use the LUT*/
  E_TEX_CLUT_MODE_INDEXED_COLOR,       /* LUT contains colors to be indexed*/
  E_TEX_CLUT_MODE_MAP_RGB,             /* LUT contains RGB color map values*/
  E_TEX_CLUT_MODE_MAP_ARGB,            /* LUT contains ARGB color map values*/
  E_TEX_CLUT_MODE_CONVOLUTION,         /* LUT contains weights for convolution (unsigned)*/
  E_TEX_CLUT_MODE_CONVOLUTION_SIGNED,  /* LUT contains weights for convolution (signed)*/
  E_TEX_CLUT_MODE_ENUM_COUNT           
} dhd_reg_tex_clut_mode_t;

/* Type Tex_Virtual_Tiling_Mode: Virtual tiling mode for textures (enum)*/
typedef enum {
  E_TEX_VIRTUAL_TILING_MODE_OFF = 0,    /* no virtual tiling (1 burst per cache line)*/
  E_TEX_VIRTUAL_TILING_MODE_SPLIT_2,    /* 2x virtual tiling (2 bursts per cache line)*/
  E_TEX_VIRTUAL_TILING_MODE_SPLIT_4,    /* 4x virtual tiling (4 bursts per cache line)*/
  E_TEX_VIRTUAL_TILING_MODE_SPLIT_8,    /* 8x virtual tiling (8 bursts per cache line)*/
  E_TEX_VIRTUAL_TILING_MODE_SPLIT_16,   /* 16x virtual tiling (16 bursts per cache line)*/
  E_TEX_VIRTUAL_TILING_MODE_ENUM_COUNT  
} dhd_reg_tex_virtual_tiling_mode_t;

/* Type Texel_Coord_Mask_Mode: Texture coordinate mask mode*/
typedef enum {
  E_TEXEL_COORD_MASK_MODE_ZERO = 0,   /* value is zero*/
  E_TEXEL_COORD_MASK_MODE_MAX,        /* value is maximal (width-1 resp. height-1)*/
  E_TEXEL_COORD_MASK_MODE_VAL_INC,    /* value is reference value+1*/
  E_TEXEL_COORD_MASK_MODE_VAL_DEC,    /* value is reference value-1*/
  E_TEXEL_COORD_MASK_MODE_VAL,        /* value is reference value*/
  E_TEXEL_COORD_MASK_MODE_ENUM_COUNT  
} dhd_reg_texel_coord_mask_mode_t;

/* Type Texel_Org: Texel data organization*/
typedef enum {
  E_TEXEL_ORG_ARGB_8888 = 0,  /* 4 channel 8888, 32 bit*/
  E_TEXEL_ORG_RGBA_8888,      /* 4 channel 8888, 32 bit*/
  E_TEXEL_ORG_ARGB_4444,      /* 4 channel 4444, 16 bit*/
  E_TEXEL_ORG_RGBA_4444,      /* 4 channel 4444, 16 bit*/
  E_TEXEL_ORG_ARGB_1555,      /* 4 channel 1555, 16 bit*/
  E_TEXEL_ORG_RGBA_5551,      /* 4 channel 5551, 16 bit*/
  E_TEXEL_ORG_RGB_565,        /* 3 channel 565, 16 bit (alpha=blue channel)*/
  E_TEXEL_ORG_AL_88,          /* 2 channel 88, 16 bit (alpha=channel1, R/G/B=channel0)*/
  E_TEXEL_ORG_AL_44,          /* 2 channel 44, 8 bit (alpha=channel1, R/G/B=channel0)*/
  E_TEXEL_ORG_AL_17,          /* 2 channel 17, 8 bit (alpha=channel1, R/G/B=channel0)*/
  E_TEXEL_ORG_AL_8,           /* 1 channel, 8 bit (A/R/G/B=same value)*/
  E_TEXEL_ORG_AL_4,           /* 1 channel, 4 bit (A/R/G/B=same value)*/
  E_TEXEL_ORG_AL_2,           /* 1 channel, 2 bit (A/R/G/B=same value)*/
  E_TEXEL_ORG_AL_1,           /* 1 channel, 1 bit ( A/R/G/B=same value)*/
  E_TEXEL_ORG_ENUM_COUNT      
} dhd_reg_texel_org_t;

/* Type Txc_Debug_Mode: Enum of TXC debug modes*/
typedef enum {
  E_TXC_DEBUG_MODE_NONE = 0,     /* No debugging*/
  E_TXC_DEBUG_MODE_SCHEDULING,   /* Highlight pixels, for which a fetch or refresh job was scheduled*/
  E_TXC_DEBUG_MODE_WAIT_CYCLES,  /* Highlight pixels, for which a wait at TXC input and/or cache RAM was necessary*/
  E_TXC_DEBUG_MODE_ENUM_COUNT    
} dhd_reg_txc_debug_mode_t;

/* Type Wrap_Mode: Texture wrap mode*/
typedef enum {
  E_WRAP_MODE_CLAMP = 0,  /* Clamp texture*/
  E_WRAP_MODE_REPEAT,     /* Repeat texture*/
  E_WRAP_MODE_MIRROR,     /* Mirror texture*/
  E_WRAP_MODE_FILL,       /* Fill texture*/
  E_WRAP_MODE_ENUM_COUNT  
} dhd_reg_wrap_mode_t;

/* Type ZSA_ORG: ZSA type selection*/
typedef enum {
  E_ZSA_ORG_S8A8Z16 = 0,  /* 32 bit SAZ (8+8+16)*/
  E_ZSA_ORG_S8A0Z24,      /* 32 bit SZ (8+24)*/
  E_ZSA_ORG_S1A5Z10,      /* 16 bit SAZ (1+5+10)*/
  E_ZSA_ORG_S8A8Z0,       /* 16 bit SA (8+8)*/
  E_ZSA_ORG_S1A0Z15,      /* 16 bit SZ (1+15)*/
  E_ZSA_ORG_S1A7Z0,       /* 8 bit SA (1+7)*/
  E_ZSA_ORG_S8A0Z0,       /* 8 bit S (8)*/
  E_ZSA_ORG_S0A8Z0,       /* 8 bit A (8)*/
  E_ZSA_ORG_ENUM_COUNT    
} dhd_reg_zsa_org_t;

/*-------------------------------------------------------------------------*/

/* Type Alpha8: 8 bit unsigned alpha channel value*/
typedef dhd_uint8_t dhd_reg_alpha8_t; /* 8 bits used*/

/* Type Alpha9s: 9 bit signed alpha channel value*/
typedef dhd_int16_t dhd_reg_alpha9s_t; /* 9 bits used*/

/* Type Color8: 8 bit unsigned color channel value*/
typedef dhd_uint8_t dhd_reg_color8_t; /* 8 bits used*/

/* Type Color9s: 9 bit signed color channel value*/
typedef dhd_int16_t dhd_reg_color9s_t; /* 9 bits used*/

/* Type Coverage: 8 bit unsigned pixel coverage value*/
typedef dhd_uint8_t dhd_reg_coverage_t; /* 8 bits used*/

/* Type DEPTH: Depth value*/
typedef dhd_uint32_t dhd_reg_depth_t; /* 24 bits used*/

/* Type Dither_Offset: Offset into a fixed 2x2 dither matrix (y1y0x1x0 of the original x/y position)*/
typedef dhd_uint8_t dhd_reg_dither_offset_t; /* 4 bits used*/

/* Type Dither_Shift: 2 bit unsigned integer value encoding the shift right distance for a dither value*/
typedef dhd_uint8_t dhd_reg_dither_shift_t; /* 2 bits used*/

/* Type Dither_Threshold: 4 bit unsigned dither threshold value, added at the output when dithering is enabled*/
typedef dhd_uint8_t dhd_reg_dither_threshold_t; /* 4 bits used*/

/* Type FB_Byte_Pitch: 15 bit unsigned framebuffer pitch in bytes*/
typedef dhd_uint16_t dhd_reg_fb_byte_pitch_t; /* 15 bits used*/

/* Type FB_Byte_Size: 14 bit unsigned framebuffer width/height in bytes (-1)*/
typedef dhd_uint16_t dhd_reg_fb_byte_size_t; /* 14 bits used*/

/* Type FB_Line_Byte_Offset: Configurable width offset of a pixel relative to the start of the cache line in bytes.*/
typedef dhd_uint8_t dhd_reg_fb_line_byte_offset_t; /* 7 bits used*/

/* Type FB_Pitch: 13 bit unsigned framebuffer pitch*/
typedef dhd_uint16_t dhd_reg_fb_pitch_t; /* 13 bits used*/

/* Type FB_Size: 12 bit unsigned framebuffer width/height-1*/
typedef dhd_uint16_t dhd_reg_fb_size_t; /* 12 bits used*/

/* Type FB_Span_Length: Maximum length of a span for the framebuffer cache in pixels*/
typedef dhd_uint8_t dhd_reg_fb_span_length_t; /* 8 bits used*/

/* Type FB_Tag: Configurable width tag (identifier) of a cache line for the framebufer cache)*/
typedef dhd_uint32_t dhd_reg_fb_tag_t; /* 19 bits used*/

/* Type Filter_Kernel_Size: 4 bit unsigned texture filter kernel width/height-1 (in sub samples, i.e. texels)*/
typedef dhd_uint8_t dhd_reg_filter_kernel_size_t; /* 4 bits used*/

/* Type Float32: 32- bit float IEEE 754*/
typedef dhd_uint32_t dhd_reg_float32_t; /* 32 bits used*/

/* Type Inv_Swizzle_Num_Bits: Unsigned 4 bit number of bits per component used for inverse swizzling modes.*/
typedef dhd_uint8_t dhd_reg_inv_swizzle_num_bits_t; /* 4 bits used*/

/* Type Pass_Count: Unsigned number of color unit passes.*/
typedef dhd_uint8_t dhd_reg_pass_count_t; /* 3 bits used*/

/* Type Pass_ID: Unsigned index for the selection of a color unit pass.*/
typedef dhd_uint8_t dhd_reg_pass_id_t; /* 2 bits used*/

/* Type Pfc_Pipeline_Events: vector of event signals*/
typedef dhd_uint8_t dhd_reg_pfc_pipeline_events_t; /* 1 bits used*/

/* Type Pixel_Byte_Offset: 26 bit unsigned pixel offset relative to the start of the framebuffer resp. ZSA buffer in multiples of bytes*/
typedef dhd_uint32_t dhd_reg_pixel_byte_offset_t; /* 26 bits used*/

/* Type Pixel_Coord: 12 bit unsigned pixel x/y coordinate*/
typedef dhd_uint16_t dhd_reg_pixel_coord_t; /* 12 bits used*/

/* Type Psu_Bez_Aa: 1/width of anti-aliasing for Bezier curve or line (4.6 unsigned fixed point)*/
typedef dhd_uint16_t dhd_reg_psu_bez_aa_t; /* 10 bits used*/

/* Type Psu_Bez_Aa_Off: Offset to anti-aliasing value (4.4 signed fixed point)*/
typedef dhd_int8_t dhd_reg_psu_bez_aa_off_t; /* 8 bits used*/

/* Type Psu_Bez_Scale: Scaling of Limiter values for Bezier function*/
typedef dhd_uint8_t dhd_reg_psu_bez_scale_t; /* 6 bits used*/

/* Type Psu_Bez_Width: Bezier line width (4.4 unsigned fixed point)*/
typedef dhd_uint8_t dhd_reg_psu_bez_width_t; /* 8 bits used*/

/* Type Psu_Lim_Inc: Type of Limiter increment value: (2.18 fixed point)*/
typedef dhd_int32_t dhd_reg_psu_lim_inc_t; /* 20 bits used*/

/* Type Psu_Lim_Value: Type of Limiter value: (14.18 fixed point)*/
typedef dhd_int32_t dhd_reg_psu_lim_value_t; /* 32 bits used*/

/* Type Psu_Stripe: Type for stripe width and offset*/
typedef dhd_uint8_t dhd_reg_psu_stripe_t; /* 8 bits used*/

/* Type Ptr: 32-bit pointer*/
typedef dhd_uint32_t dhd_reg_ptr_t; /* 32 bits used*/

/* Type Reg_Offset: Unsigned 12 bit register offset*/
typedef dhd_uint16_t dhd_reg_reg_offset_t; /* 12 bits used*/

/* Type Register_Group_Index: 6 bit unsigned index of a register group*/
typedef dhd_uint8_t dhd_reg_register_group_index_t; /* 6 bits used*/

/* Type STENCIL: Stencil value*/
typedef dhd_uint8_t dhd_reg_stencil_t; /* 8 bits used*/

/* Type Stc_Stream_Address: STC stream address*/
typedef dhd_uint32_t dhd_reg_stc_stream_address_t; /* 30 bits used*/

/* Type Str_Stack_Pointer: STR Call Stack Pointer*/
typedef dhd_uint8_t dhd_reg_str_stack_pointer_t; /* 2 bits used*/

/* Type Tex_Byte_Pitch: 15 bit unsigned texture pitch (in bytes)*/
typedef dhd_uint16_t dhd_reg_tex_byte_pitch_t; /* 15 bits used*/

/* Type Tex_Filter_Bias: 9 bit signed bias value for filter in TXP unit*/
typedef dhd_int16_t dhd_reg_tex_filter_bias_t; /* 9 bits used*/

/* Type Tex_Filter_Scale: 10 bit scale value for filter in TXP unit*/
typedef dhd_uint16_t dhd_reg_tex_filter_scale_t; /* 10 bits used*/

/* Type Tex_Filter_Shift: 6 bit signed shift value for filter in TXP unit*/
typedef dhd_int8_t dhd_reg_tex_filter_shift_t; /* 6 bits used*/

/* Type Tex_Pitch: 13 bit unsigned texture pitch*/
typedef dhd_uint16_t dhd_reg_tex_pitch_t; /* 13 bits used*/

/* Type Tex_Size: 13 bit unsigned texture size x/y*/
typedef dhd_uint16_t dhd_reg_tex_size_t; /* 13 bits used*/

/* Type Texel_Abs_Coord: 12 bit unsigned absolute (non-normalized, no fraction) texture coordinate*/
typedef dhd_uint16_t dhd_reg_texel_abs_coord_t; /* 12 bits used*/

/* Type Texel_Bit_Address: 35 bit unsigned absolute bit address of a pixel*/
typedef dhd_uint64_t dhd_reg_texel_bit_address_t; /* 35 bits used*/

/* Type Texel_Bit_Offset: 29 bit unsigned bit offset of a texel relative to the start of a texture*/
typedef dhd_uint32_t dhd_reg_texel_bit_offset_t; /* 29 bits used*/

/* Type Texel_Cache_Line_Offset: Texel offset inside a texture cache line: Word offset + byte selection + bit selection.*/
typedef dhd_uint16_t dhd_reg_texel_cache_line_offset_t; /* 10 bits used*/

/* Type Texel_Cache_Set_Line: Cache line a texel is placed in. Simple concatenation of the set and line selection bits.*/
typedef dhd_uint8_t dhd_reg_texel_cache_set_line_t; /* 3 bits used*/

/* Type Texel_Coord: 2 bit integer + 16 bit fractional signed fixed point u/v texture coordinate*/
typedef dhd_uint32_t dhd_reg_texel_coord_t; /* 18 bits used*/

/* Type Texel_Coord_Frac: 8 bit unsigned u/v fractional parts for filtering*/
typedef dhd_uint8_t dhd_reg_texel_coord_frac_t; /* 8 bits used*/

/* Type Texel_Coord_Increment: Float 32 increment (per screen pixel) of a texel coordinate*/
typedef dhd_uint32_t dhd_reg_texel_coord_increment_t; /* 32 bits used*/

/* Type Texel_Coord_Offset: Float 32 offset of a texel coordinate at the screen origin respectively at enumeration start*/
typedef dhd_uint32_t dhd_reg_texel_coord_offset_t; /* 32 bits used*/

/* Type Texel_Norm_Coord: 20 bit unsigned normalized texture coordinate in the range [0..1[*/
typedef dhd_uint32_t dhd_reg_texel_norm_coord_t; /* 20 bits used*/

/* Type Texel_Offset: 24 bit unsigned offset of a texel relative to the start of a texture*/
typedef dhd_uint32_t dhd_reg_texel_offset_t; /* 24 bits used*/

/* Type Texel_Start_Address: Start address of top-left texel of the texture in memory*/
typedef dhd_uint32_t dhd_reg_texel_start_address_t; /* 32 bits used*/

/* Type Texture_Cache_Line: Texture cache line selection. Bit slice from a texel offset.*/
typedef dhd_uint8_t dhd_reg_texture_cache_line_t; /* 2 bits used*/

/* Type Texture_Cache_Line_Offset: Offset of a texture cache line relative to the start of a texture. The width is calculated as the width of T_Texel_Bit_Offset minus the widths of the word, byte and bit selection parts.*/
typedef dhd_uint32_t dhd_reg_texture_cache_line_offset_t; /* 19 bits used*/

/* Type Texture_Cache_Replace_Count: Replace count for a texture cache line*/
typedef dhd_uint8_t dhd_reg_texture_cache_replace_count_t; /* 7 bits used*/

/* Type Texture_Cache_Set: Texture cache set selection. Bits slice from a texel offset*/
typedef dhd_uint8_t dhd_reg_texture_cache_set_t; /* 1 bits used*/

/* Type Texture_Cache_Tag: Texture cache tag. Texture ID and MSB bits of a texel bit offset concatenated.*/
typedef dhd_uint32_t dhd_reg_texture_cache_tag_t; /* 18 bits used*/

/* Type Texture_Cache_Word_Bit_Offset: Texture cache bit offset inside a cache word. Bit slice from a texel offset.*/
typedef dhd_uint8_t dhd_reg_texture_cache_word_bit_offset_t; /* 7 bits used*/

/* Type Texture_Cache_Word_Offset: Texture cache word offset inside a cache line. Bit slice from a texel offset.*/
typedef dhd_uint8_t dhd_reg_texture_cache_word_offset_t; /* 3 bits used*/

/* Type Texture_Count: Unsigned number of active texture units.*/
typedef dhd_uint8_t dhd_reg_texture_count_t; /* 2 bits used*/

/* Type Texture_ID: Unsigned index for the selection of a texture unit.*/
typedef dhd_uint8_t dhd_reg_texture_id_t; /* 1 bits used*/

/* Type Txp_Clut_Entry: CLUT entry*/
typedef dhd_uint32_t dhd_reg_txp_clut_entry_t; /* 32 bits used*/

/* Type Txp_Clut_Offset: Offset into CLUT*/
typedef dhd_uint16_t dhd_reg_txp_clut_offset_t; /* 9 bits used*/

/* Type Uint1: 1- bit unsigned integer*/
typedef dhd_uint8_t dhd_reg_uint1_t; /* 1 bits used*/

/* Type Uint12: 12- bit unsigned integer*/
typedef dhd_uint16_t dhd_reg_uint12_t; /* 12 bits used*/

/* Type Uint16: 16- bit unsigned integer*/
typedef dhd_uint16_t dhd_reg_uint16_t; /* 16 bits used*/

/* Type Uint2: 2- bit unsigned integer*/
typedef dhd_uint8_t dhd_reg_uint2_t; /* 2 bits used*/

/* Type Uint3: 3- bit unsigned integer*/
typedef dhd_uint8_t dhd_reg_uint3_t; /* 3 bits used*/

/* Type Uint32: 32- bit unsigned integer*/
typedef dhd_uint32_t dhd_reg_uint32_t; /* 32 bits used*/

/* Type Uint4: 4- bit unsigned integer*/
typedef dhd_uint8_t dhd_reg_uint4_t; /* 4 bits used*/

/* Type Uint8: 8- bit unsigned integer*/
typedef dhd_uint8_t dhd_reg_uint8_t; /* 8 bits used*/

/* Type ZSA_Byte_Offset: 26 bit unsigned ZSA entry offset relative to the start of the ZSA cache in multiples of bytes*/
typedef dhd_uint32_t dhd_reg_zsa_byte_offset_t; /* 26 bits used*/

/* Type ZSA_Line_Byte_Offset: Configurable width offset of a ZSA entry relative to the start of the cache line in bytes.*/
typedef dhd_uint8_t dhd_reg_zsa_line_byte_offset_t; /* 7 bits used*/

/* Type ZSA_Pitch: 13 bit unsigned ZSA pitch*/
typedef dhd_uint16_t dhd_reg_zsa_pitch_t; /* 13 bits used*/

/* Type ZSA_Span_Length: Maximum length of a span for the ZSA cache in pixels*/
typedef dhd_uint8_t dhd_reg_zsa_span_length_t; /* 8 bits used*/

/* Type ZSA_Tag: Configurable width tag (identifier) of a cache line for the ZSA cache)*/
typedef dhd_uint32_t dhd_reg_zsa_tag_t; /* 19 bits used*/

/* Type mbi_burstcount: Burst count signal on MBI*/
typedef dhd_uint8_t dhd_reg_mbi_burstcount_t; /* 3 bits used*/

/* Type mbi_byteenable: Byte enable mask for write data on MBI*/
typedef dhd_uint16_t dhd_reg_mbi_byteenable_t; /* 16 bits used*/

/*-------------------------------------------------------------------------*/

/* Busy_Vector layout ( Struct of T_Bool containing the ored busy signals of groups of modules )*/
typedef union tagdhd_busy_vector_t {
  struct tagdhd_busy_vector_decomp_fields_t {
    dhd_uint32_t stc     : 1;   /* Stream controller busy*/
    dhd_uint32_t str     : 1;   /* Stream reader busy*/
    dhd_uint32_t stw     : 1;   /* Stream writer busy*/
    dhd_uint32_t reg     : 1;   /* Register file busy*/
    dhd_uint32_t psu     : 1;   /* Pixel selection busy*/
    dhd_uint32_t txi     : 1;   /* Modules after PSU, up to ZSS busy*/
    dhd_uint32_t tex     : 1;   /* Modules after ZSS, up to TXS busy*/
    dhd_uint32_t col     : 1;   /* Modules after TXS, up to FBS busy*/
    dhd_uint32_t blend   : 1;   /* Modules after FBS, up to FBC busy*/
    dhd_uint32_t clear   : 1;   /* Clear unit busy*/
    dhd_uint32_t unused  : 22;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_busy_vector_decomp_t;

/* FB_Read_Flags layout ( Struct of flags to generate FB read decision )*/
typedef union tagdhd_fb_read_flags_t {
  struct tagdhd_fb_read_flags_decomp_fields_t {
    dhd_uint32_t alpha_not_one     : 1;   /* Read when pixel alpha != 1.0*/
    dhd_uint32_t alpha_not_zero    : 1;   /* Read when pixel alpha != 0.0*/
    dhd_uint32_t coverage_not_one  : 1;   /* Read when coverage != 1.0*/
    dhd_uint32_t unused            : 29;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_fb_read_flags_decomp_t;

/* Psu_Bez_Control layout ( Struct for Bezier function Control )*/
typedef union tagdhd_psu_bez_control_t {
  struct tagdhd_psu_bez_control_decomp_fields_t {
    dhd_uint32_t enable   : 1;   /* enable Bezier function*/
    dhd_uint32_t concave  : 1;   /* concave Bezier element*/
    dhd_uint32_t unused   : 30;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_psu_bez_control_decomp_t;

/* Psu_Lim_Control layout ( Struct for Limiter Control )*/
typedef union tagdhd_psu_lim_control_t {
  struct tagdhd_psu_lim_control_decomp_fields_t {
    dhd_uint32_t enable       : 1;   /* enable limiter*/
    dhd_uint32_t shared_edge  : 1;   /* shared edges; 1 = no anti-aliasing*/
    dhd_uint32_t use_enum     : 1;   /* use for enumeration; a Limiter can be used for Bezier function only*/
    dhd_uint32_t invert       : 1;   /* invert Limiter; reuse dx and dy inverted*/
    dhd_uint32_t unused       : 28;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_psu_lim_control_decomp_t;

/* Psu_Lim_Eval layout ( Struct for Limiter Evaluation output )*/
typedef union tagdhd_psu_lim_eval_t {
  struct tagdhd_psu_lim_eval_decomp_fields_t {
    dhd_uint32_t hitt    : 1;   /* true if Limiter value of position above is >= 0*/
    dhd_uint32_t hitb    : 1;   /* true if Limiter value of position below is >= 0*/
    dhd_uint32_t hitr    : 1;   /* true if Limiter value of position right is >= 0*/
    dhd_uint32_t hit     : 1;   /* true if Limiter value of current position is >= 0*/
    dhd_uint32_t be      : 1;   /* true if edge is a bottom edge*/
    dhd_uint32_t re      : 1;   /* true if edge is a right edge*/
    dhd_uint32_t unused  : 26;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_psu_lim_eval_decomp_t;

/* Psu_Store_Flags layout ( Struct for enumeration store signals )*/
typedef union tagdhd_psu_store_flags_t {
  struct tagdhd_psu_store_flags_decomp_fields_t {
    dhd_uint32_t store_up     : 1;   /* store to upward regiser*/
    dhd_uint32_t store_down   : 1;   /* store to downward regiser*/
    dhd_uint32_t store_ahead  : 1;   /* store to ahead regiser*/
    dhd_uint32_t unused       : 29;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_psu_store_flags_decomp_t;

/* S0A8Z0 layout ( Depth/Stencil/Alpha-Buffer with 8 Bits (Alpha: Bit 7-0) )*/
typedef union tagdhd_s0a8z0_t {
  struct tagdhd_s0a8z0_decomp_fields_t {
    dhd_uint32_t alpha_buffer  : 8;   /* 8-Bit Alpha-Buffer*/
    dhd_uint32_t unused        : 24;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s0a8z0_decomp_t;

/* S1A0Z15 layout ( Depth/Stencil-Buffer with 16 Bits (Stencil: Bit 15, Depth: Bits 14-0) )*/
typedef union tagdhd_s1a0z15_t {
  struct tagdhd_s1a0z15_decomp_fields_t {
    dhd_uint32_t z_buffer        : 15;  /* 15-Bit Z-Buffer*/
    dhd_uint32_t stencil_buffer  : 1;   /* 1-Bit Stencil-Buffer*/
    dhd_uint32_t unused          : 16;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s1a0z15_decomp_t;

/* S1A5Z10 layout ( Depth/Stencil/Alpha-Buffer with 16 Bits (Stencil: Bit 15, Alpha: Bits 14-10, Depth: Bits 9-0) )*/
typedef union tagdhd_s1a5z10_t {
  struct tagdhd_s1a5z10_decomp_fields_t {
    dhd_uint32_t z_buffer        : 10;  /* 10-Bit Z-Buffer*/
    dhd_uint32_t alpha_buffer    : 5;   /* 5-Bit Alpha-Buffer*/
    dhd_uint32_t stencil_buffer  : 1;   /* 1-Bit Stencil-Buffer*/
    dhd_uint32_t unused          : 16;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s1a5z10_decomp_t;

/* S1A7Z0 layout ( Depth/Stencil/Alpha-Buffer with 8 Bits (Stencil: Bit 7, Alpha: Bits 6-0) )*/
typedef union tagdhd_s1a7z0_t {
  struct tagdhd_s1a7z0_decomp_fields_t {
    dhd_uint32_t alpha_buffer    : 7;   /* 7-Bit Alpha-Buffer*/
    dhd_uint32_t stencil_buffer  : 1;   /* 1-Bit Stencil-Buffer*/
    dhd_uint32_t unused          : 24;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s1a7z0_decomp_t;

/* S8A0Z0 layout ( Depth/Stencil/Alpha-Buffer with 8 Bits (Stencil: Bit 7-0) )*/
typedef union tagdhd_s8a0z0_t {
  struct tagdhd_s8a0z0_decomp_fields_t {
    dhd_uint32_t stencil_buffer  : 8;   /* 8-Bit Stencil-Buffer*/
    dhd_uint32_t unused          : 24;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s8a0z0_decomp_t;

/* S8A0Z24 layout ( Depth/Stencil-Buffer with 32 Bits (Stencil: Bits 31-24, Depth: Bits 23-0) )*/
typedef union tagdhd_s8a0z24_t {
  struct tagdhd_s8a0z24_decomp_fields_t {
    dhd_uint32_t z_buffer        : 24;  /* 24-Bit Z-Buffer*/
    dhd_uint32_t stencil_buffer  : 8;   /* 8-Bit Stencil-Buffer*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s8a0z24_decomp_t;

/* S8A8Z0 layout ( Stencil/Alpha-Buffer with 16 Bits (Stencil: Bits 15-8, Alpha: Bits 7-0) )*/
typedef union tagdhd_s8a8z0_t {
  struct tagdhd_s8a8z0_decomp_fields_t {
    dhd_uint32_t alpha_buffer    : 8;   /* 8-Bit Alpha-Buffer*/
    dhd_uint32_t stencil_buffer  : 8;   /* 8-Bit Stencil-Buffer*/
    dhd_uint32_t unused          : 16;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s8a8z0_decomp_t;

/* S8A8Z16 layout ( Depth/Stencil/Alpha-Buffer with 32 Bits (Stencil: Bits 31-24, Alpha: Bits 23-16, Depth: Bits 15-0) )*/
typedef union tagdhd_s8a8z16_t {
  struct tagdhd_s8a8z16_decomp_fields_t {
    dhd_uint32_t z_buffer        : 16;  /* 16-Bit Z-Buffer*/
    dhd_uint32_t alpha_buffer    : 8;   /* 8-Bit Alpha-Buffer*/
    dhd_uint32_t stencil_buffer  : 8;   /* 8-Bit Stencil-Buffer*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_s8a8z16_decomp_t;

/* Str_Stack layout ( Struct of addresses for STC )*/
typedef union tagdhd_str_stack_t {
  struct tagdhd_str_stack_decomp_fields_t {
    dhd_uint64_t return_address  : 32;  /* return address to calling stream*/
    dhd_uint64_t end_address     : 32;  /* end address of (sub-)stream*/
  } m_fields;
  dhd_uint64_t m_value;
} dhd_str_stack_decomp_t;

/* Texel_Coord_Flags layout ( Struct of wrap flags )*/
typedef union tagdhd_texel_coord_flags_t {
  struct tagdhd_texel_coord_flags_decomp_fields_t {
    dhd_uint32_t overflow   : 1;   /* overflow, clamp to max*/
    dhd_uint32_t underflow  : 1;   /* underflow, clamp to zero*/
    dhd_uint32_t mod2       : 1;   /* texture tile is mirrored*/
    dhd_uint32_t unused     : 29;  /* unused bits*/
  } m_fields;
  dhd_uint32_t m_value;
} dhd_texel_coord_flags_decomp_t;

#endif /*DAVEHD_REGISTERTYPES_H_INCLUDED*/
  
