#ifndef KEY_H__
#define KEY_H__

#include "TYW_stdint.h"

/*
说明：
1、按键类型分为两类：
    1）CAN按键。
    2）单纯硬线按键，AD按键。
2、按键触发时间：
1）短按动作在抬手时触发、
2）长按动作(或超长按)在时间达到，按住时就可触发。
3）OFF到ON（或ON到OFF）在各个电源状态时按键按下时间满足后即可触发，不必抬手。

*/
/*所有按键枚举，目前最多支持8个按键*/
typedef enum
{
    KEY_UP   = 0U,
    KEY_DOWN,
    KEY_ENTER,
    KEY_RETURN,
    KEY_MENU,
    KEY_ODOTRIP,
    KEY_NUM_MAX,

} Key_Num_en_t;

/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
typedef enum
{
    // KEY_TYPE_CAN = 0U, /*CAN按键。按键不需要消抖*/
    // KEY_TYPE_LINE,      /*硬线按键，包含AD按键。按键需要消抖*/

    /*按键检测方式选择*/
    KEY_NO_DEBOUNCE_RISE = 0U, /*按键不需要消抖，并且在无效状态切换到有效状态的上升沿触发按键动作*/
    KEY_NO_DEBOUNCE_FALL,      /*按键不需要消抖，并且在有效状态切换到无效状态的下降沿触发按键动作*/

    KEY_NEED_DEBOUNCE_NORMAL, /*按键需要消抖，短按松手触发，长按，超超按，按住即可触发*/

    KEY_TYPE_MAX,
} Key_Type_en_t;

/*按键相关设置返回状态*/
typedef enum
{
    KEY_SET_OK = 0U,
    KEY_SET_ERROR,

    KEY_SET_MAX,
} Key_Set_en_t;
/*按键IG状态*/
typedef enum
{
    KEY_IG_INVALID = 0U,
    KEY_IG_OFF,
    KEY_IG_ON,

} Key_IGN_en_t;
/*-----实时传入的键值--------*/
typedef enum
{

    KEY_CAN_NONE = 0U,              /*CAN按键时，按键无动作*/
    KEY_CAN_SHORT_PRESS,            /*CAN按键时，按键短按动作*/
    KEY_CAN_LONG_PRESS,             /*CAN按键时，按键长按动作*/
    KEY_CAN_LONG_PRESS_NOT_RELEASE, /*CAN按键时，按键长按不松手动作，触发动作超长按*/

    KEY_LINE_PRESS,  /*硬线按键时，按键按下*/
    KEY_LINE_LOOSEN, /*硬线按键时，按键松开*/

    KEY_REAL_STATUS_MAX,

} Key_Real_Status_en_t;
/*按键支持的具体动作*/
typedef enum
{
    KEY_EVENT_NONE = 0U,
    KEY_EVENT_SHORT_PRESS,
    KEY_EVENT_LONG_PRESS,
    KEY_EVENT_SUPER_LONG_PRESS,
    KEY_EVENT_OFF_TO_ON,
    KEY_EVENT_ON_TO_OFF,

    KEY_EVENT_MAX,

} Key_Event_en_t;

typedef struct
{
    uint32_t u32KeyRAMAddr; /* 数据缓冲地址 */
    uint16_t u16KeyRAMLen;  /* 数据缓冲大小：以uint32_t为单位*/
} Key_RAM_Attribute_st_t;

typedef Key_Real_Status_en_t (*Key_Real_Status_Read)(void);
typedef void (*Key_Operation)(Key_Event_en_t enKeyEvent);

/*每个按键的属性*/
typedef struct
{
    /*按键类型，是CAN的还是硬线的*/
    Key_Type_en_t enKeyType;
    /*获取按键实时状态的回调函数*/
    Key_Real_Status_Read pfnKeyReadStatusCallBack;
    /*按键触发动作的回调函数*/
    Key_Operation pfnKeyOperationCallBack;

} Key_Attribute_st_t;

/*--------------------------------------------------------------------------------------------*/
extern const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX];

/*------------------------------------------------------------------------------------*/

/*10ms调用一次*/
extern void Key_Service(void);
/*首次上电时调用一次即可*/
extern void Key_Init(void);
/*对于硬线按键而言，判断短按的时间参数*/
extern Key_Set_en_t Key_Parameter_Set_Short_Press_Time(uint16_t u16Time);
/*对于硬线按键而言，判断长按的时间参数*/
extern Key_Set_en_t Key_Parameter_Set_Long_Press_Time(uint16_t u16Time);
/*对于硬线按键而言，判断超长按的时间参数*/
extern Key_Set_en_t Key_Parameter_Set_Super_Long_Press_Time(uint16_t u16Time);
/*获取IG状态*/
extern Key_IGN_en_t Key_Get_IGN_Status(void);

extern uint8_t Common_Get_RetMenu_Flag(void);

#endif