#include "UDS_2FService_Main.h"

/**
  *2F服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_2F_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC11();                                            /*2F服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC7F();                                            /*2F服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC13_MinLengthCheck();                             /*2F服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC31();                                            /*2F服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC13_TotalLengthCheck();                           /*2F服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC33();                                            /*2F服务解锁等级验证*/
    }    
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC22();                                            /*2F服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_SubParameter_NRC31();                               /*2F服务条件验证*/
    }    
    if(NRC == positiveResponse)
    {
        UDS_2FService_DID();                                                   /*2F服务DID判断*/
    }
    clearDiagMSG();                                                            /*清除诊断信息*/
}

/**
  *2F服务子功能
  */
void UDS_2FService_DID(void)
{
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*2F服务DID判断*/
    {
      case 0x6048u:
        UDS_2FService_DID_6048();
      break;
      case 0x6091u:
        UDS_2FService_DID_6091();
      break;
      case 0x6046u:
        UDS_2FService_DID_6046();
      break;
      case 0x6040u:
        UDS_2FService_DID_6040();
      break;
      case 0x6092u:
        UDS_2FService_DID_6092();  
      break;
      case 0x6020u:
        UDS_2FService_DID_6020();
      break;
      case 0x6093u:
        UDS_2FService_DID_6093();
      break;
      case 0x6021u:
        UDS_2FService_DID_6021();
      break;
      case 0x6094u:
        UDS_2FService_DID_6094();
      break;
      case 0x601Bu:
        UDS_2FService_DID_601B();
      break;
      case 0x601Cu:
        UDS_2FService_DID_601C();
      break;
      case 0x601Du:
        UDS_2FService_DID_601D();
      break;
      case 0x601Eu:
        UDS_2FService_DID_601E();
      break;
      case 0x6038u:
        UDS_2FService_DID_6038();
      break;
      case 0x601Au:
        UDS_2FService_DID_601A();
      break;
      case 0x6095u:
        UDS_2FService_DID_6095();
      break;
      case 0x6024u:
        UDS_2FService_DID_6024();
      break;
      case 0x6025u:
        UDS_2FService_DID_6025();
      break;
      case 0x603Du:
        UDS_2FService_DID_603D();
      break;
      case 0x6035u:
        UDS_2FService_DID_6035();
      break;
      case 0x6036u:
        UDS_2FService_DID_6036();
      break;
      case 0x6034u:
        UDS_2FService_DID_6034();
      break;
      case 0x6028u:
        UDS_2FService_DID_6028();
      break;
      case 0x6090u:
        UDS_2FService_DID_6090();
      break;
      //case 0x6091u:
     // break;
      case 0x6037u:
        UDS_2FService_DID_6037();
      break;
    //  case 0x6092u:
    //  break;
    //  case 0x6093u:
    //  break;
      case 0x6022u:
        UDS_2FService_DID_6022();
      break;
      case 0x601Fu:
        UDS_2FService_DID_601F();
      break;
      //case 0x6094u:
     // break;
      //case 0x6095u:
      //break;
      case 0x6096u:
        UDS_2FService_DID_6096();
      break;
      case 0x6097u:
        UDS_2FService_DID_6097();
      break;
      case 0x6098u:
        UDS_2FService_DID_6098();
      break;
      case 0x603Bu:
        UDS_2FService_DID_603B();
      break;
      case 0x6018u:
        UDS_2FService_DID_6018();
      break;
      case 0x6099u:
        UDS_2FService_DID_6099();
      break;
      case 0x609Au:
        UDS_2FService_DID_609A();
      break;
      case 0x604Bu:
        UDS_2FService_DID_604B();
      break;
      case 0x609Bu:
        UDS_2FService_DID_609B();
      break;
      case 0x6047u:
        UDS_2FService_DID_6047();
      break;
      case 0x6026u:
        UDS_2FService_DID_6026();
      break;
      case 0x6030u:
        UDS_2FService_DID_6030();
      break;
      case 0x602Bu:
        UDS_2FService_DID_602B();
      break;
      case 0x609Cu:
        UDS_2FService_DID_609C();
      break;
      case 0x609Du:
        UDS_2FService_DID_609D();
      break;
      case 0x609Eu:
        UDS_2FService_DID_609E();
      break;
      case 0x609Fu:
        UDS_2FService_DID_609F();
      break;
      case 0x60A0u:
        UDS_2FService_DID_60A0();
      break;
      case 0x60A1u:
        UDS_2FService_DID_60A1();
      break;
      case 0x6051u:
        UDS_2FService_DID_6051();
      break;
      case 0x6052u:
        UDS_2FService_DID_6052();
      break;
      case 0x60A3u:
        UDS_2FService_DID_60A3();
      break;
      case 0x60A4u:
        UDS_2FService_DID_60A4();
      break;
      case 0x60A5u:
        UDS_2FService_DID_60A5();
      break;
      case 0x60A6u:
        UDS_2FService_DID_60A6();
      break;
      case 0x60A7u:
        UDS_2FService_DID_60A7();
      break;
      case 0x60A8u:
        UDS_2FService_DID_60A8();
      break;
      case 0x60A9u:
        UDS_2FService_DID_60A9();
      break;
      case 0x6043u:
        UDS_2FService_DID_6043();
      break;
      case 0x60ACu:
        UDS_2FService_DID_60AC();
      break;
      //case 0x6048u:
     // break;
      case 0x60ADu:
        UDS_2FService_DID_60AD();
      break;
      case 0x60AEu:
        UDS_2FService_DID_60AE();
      break;
      case 0x60AFu:
        UDS_2FService_DID_60AF();
      break;
      case 0x60B0u:
        UDS_2FService_DID_60B0();
      break;
      case 0x60B1u:
        UDS_2FService_DID_60B1();
      break;
      case 0x60B2u:
        UDS_2FService_DID_60B2();
      break;
      case 0x60B3u:
        UDS_2FService_DID_60B3();
      break;
      case 0x60B4u:
        UDS_2FService_DID_60B4();
      break;
      //case 0x60ACu:
      //break;
      case 0x60B5u:
        UDS_2FService_DID_60B5();
      break;
      case 0x60B6u:
        UDS_2FService_DID_60B6();
      break;
      case 0x60B7u:
        UDS_2FService_DID_60B7();
      break;
      case 0x60B8u:
        UDS_2FService_DID_60B8();
      break;
      case 0x60B9u:
        UDS_2FService_DID_60B9();
      break;
      case 0x60BAu:
        UDS_2FService_DID_60BA();
      break;
      case 0x60BBu:
        UDS_2FService_DID_60BB();
      break;
      case 0x60BCu:
        UDS_2FService_DID_60BC();
      break;
      case 0x60BDu:
        UDS_2FService_DID_60BD();
      break;
      case 0x60BEu:
        UDS_2FService_DID_60BE();
      break;
      case 0x60BFu:
        UDS_2FService_DID_60BF();
      break;
      case 0x60C0u:
        UDS_2FService_DID_60C0();
      break;
      case 0x60C1u:
        UDS_2FService_DID_60C1();
      break;
      case 0x60C2u:
        UDS_2FService_DID_60C2();
      break;
      case 0x60C3u:
        UDS_2FService_DID_60C3();
      break;
      case 0x60C4u:
        UDS_2FService_DID_60C4();
      break;
      case 0x60C5u:
        UDS_2FService_DID_60C5();
      break;
      case 0x60C6u:
        UDS_2FService_DID_60C6();
      break;
      case 0x60C7u:
        UDS_2FService_DID_60C7();
      break;
      //case 0x6048u:
      //break;
      case 0x6065u:
        UDS_2FService_DID_6065();
      break;
      case 0x6066u:
        UDS_2FService_DID_6066();
      break;
      case 0x606Au:
        UDS_2FService_DID_606A();
      break;
      case 0x606Bu:
        UDS_2FService_DID_606B();
      break;
      case 0x606Cu:
        UDS_2FService_DID_606C();
      break;
      case 0x6077u:
        UDS_2FService_DID_6077();
      break;
    }
}

/**
  *2F服务DID6048
  *ADR 工作异常指示灯(预留)
  */
void UDS_2FService_DID_6048(void)
{
    Ab_ADRWorking(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6091
  *蓄电池充电指示灯状态
  */
void UDS_2FService_DID_6091(void)
{
    BatteryCharging(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6046
  *OBD 报警灯状态
  */
void UDS_2FService_DID_6046(void)
{
    OBDAlarm(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6040
  *主车 ABS 指示灯状态
  */
void UDS_2FService_DID_6040(void)
{
    M_ABSIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**zhucche 
  *2F服务DID6092
  *挂车 ABS 指示灯状态guache  
  */
void UDS_2FService_DID_6092(void)
{
    T_ABSIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6020
  *主车左转向指示灯
  */
void UDS_2FService_DID_6020(void)
{
    M_TurnLeft(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6093
  *挂车左转向指示灯
  */
void UDS_2FService_DID_6093(void)
{
    T_TurnLeft(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6021
  *主车右转向指示灯
  */
void UDS_2FService_DID_6021(void)
{
    M_TurnRight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6094
  *挂车右转向指示灯
  */
void UDS_2FService_DID_6094(void)
{
    T_TurnRight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID601B
  *远光灯
  */
void UDS_2FService_DID_601B(void)
{
    HighBeam(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID601C
  *前雾灯
  */
void UDS_2FService_DID_601C(void)
{
    FrontFog(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID601D
  *后雾灯
  */
void UDS_2FService_DID_601D(void)
{
    RearFog(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID601E
  *位置灯
  */
void UDS_2FService_DID_601E(void)
{
    PositionLight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6038
  *STOP 停车灯
  */
void UDS_2FService_DID_6038(void)
{
    StopLight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID601A
  *驻车制动指示灯
  */
void UDS_2FService_DID_601A(void)
{
    ParkingBrake(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6095
  *EDC 诊断指示灯
  */
void UDS_2FService_DID_6095(void)
{
    EDCLight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6024
  *定速巡航指示
  */
void UDS_2FService_DID_6024(void)
{
    CruiseControl(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6025
  *自适应巡航指示(预留)
  */
void UDS_2FService_DID_6025(void)
{
    IntelligentAdaptiveCruise(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID603D
  *安全带未系指示灯
  */
void UDS_2FService_DID_603D(void)
{
    SeatBelt(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6035
  *机油压力低指示灯
  */
void UDS_2FService_DID_6035(void)
{
    LowOilPressure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6036
  *制动气压低指示灯
  */
void UDS_2FService_DID_6036(void)
{
    LowBrakeAirPressure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6034
  *冷却液温度高指示灯(预留)
  */
void UDS_2FService_DID_6034(void)
{
    HighCoolantTemPerature(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6028
  *排气制动指示灯(预留)
  */
void UDS_2FService_DID_6028(void)
{
    ExhaustBrake(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6090
  *辅助制动 1 档指示灯(预留)
  */
void UDS_2FService_DID_6090(void)
{
    AuxiliaryBrake_1(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6091
  *辅助制动 2 档指示灯(预留)
  */
/*
void UDS_2FService_DID_6091(void)
{
    AuxiliaryBrake_2(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
*/
/**
  *2F服务DID6037
  *燃油油量低指示灯(预留)
  */
void UDS_2FService_DID_6037(void)
{
    LowFuelOil(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6092
  *维修指示灯(预留)
  */
/*
void UDS_2FService_DID_6092(void)
{
    ServiceIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
*/
/**
  *2F服务DID6093
  *变速箱低档指示灯(预留)
  */
/*
void UDS_2FService_DID_6093(void)
{
    GearboxLow(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
*/
/**
  *2F服务DID6022
  *ASR 指示灯(预留)
  */
void UDS_2FService_DID_6022(void)
{
    ASRIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID601F
  *日间行车灯(预留)
  */
void UDS_2FService_DID_601F(void)
{
    DaytimeDriving(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6094
  *遥控钥匙电量低指示灯(预留)
  */
/*
void UDS_2FService_DID_6094(void)
{
    LowBatteryOfKey(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
*/
/**
  *2F服务DID6095
  *发动机防盗指示灯(预留)
  */
/*
void UDS_2FService_DID_6095(void)
{
    EngineAntiTheft(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
*/
/**
  *2F服务DID6096
  *驾驶室翻转指示灯(预留)
  */
void UDS_2FService_DID_6096(void)
{
    CabFlip(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6097
  *车厢举升指示灯(预留)
  */
void UDS_2FService_DID_6097(void)
{
    CarLift(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6098
  *冷却液位低指示灯(预留)
  */
void UDS_2FService_DID_6098(void)
{
    LowCoolantLevel(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID603B
  *EDC 维修指示灯(预留)
  */
void UDS_2FService_DID_603B(void)
{
    EDCRepair(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6018
  *尿素液位低指示灯(预留)
  */
void UDS_2FService_DID_6018(void)
{
    LowUreaLevel(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6099
  *胎压报警指示灯(预留)
  */
void UDS_2FService_DID_6099(void)
{
    TirePressureAlarm(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID609A
  *盘式制动器磨损盘式制动器磨损v指示灯(预留)
  */
void UDS_2FService_DID_609A(void)
{
    DiscBrakeWear(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID604B
  *缓速器故障指示灯(预留)
  */
void UDS_2FService_DID_604B(void)
{
    RetarderFailure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID609B
  *变速箱故障指示灯(预留)
  */
void UDS_2FService_DID_609B(void)
{
    GearboxFailure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6047
  *ECAS 故障指示灯
  */
void UDS_2FService_DID_6047(void)
{
    ECASFailure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6026
  *ECAS 工作指示灯(预留)
  */
void UDS_2FService_DID_6026(void)
{
    ECASIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6030
  *缓速器工作指示灯(预留)
  */
void UDS_2FService_DID_6030(void)
{
    RetarderIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID602B
  *轮差速锁工作指示灯(预留)
  */
void UDS_2FService_DID_602B(void)
{
    WheelDifferentialLock(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID609C
  *浮动桥指示灯(预留)
  */
void UDS_2FService_DID_609C(void)
{
    FloatingBridgeIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID609CD
  *变速箱油温高指示灯(预留)
  */
void UDS_2FService_DID_609D(void)
{
    HighGearboxOil(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID609E
  *停车取力指示灯(预留)
  */
void UDS_2FService_DID_609E(void)
{
    ParkingPower(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID609F
  *空滤器阻塞指示灯(预留)
  */
void UDS_2FService_DID_609F(void)
{
    AirFilterBlocked(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A0
  *行车取力指示灯(预留)
  */
void UDS_2FService_DID_60A0(void)
{
    DrivingPower(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A1
  *分动器高档指示灯(预留)
  */
void UDS_2FService_DID_60A1(void)
{
    SplitterHigh_end (DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6051
  *主驾侧门开关状态信号(预留)
  */
void UDS_2FService_DID_6051(void)
{
    DriverDoorSwitch_St(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6052
  *副驾侧门开关状态信号(预留)
  */
void UDS_2FService_DID_6052(void)
{
    CoDriverDoorSwitch_ST(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u
    , DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A3
  *自适应前照工作灯(预留)
  */
void UDS_2FService_DID_60A3(void)
{
    AdaptiveFrontWorkingLight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A4
  *自适应前照报警灯(预留)
  */
void UDS_2FService_DID_60A4(void)
{
    AdaptiveFrontAlarmLight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A5
  *坡道辅助提示指示灯(预留)
  */
void UDS_2FService_DID_60A5(void)
{
    RampAssistTips(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A6
  *ACC 巡航指示灯(预留)
  */
void UDS_2FService_DID_60A6(void)
{
    ACCCruiseIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A7
  *ACC 巡航故障指示灯(预留)
  */
void UDS_2FService_DID_60A7(void)
{
    ACCCruiseFaultIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A8
  *全轮驱动指示灯(预留)
  */
void UDS_2FService_DID_60A8(void)
{
    AllWheelDriveIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60A9
  *整车信息指示灯(预留)
  */
void UDS_2FService_DID_60A9(void)
{
    VehicleInformation(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6043
  *碰撞报警指示灯(预留)
  */
void UDS_2FService_DID_6043(void)
{
    CollisionAlarm(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60AC
  *燃气泄漏报警指示灯(预留)
  */
void UDS_2FService_DID_60AC(void)
{
    GasLeakIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6048
  *ADR 工作异常指示灯(预留)
  */
/*
void UDS_2FService_DID_6048(void)
{
    Ab_ADRIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
*/
/**
  *2F服务DID60AD
  *前轮轮间差速锁指示灯(预留)
  */
void UDS_2FService_DID_60AD(void)
{
    FrontWheelsLocking(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60AE
  *EBS 红灯(预留)
  */
void UDS_2FService_DID_60AE(void)
{
    EBSRedLight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60AF
  *EBS 黄灯(预留)
  */
void UDS_2FService_DID_60AF(void)
{
    EBSYellowLight(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B0
  *喷淋壶液位低(预留)
  */
void UDS_2FService_DID_60B0(void)
{
    LowLevelOfSprayPot(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B1
  *助力转向报警(预留)
  */
void UDS_2FService_DID_60B1(void)
{
    PowerSteeringAlarm(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B2
  *自动驻车状态指示灯(预留)
  */
void UDS_2FService_DID_60B2(void)
{
    AutomaticParking_ST(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B3
  *驻车独立制动状态指示灯(预留)
  */
void UDS_2FService_DID_60B3(void)
{
    IndependentAutomaticParking_ST(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B4
  *负载转移指示灯(预留)
  */
void UDS_2FService_DID_60B4(void)
{
    LoadTransfer(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B5
  *柴油粒子过滤器再生禁止状态/ DPF 再生禁止灯(预留)
  */
void UDS_2FService_DID_60B5(void)
{
    DPFReproductionProhibited(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B6
  *超速报警指示灯/TSR 工作状态指示灯(预留)
  */
void UDS_2FService_DID_60B6(void)
{
    SpeedingAlarm(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B7
  *行人碰撞报警灯(预留)
  */
void UDS_2FService_DID_60B7(void)
{
    PedestrianCollision(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B8
  *TSR 目标车速限制(预留)
  */
void UDS_2FService_DID_60B8(void)
{
    TSRIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60B9
  *高级辅助驾驶状态指示灯
  */
void UDS_2FService_DID_60B9(void)
{
    AdvancedAssistedDriving_ST(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60BA
  *SVS 指示灯(预留)
  */
void UDS_2FService_DID_60BA(void)
{
    SVSIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60BB
  *NCD 指示灯(预留)
  */
void UDS_2FService_DID_60BB(void)
{
    NCDIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60BC
  *IHC 工作状态指示灯(预留)
  */
void UDS_2FService_DID_60BC(void)
{
    IHCWorkingIndicator(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60BD
  *动力电池系统故障指示灯(预留)
  */
void UDS_2FService_DID_60BD(void)
{
    PowerBatterySystemFailure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60BE
  *驱动电机故障指示灯(预留)
  */
void UDS_2FService_DID_60BE(void)
{
    DriveMotorFailure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60BF
  *绝缘电阻过低报警指示灯(预留)
  */
void UDS_2FService_DID_60BF(void)
{
    LowResistance(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C0
  *动力电池切断指示灯(预留)
  */
void UDS_2FService_DID_60C0(void)
{
    BreakPowerBattery(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C1
  *高压上电指示灯(预留)
  */
void UDS_2FService_DID_60C1(void)
{
    HighVoltagePowerUp(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C2
  *驱动限功率状态指示灯(预留)
  */
void UDS_2FService_DID_60C2(void)
{
    DriveLimitedPower_ST(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C3
  *驱动系统就绪指示灯(预留)
  */
void UDS_2FService_DID_60C3(void)
{
    DriveSystemReady(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C4
  *SOC 容量过低指示灯(预留)
  */
void UDS_2FService_DID_60C4(void)
{
    SOCCapacityTooLow(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C5
  *动力电池充电状态指示灯(预留)
  */
void UDS_2FService_DID_60C5(void)
{
    PowerBatteryCharging(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C6
  *外部充电线连接指示灯(预留)
  */
void UDS_2FService_DID_60C6(void)
{
    ExChargingCableConnect(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID60C7
  *车辆低速警示音关闭指示灯(预留)
  */
void UDS_2FService_DID_60C7(void)
{
    OffLowSpeedAlarm(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6048
  *离合器故障报警灯(预留)
  */
/*
void UDS_2FService_DID_6048(void)
{
    ClutchFailure(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
*/
/**
  *2F服务DID6065
  *气量（LNG）
  */
void UDS_2FService_DID_6065(void)
{
    AirVolume_LNG(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6066
  *气量（CNG）
  */
void UDS_2FService_DID_6066(void)
{
    AirVolume_CNG(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID606A
  *背光检测
  */
void UDS_2FService_DID_606A(void)
{
    BackLightTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID606B
  *LCD 测试
  */
void UDS_2FService_DID_606B(void)
{
    LCDTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID606C
  *声音测试
  */
void UDS_2FService_DID_606C(void)
{
    SoundTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID6077
  *重新计算仪表综合油耗（注：仪表重新计算当前油耗和综合油耗）
  */
void UDS_2FService_DID_6077(void)
{
    RecaculateFuelConsumption(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
