#include "Speed_PPK_Out.h"
#include "RTE_PWM_OUT.h"
#include "Common_Interface.h"
#include "Data_VehicleSpeed.h"
#include "GaugesInterface.h"

#define Speed_Clock 64453u  /*PWM时钟512分频之后*/

uint16_t Speed_PPK_Calc(uint16_t V_Speed, uint16_t m_PPK)
{
    uint32_t Frequency;
    Frequency = (uint32_t)V_Speed / 10u;
    Frequency = (uint32_t)(Frequency * m_PPK);
    Frequency = Frequency / 3600u;
    return (uint16_t)Frequency;
}

void Speed_PPK_Processing(void)
{
    uint16_t Frequency;
    //uint16_t m_Clock;
    //uint16_t m_Duty;
    uint32_t PPK ;

    PPK = Get_Speed_PPK();
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (Common_Get_Act_V_Speed_Valid() == 1u)
        {
            //Frequency = Speed_PPK_Calc(Common_Get_Act_V_Speed(), PPK);
            Frequency = Cal_Veh_Frequency();
        }
        else
        {
            Frequency = 0u;
        }
    }
    else
    {
        Frequency = 0u;
    }
/*    
    if (Frequency == 0u)
    {
        Frequency = 0u;
    }
    else if (Frequency >= 1u)
    {
        Frequency = Frequency;
    }
    else
    {
        Frequency = 1u;
    }
    if (Frequency != 0u)
    {
        m_Clock = Speed_Clock / Frequency;
        m_Duty = m_Clock / 2u;
    }
    else
    {
        m_Clock = 0u;
        m_Duty = 0u;
    }
*/

    RTE_PWM_Set_Speed_Out(Frequency, 500);
}