#include "AlarmGeneralFilie.h"

/*报警提示信息状态数据表1*/
uint8_t Alarm_Status[100]; /*[0]数据不使用,其它数组序号对应报警编号
                            [i] bit0:=1 对应的报警已发生,=0对应的报警已取消  (与报警请求表和队列同步)
                            [i] bit1:=1 表示已完成nS的文字报警显示(2S或4S)   (完成第一次报警显示)
                            [i] bit2:=1 表示报警在循环显示队列中
                            [i] bit3:=0 表示当前报警是第1次显示, =1 表示当前报警是非第1次显示
                            [i] bit4:=1 表示对应编号的声音报警已经完成
                            [i] bit5:=1 表示对应编号的声音报警触发过
                            [i] bit6:
                            [i] bit7:=1表示在行车电脑界面显示过(新加)*/

uint8_t g_PowerSt;
const uint8_t OSUnMapTbl[256] =
{
    0u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x00 to 0x0F                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x10 to 0x1F                             */
    5u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x20 to 0x2F                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x30 to 0x3F                             */
    6u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x40 to 0x4F                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x50 to 0x5F                             */
    5u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x60 to 0x6F                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x70 to 0x7F                             */
    7u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x80 to 0x8F                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0x90 to 0x9F                             */
    5u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0xA0 to 0xAF                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0xB0 to 0xBF                             */
    6u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0xC0 to 0xCF                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0xD0 to 0xDF                             */
    5u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, /* 0xE0 to 0xEF                             */
    4u, 0u, 1u, 0u, 2u, 0u, 1u, 0u, 3u, 0u, 1u, 0u, 2u, 0u, 1u, 0u  /* 0xF0 to 0xFF                             */
};

const uint8_t OSMapTbl[8] =
{

    0x01u,
    0x02u,
    0x04u,
    0x08u,
    0x10u,
    0x20u,
    0x40u,
    0x80u,

};

/**@brief 设置查找表中所在分组中的位置
* @param[in]  *p8 需要设置的查找表
* @param[in]  m_index 元素位置
* @return
*/
void General_Set_MapBit(uint8_t p8[], uint8_t m_index)
{
    p8[m_index >> 3u] |= OSMapTbl[m_index & 7u];
}

/**@brief 清除查找表中所在分组中的位置
* @param[in]  *p8 需要清除的查找表
* @param[in]  m_index 元素位置
* @return
*/
void General_Clr_MapBit(uint8_t p8[], uint8_t m_index)
{
    p8[m_index >> 3u] &= (uint8_t)(~OSMapTbl[m_index & 7u]);
}

/**@brief 设置报警状态数组指定位
* @param[in]  -m_Idx -报警编号
* @param[in]  -m_bit -指定bit
* @return  None
*/
void General_AlarmSt_Set(uint8_t m_Idx, uint8_t m_bit)
{
    Set_Bit(Alarm_Status[m_Idx], m_bit);
}

/**@brief 清除报警状态数组指定位
* @param[in]  -m_Idx -报警编号
* @param[in]  -m_bit -指定bit
* @return  None
*/
void General_AlarmSt_Clr(uint8_t m_Idx, uint8_t m_bit)
{
    Clr_Bit(Alarm_Status[m_Idx], m_bit);
}

/**@brief 获取报警状态数组指定位是否置1
* @param[in]  -m_Idx -报警编号
* @param[in]  -m_bit -指定bit
* @return  1 置位  0 未置位
*/
uint8_t General_AlarmSt_True(uint8_t m_Idx, uint8_t m_bit)
{
    uint8_t m_Result;

    if (Bit_Is_Set(Alarm_Status[m_Idx], m_bit))
    {
        m_Result = 1u;
    }
    else
    {
        m_Result = 0u;
    }
    return m_Result;
}

/**@brief 获取报警状态数组指定位是否清0
* @param[in]  -m_Idx -报警编号
* @param[in]  -m_bit -指定bit
* @return  1 清零  0 未清零
*/
uint8_t General_AlarmSt_False(uint8_t m_Idx, uint8_t m_bit)
{
    uint8_t m_Result;
    if (Bit_Is_Clr(Alarm_Status[m_Idx], m_bit))
    {
        m_Result = 1u;
    }
    else
    {
        m_Result = 0u;
    }
    return m_Result;
}

uint8_t General_AlarmSt_Value(uint8_t m_Idx)
{
    uint8_t m_Result;
    m_Result = Alarm_Status[m_Idx];
    return m_Result;
}

void General_Set_PowerSt(uint8_t PowerSt)
{
    g_PowerSt = PowerSt;
}

/*
0---IG OFF
1---IG ON
*/
uint8_t General_Get_PowerSt(void)
{
    uint8_t m_PowerSt;

    m_PowerSt = g_PowerSt;

    return m_PowerSt;
}