/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Debug mode support functions
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 9535 $
 *  $Date: 2016-08-04 19:45:11 +0200 (Do, 04. Aug 2016) $
 *  $LastChangedBy: michael.golczewski $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_DEBUG_H_INCLUDED
#define DAVEHD_DEBUG_H_INCLUDED

#include "davehd_types.h"
#include "davehd_settings.h"

/*----------------------------------------------------------------------------------------------------------*/
/* Code marked with DHD_DEBUG should be visible to compiler only in debug mode*/
/**/

#ifdef DHD_DEBUG_MODE
#define DHD_DEBUG( code )    code /* PRQA S 3410 *//* $Misra: Intended conditional compilation by macro. $*/
#else
#define DHD_DEBUG( code )
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* Compiletime assert macro*/
/**/

#ifdef DHD_SUPPORT_CASSERT
#define DHD_CASSERT(expr, msg) DHD_INTERN_CASSERT(expr,msg,__LINE__) /* PRQA S 3453 *//* $Misra: Function macro for debugging. $*/
#define DHD_INTERN_STR(a, b) a##b
/* PRQA S 0881 5 *//* $Misra: Order of macro pasting evaluation does not change results. $*/
/* PRQA S 3412 4 *//* $Misra: This debugging code intentionally emits statements. $*/
#define DHD_INTERN_CASSERT(expr, msg, line) \
  typedef dhd_uint8_t DHD_INTERN_STR(DHD_STATIC_ASSERT_##msg##_,line)[1]; \
  typedef dhd_uint8_t DHD_INTERN_STR(DHD_STATIC_ASSERT_##msg##_,line)[(expr)?1:2]; /* redefinition is required to force msvc to output the involved name in the error message*/
#else
#define DHD_CASSERT(expr, msg)
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* Debug mode error reporting functions*/
/**/

#define DHD_PANIC( device, message ) do {\
  dhd_debug_panic_internal( (device), (message), __FILE__, __LINE__ );\
} while(0)
extern void dhd_debug_panic_internal( dhd_handle_t a_device, const dhd_char_t *a_message, const dhd_char_t *a_file, dhd_uint32_t a_line );

#ifdef DHD_DEBUG_MODE
  #define DHD_ASSERT( condition ) do {\
    if (!(condition)){\
      dhd_debug_panic_internal( 0, "DHD_ASSERT("  #condition  ") failed", __FILE__, __LINE__ );\
    }\
  } while(0)
#else
  #define DHD_ASSERT( condition )
#endif /* DHD_DEBUG_MODE*/

extern void dhd_debug_out( const dhd_char_t *a_format, ... ); /* PRQA S 5069 *//* $Misra: functionality requires printf syntax $*/

extern void dhd_debug_panic( const dhd_char_t *a_message, const dhd_char_t *a_file, dhd_uint32_t a_line );


/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_DEBUG_H_INCLUDED*/
