#ifndef AvgSpeed_H
#define AvgSpeed_H
#include "Services_Mileage.h"
#include "TYW_stdint.h"
#include "Common_Interface.h"
#include "Services_Mileage.h"
/*** 参数设置 ***/
#define  DATA_AVG_SPEED_TOTAL_KM            50


/*** 参数设置 ***/
#define   DATA_ENGINE_RUNNING_THRESHOLD     400 /*发动机运转阈值*/
#define   DATA_ENGINE_STOP_THRESHOLD        300 /*发动机停止阈值*/
#define   DATA_VEHICLE_STOP_THRESHOLD       20  /*汽车停止阈值*/
#define   DATA_VEHICLE_RUNNING_THRESHOLD    25  /*汽车行进阈值*/


/*** 控制结构 ***/
typedef struct
{
    uint16_t  MileageRoCBackup;
    uint16_t  TimeRoCBackup;
    uint16_t  Mileage[DATA_AVG_SPEED_TOTAL_KM];
    uint16_t  Time[DATA_AVG_SPEED_TOTAL_KM];
    uint16_t  MileageSample;
    uint16_t  TimeSample;
    uint8_t   Ptr;
    uint8_t   Cnt;
    uint8_t   UpdateTimer;
    uint8_t   Running;
} DataAvgSpeedStruct;


void Data_AvgSpeed_KL30_Init(void);
void Data_Avg_Speed_Reset(void);
void Data_Avg_Speed_Processing(void);


#endif
