/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Advanced CPU Pool Memory Manager
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 3935 $
 *  $Date: 2014-09-23 10:52:32 +0200 (Di, 23. Sep 2014) $
 *  $LastChangedBy: golczewskim $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_POOL_ALLOCATOR_H_INCLUDED
#define DAVEHD_POOL_ALLOCATOR_H_INCLUDED

#include "davehd_types.h"

/*----------------------------------------------------------------------------------------------------------*/
/* all free blocks in the pool use this structure  */

typedef struct tagdhd_pool_freeblock {
  struct tagdhd_pool_freeblock  *m_next;                 /* next free block*/
  struct tagdhd_pool_freeblock  *m_prev;                 /* previous free block*/
  dhd_uint32_t                   m_count;                /* number of elements in this free block*/

} dhd_pool_freeblock_t;


typedef struct tagdhd_pool_freetail {
  dhd_pool_freeblock_t         *m_head;                   /* pointer to the start of this free block*/
  
} dhd_pool_freetail_t;

/*----------------------------------------------------------------------------------------------------------*/
/* control structure for a CPU pool*/

typedef struct tagdhd_pool {
  
  dhd_uint32_t                m_nodesize;                 /* size of a node in bytes (is always >= sizeof(dhd_pool_block_t) )*/
  dhd_pool_freeblock_t        m_freelist;                 /* sentinel node and list of all free blocks*/
  dhd_uint32_t                m_totalsize;                /* size of managed chunk from start of pool in bytes*/
  dhd_uint32_t                m_padding;                  /* used node padding to fulfill alignment   */
  void                       *m_endofpool;                /* last valid address in this pool*/

} dhd_pool_t;


/*----------------------------------------------------------------------------------------------------------*/
/* all used blocks in the pool are preceded by this structure*/

typedef struct tagdhd_pool_usedblock_head {
  dhd_pool_t                 *m_pool;                      /* parent pool the block was allocated from  */
  dhd_uint32_t                m_count;                     /* number of elements in this used block*/

} dhd_pool_usedblock_head_t;


/*----------------------------------------------------------------------------------------------------------*/

#ifdef DHD_USER_USE_POOLING

dhd_pool_t *dhd_internal_create_pool(void *a_memory, dhd_uint32_t a_size, dhd_uint32_t a_nodesize, dhd_uint32_t a_align);
void *dhd_internal_alloc_pool(dhd_pool_t *a_pool, dhd_uint32_t a_count);
void dhd_internal_free_pool( void *a_memory );

#endif

/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_POOL_ALLOCATOR_H_INCLUDED*/
