

#ifndef _SOUND_SOURCE_H_
#define _SOUND_SOURCE_H_

#include "TYW_stdint.h"
//#include "PCM_Sound_Tracks.h"
//#include "Sound_Tracks.h"
#include "Buzzer.h"
/******************************************************************************
音源名称列表

注意：音源名称所指代的序号应与该声音位于声音属性表中的序号一一对应
******************************************************************************/
typedef enum
{
    SND_SRC_TICK                                        = 0x00u,/*51转向            29      */
    SND_SRC_TOCK,                                       /*52转向            30      */


    SND_SRC_INDEX_MAX,
} SND_SRC_Index_en_t;

/******************************************************************************
伪音源名称列表
******************************************************************************/
#define   SND_SRC_NONE                      0xFF    //没有声音
#define   SND_SRC_CURRENT                   0xFE    //当前播放的声音

/******************************************************************************
音源循环次数
******************************************************************************/
#define   SND_CYCLE_NONSTOP                 0xFF    //不停播放

/******************************************************************************
音源播放模式
******************************************************************************/
#define   SND_MODE_SINGLE                   0x00    //使用ISD_Play_Vp方法播放
#define   SND_MODE_LOOP                     0x01    //使用ISD_Play_Vp_Loop方法播放

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    BUZZER_Track_Index_en_t  Index;
    uint8_t   Priority;
    uint8_t   Cycle;
    uint8_t   Mode;
    uint16_t  Period;
} SndAttributeStruct;

/******************************************************************************
音源属性表
******************************************************************************/
static const SndAttributeStruct SndAttributeTable[SND_SRC_INDEX_MAX] =
{
    /*================================================================================================
                  音源名称                      | 音源序号      | 优先级 |     循环次数     |    播放模式    | 周期(ms)
    ------------------------------------------------------------------------------------------------*/
    {/*	SND_SRC_TICK,            	*/	BUZZER_Track_Index_Tic,				   1,	1,	SND_MODE_SINGLE,	100U,	},
    {/*	SND_SRC_TOCK,            	*/	BUZZER_Track_Index_Tac,				   2,	1,	SND_MODE_SINGLE,	100U,	},

    /*==============================================================================================*/
};



#define   SND_TOTAL_NUM              SND_SRC_INDEX_MAX//       (sizeof(SndAttributeTable) / sizeof(SndAttributeStruct))

#endif
