#ifndef __UDS_DTC_H
#define __UDS_DTC_H

#include "TYW_stdint.h"
#include "UDS_Common.h"

#define   U100700     0xD00700u
#define   U100701     0xD00701u
#define   U100702     0xD00702u
#define   U100703     0xD00703u
#define   U100706     0xD00706u
#define   U10070F     0xD0070Fu
#define   U100710     0xD00710u
#define   B110000     0x910000u
#define   B110001     0x910001u
#define   B110002     0x910002u
#define   B110003     0x910003u
#define   B110005     0x910005u
#define   B110006     0x910006u
#define   B110007     0x910007u
#define   B110008     0x910008u
#define   B110009     0x910009u
#define   B11000A     0x91000Au
#define   B11000B     0x91000Bu
#define   B11000C     0x91000Cu

#define   cnU100700     0u
#define   cnU100701     1u
#define   cnU100702     2u
#define   cnU100703     3u
#define   cnU100706     4u
#define   cnU10070F     5u
#define   cnU100710     6u
#define   cnB110000     7u
#define   cnB110001     8u
#define   cnB110002     9u
#define   cnB110003     10u
#define   cnB110005     11u
#define   cnB110006     12u
#define   cnB110007     13u
#define   cnB110008     14u
#define   cnB110009     15u
#define   cnB11000A     16u
#define   cnB11000B     17u
#define   cnB11000C     18u

#define   cnMSG325    0u
#define   cnMSGA21    1u
#define   cnMSGEEC    2u
#define   cnMSG4E8    3u
#define   cnMSG10B    4u
#define   cnMSG400    5u

extern uint8_t HVoltageStatus;
extern uint8_t LVoltageStatus;
extern uint32_t msgList[6u][4u];
extern uint32_t DTCTimerList[18u];
extern const uint32_t DTCList[18u][2u];

void TestDTC(uint16_t timer);
void TestDTC_U100700(void);
void TestDTC_U100701(void);
void TestDTC_U100702(void);
void TestDTC_U100703(void);
void TestDTC_U100706(void);
void TestDTC_U10070F(void);
void TestDTC_U100710(void);
void TestDTC_B110000(uint16_t timer);
void TestDTC_B110001(uint16_t timer);
void TestDTC_B110002(void);
void TestDTC_B110005(void);
void TestDTC_B110006(void);
void TestDTC_B110007(void);
void TestDTC_B110008(void);
void TestDTC_B110009(void);
void TestDTC_B11000A(void);
void TestDTC_B11000B(void);
void TestDTC_B11000C(void);
uint8_t getPowerStatus(void);
uint8_t getBusoffStatus(void);
uint8_t getEngStatus(void);
uint8_t getMSGStatus(uint8_t cnMsgID);
void ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus);
void SaveDTCData(void);

#endif