#include "DisplaySch_user.h"
#include "Common_Interface.h"
#include "DispSch.h"
#include "Popup_Scheduler.h"
#include "Popup_List.h"
#include "Key.h"
#include "CAN_Lib.h"
#include "GUI.h"
#include "Services_ODO_User.h"        /*清空总计里程函数*/
#include "Menu.h"
#include "jcua.h"

uint32_t EnterTimer [ 10 ];
uint8_t  UE_EN [ Display_MAX ];
#pragma alignvar(8)
#pragma ghs section bss = default
uint8_t             Mem [ 32 ];
#pragma ghs section bss = default

#pragma ghs section  bss = ".myNonInitArea"
UE_CtrlInfo_Struct_t UE_CtrlInfo;
uint8_t BG_display_flag;
#pragma ghs section  bss = default

uint32_t       HMI_StartAnimationFrameCnt;

static void switch_branch(void);

uint8_t Get_Pwr(void)
{
    return Common_Get_IG_Sts( );
}
uint32_t Get_IG_ON(void)
{
    return Common_GetIgnOnTime( );
}
uint32_t Get_IG_Off(void)
{
    return Common_GetIgnOffTime( );
}

static const DispSch_Attr_st loc [] =
{
    {&UE_EN [ Display_StartAnimation ], UE_IGN_ON, Display_StartAnimation, (( void * )0), Display_StartAnimationEnter, Display_StartAnimationService, Display_StartAnimationExit},
    {&UE_EN [ Display_Menu ], UE_IGN_ON, Display_Menu, (( void * )0), (( void * )0), Display_MenuService, (( void * )0)},
    {&UE_EN [ Display_Alarm ], UE_IGN_ON, Display_Alarm, (( void * )0), (( void * )0), Display_AlarmService, (( void * )0)},
};

void DispSch_TotalInit(void)
{
    uint8_t        i;
    DispSch_Ext_st m_st;
    m_st.Get_Power        = Get_Pwr;
    m_st.Get_IG_ON_Timer  = Get_IG_ON;
    m_st.Get_IG_OFF_Timer = Get_IG_Off;
    m_st.Get_IG_OFF_Timer = Get_IG_Off;
    m_st.TotalSize        = Display_MAX;
    DispSch_Init(Mem, loc, &m_st, 0u);
    for ( i = 0u; i < Display_MAX; i++ )
    {
        UE_EN [ i ] = UE_Disable;
    }
}

void DisplayServices(void)
{
    uint32_t PowerOnTimer;
    uint32_t PowerOFFTimer;
    uint8_t  PowerStatus;
    uint16_t popupID = 0xFFFFu;

    PowerStatus      = Common_Get_IG_Sts( );
    PowerOnTimer     = Common_GetIgnOnTime( );
    PowerOFFTimer    = Common_GetIgnOffTime( );

    if ( (PowerOnTimer <= StartAnimationEnd) && (PowerOnTimer >= StartAnimationStart) )
    {
        UE_EN [ Display_StartAnimation ] = UE_Enable;
        UE_EN [ Display_Menu ]           = UE_Disable;
        UE_EN [ Display_Alarm ]          = UE_Disable;
    }
    else
    {
        //if (DisplayIdx < MENU_ITEM_PassWord_1)
        {
            popupID = Popup_Get_Current_Message( );
        }

        if ( popupID != 0xffffu )
        {
            UE_EN [ Display_Alarm ]         = UE_Enable;
        }
        else
        {
            UE_EN [ Display_Alarm ]          = UE_Disable;
            if ( PowerStatus == COMMON_POWER_ON )
            {
                UE_EN [ Display_Menu ] = UE_Enable;
            }
            else
            {
                UE_EN [ Display_Menu ] = UE_Disable;
            }
        }
    }
    DispSch_xxxMs_Logic(10u);
}

void Display_StartAnimationEnter(void)
{
    GUI_Display_background();
}

void Display_StartAnimationService(void)
{
    uint16_t m16_FrameCnt;

    HMI_StartAnimationFrameCnt++;
    m16_FrameCnt = HMI_StartAnimationFrameCnt;
    if ( (m16_FrameCnt % 3) == 0 )
    {
        loc_Disable_Window_App( );
        //GUI_Display_Animation_Frame(m16_FrameCnt / 3u);
        GUI_Display_background();
    }
}

void Display_StartAnimationExit(void)
{
    loc_Enable_Window_App( );
}

void Display_MenuService(void)
{
    /*上短*/
    if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP == KEY_EVENT_SHORT_PRESS )
    {
        HMI_Clear_KEY_UP();
    }
    /*上长*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP == KEY_EVENT_LONG_PRESS )
    {
        HMI_Clear_KEY_UP();
    }
    /*下短*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN == KEY_EVENT_SHORT_PRESS )
    {
        HMI_Clear_KEY_DOWN();
    }
    /*下长*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN == KEY_EVENT_LONG_PRESS )
    {
        HMI_Clear_KEY_DOWN();
    }
    /*确认短*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM == KEY_EVENT_SHORT_PRESS )
    {
        HMI_Clear_KEY_CONFIRM();
    }
    /*确认长*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM == KEY_EVENT_LONG_PRESS )
    {
        HMI_Clear_KEY_CONFIRM();
    }
    /*确认超长 30 S*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM == KEY_EVENT_SUPER_LONG_PRESS )
    {
        HMI_Clear_KEY_CONFIRM();

        /*TYW总计清零*/
        TYW_Data_ODO_Clear();
    }
    /*返回短*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL == KEY_EVENT_SHORT_PRESS )
    {
        HMI_Clear_KEY_CANCEL();
    }
    /*返回长*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL == KEY_EVENT_LONG_PRESS )
    {
        HMI_Clear_KEY_CANCEL();
    }
    /*MENU短*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU == KEY_EVENT_SHORT_PRESS )
    {
        HMI_Clear_KEY_MENU();
    }
    /*MENU长*/
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU == KEY_EVENT_LONG_PRESS )
    {
        HMI_Clear_KEY_MENU();
    }
    else
    {
        ;/*do nothing*/
    }
}
void Display_AlarmService(void)
{

}

void GUI_DisplayServices(void)
{
    if (BG_display_flag == 0)
    {
        BG_display_flag = 1;
        MenuInit();
    }
    else
    {
        if (bCurMenuIDX > _MN_DSP_LEVEPOPUP)
        {
            loc_Del_Sprite(ADAS_Sprite, Gear_Sprite);
            if (Common_Get_window_Sta() != 0u)
            {
                JCUA_Disable_window();
            }
        }
        else
        {
            loc_Del_Sprite(MENU_Sprite, MENU_Sprite);
            if (Common_Get_window_Sta() != 1u)
            {
                JCUA_Enable_window();
            }
        }
        MenuManage();
        //BG_display_flag = 0;
    }
}

void HMI_Set_KEY_UP(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP = u8KeyVal;
}
void HMI_Set_KEY_DOWN(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN = u8KeyVal;
}
void HMI_Set_KEY_CONFIRM(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM = u8KeyVal;
}
void HMI_Set_KEY_CANCEL(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL = u8KeyVal;
}
void HMI_Set_KEY_MENU(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU = u8KeyVal;
}


void HMI_Clear_KEY_UP(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP = 0u;
}
void HMI_Clear_KEY_DOWN(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN = 0u;
}
void HMI_Clear_KEY_CONFIRM(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM = 0u;
}
void HMI_Clear_KEY_CANCEL(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL = 0u;
}
void HMI_Clear_KEY_MENU(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU = 0u;
}
