#include "Popups.h"
#include "Common_Interface.h"
#include "GUI.h"
#include "Sound_Scheduler.h"

#include "Gauges.h"
#include "GaugesInterface.h"

#include "CAN_Communication_Matrix.h"
#include "Popup_List.h"
#include "Popup_Message_List.h"
#include "Sound_List.h"
#include "Telltales.h"

#include "Data_Gear.h"
#include "Line_in.h"

#include "Data_CoolantTemperature.h"
#include "Data_Voltmeter.h"
#include "Data_Fuel_User.h"

#include "Service_TPMS.h"

void Popups_Management_Service(void)
{
    Popups_Polling();
}

void Popups_Polling(void)
{
    uint16_t i = 0x00u;
    COMMON_PowerStatus_t u8IG_st;
    uint32_t u32IG_OFF_Timer = 0x00u;
    uint32_t u32IG_ON_Timer = 0x00u;
    uint8_t Can_BusOFF = 0x00u;
    uint8_t variable_1 = 0x00u;
    uint8_t variable_2 = 0x00u;
    uint8_t variable_3 = 0x00u;
    uint32_t variable_4 = 0x00u;
    uint16_t V_Speed = 0u;
    uint16_t E_Speed = 0u;

    u32IG_ON_Timer = Common_GetIgnOnTime();
    u32IG_OFF_Timer = Common_GetIgnOffTime();
    u8IG_st = Common_Get_IG_Sts();

    V_Speed = Common_Get_Disp_V_Speed(); /*车速*/
    E_Speed = Common_Get_Act_E_Speed();  /*转速*/

    /*CAN 通讯异常*/
    for (i = 0u; i < ID_TOTAL_MAX; i++)
    {
        if (CAN_MSG_Status(i) == CAN_SIG_LOST)
        {
            Can_BusOFF++;
        }
    }

    if ((u32IG_ON_Timer <= PopupStart) && (u32IG_ON_Timer >= 2u))
    {
    }
    else
    {
        if (u8IG_st == COMMON_POWER_ON)
        {
            /*----第一组---------------------------------------------------------------------*/
            if (K_Line_Set.K_Line_LID28 == 0x01u)
            {
                /*0.--1--紧急警报-刹车*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x07u) || (variable_2 == 0x07u))
                {
                    Popup_Request(POPUP1_BRAKE_BLACK);
                    Popup_Clear(POPUP1_BRAKE_BRAKE);
                    Popup_Clear(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BLACK);
                }

                /*1.--1--紧急警报-紧急制动*/
                variable_1 = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if (variable_1 == 0x07u)
                {
                    Popup_Request(POPUP1_BRAKE_BRAKE);
                    Popup_Clear(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BRAKE);
                }

                /*2.--2--车间距警报-刹车(红字)*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x06u) || (variable_2 == 0x06u))
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_R);
                    Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_R);
                }

                /*3.--2--车间距警报-碰撞报警*/
                variable_1 = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if (variable_1 == 0x06u)
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_COLLISION);
                    Popup_Clear(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_COLLISION);
                }

                /*4.--3--车间距警报-刹车(黄字)*/
                variable_1 = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                variable_2 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                if ((variable_1 == 0x05u) || (variable_2 == 0x05u))
                {
                    Popup_Request(POPUP1_BRAKE_SPACING_Y);
                    Popup_Clear(POPUT1_ASR_OPERATE);
                    return;
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_SPACING_Y);
                }
            }
            else
            {
                Popup_Clear(POPUP1_BRAKE_BLACK);
                Popup_Clear(POPUP1_BRAKE_BRAKE);
                Popup_Clear(POPUP1_BRAKE_SPACING_R);
                Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION);
                Popup_Clear(POPUP1_BRAKE_SPACING_Y);
            }

            /*5.--4--ASR工作*/
            variable_1 = Get_ID_18F0010B_Sig_ATC_or_ASR_Lamp_State();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUT1_ASR_OPERATE);
            }
            else
            {
                Popup_Delete(POPUT1_ASR_OPERATE);
            }

            /*----第二组---------------------------------------------------------------------*/
            /*6.--1--PTO紧急警报-刹车*/
            variable_1 = Get_ID_18FED900_Sig_PTO_SW();
            variable_2 = Line_In_Get_Status(LINE_IN_PTO); // B01

            if (((variable_1 == 0x01u) || (variable_2 == LINE_IN_LOGIC_VALID)) && (V_Speed >= 66u))
            {
                Popup_Request(POPUT2_PTO);
            }
            else
            {
                Popup_Delete(POPUT2_PTO);
            }

            /*7.--2--忘记松手刹车    LINE_IN_Get_PARK_BRAKE 驻车制动*/
            variable_1 = Line_In_Get_Status(LINE_IN_PARK_BRAKE);

            if ((variable_1 == LINE_IN_LOGIC_VALID) && (V_Speed >= 66u)) // 6.67Km
            {
                Popup_Request(POPUP2_PARKING_BRAKE);
            }
            else
            {
                Popup_Delete(POPUP2_PARKING_BRAKE);
            }

            /*8.--3--遥控调整车辆高度(有车速)*/
            variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);

            if ((variable_1 == LINE_IN_LOGIC_VALID) && (V_Speed > 5u)) // 0.5Km
            {
                Popup_Request(POPUP2_AIRMATIC_HIGHT);
            }
            else
            {
                Popup_Delete(POPUP2_AIRMATIC_HIGHT);
            }

            /*----第三组---------------------------------------------------------------------*/
            /*9.--1--自动巡航模式*/
            variable_1 = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();
            variable_2 = Common_Get_Cruise_TimeSta();

            if ((variable_1 == 0x01u) && (variable_2 == 1u))
            {
                Popup_Request(POPUP3_CRUISE);
            }
            else
            {
                Popup_Delete(POPUP3_CRUISE);
            }

            /*10.--2--可变SLD 模式*/
            variable_1 = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();
            variable_2 = Common_Get_Cruise_SLD_TimeSta();

            if ((variable_1 == 0x03u) && (variable_2 == 1u))
            {
                Popup_Request(POPUP3_VARIABLE_SLD);
            }
            else
            {
                Popup_Delete(POPUP3_VARIABLE_SLD);
            }

            /*----第四组---------------------------------------------------------------------*/
            if (E_Speed < 350u)
            {
                if (K_Line_Set.K_Line_LID2B == 0x00u)
                {
                    /*11.--1--充电异常（系统检测）*/
                    variable_1 = Line_In_Get_Status(LINE_IN_CHARGE);
                    variable_2 = Common_VolWarning_Sta();

                    if ((variable_1 == LINE_IN_LOGIC_VALID) || (variable_2 < 4u))
                    {
                        Popup_Request(POPUT4_ABNORMAL_CHARGE);
                    }
                    else
                    {
                        Popup_Delete(POPUT4_ABNORMAL_CHARGE);
                    }

                    /*12.--2--油压（系统检测）*/
                    variable_1 = Line_In_Get_Status(LINE_IN_ENG_OIL);
                    variable_2 = Common_VolWarning_Sta();

                    if ((variable_1 == LINE_IN_LOGIC_VALID) || (variable_2 < 4u))
                    {
                        Popup_Request(POPUP4_OIL_PRESSURE);
                    }
                    else
                    {
                        Popup_Delete(POPUP4_OIL_PRESSURE);
                    }
                }
                else
                {
                    Popup_Clear(POPUT4_ABNORMAL_CHARGE);
                    Popup_Clear(POPUP4_OIL_PRESSURE);
                }

                /*13.--3--AMT初始化异常           DM1 SPN4220 Key On時*/
                variable_4 = Get_ID_18FECA03_Sig_SPN();

                if ((variable_4 == 4220u) && (K_Line_Set.K_Line_LID41 == 0x13u))
                {
                    Popup_Request(POPUP4_AMT_INIT_EXCE);
                }
                else
                {
                    Popup_Delete(POPUP4_AMT_INIT_EXCE);
                }

                /*14.--4--尿素品质异常（系统检测）*/
                if (0)
                {
                    Popup_Request(POPUP4_ADBLUE_QUALITY);
                }
                else
                {
                    Popup_Delete(POPUP4_ADBLUE_QUALITY);
                }

                /*15.--5--尿素喷射异常（系统检测）*/
                if (0)
                {
                    Popup_Request(POPUP4_ADBLUE_SPRAY);
                }
                else
                {
                    Popup_Delete(POPUP4_ADBLUE_SPRAY);
                }

                /*16.--6--尿素水补给（系统检测）*/
                if (0)
                {
                    Popup_Request(POPUP4_ADBLUE_SUPPLY);
                }
                else
                {
                    Popup_Delete(POPUP4_ADBLUE_SUPPLY);
                }

                /*17.--7--AMT初始化结束               DM1 SPN4021  Key On時*/
                variable_4 = Get_ID_18FECA03_Sig_SPN();

                if ((variable_4 == 4021u) && (K_Line_Set.K_Line_LID41 == 0x13u))
                {
                    Popup_Request(POPUP4_START_ENG);
                }
                else
                {
                    Popup_Delete(POPUP4_START_ENG);
                }

                /*18.--8--DPD自动再生*/
                if (0)
                {
                    Popup_Request(POPUP4_DPD_AUTO);
                }
                else
                {
                    Popup_Delete(POPUP4_DPD_AUTO);
                }
            }
            else
            {
                Popup_Clear(POPUT4_ABNORMAL_CHARGE);
                Popup_Clear(POPUP4_OIL_PRESSURE);
                Popup_Clear(POPUP4_AMT_INIT_EXCE);
                Popup_Clear(POPUP4_ADBLUE_QUALITY);
                Popup_Clear(POPUP4_ADBLUE_SPRAY);
                Popup_Clear(POPUP4_ADBLUE_SUPPLY);
                Popup_Clear(POPUP4_START_ENG);
                Popup_Clear(POPUP4_DPD_AUTO);
            }

            /*----第五组---------------------------------------------------------------------*/
            /*19.--1--过热（过热，请在安全的场所停车）有车速     LID $43 :0x82*/
            variable_1 = Coolant_Get_Valid();
            variable_2 = Coolant_Get_CurSeg();

            if (K_Line_Set.K_Line_LID43 == 0x82)
            {
                if ((variable_1 == 1u) && (variable_2 >= 12u))
                {
                    Popup_Request(POPUP5_OVER_HEAT);
                }
                else if (variable_2 <= 9u)
                {
                    Popup_Delete(POPUP5_OVER_HEAT);
                }
            }
            else
            {
                Popup_Clear(POPUP5_OVER_HEAT);
            }

            /*20.冷却水（冷却液不足） B32 GND*/
            variable_1 = Line_In_Get_Status(LINE_IN_LOW_COOLANT);

            if (variable_1 == LINE_IN_LOGIC_VALID)
            {
                Popup_Request(POPUP5_LOW_COOLANT);
            }
            else
            {
                Popup_Delete(POPUP5_LOW_COOLANT);
            }

            /*21.油压(机油)请在安全场所停车 发动机启动(350r/min)后、350r/min持续5秒以上时，A32信号（10ms周期监测），连续20次检出Lo时。*/
            variable_1 = Line_In_Get_Status(LINE_IN_ENG_OIL);

            if ((E_Speed > 350u) && (variable_1 == LINE_IN_LOGIC_VALID))
            {
                Popup_Request(POPUP5_ENGINE_OIL_PRESSURE);
            }
            else
            {
                Popup_Delete(POPUP5_ENGINE_OIL_PRESSURE);
            }

            /*22.仪表故障-请与五十铃公司联系*/
            Popup_Clear(POPUP5_METER_FAILURE);

            /*23.通信系统-请与五十铃公司联系*/
            if (Can_BusOFF == ID_TOTAL_MAX)
            {
                Popup_Request(POPUP5_CAN_ERROR);
            }
            else
            {
                Popup_Delete(POPUP5_CAN_ERROR);
            }

            /*24.车速限制-图1   ID：18FF2300 Byte：7 Bit：4,3   10(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Engine_Derate();

            if ((variable_1 == 0x02u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_SPEED_LIMIT);
            }
            else
            {
                Popup_Delete(POPUP5_SPEED_LIMIT);
            }

            /*25.扭矩限制-图2 ID：18FF2300 Byte：7 Bit：4,3   01(B)*/
            if ((variable_1 == 0x01u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_TORQUE_REDUCTION);
            }
            else
            {
                Popup_Delete(POPUP5_TORQUE_REDUCTION);
            }

            /*26.尿素品质异常-图1 ID：18FF2300 Byte：3 Bit：6,5  01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber3();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUP5_INCORRECT_ADBLUE);
            }
            else
            {
                Popup_Delete(POPUP5_INCORRECT_ADBLUE);
            }

            /*27.临界排放故障-图1 ID：18FF2300 Byte：7 Bit：6,5  01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_EXH_System();

            if (variable_1 == 1)
            {
                Popup_Request(POPUP5_CRITICAL_EMISSION);
            }
            else
            {
                Popup_Delete(POPUP5_CRITICAL_EMISSION);
            }

            if (K_Line_Set.K_Line_LID41 = 0x13u)
            {
                /*28.AMT异常-图1 ID：18FF8503 Byte：1 Bit：4,3 01(B) LID $41 : 0x13          PGN：65413  TC2DIS*/
                variable_1 = Get_ID_18FF8503_Sig_Spanner_Warning();

                if (variable_1 == 1)
                {
                    Popup_Request(POPUP5_AMT_SPANNER_WARNING);
                }
                else
                {
                    Popup_Delete(POPUP5_AMT_SPANNER_WARNING);
                }

                /*29.AMT异常(气压低下)-图1 ID：18FF8503 Byte：2 Bit：6,5 01(B) LID $41 : 0x13  PGN：65413  TC2DIS*/
                variable_1 = Get_ID_18FF2300_Sig_Glow_Lamp();

                if (variable_1 == 1)
                {
                    Popup_Request(POPUP5_AMT_LOW_AIR_WARNING);
                }
                else
                {
                    Popup_Delete(POPUP5_AMT_LOW_AIR_WARNING);
                }
            }
            else
            {
                Popup_Clear(POPUP5_AMT_SPANNER_WARNING);
                Popup_Clear(POPUP5_AMT_LOW_AIR_WARNING);
            }

            /*30.胎压 低圧警報-轮胎漏气警告 ID：18011733  Byte：5 Bit：5 01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSFast_air_leakage();

            if ((K_Line_Set.K_Line_LID3E = 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_LOW_PRESSURE_ALARM);
            }
            else
            {
                Popup_Delete(POPUP5_LOW_PRESSURE_ALARM);
            }

            /*31.尿素补给-补充尿素溶液-图1 ID：18FF2300 Byte：3 Bit：4,3 01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber2();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUP5_APP_ADBLUE);
            }
            else
            {
                Popup_Delete(POPUP5_APP_ADBLUE);
            }

            /*32.尿素余量少-无车速-图2 ID：18FF2300 Byte：3 Bit：4,3 10(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber2();

            if (variable_1 == 0x02u)
            {
                Popup_Request(POPUP5_ADBLUE_LEVEL_LOW);
            }
            else
            {
                Popup_Delete(POPUP5_ADBLUE_LEVEL_LOW);
            }

            /*33. 低圧警報（低下）ID：18011733  Byte：5 Bit：8 01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSLow_Presure_Sta();

            if ((K_Line_Set.K_Line_LID3E = 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_LOW_FAILURE);
            }
            else
            {
                Popup_Delete(POPUP5_LOW_FAILURE);
            }

            /*34.摄像头有污染-请与五十铃公司联系 ID：18FE5BE8 Byte7  Bit5-8 0010(B) 0011(B) LID $27: 0x01*/
            variable_1 =  Get_ID_18FE5BE8_Sig_Camera_Status();

            if ((K_Line_Set.K_Line_LID27 = 0x01u) && ((variable_1 == 0x02u) || (variable_2 == 0x03u)))
            {
                Popup_Request(POPUP5_CAMERA_POLLUTION);
            }
            else
            {
                Popup_Delete(POPUP5_CAMERA_POLLUTION);
            }

            /*35.尿素喷射异常（停止）-图1 ID：18FF2300 Byte：3 Bit：2,1 01(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber1();

            if ((variable_1 == 0x01u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_AdBlue_INJ_SYSTEM);
            }
            else
            {
                Popup_Delete(POPUP5_AdBlue_INJ_SYSTEM);
            }

            /*36.尿素喷射异常（消耗量）-图1  ID：18FF2300 Byte：3 Bit：2,1 10(B)*/
            variable_1 = Get_ID_18FF2300_Sig_Amber1();

            if ((variable_1 == 0x02u) || (variable_1 == 0x03u))
            {
                Popup_Request(POPUP5_AdBlue_DOS_MALFUNC);
            }
            else
            {
                Popup_Delete(POPUP5_AdBlue_DOS_MALFUNC);
            }

            /*37.高圧警報-轮胎高压警告 ID：18011733  Byte：5 Bit：7  01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSHigh_Presure_Sta();

            if ((K_Line_Set.K_Line_LID3E = 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_TPMS_HIGH_AIR);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_HIGH_AIR);
            }

            /*38.高温警報-轮胎高温警告 ID：18011733  Byte：5 Bit：6  01(B) LID $3E : 0x01*/
            variable_1 = Get_TPMSHigh_Temperature_Sta();

            if ((K_Line_Set.K_Line_LID3E = 0x01u) && (variable_1  == 0x01u))
            {
                Popup_Request(POPUP5_TPMS_HIGH_TEMP);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_HIGH_TEMP);
            }

            /*39.DPD手动再生要求1-DPD需要再生 18FD7C00 Byte：1 Bit：3-1  001：On – solid*/
            variable_1 = Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber();

            if (variable_1 == 0x01u)
            {
                Popup_Request(POPUP5_PUSH_DPD_SWITCH1);
            }
            else
            {
                Popup_Delete(POPUP5_PUSH_DPD_SWITCH1);
            }

            /*40.DPD手动再生要求2-DPD需要再生 18FD7C00 Byte：1 Bit：3-1     100：On – fast blink (1 HZ)*/
            variable_1 = Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber();

            if (variable_1 == 0x04u)
            {
                Popup_Request(POPUP5_PUSH_DPD_SWITCH2);
            }
            else
            {
                Popup_Delete(POPUP5_PUSH_DPD_SWITCH2);
            }

            /*41.TPMS故障-轮胎监控失败  ID：18011733  Byte：6 Bit：ALL 0111(B) or 1000(B) or 1001(B)*/
            variable_1 = Get_TPMSSensor_fault_Sta();

            if  ((K_Line_Set.K_Line_LID3E = 0x01u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP5_TPMS_FAILURE);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_FAILURE);
            }


            /*42.TPMS電池低下-轮胎监控传感器电压下降  ID：18011733  Byte：5 Bit：4  01(B)  LID $3E : 0x01*/
            variable_1 = Get_TPMSLow_Voltage_Sta();

            if  ((K_Line_Set.K_Line_LID3E = 0x01u) && (variable_1  == 1))
            {
                Popup_Request(POPUP5_TPMS_MONITOR_DROP);
            }
            else
            {
                Popup_Delete(POPUP5_TPMS_MONITOR_DROP);
            }

            /*----第六组---------------------------------------------------------------------*/
            if (V_Speed < 66u)
            {
                /*43.遥控车辆高度调整中(无车速) B30 28V*/
                variable_1 = Line_In_Get_Status(LINE_IN_AIR_SUS);

                if (variable_1 == 1)
                {
                    Popup_Request(POPUP6_HEIGHT_CONTROL);
                }
                else
                {
                    Popup_Delete(POPUP6_HEIGHT_CONTROL);
                }

                /*44.PTO(停车中)(无车速)  /ID：18FED900  Byte：2 Bit：8,7  01(B)   OR  B01 28V*/
                variable_1 = Get_ID_18FED900_Sig_PTO_SW();
                variable_2 = Line_In_Get_Status(LINE_IN_PTO);

                if ((variable_1 == 1) || ( variable_2 == 1))
                {
                    Popup_Request(POPUP6_PTO_STOP);
                }
                else
                {
                    Popup_Delete(POPUP6_PTO_STOP);
                }
            }
            else
            {
                Popup_Clear(POPUP6_HEIGHT_CONTROL);
                Popup_Clear(POPUP6_PTO_STOP);
            }

            /*----第七组---------------------------------------------------------------------*/
            /*45.充电异常-请与五十铃公司联系*/
            variable_1 = Line_In_Get_Status(LINE_IN_CHARGE);
            variable_2 = Common_VolWarning_Sta();

            if ((variable_1 == 0x01u) || ((variable_2 == 0x01u) && (E_Speed > 350u)))
            {
                Popup_Request(POPUP7_CHARGE_ABNORMAL);
            }
            else
            {
                Popup_Delete(POPUP7_CHARGE_ABNORMAL);
            }
            /*46.AMT異常-AMT异常  ID：18FF8503　Bite：1 Bit：2,1   LID $41 : 0x13*/
            variable_1 = Get_ID_18FF8503_Sig_Stop_Warning();

            if ((K_Line_Set.K_Line_LID41 == 0x13u) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP7_AMT_ERROR);
            }
            else
            {
                Popup_Delete(POPUP7_AMT_ERROR);
            }

            /*----第八组---------------------------------------------------------------------*/
            /*47.补充燃料-油箱单位*/
            //if (K_Line_Set.K_Line_LID43 == 0x82u)
            //{
            //    //if ((Fuel_Seg <= 1 ) && (FuelStatus == 0) && (FuelResistanceV != 65535))
            //    if (0)
            //    {
            //        Popup_Request(POPUP8_REFUEL);
            //    }
            //    else
            //    {
            //        Popup_Delete(POPUP8_REFUEL);
            //    }
            //}
            //else
            //{
            //    Popup_Clear(POPUP8_REFUEL);
            //}

            if (K_Line_Set.K_Line_LID41 == 0x13u)
            {
                /*48.AMT过热-离合器过载 ID：18FF8503　Bite：2 Bit：4,3  001(B)  LID $41 : 0x13*/
                variable_1 = Get_ID_18FF8503_Sig_Clutch_Overload_warning();

                if (variable_1 == 0x01u)
                {
                    Popup_Request(POPUP8_ATM_CLUCH_OVERHEATING);
                }
                else
                {
                    Popup_Delete(POPUP8_ATM_CLUCH_OVERHEATING);
                }

                /*49.AMT磨耗-离合器磨损 ID：18FF8503　Bite：2 Bit：2,1  001(B)  LID $41 : 0x13*/
                variable_1 = Get_ID_18FF8503_Sig_Manouvering_mode();

                if (variable_1 == 0x01u)
                {
                    Popup_Request(POPUP1_BRAKE_BRAKE);
                }
                else
                {
                    Popup_Delete(POPUP1_BRAKE_BRAKE);
                }
            }
            else
            {
                Popup_Clear(POPUP8_ATM_CLUCH_OVERHEATING);
                Popup_Clear(POPUP1_BRAKE_BRAKE);
            }

            /*50.低电压报警 显示条件：发动机启动(350r/min)后，7秒检测到23.5V时 显示消失条件：10秒检测到25V以上时*/
            //if (( KL30_Volt < 2350) && ( E_Speed > 350)) //23.5V
            //{
            //    Popup_Request(POPUP8_LOW_VOLTAGE_SPEED);
            //}
            //else if (KL30_Volt > 2500)
            //{
            //    Popup_Delete(POPUP8_LOW_VOLTAGE_SPEED);
            //}

            /*51.过电压报警 显示条件：发动机启动(350r/min)后，7秒检测到30.4V以上时 显示消失条件：10秒检测到29.4V以下时*/
            //if ((KL30_Volt > 3044)  && ( E_Speed > 350))  //30.44V
            //{
            //    Popup_Request(POPUP8_OVERVOLTAGE);
            //}
            //else if (KL30_Volt < 2940)
            //{
            //    Popup_Delete(POPUP8_OVERVOLTAGE);
            //}

            /*52.后蹄片磨损*/
            variable_1 = Line_In_Get_Status(LINE_IN_WEAR2);

            if (variable_1 == LINE_IN_LOGIC_VALID)
            {
                Popup_Request(POPUP1_BRAKE_BRAKE);
            }
            else
            {
                Popup_Delete(POPUP1_BRAKE_BRAKE);
            }
            /*53.前蹄片磨损*/
            variable_1 = Line_In_Get_Status(LINE_IN_WEAR_IND);

            if (variable_1 == LINE_IN_LOGIC_VALID)
            {
                Popup_Request(POPUP1_BRAKE_BRAKE);
            }
            else
            {
                Popup_Delete(POPUP1_BRAKE_BRAKE);
            }

            /*54.DPD自动再生-DPD自动再生中  ID：18FED900 (AUXIO)  Byte：8  bit：5,4  01(B)  Engine Speed ： 350rpm以上*/
            variable_1  = Get_ID_18FED900_Sig_DPF_Regeneration_Status();

            if ((E_Speed >= 350) && (variable_1 == 0x01u))
            {
                Popup_Request(POPUP8_DPD_AUTO);
            }
            else
            {
                Popup_Delete(POPUP8_DPD_AUTO);
            }

            /*----第九组---------------------------------------------------------------------*/
            /*55.气压过低-请冲入空气*/
            /*56.EBS故障（红）-请与五十铃公司联系*/
#if 0
            /*----第十组---------------------------------------------------------------------*/
            /*57.省油耗建议-急加速*/
            if ((AccSubSpeed.AccSpeed_Flag == 1) && (User_App.User_JADD != 0xFF))
            {
                Popup_Request(POPUP10_RAPID_ACC);
            }
            else
            {
                Popup_Delete(POPUP10_RAPID_ACC);
            }
            /*58.省油耗建议-急减速*/
            if ((AccSubSpeed.SubSpeed_Flag == 1) && (User_App.User_JSUB != 0xFF))
            {
                Popup_Request(POPUP10_RAPID_SUB);
            }
            else
            {
                Popup_Delete(POPUP10_RAPID_SUB);
            }
            /*59.省油耗建议-请降低发动机转速*/
            if ((DataOverESpeed == 1) && (User_App.User_Speed != 0xFF))
            {
                Popup_Request(POPUP10_REVAL_ENGINE);
            }
            else
            {
                Popup_Delete(POPUP10_REVAL_ENGINE);
            }
            /*60.省油耗建议-请降低速度*/
            if (
                ((DataOverSpeedK_Line == 1) && (K_Line_Set.K_Line_LID44 != 0xFF)) || \
                ((AccSubSpeed.GslSpeed_Flag) && (User_App.User_Gsl))             || \
                ((AccSubSpeed.YblSpeed_Flag) && (User_App.User_Ybl))
            )
            {
                Popup_Request(POPUP10_REVAL_SPEED);
            }
            else
            {
                Popup_Delete(POPUP10_REVAL_SPEED);
            }

            /*----第十一组---------------------------------------------------------------------*/
            /*61.发动机机油＆滤清器*/
            if (((State_Flag.User_FDJYLQQ_FLAG == 1) || (State_Flag.User_FDJYLQQ_FLAG == 2)) && (User_FDJYLQQ_Time <= 600))
            {
                Popup_Request(POPUP11_ENGINE_OIL_FILTERPOPUP11_ENGINE_OIL_FILTER);
            }
            else
            {
                Popup_Delete(POPUP11_ENGINE_OIL_FILTER);
            }
            /*62.燃油滤清器*/
            if (((State_Flag.User_RYLQQ_FLAG   == 1) || (State_Flag.User_RYLQQ_FLAG   == 2)) && (User_RYLQQ_Time <= 600))
            {
                Popup_Request(POPUP11_FUEL_FILTER);
            }
            else
            {
                Popup_Delete(POPUP11_FUEL_FILTER);
            }
            /*63.变速箱油*/
            if (((State_Flag.User_BSXY_FLAG    == 1) || (State_Flag.User_BSXY_FLAG    == 2)) && (User_BSXY_Time <= 600))
            {
                Popup_Request(POPUP11_T_MISSION_OIL);
            }
            else
            {
                Popup_Delete(POPUP11_T_MISSION_OIL);
            }
            /*64.差速器油*/
            if (((State_Flag.User_CSQY_FLAG    == 1) || (State_Flag.User_CSQY_FLAG    == 2)) && (User_CSQY_Time <= 600))
            {
                Popup_Request(POPUP11_DIFF_OIL);
            }
            else
            {
                Popup_Delete(POPUP11_DIFF_OIL);
            }
            /*65.顺畅系统离合器油*/
            //if(((State_Flag.User_LHQY_FLAG   == 1) || (State_Flag.User_LHQY_FLAG   == 2))&&(User_LHQY_Time <= 600))
            if (0)
            {
                Popup_Request(POPUP11_CLUTCH_OIL);
            }
            else
            {
                Popup_Delete(POPUP11_CLUTCH_OIL);
            }
            /*66.动力转向液*/
            if (((State_Flag.User_DLZXY_FLAG   == 1) || (State_Flag.User_DLZXY_FLAG   == 2)) && (User_DLZXY_Time <= 600))
            {
                Popup_Request(POPUP11_P_STEERING_FRUID);
            }
            else
            {
                Popup_Delete(POPUP11_P_STEERING_FRUID);
            }
            /*67.更换轮胎・轮胎位置*/
            if (((State_Flag.User_LT_FLAG      == 1) || (State_Flag.User_LT_FLAG      == 2)) && (User_LT_Time <= 600))
            {
                Popup_Request(POPUP11_TIRE_ROTATION);
            }
            else
            {
                Popup_Delete(POPUP11_TIRE_ROTATION);
            }
#endif
        }
        else /*ig off*/
        {
            Popup_Clear(POPUP1_BRAKE_BLACK);             /*00.紧急警报-刹车*/
            Popup_Clear(POPUP1_BRAKE_BRAKE);             /*01.紧急警报-紧急制动*/
            Popup_Clear(POPUP1_BRAKE_SPACING_R);         /*02.车间距警报-刹车(红字)*/
            Popup_Clear(POPUP1_BRAKE_SPACING_COLLISION); /*03.车间距警报-碰撞报警*/
            Popup_Clear(POPUP1_BRAKE_SPACING_Y);         /*04.车间距警报-刹车(黄字)*/
            Popup_Clear(POPUT1_ASR_OPERATE);             /*05.ASR工作*/
            Popup_Clear(POPUT2_PTO);                     /*06.PTO紧急警报-刹车*/
            Popup_Clear(POPUP2_PARKING_BRAKE);           /*07.忘记松手刹车*/
            Popup_Clear(POPUP2_AIRMATIC_HIGHT);          /*08.遥控调整车辆高度(有车速)*/
            Popup_Clear(POPUP3_CRUISE);                  /*09.自动巡航模式*/
            Popup_Clear(POPUP3_VARIABLE_SLD);            /*10.可变SLD 模式*/
            Popup_Clear(POPUT4_ABNORMAL_CHARGE);         /*11.充电异常（系统检测）*/
            Popup_Clear(POPUP4_OIL_PRESSURE);            /*12.油压（系统检测）*/
            Popup_Clear(POPUP4_AMT_INIT_EXCE);           /*13.AMT初始化异常*/
            Popup_Clear(POPUP4_ADBLUE_QUALITY);          /*14.尿素品质异常（系统检测）*/
            Popup_Clear(POPUP4_ADBLUE_SPRAY);            /*15.尿素喷射异常（系统检测）*/
            Popup_Clear(POPUP4_ADBLUE_SUPPLY);           /*16.尿素水补给（系统检测）*/
            Popup_Clear(POPUP4_START_ENG);               /*17.AMT初始化结束*/
            Popup_Clear(POPUP4_DPD_AUTO);                /*18.DPD自动再生*/
            Popup_Clear(POPUP5_OVER_HEAT);               /*19.过热（过热，请在安全的场所停车）*/
            Popup_Clear(POPUP5_LOW_COOLANT);             /*20.冷却水（冷却水不足）*/
            Popup_Clear(POPUP5_ENGINE_OIL_PRESSURE);     /*21.油压异常*/
            Popup_Clear(POPUP5_METER_FAILURE);           /*22.仪表故障-请与五十铃公司联系*/
            Popup_Clear(POPUP5_CAN_ERROR);               /*23.通信系统-请与五十铃公司联系*/
            Popup_Clear(POPUP5_SPEED_LIMIT);             /*24.车速限制*/
            Popup_Clear(POPUP5_TORQUE_REDUCTION);        /*25.扭矩限制*/
            Popup_Clear(POPUP5_INCORRECT_ADBLUE);        /*26.尿素品质异常*/
            Popup_Clear(POPUP5_CRITICAL_EMISSION);       /*27.临界排放故障*/
            Popup_Clear(POPUP5_AMT_SPANNER_WARNING);     /*28.AMT异常-请重启发动机*/
            Popup_Clear(POPUP5_AMT_LOW_AIR_WARNING);     /*29.AMT异常(气压低下)*/
            Popup_Clear(POPUP5_LOW_PRESSURE_ALARM);      /*30.胎压报警-快速漏气*/
            Popup_Clear(POPUP5_APP_ADBLUE);              /*31.尿素补给-补充尿素溶液*/
            Popup_Clear(POPUP5_ADBLUE_LEVEL_LOW);        /*32.尿素余量少-无车速*/
            Popup_Clear(POPUP5_LOW_FAILURE);             /*33.胎压报警-气压低*/
            Popup_Clear(POPUP5_CAMERA_POLLUTION);        /*34.摄像头有污染-请与五十铃公司联系*/
            Popup_Clear(POPUP5_AdBlue_INJ_SYSTEM);       /*35.尿素喷射异常（停止）*/
            Popup_Clear(POPUP5_AdBlue_DOS_MALFUNC);      /*36.尿素喷射异常（消耗量）*/
            Popup_Clear(POPUP5_TPMS_HIGH_AIR);           /*37.高圧警報-轮胎高压警告*/
            Popup_Clear(POPUP5_TPMS_HIGH_TEMP);          /*38.高温警報-轮胎高温警告*/
            Popup_Clear(POPUP5_PUSH_DPD_SWITCH1);        /*39.DPD手动再生要求1-请按下DPD开关*/
            Popup_Clear(POPUP5_PUSH_DPD_SWITCH2);        /*40.DPD手动再生要求2-请按下DPD开关*/
            Popup_Clear(POPUP5_TPMS_FAILURE);            /*41.TPMS故障*/
            Popup_Clear(POPUP5_TPMS_MONITOR_DROP);       /*42.TPMS電池低下-轮胎监控传感器电压下降*/
            Popup_Clear(POPUP6_HEIGHT_CONTROL);          /*43.遥控车辆高度调整中(无车速)*/
            Popup_Clear(POPUP6_PTO_STOP);                /*44.PTO(停车中)*/
            Popup_Clear(POPUP7_CHARGE_ABNORMAL);         /*45.充电异常-请与五十铃公司联系*/
            Popup_Clear(POPUP7_AMT_ERROR);               /*46.AMT異常-请联系经销商*/
            Popup_Clear(POPUP8_REFUEL);                  /*47.补充燃料-油箱单位*/
            Popup_Clear(POPUP8_ATM_CLUCH_OVERHEATING);   /*48.AMT过热-选择合适的档位*/
            Popup_Clear(POPUP8_ATM_WORN_OUT);            /*49.AMT磨耗-离合器磨损*/
            Popup_Clear(POPUP8_LOWVOLTAGE);              /*50.低电压报警*/
            Popup_Clear(POPUP8_OVERVOLTAGE);             /*51.过电压报警*/
            Popup_Clear(POPUP8_BRAKE_BLOCKR);            /*52.后蹄片磨损*/
            Popup_Clear(POPUP8_BRAKE_BLOCKF);            /*53.前蹄片磨损*/
            Popup_Clear(POPUP8_DPD_AUTO);                /*54.DPD自动再生-再生将自动完成，不需要操作开关*/
            Popup_Clear(POPUP9_AIR_PRESSURE);            /*55.气压过低-请冲入空气*/
            Popup_Clear(POPUP9_EBS_ERROR);               /*56.EBS故障（红）-请与五十铃公司联系*/
            Popup_Clear(POPUP10_RAPID_ACC);              /*57.省油耗建议-急加速*/
            Popup_Clear(POPUP10_RAPID_SUB);              /*58.省油耗建议-急减速*/
            Popup_Clear(POPUP10_REVAL_ENGINE);           /*59.省油耗建议-请降低发动机转速*/
            Popup_Clear(POPUP10_REVAL_SPEED);            /*60.省油耗建议-请降低速度*/
            Popup_Clear(POPUP11_ENGINE_OIL_FILTER);      /*61.发动机机油＆滤清器*/
            Popup_Clear(POPUP11_FUEL_FILTER);            /*62.燃油滤清器*/
            Popup_Clear(POPUP11_T_MISSION_OIL);          /*63.变速箱油*/
            Popup_Clear(POPUP11_DIFF_OIL);               /*64.差速器油*/
            Popup_Clear(POPUP11_CLUTCH_OIL);             /*65.顺畅系统离合器油*/
            Popup_Clear(POPUP11_P_STEERING_FRUID);       /*66.动力转向液*/
            Popup_Clear(POPUP11_TIRE_ROTATION);          /*67.更换轮胎・轮胎位置*/
        }
    }
}

void Popups_Displaying(uint8_t PopupMsg)
{
    if (PopupMsg < POPUP_MSG_NUMBER_TOTAL)
    {
        switch (PopupMsgAttributeTable[PopupMsg].Type)
        {
        case POPUP_TYPE_GENERAL:
            GUI_General_Popup_Display(PopupMsg);
            break;

        default:
            break;
        }
    }
}

void Popups_Sound_Playing(uint8_t PopupSnd)
{
    uint8_t ReqCode = 0u;

    ReqCode = Popup_Get_Current_Sound_Req_Code();

    switch (PopupSnd)
    {
    default:
        if (ReqCode)
            Sound_Request(PopupSnd, ReqCode);
        else
            Sound_Delete(PopupSnd);
        break;
    }
}
