/**************************************************************************
 * \file     Tasks.c
 * \brief    Task list
 * \details
 * \author   Zhang Xuan
 * \version  V1.0.0
 * \date     07-Sep-2018
 * \par      History:
 *           V1.0.0 Initial release
 * \par      Copyright:
 *           (c) Heilongjiang TYW Electronics co., LTD
 ******************************************************************************/
#include "r_typedefs.h"
#include "Sys_Scheduler.h"
#include "rh850_macros.h"

#include "Analog_Signals.h"
#include "RTC.h"

#include "Watchdog.h"

#include "debugger.h"
#include "Emulated_EEPROM.h"

#include "r_ddb_api.h"
#include "r_wm_api.h"
#include "Graphic.h"

#include "CAN_Communication_Matrix.h"
#include "CAN_FUNC.h"

#include "PowerManagement.h"
#include "System_Monitor.h"
#include "Common_Interface.h"

#include "Services_ODO_User.h"
#include "Data_CoolantTemperature.h"
#include "Data_VehicleSpeed.h"
#include "Data_EngineSpeed.h"
#include "AC_TEMP.h"
#include "Data_Time.h"
#include "Data_Gear.h"
#include "Data_Voltmeter.h"
#include "Data_WET.h"
#include "Data_AirPressure.h"
#include "Data_Fuel_User.h"
#include "Services_Mileage.h"
//#include "Services_ODO.h"
#include "Services_Mileage.h"
//#include "Services_Trip.h"
#include "Speed_PPK_Out.h"
#include "Service_TPMS.h"
#include "Service_OFF_Time.h"

#include "Flash_synchronizer.h"
#include "Line_in.h"
#include "Telltales.h"
#include "GUI.h"
#include "Key.h"
#include "Menu.h"

#include "GUI_Interface.h"
#include "Popup_Scheduler.h"
#include "Popups.h"

#include "GaugesInterface.h"
#include "DisplaySch_user.h"

#include "Sound_Scheduler.h"
#include "Sound_Player.h"
#include "BGLInterface.h"
#include "BackLight_APP.h"
#include "CD4051.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "DoCAN_ISO15765.h"
#include "UDS_ISO14229_Server.h"
#include "Maintenance.h"
#include "Data_FuelConsump.h"

#include "IS31FL3236.h"
#include "TimerB.h"

#include "BU98R10.h"
#include "SEG_DISPLAY.h"

#include "Buzzer.h"
#include "CAN_FUNC.h"
#include "app_Service.h"

#include "kwp2000_tp.h"
#include "kwp2000_protocol.h"

#include "UART.h"

static uint8_t u08_1ms_count;

/*******************************************************************************
 *                                                                              *
 *   系统常规运行模式(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )任务列表   *
 *                                                                              *
 *******************************************************************************/

/*==============================================================================
伪实时任务
------------------------------------------------------------------------------*/

void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service();
    DoCAN_Communication_Service();
    UDS_Server_Application_Service();
    IS31_Service();
    BU98R10_Update_Service();
    Diagnosis_main();

}
/*============================================================================*/

/*==============================================================================
2ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks(void)
{
    uint16_t m16_FrameCnt;

    UDS_KL15_init();
    Analog_Signal_Conv_Service();
    Sys_Status_Update_Service();
    Common_Input_Para();
    m16_FrameCnt = Common_GetHMI_StartAnimationFrameCnt();
    m16_FrameCnt = m16_FrameCnt / 4u;

    if (m16_FrameCnt >= FRAMECNTFLAG)
    {
        Gauges_Time_Xms_Count(2);
    }
    UDS_10ms_Service();
}
/*============================================================================*/
/*==============================================================================
10ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks(void)
{
    COM_RX_Process();
    Id18EF1817_Send_Service();
    Id18033317_Send_Service();
    Id18FFE517_Send_Service();
}

/*==============================================================================
10ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks(void)
{
    DisplayServices();
    loc_Display_Service();
    Data_Mileage_Write_EEPROM();
    Line_In_Debounce_Service();
    Telltales_Left_Right_Management_Service();

    if (MenuFlag.Menu_Popup_Flag == 4u)
    {
        Test_LED_AllLight();
    }
    else
    {
        Telltales_Management();
    }

    Key_Service();
    CAN_BUSOFF_Recover();

    /*表头调度函数 added by yutian*/
    UserGaugeSchedule(); /*在主循环中调用*/
    /*end*/
    CD4051B_ReadSignal_Serviece();
    Sound_Play_Service();

    Can_BusOff_Fun();

    Fuel_User_KL15_ON_Processing_Service();
}
/*============================================================================*/

/*==============================================================================
20ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks(void)
{
    Coolant_Processing_Service();
    Tacho_Processing_Service();
    Speed_Processing_Service();
    AirPressure_Processing_Service();
    Voltmeter_Processing_Service();
    Sound_Management_Service();
    CD4051B_Debounce_Service();
    Seg_Display_Service(); /*段码显示逻辑*/
    Seg_Buffer_Commit();
    BU98R10_Update_Request();
}
/*============================================================================*/

/*==============================================================================
50ms周期执行任务
------------------------------------------------------------------------------*/

void Sys_Run_Mode_50ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();
    Data_Time_Calibration();
    Speed_PPK_Processing();
    Sound_Scheduling_Service();
    // BGTask();
    IS31_Scan_Refresh();

    Drive_Info_IC1_STATUS_Rx();
    Drive_Info_IC3_STATUS_Rx();
}
/*============================================================================*/

/*==============================================================================
100ms周期执行任务
------------------------------------------------------------------------------*/
//uint8_t   YZHD_TEST[10] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
//uint32_t  YZHD_Count = 0;
void Sys_Run_Mode_100ms_Tasks(void)
{

    BL_Management_service();
    RTE_RTC_Services_100Ms_Cbk();
    Data_ODO_Processing();
    Data_Trip_Processing();
    // Data_Avg_Speed_Processing();
    Data_TPMS_Value_Processing();
    Data_Ambient_Temperature_Processing();

    // Display_Schedule_Service();/*显示函数入口*/
    // Menu_Display_Service();
    // External_Influence_ENERGY_RECOVERY_LEVEL_Select();
    // LongTimeNoKey_Operation();
    // Menu_Get_Battery_Sts_Exist();
    Popups_Management_Service();
    Popup_Scheduling_Service();
    Popup_Alone_Sound_Server();

    /*保养通知数据计算*/
    Common_EOL_User_Server();
    /*加速度计算*/
    Data_Acc_Speed_Processing();
    /*高速路一般路报警判断*/
    Data_GsLYbL_Speed_Processing();
    /**/
    Common_Set_K_Line_Value();
    Common_DTC_Server();

    Drive_Info_Speed1_Plus_Conversion();

    //YZHD_Count++;
    //if (YZHD_Count == 20)
    //{
    //    UART_Ch2_Send_Multiple_Byte(&YZHD_TEST[0],  10);
    //}
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                     系统休眠模式(SYS_MODE_SLEEP)任务列表                     *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
休眠模式下执行的后台任务
------------------------------------------------------------------------------*/
void Sys_Sleep_Mode_Tasks(void)
{
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           精确的50us计时任务列表                             *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
精确的50us计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
    static uint16_t PerCounter = 0u;
    Sys_Rolling();
    COM_NM_Process();
    COM_TX_Process();
    DoCAN_Timer_Update(50);
    // TimerB_Fre_Timeout(50);
    Cal_Veh_Cycle(SPEED_SIGNAL_PWM_IN); /*车速输入，非捕获方式 20211018*/
    PerCounter++;
    if (PerCounter >= 20 * 5)
    {
        PerCounter = 0u;
        SEG_LCD_Window_Control_Service();
    }
    Buzzer_Play_ISR();

    /*----K_Line----*/
    u08_1ms_count ++;
    if (u08_1ms_count >= 20)
    {
        u08_1ms_count = 0;
        Kwp2000_ComInit_Handle();
        Kwp2000_Handle(); /* qitiancun */
        Kwp2000_Timeout();
    }
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           精确的100ms计时任务列表                            *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
精确的100ms计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
    Data_Mileage_ISR();
    Service_OFF_Timing_Process();
    Fuel_User_KL15_OFF_Processing_Service();
}
/*============================================================================*/

void APP_Startup_Init(uint8_t startMode)
{
    Power_Management_Init(startMode);
}
