#ifndef _EOL_Para_H_
#define _EOL_Para_H_

#include "TYW_stdint.h"

typedef struct
{
    uint32_t Flag;
    uint8_t  DID_605C;
    uint8_t  DID_605D;
    uint8_t  DID_605E;
    uint8_t  DID_605F;
    uint8_t  DID_6060;
    uint8_t  DID_6062[2];
    uint8_t  DID_6063;
    uint8_t  DID_6064;
    uint8_t  DID_6068;
    uint8_t  DID_606D;
    uint8_t  DID_606E;
    uint8_t  DID_606F[2];
    uint8_t  DID_6070;
    uint8_t  DID_6071;
    uint8_t  DID_6072;
    uint8_t  DID_6073;
    uint8_t  DID_6074;
    uint8_t  DID_6075;
    uint8_t  DID_6076[3];
    uint8_t  DID_60C9;
    uint8_t  DID_60CA[2];
    uint8_t  DID_60CB[2];
    uint8_t  DID_60CC;
    uint8_t  DID_60CD[2];
    uint8_t  DID_60CE;
    uint8_t  DID_60CF;
    uint8_t  DID_60D0;
    uint8_t  DID_60D1;
    uint8_t  DID_60D2;
} _EOL_Data_Type;

extern _EOL_Data_Type EOL_Data_Type;

void EOL_InitVal(void);
/*LDWS(车道偏离)系统开关*/
uint8_t Val_EOL_605C_LDWS(void);
/*AFS 系统开关*/
uint8_t Val_EOL_605D_AFS(void);
/*HUD 系统开关*/
uint8_t Val_EOL_605E_HUD(void);
/* ACC 系统开关关*/
uint8_t Val_EOL_605F_ACC(void);
/* 称重系统开关*/
uint8_t Val_EOL_6060_Weigh(void);
/* 车速里程表 K 值*/
uint16_t Val_EOL_6062_KValue(void);
/* 发动机速比*/
uint8_t Val_EOL_6063_Engine(void);
/* 单位*/
uint8_t Val_EOL_6064_Unit(void);
/* 语言*/
uint8_t Val_EOL_6068_Language(void);
/* 轮胎防盗使能开关*/
uint8_t Val_EOL_606D_TireAntiTheft(void);
/* 换挡提示设置*/
uint8_t Val_EOL_606E_Shift(void);
/* 油箱容量设置*/
uint16_t Val_EOL_606F_FuelTank(void);
/* HAS 系统开关*/
uint8_t Val_EOL_6070_HAS(void);
/* ESC 系统开关*/
uint8_t Val_EOL_6071_ESC(void);
/* 盘式制动磨损报警功能*/
uint8_t Val_EOL_6072_DiscBrake(void);
/*挂车设置*/
uint8_t Val_EOL_6073_SetRrailer(void);
/*排放配置*/
uint8_t Val_EOL_6074_Emission(void);
/*超速报警车型信号*/
uint8_t Val_EOL_6075_SpeedAlarm(void);
/* 油箱容量设置*/
uint32_t Val_EOL_6076_FuelTank(void);
/*尿素箱容积*/
uint8_t Val_EOL_60C9_Urea(void);
/* 主油箱容积*/
uint16_t Val_EOL_60CA_MainFuelTank(void);
/* 副油箱容积*/
uint16_t Val_EOL_60CB_AuxiliaryTank(void);
/*油箱类型*/
uint8_t Val_EOL_60CC_FuelTankType(void);
/* 发动机类型*/
uint16_t Val_EOL_60CD_EngineType(void);
/*TCU 类型*/
uint8_t Val_EOL_60CE_FuelTankType(void);
/*驱动能源类型*/
uint8_t Val_EOL_60CF_DriveEnergy(void);
/*驱动形式*/
uint8_t Val_EOL_60D0_DriveForm(void);
/*蓄电池容量*/
uint8_t Val_EOL_60D1_BatteryCapacity(void);
/*电池管理系统*/
uint8_t Val_EOL_60D2_BatteryManagement(void);

#endif