/*
****************************************************************************
PROJECT : GRAPE_APP
FILE    : $Id: write.c 25427 2013-06-14 07:55:45Z nan.wang $
============================================================================ 
DESCRIPTION
Sample program for demonstration of the D1MX GFX features
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2014
                                  by 
                       Renesas Electronics (Europe) GmbH. 
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing, not for mass production

DISCLAIMER 

LICENSEE has read, understood and accepted the terms and conditions defined in
the license agreement, especially the usage rights. In any case, it is
LICENSEE's responsibility to make sure that any user of the software complies
with the terms and conditions of the signed license agreement.

SAMPLE CODE is not part of the licensed software, as such it must not be used in
mass-production applications. It can only be used for evaluation and
demonstration purposes at customer抯 premises listed in the signed license
agreement.
****************************************************************************
*/

/***********************************************************
  Title: Write Module 
  
  This module contains the write functions for bitmap fonts.
*/


/***********************************************************
  Section: Includes
*/

#include "r_typedefs.h"         /* Renesas basic types, e.g. uint32_t */
#include "r_drw2d_os.h"
#include "r_drw2d_api.h"
#include "img_format.h"
#include "font.h"
#include "write.h"
#include "r_config_d1x.h"
#include "main.h"
#include "images.h"
#include "han00002ce20.h"
#include <stdint.h>
//#include "han5c009f00.h"
//#include "han34009fff.h"
/***********************************************************
  Variable: locCurrentFont

  Font to be used by text operations.
*/

static const Font_t *locCurrentFont;

static r_drw2d_Rect_t rect;
static r_drw2d_Rect_t src_rect;
static r_drw2d_Texture_t tex;

/***********************************************************
  Function: locGetCharRemapping
*/

static int locGetCharRemapping(unsigned char Character)
{
    int c;
    
    /* Character remapping */
    if ((Character >= 32) && (Character < 128))
    {
        /* visible ASCII characters start with 32 (blank)
           not visible chars 0-31 and will be omitted */
        c = (Character - 32);
    }
    else
    {
        switch (Character)
        {
            case 0xB0:
            	  /* special remapping for non ASCII character 'degree' (掳 or 0xB0)
            	     non visible char DEL (127) will be used for 'degree' */
                c = (127 - 32);
                break;
            default:
                /* use blank as default */
                c = 0;
                break;
        }
    }
    return c;
}


/***********************************************************
  Function: locWriteChar

  Write a single character.

  Use the currently selected buffer, font and color to draw
  a character at the given position.

  Parameters:
  Dev        - R_DRW2D device structure
  PosX       - Display X position (not turned)
  PosY       - Display Y position (not turned)
  Character  - ASCII value of the character

  Returns:
  void
*/
static const FontPos_t FontPos[] = {
    { 0, 4}, /*   */
    { 4, 4}, /* ! */
    { 8, 8}, /* " */
    { 16, 9}, /* # */
    { 25, 9}, /* $ */
    { 34, 16}, /* % */
    { 50, 12}, /* & */
    { 62, 4}, /* ' */
    { 66, 5}, /* ( */
    { 71, 5}, /* ) */
    { 76, 6}, /* * */
    { 82, 9}, /* + */
    { 91, 4}, /* , */
    { 95, 5}, /* - */
    { 100, 4}, /* . */
    { 104, 4}, /* / */
    { 108, 9}, /* 0 */
    { 117, 9}, /* 1 */
    { 126, 9}, /* 2 */
    { 135, 9}, /* 3 */
    { 144, 9}, /* 4 */
    { 153, 9}, /* 5 */
    { 162, 9}, /* 6 */
    { 171, 9}, /* 7 */
    { 180, 9}, /* 8 */
    { 189, 9}, /* 9 */
    { 198, 6}, /* : */
    { 204, 6}, /* ; */
    { 210, 9}, /* < */
    { 219, 9}, /* = */
    { 228, 9}, /* > */
    { 237, 10}, /* ? */
    { 247, 16}, /* @ */
    { 263, 11}, /* A */
    { 274, 12}, /* B */
    { 286, 12}, /* C */
    { 298, 12}, /* D */
    { 310, 11}, /* E */
    { 321, 10}, /* F */
    { 331, 12}, /* G */
    { 343, 12}, /* H */
    { 355, 4}, /* I */
    { 359, 9}, /* J */
    { 368, 12}, /* K */
    { 380, 10}, /* L */
    { 390, 13}, /* M */
    { 403, 12}, /* N */
    { 415, 12}, /* O */
    { 427, 11}, /* P */
    { 438, 12}, /* Q */
    { 450, 12}, /* R */
    { 462, 11}, /* S */
    { 473, 10}, /* T */
    { 483, 12}, /* U */
    { 495, 11}, /* V */
    { 506, 15}, /* W */
    { 521, 11}, /* X */
    { 532, 10}, /* Y */
    { 542, 9}, /* Z */
    { 551, 5}, /* [ */
    { 556, 4}, /* \ */
    { 560, 5}, /* ] */
    { 565, 9}, /* ^ */
    { 574, 9}, /* _ */
    { 583, 5}, /* ` */
    { 588, 9}, /* a */
    { 597, 10}, /* b */
    { 607, 9}, /* c */
    { 616, 10}, /* d */
    { 626, 9}, /* e */
    { 635, 6}, /* f */
    { 641, 9}, /* g */
    { 650, 10}, /* h */
    { 660, 4}, /* i */
    { 664, 5}, /* j */
    { 669, 9}, /* k */
    { 678, 4}, /* l */
    { 682, 14}, /* m */
    { 696, 10}, /* n */
    { 706, 10}, /* o */
    { 716, 10}, /* p */
    { 726, 10}, /* q */
    { 736, 6}, /* r */
    { 742, 9}, /* s */
    { 751, 5}, /* t */
    { 756, 10}, /* u */
    { 766, 9}, /* v */
    { 775, 13}, /* w */
    { 788, 9}, /* x */
    { 797, 9}, /* y */
    { 806, 9}, /* z */
    { 815, 6}, /* { */
    { 821, 4}, /* | */
    { 825, 6}, /* } */
    { 831, 10}, /* ~ */
    { 841, 6}, /*  */
};

typedef struct
{
    unsigned short StartAddr;
    unsigned short EndAddr;
    unsigned short Offset;
}s_FontBlock;

#define FONT_BLOCK_MAX      220

static s_FontBlock FontBlock[FONT_BLOCK_MAX] = 
{
    {0, 126, 0          },
    {160, 259, 33       },
    {272, 275, 45       },
    {282, 283, 51       },
    {296, 299, 63       },
    {323, 324, 86       },
    {327, 328, 88       },
    {332, 335, 91       },
    {338, 339, 93       },
    {360, 365, 113      },
    {402, 402, 149      },
    {416, 417, 162      },
    {431, 432, 175      },
    {461, 476, 203      },
    {504, 505, 230      },
    {593, 593, 317      },
    {609, 609, 332      },
    {711, 711, 433      },
    {713, 715, 434      },
    {729, 729, 447      },
    {913, 929, 630      },
    {931, 937, 631      },
    {945, 961, 638      },
    {963, 969, 639      },
    {1025, 1025, 694    },
    {1040, 1103, 708    },
    {1105, 1105, 709    },
    {7742, 7743, 7345   },
    {7840, 7929, 7441   },
    {8194, 8195, 7705   },
    {8208, 8214, 7717   },
    {8216, 8218, 7718   },
    {8220, 8222, 7719   },
    {8224, 8226, 7720   },
    {8229, 8231, 7722   },
    {8240, 8240, 7730   },
    {8242, 8243, 7731   },
    {8245, 8245, 7732   },
    {8249, 8252, 7735   },
    {8258, 8258, 7740   },
    {8263, 8265, 7744   },
    {8273, 8273, 7751   },
    {8361, 8361, 7838   },
    {8364, 8364, 7840   },
    {8413, 8414, 7888   },
    {8448, 8448, 7921   },
    {8451, 8451, 7923   },
    {8453, 8453, 7924   },
    {8457, 8458, 7927   },
    {8463, 8463, 7931   },
    {8467, 8467, 7934   },
    {8470, 8470, 7936   },
    {8481, 8482, 7946   },
    {8486, 8487, 7949   },
    {8491, 8491, 7952   },
    {8494, 8494, 7954   },
    {8501, 8501, 7960   },
    {8507, 8507, 7965   },
    {8544, 8555, 8001   },
    {8560, 8571, 8005   },
    {8592, 8601, 8025   },
    {8632, 8633, 8055   },
    {8644, 8646, 8065   },
    {8651, 8652, 8069   },
    {8656, 8656, 8072   },
    {8658, 8658, 8073   },
    {8660, 8660, 8074   },
    {8678, 8681, 8091   },
    {8693, 8693, 8102   },
    {8704, 8704, 8112   },
    {8706, 8707, 8113   },
    {8709, 8715, 8114   },
    {8719, 8719, 8117   },
    {8721, 8723, 8118   },
    {8725, 8725, 8119   },
    {8730, 8730, 8123   },
    {8733, 8736, 8125   },
    {8739, 8739, 8127   },
    {8741, 8750, 8128   },
    {8756, 8759, 8133   },
    {8765, 8765, 8138   },
    {8771, 8771, 8143   },
    {8773, 8773, 8144   },
    {8776, 8776, 8146   },
    {8780, 8780, 8149   },
    {8786, 8786, 8154   },
    {8800, 8802, 8167   },
    {8804, 8807, 8168   },
    {8810, 8811, 8170   },
    {8814, 8815, 8172   },
    {8818, 8819, 8174   },
    {8822, 8823, 8176   },
    {8834, 8839, 8186   },
    {8842, 8843, 8188   },
    {8853, 8857, 8197   },
    {8864, 8864, 8203   },
    {8869, 8869, 8207   },
    {8895, 8895, 8232   },
    {8922, 8923, 8258   },
    {8965, 8967, 8299   },
    {8978, 8978, 8309   },
    {8984, 8984, 8314   },
    {9001, 9002, 8330   },
    {9136, 9137, 8463   },
    {9150, 9164, 8475   },
    {9166, 9166, 8476   },
    {9178, 9179, 8487   },
    {9251, 9251, 8558   },
    {9312, 9643, 8618   },
    {9649, 9651, 8623   },
    {9654, 9655, 8625   },
    {9660, 9661, 8629   },
    {9664, 9665, 8631   },
    {9670, 9676, 8635   },
    {9678, 9683, 8636   },
    {9698, 9702, 8650   },
    {9711, 9711, 8658   },
    {9728, 9731, 8674   },
    {9733, 9734, 8675   },
    {9737, 9737, 8677   },
    {9742, 9743, 8681   },
    {9750, 9751, 8687   },
    {9756, 9759, 8691   },
    {9775, 9775, 8706   },
    {9792, 9794, 8722   },
    {9824, 9839, 8751   },
    {9842, 9853, 8753   },
    {9888, 9888, 8787   },
    {9917, 9918, 8815   },
    {9986, 9986, 8882   },
    {10003, 10003, 8898 },
    {10010, 10010, 8904 },
    {10045, 10045, 8938 },
    {10047, 10048, 8939 },
    {10070, 10070, 8960 },
    {10102, 10111, 8991 },
    {10145, 10145, 9024 },
    {10548, 10549, 9426 },
    {10687, 10687, 9563 },
    {10746, 10747, 9621 },
    {11013, 11015, 9886 },
    {11034, 11034, 9904 },
    {11834, 11835, 10703},
    {11904, 11929, 10771},
    {11931, 12019, 10772},
    {12032, 12245, 10784},
    {12272, 12283, 10810},
    {12288, 12351, 10814},
    {12353, 12438, 10815},
    {12441, 12543, 10817},
    {12549, 12589, 10822},
    {12593, 12643, 10825},
    {12645, 12686, 10826},
    {12688, 12730, 10827},
    {12736, 12771, 10832},
    {12784, 12830, 10844},
    {12832, 13054, 10845},
    {13056, 13099, 10846},
    {13101, 19893, 10847},
    {19968, 40912, 10921},
    {63744, 63747, 33752},
    {63749, 63750, 33753},
    {63755, 63756, 33757},
    {63768, 63768, 33768},
    {63777, 63777, 33776},
    {63789, 63789, 33787},
    {63791, 63791, 33788},
    {63793, 63797, 33789},
    {63799, 63802, 33790},
    {63811, 63811, 33798},
    {63815, 63816, 33801},
    {63818, 63818, 33802},
    {63822, 63822, 33805},
    {63826, 63827, 33808},
    {63838, 63838, 33818},
    {63842, 63847, 33821},
    {63854, 63854, 33827},
    {63858, 63858, 33830},
    {63860, 63860, 33831},
    {63866, 63867, 33836},
    {63870, 63872, 33838},
    {63876, 63877, 33841},
    {63882, 63884, 33845},
    {63886, 63886, 33846},
    {63891, 63891, 33850},
    {63893, 63893, 33851},
    {63896, 63896, 33853},
    {63918, 63918, 33874},
    {63923, 63923, 33878},
    {63927, 63927, 33881},
    {63931, 63931, 33884},
    {63933, 63934, 33885},
    {63936, 63936, 33886},
    {63941, 63942, 33890},
    {63952, 63952, 33899},
    {63960, 63961, 33906},
    {63966, 63968, 33910},
    {63970, 63972, 33911},
    {63977, 63977, 33915},
    {63988, 63989, 33925},
    {63994, 63994, 33929},
    {63997, 63997, 33931},
    {64002, 64002, 33935},
    {64005, 64008, 33937},
    {64010, 64010, 33938},
    {64012, 64013, 33939},
    {64073, 64073, 33998},
    {64093, 64094, 34017},
    {64256, 64260, 34178},
    {65040, 65049, 34957},
    {65072, 65106, 34979},
    {65108, 65126, 34980},
    {65128, 65131, 34981},
    {65281, 65470, 35130},
    {65474, 65479, 35133},
    {65482, 65487, 35135},
    {65490, 65495, 35137},
    {65498, 65500, 35139},
    {65504, 65510, 35142},
    {65512, 65518, 35143},
};

static unsigned short GetWordIndex(unsigned short unicodeID)
{
    unsigned short StartIndex = 0;
    unsigned short MiddleIndex = FONT_BLOCK_MAX / 2;
    unsigned short EndIndex = FONT_BLOCK_MAX;
    unsigned short i;
    unsigned short ret = 0xFFFF;
    unsigned char OverFlag = 0;

    for (i = 0; i < 10; i++)
    {
        switch (EndIndex - StartIndex)
        {
            case 0:
            {
                if ((unicodeID <= FontBlock[StartIndex].EndAddr) && (unicodeID >= FontBlock[StartIndex].StartAddr))
                {
                    //ret = Hansans00002ce20[unicodeID - FontBlock[StartIndex].Offset].FontID;
                    ret = unicodeID - FontBlock[StartIndex].Offset;
                }
                else
                {
                    ret = 0xFFFF;
                }
                OverFlag = 1;
            }break;

            case 1:
            {
                if ((unicodeID <= FontBlock[StartIndex].EndAddr) && (unicodeID >= FontBlock[StartIndex].StartAddr))
                {
                    //ret = Hansans00002ce20[unicodeID - FontBlock[StartIndex].Offset].FontID;
                    ret = unicodeID - FontBlock[StartIndex].Offset;
                }
                else if ((unicodeID <= FontBlock[EndIndex].EndAddr) && (unicodeID >= FontBlock[EndIndex].StartAddr))
                {
                    //ret = Hansans00002ce20[unicodeID - FontBlock[EndIndex].Offset].FontID;
                    ret = unicodeID - FontBlock[EndIndex].Offset;
                }
                else
                {
                    ret = 0xFFFF;
                }
                OverFlag = 1;
            }break;

            default:
                break;
        }
        if (OverFlag)
        {
            break;
        }
        if ((unicodeID < FontBlock[MiddleIndex].StartAddr) && (unicodeID >= FontBlock[StartIndex].StartAddr))
        {
            //StartIndex = StartIndex;
            EndIndex = MiddleIndex;
            MiddleIndex = (EndIndex + StartIndex) / 2;
        }
        else
        {
            StartIndex = MiddleIndex;
            MiddleIndex = (EndIndex + StartIndex) / 2;
        }
    }

    return ret;
}

static void locWriteChar(r_drw2d_Device_t Dev, int PosX, int PosY, unsigned char Character)
{
    int       xsrc;
    int       wsrc;
    char      c;
   
    c = locGetCharRemapping(Character);
    xsrc  = FontPos[c].Offset;
    wsrc  = FontPos[c].Width;

    rect.Pos.X = R_DRW2D_2X(PosX);
    rect.Pos.Y = R_DRW2D_2X(PosY);
    //rect.Size.Height = R_DRW2D_2X(locCurrentFont->Height);
    rect.Size.Height = R_DRW2D_2X(19);
    rect.Size.Width = R_DRW2D_2X(wsrc);

    src_rect.Pos.X = R_DRW2D_2X(xsrc);
    src_rect.Pos.Y = R_DRW2D_2X(0);
    //src_rect.Size.Height = R_DRW2D_2X(locCurrentFont->Height);
	 src_rect.Size.Height = R_DRW2D_2X(19);
    src_rect.Size.Width = R_DRW2D_2X(wsrc);

    R_DRW2D_TextureBlit(Dev, &src_rect, &rect);
}

/***********************************************************
  Section: Global Functions

  Description see: <write.h>
*/

/***********************************************************
  Function: SelectFont
*/
/*
void SelectFont(const Font_t *Font)
{
    locCurrentFont = Font;
}
*/

/***********************************************************
  Function: GetFontHeight
*/

int GetFontHeight(void)
{
    return locCurrentFont->Height;
}



/***********************************************************
  Function: GetCharWidth
*/

int GetCharWidth(char Character)
{
    int c;

    c = locGetCharRemapping(Character);
    if ((c < 0) || (c > 95))
    {
        return 0;
    }
   // return locCurrentFont->Pos[c].Width;
    return FontPos[c].Width;
}


/***********************************************************
  Function: GetTextWidth
*/

int GetTextWidth(char *Text)
{
    int w;

    w = 0;
    while (*Text != 0)
    {
        w += GetCharWidth(*Text);
        Text++;
    }
    return w;
}

/***********************************************************
  Function: GetTextHeight
*/

int GetTextHeight(char *Text)
{
    int h;

    h = 1; /* To include the last line */
    while (*Text != 0)
    {
        if (*Text == '\n')
        {
            h += GetFontHeight();
        }
        Text++;
    }
    return h;
}
void Write_Hanzi(r_drw2d_Device_t Dev,int PosX, int PosY, r_drw2d_Color_t  Color, uint16_t a[],uint16_t count)
{
  int startx, starty;
  static r_drw2d_Texture_t tex1, tex2;
  int counti, countj, counta;
  int i, j;
  static r_drw2d_Rect_t rect;
  static r_drw2d_Rect_t src_rect;
  r_drw2d_EffectStage_t effect[2];
  uint32_t xPos, yPos;
  unsigned short xsrc, ysrc, wsrc, hsrc;
  i = 0;
  j = 0;
  counta = 0;
  /*字库地址*/
  tex1.Buffer.Data = get_Pic_Attribute(ziku_0).u32Pic_Addr;
  tex1.Buffer.Pitch = 4000;
  tex1.Buffer.PixelFormat = R_DRW2D_PIXELFORMAT_AL8;
  tex1.Buffer.Size.Height = 3900;
  tex1.Buffer.Size.Width = 4000;
  tex1.Flags = R_DRW2D_TEX_BILINEAR;
  tex1.Handle = 0;

  R_DRW2D_CtxIdentity(Dev);
  R_DRW2D_CtxTextureIdentity(Dev);

  R_DRW2D_CtxBlendMode(Dev, R_DRW2D_BLENDMODE_SRC_OVER);
  R_DRW2D_CtxFillMode(Dev, R_DRW2D_FILLMODE_TEXTURE);

  effect[0].Name = R_DRW2D_EFFECT_MODULATE;
  effect[0].Args[0].Source = R_DRW2D_EFFECT_SOURCE_TEXTURE_UNIT;
  effect[0].Args[0].Param.Color.Source.TextureUnit = 0;
  effect[0].Args[0].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;
  effect[0].Args[1].Source = R_DRW2D_EFFECT_SOURCE_CONSTANT_COLOR;
  effect[0].Args[1].Param.Color.Source.ConstantColor = Color;
  effect[0].Args[1].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;

  R_DRW2D_CtxEffectsSet(Dev, effect, 1);
  R_DRW2D_CtxTextureSet(Dev, 0, &tex1);

  startx = PosX;
  starty = PosY;

  PosY = starty;
  PosX = startx;
  for (int i = 0; i < count; i++)
  {
    //counta = a[i];
    counta = GetWordIndex(a[i]);
    if(counta < 0xFFFF)
    {
        xsrc = Hansans00002ce20[counta].Xpos; //
        ysrc = Hansans00002ce20[counta].Ypos;
        wsrc = Hansans00002ce20[counta].Width;
        hsrc = Hansans00002ce20[counta].Height;

        rect.Pos.X = R_DRW2D_2X(PosX);
        rect.Pos.Y = R_DRW2D_2X(PosY);
        rect.Size.Width = R_DRW2D_2X(wsrc);
        rect.Size.Height = R_DRW2D_2X(hsrc);

        src_rect.Pos.X = R_DRW2D_2X(xsrc);
        src_rect.Pos.Y = R_DRW2D_2X(ysrc);
        src_rect.Size.Width = R_DRW2D_2X(wsrc);
        src_rect.Size.Height = R_DRW2D_2X(hsrc);

        R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

        PosX += wsrc;
    }
    else
    {
        counta = 0x293A;
        xsrc = Hansans00002ce20[counta].Xpos; //
        ysrc = Hansans00002ce20[counta].Ypos;
        wsrc = Hansans00002ce20[counta].Width;
        hsrc = Hansans00002ce20[counta].Height;

        rect.Pos.X = R_DRW2D_2X(PosX);
        rect.Pos.Y = R_DRW2D_2X(PosY);
        rect.Size.Width = R_DRW2D_2X(wsrc);
        rect.Size.Height = R_DRW2D_2X(hsrc);

        src_rect.Pos.X = R_DRW2D_2X(xsrc);
        src_rect.Pos.Y = R_DRW2D_2X(ysrc);
        src_rect.Size.Width = R_DRW2D_2X(wsrc);
        src_rect.Size.Height = R_DRW2D_2X(hsrc);

        R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

        PosX += wsrc;
    }
    /*if ((counta >= 0x0020) && (counta < 0x007f)) //CJK latin zihao 20,15*15.
    {
      xsrc = Hansans00002ce20[counta].Xpos; //
      ysrc = Hansans00002ce20[counta].Ypos;
      wsrc = Hansans00002ce20[counta].Width;
      hsrc = Hansans00002ce20[counta].Height;

      rect.Pos.X = R_DRW2D_2X(PosX);
      rect.Pos.Y = R_DRW2D_2X(PosY);
      rect.Size.Width = R_DRW2D_2X(wsrc);
      rect.Size.Height = R_DRW2D_2X(hsrc);

      src_rect.Pos.X = R_DRW2D_2X(xsrc);
      src_rect.Pos.Y = R_DRW2D_2X(ysrc);
      src_rect.Size.Width = R_DRW2D_2X(wsrc);
      src_rect.Size.Height = R_DRW2D_2X(hsrc);

      R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

      PosX += wsrc;
    }
    else if ((counta >= 0x33ff) && (counta < 0x4db6)) //CJK siyuanheiti zihao 20,15*15.
    {
      counta -= 0x2a5f;
      xsrc = Hansans00002ce20[counta].Xpos; //
      ysrc = Hansans00002ce20[counta].Ypos;
      wsrc = Hansans00002ce20[counta].Width;
      hsrc = Hansans00002ce20[counta].Height;

      rect.Pos.X = R_DRW2D_2X(PosX);
      rect.Pos.Y = R_DRW2D_2X(PosY);
      rect.Size.Width = R_DRW2D_2X(wsrc);
      rect.Size.Height = R_DRW2D_2X(hsrc);

      src_rect.Pos.X = R_DRW2D_2X(xsrc);
      src_rect.Pos.Y = R_DRW2D_2X(ysrc);
      src_rect.Size.Width = R_DRW2D_2X(wsrc);
      src_rect.Size.Height = R_DRW2D_2X(hsrc);

      R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

      PosX += wsrc;
    }
    else if ((counta >= 0x4e00) && (counta < 0xa000)) //CJK siyuanheiti zihao 20,15*15.
    {

      counta -= 0x2aa9;

      xsrc = Hansans00002ce20[counta].Xpos; //
      ysrc = Hansans00002ce20[counta].Ypos;
      wsrc = Hansans00002ce20[counta].Width;
      hsrc = Hansans00002ce20[counta].Height;

      rect.Pos.X = R_DRW2D_2X(PosX);
      rect.Pos.Y = R_DRW2D_2X(PosY);
      rect.Size.Width = R_DRW2D_2X(wsrc);
      rect.Size.Height = R_DRW2D_2X(hsrc);

      src_rect.Pos.X = R_DRW2D_2X(xsrc);
      src_rect.Pos.Y = R_DRW2D_2X(ysrc);
      src_rect.Size.Width = R_DRW2D_2X(wsrc);
      src_rect.Size.Height = R_DRW2D_2X(hsrc);

      R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

      PosX += wsrc;
    }
    //unclude in font
    else
    {
      counta = 0x293A;  //0x53e3;  //0x09a1;

      xsrc = Hansans00002ce20[counta].Xpos; //
      ysrc = Hansans00002ce20[counta].Ypos;
      wsrc = Hansans00002ce20[counta].Width;
      hsrc = Hansans00002ce20[counta].Height;

      rect.Pos.X = R_DRW2D_2X(PosX);
      rect.Pos.Y = R_DRW2D_2X(PosY);
      rect.Size.Width = R_DRW2D_2X(wsrc);
      rect.Size.Height = R_DRW2D_2X(hsrc);

      src_rect.Pos.X = R_DRW2D_2X(xsrc);
      src_rect.Pos.Y = R_DRW2D_2X(ysrc);
      src_rect.Size.Width = R_DRW2D_2X(wsrc);
      src_rect.Size.Height = R_DRW2D_2X(hsrc);

      R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

      PosX += wsrc;
    }*/
  }
  

  R_DRW2D_CtxEffectsDelete(Dev);
}

static const uint8_t EnglishFont[] =
{
 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x15,0xff,0xf1,0x16,0xff,0xf1,0x0,0x0,0x0,0x70,0xe2,0xff,0xe0,0x70,0x0,0x0,0x19,0xb1,0xf5,0xf3,0xb0,0x19,0x0,0x0,0x0,0x34,0xfe,0xd1,0x3,0x0,0x0,0x0,0x0,0x0,0xc,0x92,0xe5,0xfb,0xe5,0x8c,0x8,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x3f,0xff,0xc5,0xc5,0xff,0x3e,0x0,0x0,0x0,0x0,0xee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1d,0xff,0xea,0x0,0x26,0xb3,0xf3,0xf3,0xb3,0x26,0x0,0x0,0x0,0x0,0x0,0x10,0xef,0xff,0x0,0x0,0x0,0x0,0x3d,0xbb,0xf3,0xf8,0xcc,0x58,0x0,0x0,0x0,0x5a,0xc6,0xf4,0xf9,0xdc,0x7d,0x1,0x0,0x0,0x0,0x0,0x0,0x1d,0xf2,0xff,0x0,0x0,0x13,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x9,0x84,0xdf,0xfa,0xe9,0x99,0x9,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x5d,0xcc,0xf7,0xf7,0xcc,0x5d,0x0,0x0,0x0,0x3d,0xc2,0xf7,0xec,0x9e,0x15,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2c,0xb6,0xf4,0xf5,0xc0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3a,0x9a,0xd7,0xf5,0xfb,0xe4,0xae,0x4f,0x0,0x0,0x0,0x0,0x0,0x0,0xb,0xf5,0xff,0xf5,0xb,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xfa,0xdf,0x80,0x2,0x0,0x0,0x0,0x0,0x0,0x57,0xbd,0xed,0xfb,0xe4,0xa0,0x25,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xfe,0xf3,0xca,0x5f,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x41,0xb5,0xee,0xfc,0xe9,0xb0,0x36,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x74,0xff,0xdd,0x1f,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0x2a,0x0,0x0,0x0,0x2b,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x71,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x5f,0xc8,0xf3,0xf3,0xc3,0x52,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xfd,0xf4,0xd6,0x6d,0x0,0x0,0x0,0x0,0x0,0x59,0xc5,0xf3,0xf4,0xc7,0x5b,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xfd,0xf2,0xce,0x6e,0x0,0x0,0x0,0x0,0x4a,0xba,0xed,0xfb,0xe7,0xa7,0x29,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x5,0xe8,0xf6,0x11,0x0,0x0,0x0,0x0,0x0,0x13,0xf8,0xe8,0xdf,0xff,0x35,0x0,0x0,0x1,0xf0,0xff,0xf5,0x2,0x0,0x0,0x35,0xff,0xda,0x31,0xfb,0xf0,0x1a,0x0,0x0,0x0,0x1a,0xf0,0xfb,0x64,0xfd,0xee,0x14,0x0,0x0,0x0,0x0,0x13,0xed,0xfc,0x33,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0xff,0xff,0xf2,0xff,0x15,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x26,0xfc,0xff,0x38,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0xff,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0xc9,0xf7,0xf4,0xba,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2c,0xbb,0xf4,0xff,0x0,0xff,0xff,0x0,0xff,0xf3,0xbd,0x2a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21,0xc4,0xf9,0xc3,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x40,0xff,0xc7,0x40,0xff,0xc7,0x0,0x0,0x70,0xff,0xff,0xff,0xff,0xff,0x6e,0x0,0xb4,0xff,0x4b,0x49,0xff,0xb3,0x0,0x0,0x1,0xc7,0xff,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0xac,0xff,0xff,0xff,0xff,0xff,0x9f,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xb8,0xff,0x52,0x54,0xff,0xb9,0x0,0x0,0xb4,0xa4,0xd1,0x83,0xb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48,0xff,0xbf,0x11,0xe7,0xff,0xff,0xff,0xff,0xe7,0x11,0x0,0x0,0x0,0x7,0xb3,0xff,0xff,0x0,0x0,0x0,0x3c,0xfa,0xff,0xff,0xff,0xff,0xff,0x61,0x0,0x6b,0xff,0xff,0xff,0xff,0xff,0xff,0x87,0x0,0x0,0x0,0x0,0x0,0xb8,0xff,0xff,0x0,0x0,0x3a,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x3,0xbd,0xff,0xff,0xff,0xff,0xff,0x8d,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x6b,0xff,0xff,0xff,0xff,0xff,0xff,0x6a,0x0,0x39,0xfa,0xff,0xff,0xff,0xff,0xd6,0xa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x25,0xf0,0xff,0xff,0xff,0xff,0xfc,0x47,0x0,0x0,0x0,0x0,0x10,0xae,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbe,0x14,0x0,0x0,0x0,0x0,0x59,0xff,0xff,0xff,0x59,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x80,0x0,0x0,0x0,0x0,0x8e,0xff,0xff,0xff,0xff,0xff,0xff,0xf5,0x37,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8e,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xfa,0x45,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x67,0xff,0xd9,0x1b,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0x78,0x0,0x0,0x0,0x79,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0xf4,0x1f,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x86,0xff,0xff,0xff,0xff,0xff,0xff,0x7d,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x70,0x0,0x0,0x0,0x89,0xff,0xff,0xff,0xff,0xff,0xff,0x84,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x75,0x0,0x0,0x5f,0xff,0xff,0xff,0xff,0xff,0xff,0xf3,0x2c,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x8a,0xff,0x70,0x0,0x0,0x0,0x0,0x0,0x74,0xff,0x8a,0x8f,0xff,0x81,0x0,0x0,0x25,0xff,0xff,0xff,0x2a,0x0,0x0,0x80,0xff,0x90,0x0,0x87,0xff,0xaf,0x0,0x0,0x0,0xb0,0xff,0x87,0x0,0x91,0xff,0x9b,0x0,0x0,0x0,0x0,0x99,0xff,0x90,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xab,0x0,0xff,0xff,0xff,0xff,0xc8,0xff,0x3f,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0xa8,0xff,0xff,0xb9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe1,0xff,0xff,0xff,0xac,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcd,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0xff,0xff,0xff,0xcc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc4,0x78,0xc,0x78,0xc3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xe6,0xea,0x0,0x0,0xe8,0xea,0x0,0x0,0x0,0x6b,0xff,0x9d,0x6b,0xff,0x9d,0x0,0x0,0xe3,0xff,0x54,0xff,0x57,0xff,0xdf,0x0,0xf5,0xff,0x6,0x6,0xff,0xf5,0x0,0x0,0x5f,0xff,0xa9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8,0xff,0x43,0x7,0x4f,0xff,0xf5,0x0,0x0,0x0,0x0,0xe6,0xea,0x0,0x0,0x1d,0xfe,0xe8,0x4,0x4,0xea,0xfe,0x1c,0x0,0x1a,0xb4,0xf0,0xb7,0x1a,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x73,0xff,0x95,0x7b,0xff,0xc0,0x19,0x18,0xbe,0xff,0x7b,0x0,0x0,0x39,0xce,0xfc,0xff,0xff,0x0,0x0,0x0,0xb8,0xff,0xa3,0x17,0xf,0x85,0xff,0xdd,0x0,0xba,0xf2,0x72,0x11,0x8,0x51,0xff,0xf3,0x0,0x0,0x0,0x0,0x61,0xff,0xff,0xff,0x0,0x0,0x60,0xff,0xad,0x0,0x0,0x0,0x0,0x0,0x0,0x60,0xff,0xbc,0x22,0x7,0x5f,0xf4,0xc6,0x0,0x0,0x0,0x0,0x0,0x10,0xe4,0xfd,0x65,0x0,0xe2,0xff,0x85,0x12,0x10,0x85,0xff,0xe1,0x0,0xbb,0xff,0x91,0xf,0x1e,0xb8,0xff,0x73,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0xbf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbf,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa8,0xff,0xc1,0x1e,0xe,0x83,0xff,0xd0,0x0,0x0,0x0,0xc,0xcf,0xff,0xef,0x7f,0x2d,0x9,0x7,0x27,0x76,0xef,0xff,0xc7,0x4,0x0,0x0,0x0,0xb2,0xff,0xa6,0xff,0xb2,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x1,0x9,0x70,0xff,0xe7,0x0,0x0,0x0,0x3f,0xff,0xfd,0x7e,0x18,0x6,0x44,0xdf,0xff,0xcb,0x0,0x0,0xff,0xff,0x0,0x0,0x5,0x1d,0x75,0xfb,0xff,0x3f,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x49,0xff,0xf6,0x6d,0x17,0x5,0x3b,0xdc,0xff,0xd3,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x5a,0xfd,0xd5,0x18,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xf8,0xc6,0x0,0x0,0x0,0xc7,0xf8,0xff,0xff,0x0,0x0,0xff,0xff,0xff,0xb7,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x3c,0xff,0xfc,0x72,0x10,0xf,0x6f,0xfb,0xfe,0x37,0x0,0x0,0xff,0xff,0x0,0x0,0x5,0x1c,0x91,0xff,0xe0,0x0,0x0,0x3e,0xff,0xf5,0x64,0xe,0xe,0x64,0xf6,0xfe,0x33,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x1,0x17,0x9a,0xff,0xe2,0x0,0x0,0xe1,0xff,0x84,0x1a,0x3,0x27,0xbc,0xff,0xb2,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x26,0xff,0xd7,0x0,0x0,0x0,0x0,0x1,0xda,0xff,0x28,0x43,0xff,0xcd,0x0,0x0,0x59,0xff,0xff,0xff,0x5c,0x0,0x0,0xcb,0xff,0x46,0x0,0x8,0xd9,0xff,0x56,0x0,0x57,0xff,0xd9,0x8,0x0,0xd,0xe3,0xfd,0x34,0x0,0x0,0x34,0xfd,0xe3,0xd,0x0,0x0,0x0,0x0,0x0,0x61,0xff,0xeb,0x16,0x0,0xff,0xff,0x0,0x0,0x9d,0xff,0x6a,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x2f,0xfe,0xde,0xe3,0xff,0x3b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfe,0xff,0x1e,0x4,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8,0xff,0x32,0x2,0x0,0xff,0xff,0x0,0x2,0x32,0xff,0xf9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfa,0xc,0x0,0xc,0xf9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf3,0xf2,0x0,0x0,0xba,0xc6,0x0,0x0,0xbd,0xc6,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xfa,0xff,0xf,0xff,0x0,0x0,0x0,0x0,0xf5,0xff,0x6,0x6,0xff,0xf5,0x0,0xd,0xe7,0xf5,0x1d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd0,0xff,0x6c,0x0,0x5b,0xff,0xd6,0x0,0x0,0x0,0x0,0xba,0xc6,0x0,0x0,0x71,0xff,0x94,0x0,0x0,0x98,0xff,0x6f,0x0,0x7c,0xce,0x1b,0xcc,0x7b,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9d,0xff,0x6a,0xc3,0xff,0x3c,0x0,0x0,0x3d,0xff,0xc3,0x0,0x0,0xff,0xfc,0x62,0xff,0xff,0x0,0x0,0x0,0xc3,0xf0,0x16,0x0,0x0,0x7,0xff,0xf9,0x0,0x0,0x0,0x0,0x1,0x13,0x6e,0xff,0xd5,0x0,0x0,0x0,0x1a,0xef,0xe6,0xff,0xff,0x0,0x0,0x86,0xff,0x88,0x0,0x0,0x0,0x0,0x0,0x0,0xb6,0xff,0x23,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x93,0xff,0x7a,0x0,0x0,0xf7,0xff,0x7,0x0,0x0,0x8,0xff,0xf5,0x0,0xf4,0xff,0xd,0x0,0x0,0x1b,0xff,0xc1,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0xbe,0xff,0xff,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0xbe,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0xee,0xff,0x28,0x0,0x0,0xa,0xff,0xf8,0x0,0x0,0x0,0x9c,0xff,0xd6,0x1d,0x6a,0xd8,0xf7,0xb9,0x45,0xff,0xea,0xe8,0xff,0x65,0x0,0x0,0x11,0xf9,0xf2,0x10,0xf0,0xf9,0x11,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xa,0xff,0xf9,0x0,0x0,0x0,0xa5,0xff,0x88,0x0,0x0,0x0,0x0,0x35,0xc0,0x40,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x7d,0xff,0xa9,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xac,0xff,0x6e,0x0,0x0,0x0,0x0,0x37,0xc0,0x40,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x4e,0xfb,0xd1,0x15,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xba,0xfd,0x15,0x0,0x16,0xfd,0xb9,0xff,0xff,0x0,0x0,0xff,0xff,0xa5,0xff,0x5b,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xa8,0xff,0x87,0x0,0x0,0x0,0x0,0x85,0xff,0xa2,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xc,0xff,0xf9,0x0,0x0,0xa6,0xff,0x72,0x0,0x0,0x0,0x0,0x75,0xff,0x99,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xb,0xff,0xfa,0x0,0x0,0xf8,0xff,0x34,0x0,0x0,0x0,0x22,0xff,0xf1,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xc2,0xff,0x41,0x0,0x0,0x0,0x44,0xff,0xc4,0x0,0x5,0xf1,0xfe,0x1a,0x0,0x8c,0xff,0xd0,0xff,0x8d,0x0,0x17,0xfe,0xf4,0x7,0x0,0x0,0x3c,0xfe,0xe9,0x25,0xe9,0xfe,0x3c,0x0,0x0,0x0,0x51,0xff,0xc9,0x1,0x1,0xc8,0xff,0x51,0x0,0x0,0x0,0x0,0x0,0x1a,0xef,0xff,0x58,0x0,0x0,0xff,0xff,0x0,0x0,0x73,0xff,0x95,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xb3,0xff,0x59,0x60,0xff,0xbc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x84,0xe3,0xfc,0xf0,0xb0,0x1d,0x0,0x0,0xff,0xff,0x4a,0xd4,0xf8,0xd1,0x49,0x0,0x0,0x0,0x0,0x48,0xcf,0xf9,0xf2,0xbf,0x27,0x0,0x0,0x0,0x4b,0xd1,0xf8,0xd4,0x4a,0xff,0xff,0x0,0x0,0x0,0x4b,0xd5,0xf9,0xd3,0x4e,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x4c,0xd5,0xf7,0xbd,0x20,0xff,0xff,0x0,0x0,0xff,0xff,0x7,0x96,0xf1,0xec,0x9c,0xd,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x4b,0xf8,0xe9,0x23,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x4d,0xd3,0xf8,0xc0,0x1a,0x44,0xd5,0xf6,0xbc,0x1d,0x0,0x0,0xff,0xff,0x35,0xba,0xf4,0xf1,0xa6,0x14,0x0,0x0,0x0,0x2a,0xb3,0xf4,0xf2,0xb0,0x24,0x0,0x0,0x0,0xff,0xff,0x4f,0xd5,0xf9,0xd4,0x4a,0x0,0x0,0x0,0x0,0x4b,0xd3,0xf9,0xda,0x52,0xff,0xff,0x0,0x0,0xff,0xff,0x51,0xee,0xc4,0x0,0x14,0xa4,0xec,0xfb,0xe5,0x91,0xa,0x0,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x54,0xff,0xab,0x0,0x0,0x0,0xab,0xff,0x54,0xde,0xff,0x24,0x0,0x0,0xcc,0xff,0xd7,0x0,0x0,0x24,0xff,0xde,0x32,0xfc,0xe6,0xe,0x0,0x11,0xe8,0xfa,0x44,0xf9,0xed,0x9,0x0,0x0,0x0,0x9,0xed,0xf8,0x13,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x1,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc4,0x78,0xc,0x78,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdf,0xdf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xc8,0xff,0xb5,0xff,0x0,0x0,0x0,0x0,0xb5,0xff,0x4b,0x49,0xff,0xb3,0x0,0x8b,0xff,0x7d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4b,0xff,0xff,0xd2,0xff,0xf6,0x45,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb1,0xff,0x55,0x0,0x0,0x58,0xff,0xb0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc8,0xff,0x3f,0xeb,0xff,0x11,0x0,0x0,0x10,0xff,0xea,0x0,0x0,0xcb,0x3f,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0xff,0xd1,0x0,0x0,0x0,0x0,0xb9,0xff,0xff,0xe7,0x36,0x0,0x0,0x0,0xb2,0xff,0x50,0xff,0xff,0x0,0x0,0xad,0xff,0xe2,0xf1,0xf6,0xbd,0x37,0x0,0x0,0xe5,0xeb,0x5c,0xc4,0xf6,0xc0,0x38,0x0,0x0,0x0,0x0,0x0,0x1f,0xfa,0xe1,0x5,0x0,0x0,0xb8,0xff,0x82,0x10,0x11,0x85,0xff,0xb3,0x0,0xf6,0xff,0x11,0x0,0x0,0xd,0xff,0xea,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x3d,0xbd,0xff,0xfc,0xac,0x39,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x3a,0xae,0xfd,0xff,0xbd,0x3d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x98,0xff,0xc7,0x0,0x0,0x28,0xfe,0xf8,0x24,0x8b,0xff,0xff,0xff,0xff,0xeb,0xff,0xa5,0x60,0xff,0xc3,0x0,0x0,0x64,0xff,0xa1,0x0,0x9c,0xff,0x64,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xb,0x7b,0xff,0xd1,0x0,0x0,0x0,0xde,0xff,0x27,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x22,0xff,0xe1,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe3,0xff,0x1e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x43,0xf8,0xfe,0x22,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x71,0xff,0x61,0x0,0x62,0xff,0x70,0xff,0xff,0x0,0x0,0xff,0xff,0x14,0xe9,0xea,0x13,0x0,0x0,0xff,0xff,0x0,0x0,0xe1,0xff,0x29,0x0,0x0,0x0,0x0,0x28,0xff,0xdd,0x0,0x0,0xff,0xff,0x0,0x0,0x4,0x1d,0x95,0xff,0xd5,0x0,0x0,0xe0,0xff,0x21,0x0,0x0,0x0,0x0,0x23,0xff,0xd5,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x7,0x22,0x9a,0xff,0xcb,0x0,0x0,0xb3,0xff,0xfb,0xaa,0x4e,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x5e,0xff,0xa9,0x0,0x0,0x0,0xac,0xff,0x60,0x0,0x0,0xac,0xff,0x64,0x0,0xc0,0xff,0x6b,0xff,0xbf,0x0,0x60,0xff,0xb1,0x0,0x0,0x0,0x0,0x95,0xff,0xf1,0xff,0x95,0x0,0x0,0x0,0x0,0x0,0xb1,0xff,0x63,0x63,0xff,0xb1,0x0,0x0,0x0,0x0,0x0,0x0,0xb3,0xff,0xaf,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x48,0xff,0xbf,0x0,0x0,0x0,0xff,0xff,0x0,0x38,0xff,0xcd,0x1,0x2,0xd1,0xff,0x3d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81,0xff,0xff,0xff,0xff,0xff,0xbe,0x0,0x0,0xff,0xff,0xfc,0xff,0xff,0xff,0xfc,0x3d,0x0,0x0,0x3a,0xfc,0xff,0xff,0xff,0xff,0xb3,0x0,0x0,0x3f,0xfd,0xff,0xff,0xff,0xfc,0xff,0xff,0x0,0x0,0x38,0xfb,0xff,0xff,0xff,0xfc,0x3d,0x0,0xff,0xff,0xff,0xff,0xff,0x0,0x3c,0xfc,0xff,0xff,0xff,0xda,0xff,0xff,0x0,0x0,0xff,0xff,0xa8,0xff,0xff,0xff,0xff,0x9f,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x50,0xf9,0xf3,0x33,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0xfd,0xff,0xff,0xff,0xcd,0xf7,0xff,0xff,0xff,0xb8,0x0,0x0,0xff,0xff,0xf8,0xff,0xff,0xff,0xff,0xac,0x0,0x0,0x21,0xef,0xff,0xff,0xff,0xff,0xea,0x1d,0x0,0x0,0xff,0xff,0xfa,0xff,0xff,0xff,0xfc,0x3a,0x0,0x0,0x3d,0xfc,0xff,0xff,0xff,0xfa,0xff,0xff,0x0,0x0,0xff,0xff,0xfc,0xff,0xb8,0x0,0xb7,0xff,0xff,0xff,0xff,0xff,0x9a,0x0,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x9,0xf2,0xf5,0xb,0x0,0xb,0xf6,0xf3,0x9,0x9b,0xff,0x64,0x0,0x1e,0xff,0xff,0xff,0x25,0x0,0x65,0xff,0x9a,0x0,0x8d,0xff,0x8f,0x0,0x9d,0xff,0x80,0x0,0xaa,0xff,0x65,0x0,0x0,0x0,0x66,0xff,0xa2,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x12,0xff,0xfd,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xf8,0xff,0x12,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21,0xc4,0xfa,0xc4,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcb,0xcb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea,0xff,0x1e,0xea,0xff,0x1e,0x0,0x0,0x3e,0xf7,0xff,0xff,0xc5,0x3c,0x0,0x0,0x1b,0xb2,0xf5,0xf5,0xb1,0x19,0x26,0xfa,0xde,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3b,0xee,0xff,0xff,0xee,0x2b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdc,0xff,0x26,0x0,0x0,0x28,0xff,0xdd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf2,0xff,0x15,0xfa,0xff,0x2,0x0,0x0,0x2,0xff,0xf9,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1d,0xdf,0xff,0x5f,0x0,0x0,0x0,0x0,0xe4,0xff,0xff,0xf2,0x3e,0x0,0x0,0x5b,0xff,0xa8,0x0,0xff,0xff,0x0,0x0,0xd3,0xff,0xff,0xff,0xff,0xff,0xf9,0x39,0x0,0xf8,0xff,0xff,0xff,0xff,0xff,0xf9,0x38,0x0,0x0,0x0,0x0,0x8e,0xff,0x7d,0x0,0x0,0x0,0x1c,0xc8,0xff,0xff,0xff,0xff,0xc6,0x18,0x0,0xc0,0xff,0x9f,0x16,0x15,0x9b,0xff,0xfa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c,0xbc,0xff,0xf2,0x90,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x24,0x95,0xf5,0xff,0xbc,0x3c,0x0,0x0,0x0,0x0,0x0,0xb,0xc3,0xff,0xf6,0x36,0x0,0x0,0x8a,0xff,0x98,0x3b,0xff,0xf3,0x4e,0xb,0x77,0xff,0xff,0x84,0x13,0xff,0xf2,0x0,0x0,0xbd,0xff,0x48,0x0,0x41,0xff,0xbd,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x68,0x0,0x0,0x0,0xf7,0xff,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x5,0xff,0xf9,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0xfb,0xff,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x38,0xf3,0xf7,0xff,0x93,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x27,0xff,0xaf,0x0,0xb0,0xff,0x26,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x56,0xff,0xa2,0x0,0x0,0xff,0xff,0x0,0x0,0xfb,0xff,0x6,0x0,0x0,0x0,0x0,0x6,0xff,0xf7,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x59,0x0,0x0,0xf8,0xff,0x5,0x0,0x0,0x0,0x0,0x7,0xff,0xf2,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf4,0x3d,0x0,0x0,0x1b,0xd2,0xff,0xff,0xff,0xf0,0x9a,0x24,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x9,0xf0,0xfa,0x17,0x0,0x18,0xfb,0xf2,0xb,0x0,0x0,0x60,0xff,0xb0,0x1,0xf1,0xf9,0x10,0xfc,0xef,0x0,0xaa,0xff,0x67,0x0,0x0,0x0,0x0,0xd,0xe1,0xff,0xe1,0xd,0x0,0x0,0x0,0x0,0x0,0x1d,0xf3,0xea,0xea,0xf4,0x1e,0x0,0x0,0x0,0x0,0x0,0x5d,0xff,0xed,0x18,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x1d,0xff,0xea,0x0,0x0,0x0,0xff,0xff,0x0,0xbd,0xff,0x45,0x0,0x0,0x46,0xff,0xbf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe3,0xff,0x5b,0x4,0x32,0xff,0xf5,0x0,0x0,0xff,0xff,0xae,0x16,0x16,0xb1,0xff,0xb6,0x0,0x0,0xb2,0xff,0x9f,0x13,0x50,0xff,0xef,0x0,0x0,0xb7,0xff,0xaf,0x15,0x16,0xb1,0xff,0xff,0x0,0x0,0xaf,0xff,0x55,0x7,0x4f,0xff,0xb0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xb3,0xff,0xb3,0x15,0x18,0xb7,0xff,0xff,0x0,0x0,0xff,0xff,0xb8,0x21,0x8,0x74,0xff,0xeb,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x54,0xfb,0xfa,0x47,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x9a,0xe,0x51,0xff,0xff,0xa2,0xf,0x5a,0xff,0xf4,0x0,0x0,0xff,0xff,0xbc,0x25,0x9,0x82,0xff,0xef,0x0,0x0,0x9e,0xff,0xb9,0x18,0x18,0xb9,0xff,0x9d,0x0,0x0,0xff,0xff,0xb1,0x17,0x16,0xb4,0xff,0xb3,0x0,0x0,0xb6,0xff,0xb4,0x18,0x15,0xae,0xff,0xff,0x0,0x0,0xff,0xff,0x91,0xb,0x22,0x0,0xf9,0xff,0x31,0x5,0x5b,0xff,0xee,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xa3,0xff,0x57,0x0,0x58,0xff,0xa5,0x0,0x58,0xff,0xa5,0x0,0x6e,0xff,0xff,0xff,0x74,0x0,0xa6,0xff,0x57,0x0,0xb,0xdf,0xfc,0x6f,0xff,0xd0,0x5,0x0,0x45,0xff,0xd3,0x0,0x0,0x0,0xd4,0xff,0x39,0x0,0x0,0x0,0x0,0x0,0x87,0xff,0x7e,0x0,0xf,0x8e,0xff,0xd4,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xce,0xff,0x92,0x12,0x0,0x66,0xe2,0xf9,0xc8,0x6b,0x16,0x1c,0x9c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb7,0xb8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x16,0xff,0xf1,0x16,0xff,0xf1,0x0,0x0,0x0,0x0,0x29,0xa0,0xff,0xff,0xfe,0x6a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb6,0xff,0x51,0x19,0xb0,0xf4,0xf4,0xaf,0x17,0x0,0x0,0x3d,0xf9,0xf7,0xb1,0xff,0xff,0x81,0x12,0x8f,0x5e,0x5,0x0,0x0,0x0,0x0,0x0,0xf6,0xff,0xe,0x0,0x0,0x10,0xff,0xf6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1d,0xff,0xea,0x0,0xfa,0xff,0x2,0x0,0x0,0x2,0xff,0xf8,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x28,0xe1,0xff,0xa6,0x0,0x0,0x0,0x0,0x0,0x12,0xd,0x9b,0xff,0xc1,0x0,0x16,0xec,0xeb,0x15,0x0,0xff,0xff,0x0,0x0,0xbe,0xec,0x6c,0xd,0x1a,0xa1,0xff,0xc0,0x0,0xfa,0xff,0x9d,0x16,0x13,0xa0,0xff,0xbe,0x0,0x0,0x0,0x5,0xeb,0xff,0x1e,0x0,0x0,0x0,0x29,0xe1,0xff,0xff,0xff,0xff,0xe1,0x2b,0x0,0x3b,0xfa,0xff,0xff,0xff,0xff,0xff,0xf7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xe2,0x2a,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x2a,0xe3,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x91,0xff,0xf4,0x43,0x0,0x0,0x0,0xcd,0xff,0x43,0xa9,0xff,0x71,0x0,0x0,0xa,0xff,0xff,0x62,0x7,0xff,0xf8,0x0,0x19,0xfd,0xeb,0x4,0x0,0x2,0xe3,0xfd,0x19,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe6,0x2f,0x0,0x0,0xfa,0xff,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x4,0xff,0xf8,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0xfa,0xff,0x7,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0xef,0xc6,0x24,0xee,0xfc,0x31,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0xdd,0xf4,0x10,0xf5,0xdc,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0xaf,0xff,0x45,0x0,0xff,0xff,0x0,0x0,0xf9,0xff,0x0,0x0,0x0,0x0,0x0,0x1,0xff,0xf7,0x0,0x0,0xff,0xff,0xff,0xff,0xfc,0xee,0xc1,0x4c,0x0,0x0,0x0,0xf8,0xfe,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xfa,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xf5,0x75,0x1b,0x0,0x0,0x0,0x0,0x4,0x5b,0xb8,0xf9,0xff,0xff,0xf7,0x41,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xfe,0x0,0x0,0x0,0x96,0xff,0x7a,0x0,0x7c,0xff,0x9a,0x0,0x0,0x0,0x16,0xfe,0xf4,0x2e,0xff,0xcd,0x0,0xd3,0xff,0x27,0xf0,0xff,0x1d,0x0,0x0,0x0,0x0,0xd,0xe1,0xff,0xe1,0xd,0x0,0x0,0x0,0x0,0x0,0x0,0x71,0xff,0xff,0x72,0x0,0x0,0x0,0x0,0x0,0x18,0xed,0xff,0x5c,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xf2,0xff,0x15,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x51,0x8d,0xd2,0xff,0xff,0x0,0x0,0xff,0xff,0x1d,0x0,0x0,0x22,0xff,0xed,0x0,0x0,0xec,0xff,0x16,0x0,0x0,0x0,0x0,0x0,0x0,0xed,0xff,0x1e,0x0,0x0,0x22,0xff,0xff,0x0,0x0,0xea,0xff,0xff,0xff,0xff,0xff,0xe7,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xec,0xff,0x22,0x0,0x0,0x25,0xff,0xff,0x0,0x0,0xff,0xff,0x23,0x0,0x0,0xa,0xff,0xfd,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0xfc,0xff,0xd4,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x18,0x0,0x6,0xff,0xff,0x1d,0x0,0x7,0xff,0xff,0x0,0x0,0xff,0xff,0x24,0x0,0x0,0xf,0xff,0xfe,0x0,0x0,0xe8,0xff,0x25,0x0,0x0,0x25,0xff,0xe6,0x0,0x0,0xff,0xff,0x1e,0x0,0x0,0x23,0xff,0xec,0x0,0x0,0xee,0xff,0x23,0x0,0x0,0x1f,0xff,0xff,0x0,0x0,0xff,0xff,0x26,0x0,0x0,0x0,0xd0,0xff,0xe4,0x9a,0x59,0xf,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x4b,0xff,0xad,0x0,0xae,0xff,0x4e,0x0,0x16,0xfe,0xe5,0x0,0xbf,0xff,0xcb,0xff,0xc3,0x0,0xe6,0xfe,0x15,0x0,0x0,0x48,0xff,0xff,0xfa,0x30,0x0,0x0,0x1,0xdf,0xff,0x43,0x0,0x44,0xff,0xd1,0x0,0x0,0x0,0x0,0x0,0x8a,0xff,0x83,0x0,0x0,0xff,0xff,0xef,0x43,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x41,0xf1,0xff,0xff,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa3,0xa4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xff,0x8f,0xff,0xe6,0x0,0x0,0x0,0x0,0x0,0x0,0x4d,0xff,0xbb,0x0,0xb4,0xff,0x49,0x49,0xff,0xb2,0x0,0x0,0xc7,0xff,0x56,0x0,0x85,0xff,0xff,0xc5,0xff,0xdd,0x0,0x0,0x0,0x0,0x0,0x0,0xfe,0xff,0x3,0x0,0x0,0x3,0xff,0xfc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x48,0xff,0xbf,0x0,0xeb,0xff,0xf,0x0,0x0,0x11,0xff,0xe9,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x37,0xec,0xff,0xa6,0x5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0xff,0xf4,0x0,0xac,0xff,0x58,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xff,0xf6,0x0,0xeb,0xff,0xd,0x0,0x0,0x12,0xff,0xf6,0x0,0x0,0x0,0x43,0xff,0xcd,0x0,0x0,0x0,0x0,0xbf,0xff,0x88,0x11,0x12,0x86,0xff,0xc3,0x0,0x0,0x3b,0xc2,0xf7,0xc5,0x5f,0xeb,0xe3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c,0xbd,0xff,0xf9,0x9e,0x29,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x26,0x99,0xf7,0xff,0xb9,0x38,0x0,0x0,0x0,0x0,0x0,0xe5,0xff,0x4c,0x0,0x0,0x0,0x0,0xf2,0xff,0x12,0xe7,0xff,0x1c,0x0,0x0,0x23,0xff,0xff,0x41,0x2c,0xff,0xd6,0x0,0x6f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x6f,0x0,0x0,0xff,0xff,0x0,0x0,0x1,0x9,0x27,0x98,0xff,0xc4,0x0,0x0,0xe3,0xff,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x1f,0xff,0xe1,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0,0xff,0x23,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xfe,0x0,0x0,0xff,0xff,0xc1,0xc,0x0,0x6a,0xff,0xc6,0x1,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x94,0xff,0x95,0xff,0x93,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x19,0xef,0xde,0xa,0xff,0xff,0x0,0x0,0xe1,0xff,0x1a,0x0,0x0,0x0,0x0,0x1b,0xff,0xde,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe1,0xff,0x1a,0x0,0x0,0x0,0x0,0x0,0xfd,0xe7,0x0,0x0,0xff,0xff,0x0,0x12,0x8b,0xff,0xff,0xc0,0xb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x53,0xc0,0xff,0xcd,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xf8,0xff,0x5,0x0,0x0,0x0,0x0,0x6,0xff,0xf8,0x0,0x0,0x0,0x32,0xff,0xe0,0x5,0xe1,0xff,0x36,0x0,0x0,0x0,0x0,0xc9,0xff,0xa2,0xff,0x9a,0x0,0xa1,0xff,0x93,0xff,0xd2,0x0,0x0,0x0,0x0,0x0,0x95,0xff,0xf1,0xff,0x95,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0xff,0xff,0x3,0x0,0x0,0x0,0x0,0x0,0xaf,0xff,0xb3,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xc8,0xff,0x3f,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x42,0xee,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x3,0x0,0x0,0x3,0xff,0xfb,0x0,0x0,0xfc,0xff,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0xfc,0xff,0x2,0x0,0x0,0x4,0xff,0xff,0x0,0x0,0xfc,0xff,0xff,0xff,0xff,0xff,0xfb,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xfc,0xff,0x3,0x0,0x0,0x4,0xff,0xff,0x0,0x0,0xff,0xff,0x2,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0xff,0xf7,0xff,0x4d,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x1,0x0,0x0,0xff,0xff,0x2,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x4,0x0,0x0,0x1,0xff,0xff,0x0,0x0,0xfd,0xff,0x3,0x0,0x0,0x4,0xff,0xfa,0x0,0x0,0xff,0xff,0x3,0x0,0x0,0x4,0xff,0xfb,0x0,0x0,0xfc,0xff,0x3,0x0,0x0,0x4,0xff,0xff,0x0,0x0,0xff,0xff,0xb,0x0,0x0,0x0,0x2c,0xd2,0xff,0xff,0xff,0xf2,0x54,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x1,0x0,0x0,0x6,0xff,0xff,0x0,0x0,0x5,0xed,0xf6,0x18,0xf7,0xf0,0x7,0x0,0x0,0xd2,0xff,0x3a,0xfc,0xfe,0x2f,0xfd,0xfd,0x3b,0xff,0xd1,0x0,0x0,0x0,0x2,0xe3,0xff,0xd8,0x2,0x0,0x0,0x0,0x7c,0xff,0xb1,0x0,0xb2,0xff,0x68,0x0,0x0,0x0,0x0,0x86,0xff,0x89,0x0,0x0,0x0,0xff,0xff,0xed,0x34,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x36,0xef,0xff,0xff,0x0,0x98,0x19,0x12,0x5a,0xbd,0xf9,0xdd,0x61,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e,0x91,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xec,0xff,0x18,0xff,0x6,0xff,0xfb,0x0,0x0,0x0,0x0,0x0,0x7,0xdb,0xfb,0x2a,0x0,0xf6,0xff,0x6,0x6,0xff,0xf5,0x0,0x0,0xfa,0xff,0x9,0x0,0x0,0x89,0xff,0xff,0xff,0x64,0x0,0x0,0x0,0x0,0x0,0x0,0xf4,0xff,0xb,0x0,0x0,0xb,0xff,0xee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x73,0xff,0x95,0x0,0xc4,0xff,0x39,0x0,0x0,0x3a,0xff,0xc1,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x37,0xf2,0xff,0x88,0x1,0x0,0x0,0x0,0xbb,0xed,0x21,0x0,0x0,0x16,0xff,0xf2,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xc0,0xef,0x24,0x0,0x0,0x14,0xff,0xef,0x0,0xc1,0xff,0x19,0x0,0x0,0xd,0xff,0xf3,0x0,0x0,0x0,0x87,0xff,0x82,0x0,0x0,0x0,0x0,0xf7,0xff,0x8,0x0,0x0,0x8,0xff,0xf7,0x0,0x0,0x0,0x0,0x0,0x0,0x23,0xff,0xb5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3d,0xbe,0xff,0xfe,0xb1,0x3b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3a,0xaf,0xfd,0xff,0xbb,0x3a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfd,0xff,0x3,0x0,0x0,0x0,0x0,0xfc,0xff,0x3,0xfb,0xff,0x9,0x0,0x0,0x7e,0xff,0xff,0x20,0x80,0xff,0x86,0x0,0xc8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc8,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xa,0xff,0xf6,0x0,0x0,0xac,0xff,0x85,0x0,0x0,0x0,0x0,0x39,0xc0,0x40,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x6e,0xff,0xa7,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa9,0xff,0x71,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0xf7,0xff,0x12,0x0,0x0,0x13,0xff,0xf3,0x0,0x0,0xff,0xff,0xa,0x0,0x0,0x2,0xcd,0xff,0x63,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x4a,0xff,0xfd,0xff,0x49,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x61,0xff,0x8c,0xff,0xff,0x0,0x0,0xa6,0xff,0x7a,0x0,0x0,0x0,0x0,0x7a,0xff,0xa4,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xab,0xff,0x75,0x0,0xaa,0x96,0x17,0x73,0xff,0xb2,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xac,0xff,0xff,0xa6,0x0,0x0,0x0,0xe9,0xff,0x2a,0x0,0x0,0x0,0xe,0xff,0xf8,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xe3,0xff,0x2d,0x0,0x0,0x0,0x0,0x26,0xff,0xe5,0x0,0x0,0x0,0x0,0xce,0xff,0x97,0xff,0xd3,0x0,0x0,0x0,0x0,0x0,0x7d,0xff,0xfc,0xff,0x67,0x0,0x6f,0xff,0xf7,0xff,0x88,0x0,0x0,0x0,0x0,0x3c,0xfe,0xe9,0x25,0xe9,0xfe,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x59,0xff,0xef,0x1a,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x9d,0xff,0x6a,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd6,0xff,0x94,0x4a,0x1f,0xff,0xff,0x0,0x0,0xff,0xff,0x27,0x0,0x0,0x20,0xff,0xe9,0x0,0x0,0xec,0xff,0x1b,0x0,0x0,0x0,0x0,0x0,0x0,0xea,0xff,0x20,0x0,0x0,0x23,0xff,0xff,0x0,0x0,0xed,0xff,0x15,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xec,0xff,0x22,0x0,0x0,0x25,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x8e,0x68,0xff,0xca,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xe8,0xff,0x25,0x0,0x0,0x26,0xff,0xe3,0x0,0x0,0xff,0xff,0x29,0x0,0x0,0x20,0xff,0xe8,0x0,0x0,0xe7,0xff,0x1f,0x0,0x0,0x2b,0xff,0xff,0x0,0x0,0xff,0xff,0x2,0x0,0x0,0x0,0x0,0x0,0x3a,0x84,0xb5,0xff,0xe5,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0xe,0x0,0x0,0x21,0xff,0xff,0x0,0x0,0x0,0x9a,0xff,0x9f,0xff,0xa0,0x0,0x0,0x0,0x8f,0xff,0xc6,0xff,0xc6,0x0,0xc0,0xff,0xc7,0xff,0x8e,0x0,0x0,0x0,0x6a,0xff,0xff,0xff,0x6a,0x0,0x0,0x0,0x1b,0xfc,0xfd,0x46,0xfd,0xf2,0xc,0x0,0x0,0x0,0x82,0xff,0x8d,0x0,0x0,0x0,0x0,0x13,0x94,0xff,0xbc,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xc0,0xff,0x84,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x95,0xff,0x72,0x95,0xff,0x72,0x0,0x0,0x0,0xb1,0xff,0x6d,0xff,0x40,0xff,0xd7,0x0,0x0,0x0,0x0,0x0,0x79,0xff,0x8f,0x0,0x0,0xf5,0xff,0x6,0x7,0xff,0xf4,0x0,0x0,0xdf,0xff,0x87,0xf,0x14,0x74,0xfc,0xff,0xff,0xb5,0x1a,0x0,0x0,0x0,0x0,0x0,0xd7,0xff,0x28,0x0,0x0,0x28,0xff,0xd1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9d,0xff,0x6a,0x0,0x7c,0xff,0xbb,0x17,0x16,0xba,0xff,0x79,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x17,0xe9,0xff,0x7a,0x0,0x0,0x0,0x0,0x0,0xb4,0xff,0xb4,0x16,0x14,0xa8,0xff,0xb0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xb3,0xff,0xbc,0x18,0x14,0xa5,0xff,0xa9,0x0,0x74,0xff,0xb3,0x1c,0xf,0x90,0xff,0xbb,0x0,0x0,0x0,0xbc,0xff,0x45,0x0,0x0,0x0,0x0,0xe0,0xff,0x82,0x10,0x10,0x84,0xff,0xdc,0x0,0xc7,0xf4,0x5c,0x6,0x21,0xbb,0xff,0x5e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0xbf,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xbd,0x3c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xec,0xff,0x18,0xe2,0xff,0x72,0x8,0x50,0xf6,0xff,0xff,0x39,0xf3,0xea,0x14,0x22,0xff,0xe6,0x2,0x0,0x0,0x0,0x3,0xe9,0xff,0x22,0x0,0xff,0xff,0x0,0x0,0x0,0x2,0x12,0x82,0xff,0xda,0x0,0x0,0x48,0xff,0xfb,0x76,0x14,0xb,0x4c,0xe1,0xff,0xc7,0x0,0x0,0xff,0xff,0x0,0x0,0x1,0x11,0x5d,0xf2,0xff,0x42,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48,0xff,0xf5,0x69,0x14,0x5,0x2d,0x8c,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0xcb,0xff,0x98,0x10,0x2d,0xac,0xff,0xc7,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x37,0xfe,0xeb,0x12,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x9,0xf7,0xff,0xf6,0x8,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xba,0xfc,0xff,0xff,0x0,0x0,0x3d,0xff,0xfb,0x72,0x11,0x10,0x71,0xfb,0xfe,0x3b,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x49,0xff,0xf7,0x56,0x51,0xf3,0xfe,0xff,0xff,0x59,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x14,0xe9,0xff,0xff,0x55,0x0,0x0,0x9f,0xff,0xcb,0x35,0x6,0x17,0x91,0xff,0xd8,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xab,0xff,0xd3,0x40,0x9,0x5,0x32,0xc3,0xff,0xae,0x0,0x0,0x0,0x0,0x6a,0xff,0xff,0xff,0x70,0x0,0x0,0x0,0x0,0x0,0x31,0xff,0xff,0xff,0x33,0x0,0x3d,0xff,0xff,0xff,0x3d,0x0,0x0,0x0,0x8,0xd8,0xff,0x56,0x0,0x57,0xff,0xd8,0x8,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x16,0xeb,0xff,0x60,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x73,0xff,0x95,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf9,0xff,0x3d,0xb,0x73,0xff,0xff,0x3,0x0,0xff,0xff,0xbc,0x1c,0x12,0xad,0xff,0xae,0x0,0x0,0xb4,0xff,0x93,0x9,0x53,0xff,0xde,0x0,0x0,0xad,0xff,0xaf,0x16,0x16,0xb4,0xff,0xff,0x0,0x0,0xb5,0xff,0x95,0xa,0x55,0xff,0xd4,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xb2,0xff,0xb1,0x14,0x1b,0xbc,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x1,0x4,0xd8,0xff,0x47,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xa6,0xff,0xb8,0x18,0x18,0xb9,0xff,0x98,0x0,0x0,0xff,0xff,0xbc,0x1b,0x13,0xac,0xff,0xab,0x0,0x0,0xa7,0xff,0xac,0x13,0x1d,0xc1,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xf9,0xff,0x59,0x6,0x38,0xff,0xf5,0x0,0x0,0xfc,0xff,0x18,0x11,0x0,0xef,0xff,0x7c,0x9,0x22,0xb6,0xff,0xff,0x0,0x0,0x0,0x41,0xff,0xfe,0xff,0x49,0x0,0x0,0x0,0x4c,0xff,0xff,0xff,0x75,0x0,0x6d,0xff,0xff,0xff,0x4b,0x0,0x0,0x14,0xee,0xff,0x95,0xff,0xee,0x14,0x0,0x0,0x0,0xb3,0xff,0xf1,0xff,0x96,0x0,0x0,0x0,0x7f,0xff,0x86,0x0,0x0,0x0,0x0,0x0,0x0,0x1c,0xff,0xf2,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xf5,0xff,0x19,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0xff,0x47,0xc0,0xff,0x47,0x0,0x0,0x0,0x46,0xff,0xff,0xff,0xff,0xff,0x68,0x0,0x0,0x0,0x0,0x1a,0xf3,0xe9,0xf,0x0,0x0,0xb3,0xff,0x4b,0x4b,0xff,0xb1,0x0,0x0,0x5e,0xff,0xff,0xff,0xff,0xff,0xff,0xda,0xff,0xff,0xb5,0x0,0x0,0x0,0x0,0x0,0xa8,0xff,0x55,0x0,0x0,0x56,0xff,0xa4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0xc8,0xff,0x3f,0x0,0x10,0xe3,0xff,0xff,0xff,0xff,0xe5,0x10,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x93,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x31,0xf6,0xff,0xff,0xff,0xff,0xf0,0x28,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x31,0xf7,0xff,0xff,0xff,0xff,0xeb,0x22,0x0,0xa,0xd7,0xff,0xff,0xff,0xff,0xfa,0x3a,0x0,0x0,0x0,0xe2,0xff,0x1a,0x0,0x0,0x0,0x0,0x66,0xff,0xff,0xff,0xff,0xff,0xff,0x62,0x0,0x88,0xff,0xff,0xff,0xff,0xff,0xbd,0x2,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbf,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0xbe,0xff,0x5a,0x80,0xff,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xf4,0x3f,0x0,0x7a,0xff,0x93,0x0,0x0,0x0,0x0,0x0,0x96,0xff,0x7a,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x67,0x0,0x0,0x0,0x99,0xff,0xff,0xff,0xff,0xff,0xff,0xf1,0x30,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x95,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e,0xff,0xff,0xff,0xff,0xff,0xff,0xe2,0x68,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x58,0xff,0xff,0xff,0xff,0xff,0xfd,0x4c,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x9c,0xff,0x98,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0xb7,0xff,0xb6,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x1f,0xf3,0xff,0xff,0x0,0x0,0x0,0x86,0xff,0xff,0xff,0xff,0xff,0xff,0x85,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0,0xff,0xff,0xff,0xff,0xff,0xff,0xd7,0x2,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x39,0xf6,0xff,0xea,0x15,0x0,0x21,0xed,0xff,0xff,0xff,0xff,0xff,0xfe,0x53,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x28,0xee,0xff,0xff,0xff,0xff,0xff,0xff,0xf3,0x2f,0x0,0x0,0x0,0x0,0xf,0xf6,0xff,0xf9,0x13,0x0,0x0,0x0,0x0,0x0,0x0,0xe5,0xff,0xf9,0x6,0x0,0xd,0xfe,0xff,0xef,0x3,0x0,0x0,0x0,0x87,0xff,0xb0,0x0,0x0,0x0,0xb1,0xff,0x87,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xab,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0x0,0x0,0x48,0xff,0xbf,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbc,0xff,0xff,0xff,0xff,0xee,0xff,0x23,0x0,0xff,0xff,0xfa,0xff,0xff,0xff,0xfb,0x36,0x0,0x0,0x3f,0xfd,0xff,0xff,0xff,0xff,0x75,0x0,0x0,0x33,0xf9,0xff,0xff,0xff,0xfa,0xff,0xff,0x0,0x0,0x3e,0xfc,0xff,0xff,0xff,0xff,0x5a,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x39,0xfc,0xff,0xff,0xff,0xca,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x51,0xff,0xc4,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x29,0xf3,0xff,0xff,0xff,0xff,0xe7,0x19,0x0,0x0,0xff,0xff,0xf9,0xff,0xff,0xff,0xf8,0x30,0x0,0x0,0x2e,0xf9,0xff,0xff,0xff,0xfa,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xad,0xff,0xff,0xff,0xff,0xff,0xa0,0x0,0x0,0xe1,0xff,0xff,0xb0,0x0,0xa7,0xff,0xff,0xff,0xff,0xf8,0xff,0xff,0x0,0x0,0x0,0x2,0xe6,0xff,0xed,0x5,0x0,0x0,0x0,0xd,0xfb,0xff,0xff,0x24,0x0,0x1b,0xfe,0xff,0xfb,0xd,0x0,0x0,0x9b,0xff,0x9e,0x0,0xac,0xff,0x9b,0x0,0x0,0x0,0x4f,0xff,0xff,0xff,0x2e,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x4,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xeb,0xff,0x1d,0xeb,0xff,0x1d,0x0,0x0,0x0,0x0,0x63,0xe0,0xff,0xdd,0x6b,0x0,0x0,0x0,0x0,0x0,0xa5,0xff,0x63,0x0,0x0,0x0,0x19,0xb0,0xf4,0xf5,0xaf,0x17,0x0,0x0,0x0,0x4d,0xc2,0xf3,0xf8,0xd3,0x6f,0x2,0x59,0xca,0x16,0x0,0x0,0x0,0x0,0x0,0x66,0xff,0x94,0x0,0x0,0x95,0xff,0x68,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0xf2,0xff,0x15,0x0,0x0,0x20,0xad,0xf2,0xf4,0xb4,0x25,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xe7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x35,0xbc,0xf6,0xf2,0xb1,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x39,0xc0,0xf7,0xf0,0xb0,0x26,0x0,0x0,0x0,0x15,0x9e,0xed,0xf8,0xc4,0x3f,0x0,0x0,0x0,0x0,0xf8,0xff,0x4,0x0,0x0,0x0,0x0,0x0,0x53,0xc6,0xf6,0xf8,0xcb,0x57,0x0,0x0,0x5,0x8c,0xe6,0xfb,0xdf,0x84,0x9,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x70,0xff,0xcf,0x8,0x8b,0xed,0xee,0x82,0x6f,0xf7,0xed,0xa7,0x27,0x0,0x0,0xd3,0xff,0x3e,0x0,0x0,0x0,0x0,0x0,0x3f,0xff,0xd3,0x0,0xff,0xff,0xff,0xff,0xff,0xfb,0xf3,0xce,0x63,0x0,0x0,0x0,0x0,0x1,0x60,0xc4,0xf2,0xfc,0xe3,0x9f,0x24,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xf3,0xc5,0x5a,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48,0xb3,0xec,0xfb,0xd9,0x7b,0xa,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x5b,0xcf,0xf9,0xf5,0xc3,0x47,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x14,0xed,0xfd,0x34,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x6d,0xff,0x6c,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x6c,0xff,0xff,0x0,0x0,0x0,0x0,0x58,0xc6,0xf4,0xf4,0xc6,0x57,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x6f,0xd3,0xf8,0xe1,0x69,0xbc,0xfd,0x56,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x52,0xfd,0xff,0xaa,0x0,0x0,0x25,0xa5,0xe8,0xfb,0xed,0xba,0x46,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x21,0x9e,0xe1,0xfa,0xfd,0xe6,0xa4,0x28,0x0,0x0,0x0,0x0,0x0,0x0,0xa2,0xff,0xa9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9a,0xff,0xcd,0x0,0x0,0x0,0xd9,0xff,0xa9,0x0,0x0,0x0,0x31,0xfb,0xf0,0x1a,0x0,0x0,0x0,0x1a,0xf0,0xfb,0x31,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0x0,0x0,0x1d,0xff,0xea,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1b,0xb4,0xf6,0xee,0x97,0x2b,0xff,0xa0,0x0,0xff,0xff,0x49,0xd1,0xf9,0xd4,0x48,0x0,0x0,0x0,0x0,0x50,0xd4,0xfa,0xe4,0x81,0x2,0x0,0x0,0x0,0x44,0xd2,0xf9,0xd4,0x4b,0xff,0xff,0x0,0x0,0x0,0x4f,0xd0,0xf9,0xe3,0x6c,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x51,0xd9,0xf6,0xac,0x17,0xff,0xf8,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x1,0xff,0xfe,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xc5,0xff,0x41,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x2d,0xb2,0xf4,0xf3,0xaf,0x22,0x0,0x0,0x0,0xff,0xff,0x40,0xd2,0xf9,0xcd,0x3f,0x0,0x0,0x0,0x0,0x45,0xd3,0xf9,0xce,0x43,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0xd,0x94,0xe5,0xfc,0xe9,0x95,0xb,0x0,0x0,0x55,0xe5,0xf8,0xbe,0x0,0x11,0xa3,0xf0,0xf5,0xc2,0x3d,0xff,0xff,0x0,0x0,0x0,0x0,0x90,0xff,0x9b,0x0,0x0,0x0,0x0,0x0,0xc6,0xff,0xd4,0x0,0x0,0x0,0xc6,0xff,0xc5,0x0,0x0,0x35,0xfe,0xe8,0x11,0x0,0x15,0xe9,0xfd,0x35,0x0,0x0,0x4,0xe6,0xff,0xc5,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0xff,0xfd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x16,0xfc,0xe2,0x1,0x2,0xe3,0xfe,0x1b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe,0xf4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa,0xf4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xeb,0xff,0xa0,0x5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4c,0xf9,0xbd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa,0xa7,0x99,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0xfb,0xff,0x4d,0x5,0xd,0x6c,0xff,0xd8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x2c,0xff,0xf3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x2b,0xec,0xff,0x5f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf3,0xff,0x40,0x2,0x0,0xff,0xff,0x0,0x2,0x3f,0xff,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb1,0xff,0x4a,0x4b,0xff,0xb6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x76,0xbf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6a,0xbf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e,0xfd,0xff,0xd6,0x69,0x28,0x7,0x2,0x17,0x4a,0xa8,0xfe,0xee,0x25,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xad,0xff,0xff,0xff,0xff,0xff,0xff,0x78,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa8,0xff,0xff,0xc9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xe5,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb9,0xff,0xff,0xff,0x0,0xff,0xff,0x0,0xff,0xff,0xff,0xba,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3b,0xff,0xc1,0xc2,0xff,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb3,0x2b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb3,0x2b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4b,0xe8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xda,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe,0x92,0xdf,0xfa,0xfb,0xe1,0x88,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcb,0xfa,0xd1,0x34,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xee,0xfb,0xcc,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c,0xb4,0xf3,0xff,0x0,0xff,0xff,0x0,0xff,0xf2,0xb0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x68,0xb4,0xe3,0xf9,0xfa,0xe6,0xb5,0x61,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

void Write_String(r_drw2d_Device_t Dev,int PosX, int PosY, r_drw2d_Color_t  Color, char *Text)
{
    
    int                   startx;
    static r_drw2d_Texture_t tex1;
    
    static r_drw2d_Rect_t rect;
    static r_drw2d_Rect_t src_rect;
    r_drw2d_EffectStage_t effect[2];
    uint32_t xPos, yPos;
    tex1.Buffer.Data = &EnglishFont;
    tex1.Buffer.Pitch =  850;/* Pic_Attribute[FONT_English].u16Pic_Width;*/
    tex1.Buffer.PixelFormat = R_DRW2D_PIXELFORMAT_AL8;
    tex1.Buffer.Size.Height =  19;/*Pic_Attribute[FONT_English].u16Pic_Height;*/
    tex1.Buffer.Size.Width =   850;/*Pic_Attribute[FONT_English].u16Pic_Width;*/
    tex1.Flags = R_DRW2D_TEX_BILINEAR;
    tex1.Handle = 0;


    R_DRW2D_CtxIdentity(Dev);
    R_DRW2D_CtxTextureIdentity(Dev);

    R_DRW2D_CtxBlendMode(Dev, R_DRW2D_BLENDMODE_SRC_OVER);
    R_DRW2D_CtxFillMode(Dev, R_DRW2D_FILLMODE_TEXTURE);

    effect[0].Name = R_DRW2D_EFFECT_MODULATE;
    effect[0].Args[0].Source = R_DRW2D_EFFECT_SOURCE_TEXTURE_UNIT;
    effect[0].Args[0].Param.Color.Source.TextureUnit = 0;
    effect[0].Args[0].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;
    effect[0].Args[1].Source = R_DRW2D_EFFECT_SOURCE_CONSTANT_COLOR;
    effect[0].Args[1].Param.Color.Source.ConstantColor = Color;
    effect[0].Args[1].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;

    R_DRW2D_CtxEffectsSet(Dev, effect, 1);
    R_DRW2D_CtxTextureSet(Dev, 0, &tex1);

    startx = PosX;
    while (*Text != 0)
    {
        if (*Text == '\n')
        {
            PosX  = startx;
	    PosY += 19;
        }
        else
        {
            locWriteChar(Dev, PosX, PosY, *Text);
            PosX += GetCharWidth(*Text);
        }
        Text++;
    } 
    
    R_DRW2D_CtxEffectsDelete(Dev);

}

unsigned int CheckHansans00002ce20List(unsigned int Unicode_16t)
{
    unsigned int ret = 0u;;
    /*if ((Unicode_16t >= 0x0020) && (Unicode_16t < 0x007f)) //CJK latin zihao 20,15*15.
    {
        ret = Unicode_16t;
    }
    else if ((Unicode_16t >= 0x33ff) && (Unicode_16t < 0x4db6)) //CJK siyuanheiti zihao 20,15*15.
    {
      ret =  Unicode_16t - 0x2a5f;
    }
    else if ((Unicode_16t >= 0x4e00) && (Unicode_16t < 0xa000)) //CJK siyuanheiti zihao 20,15*15.
    {

      ret = Unicode_16t - 0x2aa9;
    }
    //unclude in font
    else
    {
      ret = 0x53e3;  //0x09a1;
    }*/
    ret = GetWordIndex(Unicode_16t);
    if(ret >= 0xFFFF)
    {
        ret = 0x293A;
    }

    return ret;
}

unsigned int Get_Unicode_Words_Width(unsigned int Unicode_16t)
{
    unsigned int ret = 0u;
    unsigned int Index = CheckHansans00002ce20List(Unicode_16t);
    ret = Hansans00002ce20[Index].Width;

    //ret = R_DRW2D_2X(ret) + 4;
    //ret = ret + 2;

    return ret;
}
