#include "EOL_Para.h"

_EOL_Data_Type EOL_Data_Type;

void EOL_InitVal(void)
{
	EOL_Data_Type.Flag = 0x7AA7A55Au;
    EOL_Data_Type.DID_605C = 1u;
    EOL_Data_Type.DID_605D = 1u;
    EOL_Data_Type.DID_605E = 1u;
    EOL_Data_Type.DID_605F = 1u;
    EOL_Data_Type.DID_6060 = 1u;
    EOL_Data_Type.DID_6062[0u] = 0x1Fu;
    EOL_Data_Type.DID_6062[1u] = 0x40;
    EOL_Data_Type.DID_6063 = 1u;
    EOL_Data_Type.DID_6064 = 1u;
    EOL_Data_Type.DID_6068 = 1u;
    EOL_Data_Type.DID_606D = 1u;
    EOL_Data_Type.DID_606E = 1u;
    EOL_Data_Type.DID_606F[0u] = 0x00;
    EOL_Data_Type.DID_606F[1u] = 0x64;
    EOL_Data_Type.DID_6070 = 1u;
    EOL_Data_Type.DID_6071 = 1u;
    EOL_Data_Type.DID_6072 = 1u;
    EOL_Data_Type.DID_6073 = 1u;
    EOL_Data_Type.DID_6074 = 1u;
    EOL_Data_Type.DID_6075 = 1u;
    EOL_Data_Type.DID_6076[0u] = 0x00u;
    EOL_Data_Type.DID_6076[1u] = 0x00u;
    EOL_Data_Type.DID_6076[2u] = 0x00u;
    EOL_Data_Type.DID_60C9 = 1u;
    EOL_Data_Type.DID_60CA[0u] = 0x00u;
    EOL_Data_Type.DID_60CA[1u] = 0x64u;
    EOL_Data_Type.DID_60CB[0u] = 0x00u;
    EOL_Data_Type.DID_60CB[1u] = 0x64u;
    EOL_Data_Type.DID_60CC = 0x01u;
    EOL_Data_Type.DID_60CD[0u] = 0x00u;
    EOL_Data_Type.DID_60CD[1u] = 0x1u;
    EOL_Data_Type.DID_60CE = 1u;
    EOL_Data_Type.DID_60CF = 1u;
    EOL_Data_Type.DID_60D0 = 1u;
    EOL_Data_Type.DID_60D1 = 1u;
    EOL_Data_Type.DID_60D2 = 1u;
}

/*LDWS(车道偏离)系统开关*/
uint8_t Val_EOL_605C_LDWS(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_605C;
	return Res;
}

/*AFS 系统开关*/
uint8_t Val_EOL_605D_AFS(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_605D;
	return Res;
}

/*HUD 系统开关*/
uint8_t Val_EOL_605E_HUD(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_605E;
	return Res;
}

/* ACC 系统开关关*/
uint8_t Val_EOL_605F_ACC(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_605F;
	return Res;
}

/* 称重系统开关*/
uint8_t Val_EOL_6060_Weigh(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6060;
	return Res;
}

/* 车速里程表 K 值*/
uint16_t Val_EOL_6062_KValue(void)
{
	uint16_t Res;
	Res = 0u;
	Res = Res | (EOL_Data_Type.DID_6062[0u] << 8u);
	Res = (Res & 0xFF00u) | EOL_Data_Type.DID_6062[1u];
	return Res;
}

/* 发动机速比*/
uint8_t Val_EOL_6063_Engine(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6063;
	return Res;
}

/* 单位*/
uint8_t Val_EOL_6064_Unit(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6064;
	return Res;
}

/* 语言*/
uint8_t Val_EOL_6068_Language(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6068;
	return Res;
}

/* 轮胎防盗使能开关*/
uint8_t Val_EOL_606D_TireAntiTheft(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_606D;
	return Res;
}

/* 换挡提示设置*/
uint8_t Val_EOL_606E_Shift(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_606E;
	return Res;
}

/* 油箱容量设置*/
uint16_t Val_EOL_606F_FuelTank(void)
{
	uint16_t Res;
	Res = 0u;
	Res = Res | (EOL_Data_Type.DID_606F[0u] << 8u);
	Res = (Res & 0xFF00u) | EOL_Data_Type.DID_606F[1u];
	return Res;
}

/* HAS 系统开关*/
uint8_t Val_EOL_6070_HAS(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6070;
	return Res;
}

/* ESC 系统开关*/
uint8_t Val_EOL_6071_ESC(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6071;
	return Res;
}

/* 盘式制动磨损报警功能*/
uint8_t Val_EOL_6072_DiscBrake(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6072;
	return Res;
}

/*挂车设置*/
uint8_t Val_EOL_6073_SetRrailer(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6073;
	return Res;
}

/*排放配置*/
uint8_t Val_EOL_6074_Emission(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6074;
	return Res;
}

/*超速报警车型信号*/
uint8_t Val_EOL_6075_SpeedAlarm(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_6075;
	return Res;
}

/* 油箱容量设置*/
uint32_t Val_EOL_6076_FuelTank(void)
{
    uint32_t Res = 0u;

    Res = (uint8_t)(EOL_Data_Type.DID_6076[0u] & 0xFFU);
    Res = ((Res << 8) & 0XFF00u);
    Res = ((Res | EOL_Data_Type.DID_6076[1u]) & 0x00FFFFu);
    Res = ((Res << 8u) & 0xFFFF00u);
    Res = ((Res | EOL_Data_Type.DID_6076[2u]) & 0xFFFFFFu);
    return Res;
}

/*尿素箱容积*/
uint8_t Val_EOL_60C9_Urea(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_60C9;
	return Res;
}

/* 主油箱容积*/
uint16_t Val_EOL_60CA_MainFuelTank(void)
{
	uint16_t Res;
	Res = 0u;
	Res = Res | (EOL_Data_Type.DID_60CA[0u] << 8u);
	Res = (Res & 0xFF00u) | EOL_Data_Type.DID_60CA[1u];
	return Res;
}

/* 副油箱容积*/
uint16_t Val_EOL_60CB_AuxiliaryTank(void)
{
	uint16_t Res;
	Res = 0;
	Res = Res | (EOL_Data_Type.DID_60CB[0u] << 8u);
	Res = (Res & 0xFF00u) | EOL_Data_Type.DID_60CB[1u];
	return Res;
}

/*油箱类型*/
uint8_t Val_EOL_60CC_FuelTankType(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_60CC;
	return Res;
}

/* 发动机类型*/
uint16_t Val_EOL_60CD_EngineType(void)
{
	uint16_t Res;
	Res = 0;
	Res = Res | (EOL_Data_Type.DID_60CD[0u] << 8u);
	Res = (Res & 0xFF00u) | EOL_Data_Type.DID_60CD[1u];
	return Res;
}

/*TCU 类型*/
uint8_t Val_EOL_60CE_FuelTankType(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_60CE;
	return Res;
}

/*驱动能源类型*/
uint8_t Val_EOL_60CF_DriveEnergy(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_60CF;
	return Res;
}


/*驱动形式*/
uint8_t Val_EOL_60D0_DriveForm(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_60D0;
	return Res;
}

/*蓄电池容量*/
uint8_t Val_EOL_60D1_BatteryCapacity(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_60D1;
	return Res;
}

/*电池管理系统*/
uint8_t Val_EOL_60D2_BatteryManagement(void)
{
	uint8_t Res;
	Res = EOL_Data_Type.DID_60D2;
	return Res;
}