#ifndef _BACKGROUND_LIGHT_H
#define _BACKGROUND_LIGHT_H
#include "BGLInterface.h"
/*#define uint8_t unsigned char*/
/*#define uint16_t unsigned short/*3360 324*/
/*#define uint16_t unsigned int*/ /*Freesecale */
/*#define uint32_t unsigned long*//*Freesecale */
/*#define uint32_t unsigned int*/
typedef struct
{
    uint16_t DestBackLightDuty;
    uint16_t CurBackLightDuty;
    uint16_t BackLightDutyMin;
} BACKLIGHT_PARA;
typedef struct
{
    uint8_t BL_User_PowerSt;
    uint8_t BL_User_WakeFlag;
    uint16_t BL_User_TFTDuty;
    uint16_t BL_User_GaugesDuty;
    uint16_t BL_User_TFTDuty_MIN;
    uint16_t BL_User_GaugesDuty_MIN;
#if (RGB_FUCTION ==1)
    uint16_t BL_User_RDuty;
    uint16_t BL_User_GDuty;
    uint16_t BL_User_BDuty;
    uint16_t BL_User_RDuty_MIN;
    uint16_t BL_User_GDuty_MIN;
    uint16_t BL_User_BDuty_MIN;
#endif
} BL_USER_PARA;
typedef struct
{
    uint8_t BL_User_Theme;
    uint8_t BL_User_Type;
    uint8_t BL_User_TFTLvl;
    uint8_t BL_User_DIALLvl;
    uint8_t BL_User_RGBLvl;
    uint8_t BL_User_Lvl_Total;
    uint16_t BL_User_NTC_AD;
    uint16_t BL_User_NTC_AD_MAX;
    uint8_t BL_User_effect;
} BL_STATE_PARA;
enum
{
    BGL_IGN_OFF,
    BGL_IGN_ON,
};
enum
{
    BL_TFT,
    BL_DIAL,
    LED_FUEL,
    LED_TEMP,
    LED_TEMPBL,
#if (RGB_FUCTION ==1)
    BL_R,
    BL_G,
    BL_B,
#endif
    BACKLIGHT_TOTAL,
};
enum
{
    BGL_GRADUAL,
    BGL_DIRECT,
};
extern uint16_t IgnOffKeepMs;

#define IGN_ON_BACK_LIGHT_DELAY_MS 400u
#define IGN_OFF_BACK_LIGHT_DELAY_MS 10u
#define BACKLIGHT_LV100 0u
#define BACKLIGHT_LV80 1u
#define BACKLIGHT_LV40 2u


extern void SetBackLightOutput(uint8_t n, uint16_t val);
extern void SetBacklightDestVal(uint8_t n, const uint16_t val);
extern void SetBacklightCurVal(uint8_t n, uint16_t val);
extern void SetBacklightMinVal(uint8_t n, uint16_t val);
extern void BackLightDamp(uint8_t TimeX);
extern void BackLightDeal(BL_USER_PARA  BL_FunPara, BL_STATE_PARA BLFunStatePara);
extern void SetBacklightMinVal(uint8_t n, uint16_t val);
extern void  BGLPwm_Config(uint8_t BGLType,  uint16_t DutyVal);
extern void BGLPwm_Start(uint8_t BGLType);
extern void BGLPwm_Stop(uint8_t BGLType);
/**/
extern void BackLightDeal_NTC(BL_USER_PARA  BL_FunPara, BL_STATE_PARA BLFunStatePara);
extern void AD_SwapShort(uint16_t *pData1, uint16_t *pData2);
extern void AD_SortShort(uint16_t SortData[], uint8_t len);
extern uint32_t Calculate_Thermistor(BL_STATE_PARA BLFunStatePara);
extern uint32_t Get_NTCresistance(void);

#endif