#include "Service_TPMS.h"
#include "CAN_Communication_Matrix.h"
#include "Flash_synchronizer.h"

/*** TPMS ***/
_USER_TPMS TPMS_Out[TPMSNumMax] = {0};

/******************************************************************************
  Function：Data_TPMS_KL30_Init
  Description：该服务函数首次KL30时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_KL30_Init(void)
{
    TPMS_Out[FirstLOut].TPMSTyreID = FirstLOutID;
    TPMS_Out[FirstROut].TPMSTyreID = FirstROutID;

    TPMS_Out[SecondLIn].TPMSTyreID = SecondLInID;
    TPMS_Out[SecondRIn].TPMSTyreID = SecondRInID;

    TPMS_Out[ThirdLOut].TPMSTyreID = ThirdLOutID;
    TPMS_Out[ThirdLIn].TPMSTyreID = ThirdLInID;
    TPMS_Out[ThirdROut].TPMSTyreID = ThirdROutID;
    TPMS_Out[ThirdRIn].TPMSTyreID = ThirdRInID;

    TPMS_Out[FourthLOut].TPMSTyreID = FourthLOutID;
    TPMS_Out[FourthLIn].TPMSTyreID = FourthLInID;
    TPMS_Out[FourthROut].TPMSTyreID = FourthROutID;
    TPMS_Out[FourthRIn].TPMSTyreID = FourthRInID;

    TPMS_Out[FirstLOut].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[FirstROut].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;

    TPMS_Out[SecondLIn].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[SecondRIn].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;

    TPMS_Out[ThirdLOut].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[ThirdLIn].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[ThirdROut].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[ThirdRIn].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;

    TPMS_Out[FourthLOut].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[FourthLIn].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[FourthROut].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
    TPMS_Out[FourthRIn].TPMSDataInvalidTime = TPMSDataInvaliTimeNUM;
}
/******************************************************************************
  Function：Data_TPMS_KL15_ON_Init
  Description：该服务函数首次KL15时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_KL15_ON_Init(void)
{
}
/******************************************************************************
  Function：Data_TPMS_Value_Processing
  Description：数据处理总接口  ms任务
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_Value_Processing(void)
{
    /*报文数据获取，处理*/
    Get_Data_TPMS_Value(FirstLOut);
    Get_Data_TPMS_Value(FirstROut);

    Get_Data_TPMS_Value(SecondLIn);
    Get_Data_TPMS_Value(SecondRIn);

    Get_Data_TPMS_Value(ThirdLOut);
    Get_Data_TPMS_Value(ThirdLIn);
    Get_Data_TPMS_Value(ThirdROut);
    Get_Data_TPMS_Value(ThirdRIn);

    Get_Data_TPMS_Value(FourthLOut);
    Get_Data_TPMS_Value(FourthLIn);
    Get_Data_TPMS_Value(FourthROut);
    Get_Data_TPMS_Value(FourthRIn);

    /*报文状态获取*/
    Get_Data_TPMS_Status(FirstLOut);
    Get_Data_TPMS_Status(FirstROut);

    Get_Data_TPMS_Status(SecondLIn);
    Get_Data_TPMS_Status(SecondRIn);

    Get_Data_TPMS_Status(ThirdLOut);
    Get_Data_TPMS_Status(ThirdLIn);
    Get_Data_TPMS_Status(ThirdROut);
    Get_Data_TPMS_Status(ThirdRIn);

    Get_Data_TPMS_Status(FourthLOut);
    Get_Data_TPMS_Status(FourthLIn);
    Get_Data_TPMS_Status(FourthROut);
    Get_Data_TPMS_Status(FourthRIn);
}

/******************************************************************************
  Function：Get_Data_TPMS_Value
  Description：胎压数据获取 数据精度在获取数据函数进行处理
  Input: 输入枚举编号
  Output:
 ******************************************************************************/
void Get_Data_TPMS_Value(TPMSNUM_t TPMSTyreID)
{
    uint16_t TyrePressure = 0u;
    uint8_t TyreTemp = 0u;

    if (TPMS_Out[TPMSTyreID].TPMSTyreID == Get_ID_18011733_Sig_Tire_Index())
    {
        /*胎压  数据处理*/
        TyrePressure = Get_ID_18011733_Sig_Tire_Pressure();
        if (TyrePressure < 1000u)
        {
            TPMS_Out[TPMSTyreID].TPMSPressure  = TyrePressure ;
        }
        else
        {
            TPMS_Out[TPMSTyreID].TPMSPressure = 0x00u;
        }

        /*胎温数据处理*/
        TPMS_Out[TPMSTyreID].TPMSTempSign = Get_ID_18011733_Sig_Tire_Temperature_Sign();

        if (TPMS_Out[TPMSTyreID].TPMSTempSign == 0x01u)
        {
            /*' - '*/
            TyreTemp = (uint8_t)(TYRETEMP_OFFSET_VALUE - (Get_ID_18011733_Sig_Tire_Temperature() & 0x7F));

            if (TyreTemp > 99)
            {
                TPMS_Out[TPMSTyreID].TPMSTemp = 99u;
            }
            else
            {
                TPMS_Out[TPMSTyreID].TPMSTemp = TyreTemp;
            }
        }
        else
        {
            /*' + '*/
            TPMS_Out[TPMSTyreID].TPMSTemp = Get_ID_18011733_Sig_Tire_Temperature();
        }

        /*数据掉线计时器*/
        TPMS_Out[TPMSTyreID].TPMSDataInvalidTime = 0u;
    }
    else
    {
        if (TPMS_Out[TPMSTyreID].TPMSDataInvalidTime < 0xFFFFu)
        {
            TPMS_Out[TPMSTyreID].TPMSDataInvalidTime++;
        }
        else
        {
            TPMS_Out[TPMSTyreID].TPMSDataInvalidTime = 0xFFFFu;
        }
    }
    if (CAN_MSG_Status(ID_CanMsg18011733_Msg_Count) == CAN_SIG_LOST)
    {
        TPMS_Out[TPMSTyreID].TPMSPressure = 0x00u;
        TPMS_Out[TPMSTyreID].TPMSTemp = 0x00u;
    }
}

/******************************************************************************
  Function：Get_Data_TPMS_Status
  Description：胎压状态获取
  Input:输入枚举编号
  Output:
 ******************************************************************************/
void Get_Data_TPMS_Status(TPMSNUM_t TPMSTyreID)
{
    if (TPMS_Out[TPMSTyreID].TPMSTyreID == Get_ID_18011733_Sig_Tire_Index())
    {
        /*低气压报警          */
        TPMS_Out[TPMSTyreID].TPMSLowpressure = Get_ID_18011733_Sig_Low_Presure_Alarm();
        /*高气压报警          */
        TPMS_Out[TPMSTyreID].TPMSHighpressure = Get_ID_18011733_Sig_High_Presure_Alarm();
        /*高温报警            */
        TPMS_Out[TPMSTyreID].TPMSHightemperature = Get_ID_18011733_Sig_High_Temperature_Alarm();
        /*快速漏气报警        */
        TPMS_Out[TPMSTyreID].TPMSRapidleakage = Get_ID_18011733_Sig_Fast_air_leakage_alarm();
        /*低电压报警          */
        TPMS_Out[TPMSTyreID].TPMSLowvoltage = Get_ID_18011733_Sig_Low_Voltage_Alarm();
        /*无信号报警           */
        TPMS_Out[TPMSTyreID].TPMSNosignal = Get_ID_18011733_Sig_No_signal_Alarm();
        /*传感器故障信息       */
        TPMS_Out[TPMSTyreID].TPMSSensorfault = Get_ID_18011733_Sig_Sensor_fault_information();
    }
    else if (CAN_MSG_Status(ID_CanMsg18011733_Msg_Count) == CAN_SIG_LOST)
    {
        /*低气压报警          */
        TPMS_Out[TPMSTyreID].TPMSLowpressure = 0u;
        /*高气压报警          */
        TPMS_Out[TPMSTyreID].TPMSHighpressure = 0u;
        /*高温报警            */
        TPMS_Out[TPMSTyreID].TPMSHightemperature = 0u;
        /*快速漏气报警        */
        TPMS_Out[TPMSTyreID].TPMSRapidleakage = 0u;
        /*低电压报警          */
        TPMS_Out[TPMSTyreID].TPMSLowvoltage = 0u;
        /*无信号报警           */
        TPMS_Out[TPMSTyreID].TPMSNosignal = 0u;
        /*传感器故障信息       */
        TPMS_Out[TPMSTyreID].TPMSSensorfault = 0u;
    }
}

/******************************************************************************
  Function： Get_DataTPMS_Pressure_Value
  Description：获取某个编号轮胎胎压数据
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint16_t Get_DataTPMS_Pressure_Value(TPMSNUM_t TPMSTyreID)
{
    return TPMS_Out[TPMSTyreID].TPMSPressure;
}

/******************************************************************************
  Function： Get_DataTPMS_Pressure_Sta
  Description：获取某个编号轮胎胎压状态
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据状态 有效无效等
 ******************************************************************************/
uint16_t Get_DataTPMS_Pressure_Sta(TPMSNUM_t TPMSTyreID)
{
    uint16_t Pressure_Sta = 0u;

    if ((TPMS_Out[TPMSTyreID].TPMSDataInvalidTime) >= TPMSDataInvaliTimeNUM) /*数据超时 掉线或轮刷超时*/
    {
        Pressure_Sta = (uint16_t)STATUS_TIMEOUT;
    }
    else if ((TPMS_Out[TPMSTyreID].TPMSPressure) >= 0xFAu) /*超出最大范围*/
    {
        Pressure_Sta = (uint16_t)STATUS_UNSUPPORTED;
    }
    else
    {
        Pressure_Sta = (uint16_t)STATUS_SUCCESS;
    }

    return Pressure_Sta;
}
/******************************************************************************
  Function： Get_DataTPMS_Pressure_FLashSta
  Description：获取某个编号轮胎胎压状态
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据的闪烁状态
 ******************************************************************************/
uint8_t Get_DataTPMS_Pressure_FLashSta(TPMSNUM_t TPMSTyreID)
{
    uint8_t Pressure_Sta = 0u;
    uint16_t Get_Pressure_Sta = 0u;

    Get_Pressure_Sta = Get_DataTPMS_Pressure_Sta(TPMSTyreID);

    if (Get_Pressure_Sta == STATUS_TIMEOUT)
    {
        Pressure_Sta = FLASH_SYNC_1Hz;
    }

    return (uint8_t)Pressure_Sta;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_Value
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint16_t Get_DataTPMS_Temp_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint16_t)TPMS_Out[TPMSTyreID].TPMSTemp;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_Sta
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output: 输出胎温数据状态，有效无效正数负数等
 ******************************************************************************/
uint16_t Get_DataTPMS_Temp_Sta(TPMSNUM_t TPMSTyreID)
{
    uint16_t Temp_Value = 0u;
    uint16_t Get_Temp_Value = 0u;

    Get_Temp_Value = Get_DataTPMS_Temp_Value(TPMSTyreID);

    if (TPMS_Out[TPMSTyreID].TPMSDataInvalidTime >= TPMSDataInvaliTimeNUM) /*数据超时 掉线或轮刷超时*/
    {
        Temp_Value = (uint16_t)STATUS_TIMEOUT;
    }
    else if (Get_Temp_Value >= 0xFFFFu) /*超出最大范围*/
    {
        Temp_Value = (uint16_t)STATUS_UNSUPPORTED;
    }
    else if ((TPMS_Out[TPMSTyreID].TPMSTempSign) == 0x01u) /*负数 返回状态*/
    {
        Temp_Value = (uint16_t)STATUS_NEGATIVE;
    }
    else if ((TPMS_Out[TPMSTyreID].TPMSTempSign) == 0x00u) /*正数 零 返回状态*/
    {
        Temp_Value = (uint16_t)STATUS_NONNEGATIVE;
    }
    else
    {
        Temp_Value = (uint16_t)STATUS_SUCCESS;
    }
    return (uint16_t)Temp_Value;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_FLashSta
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output: 输出胎温闪烁状态
 ******************************************************************************/
uint8_t Get_DataTPMS_Temp_FLashSta(TPMSNUM_t TPMSTyreID)
{
    uint8_t TEMP_Sta = 0u;
    uint16_t Get_Temp_Sta = 0u;

    Get_Temp_Sta = Get_DataTPMS_Temp_Sta(TPMSTyreID);

    if (Get_Temp_Sta == (uint16_t)STATUS_TIMEOUT)
    {
        TEMP_Sta = FlashSync1Hz;
    }

    return (uint8_t)TEMP_Sta;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎低气压报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_TPMSLowpressure_Sta(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSLowpressure;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎高气压报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_TPMSHighpressure_Sta(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSHighpressure;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎高温报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_TPMSHigTemp_Sta(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSHightemperature;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎快速漏气报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_RapidLeakWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSRapidleakage;
}

/******************************************************************************
  Function：Get_TPMSLowvoltage_Sta
  Description：获取某个编号轮胎低电压报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_TPMSLowvoltage_Sta(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSLowvoltage;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎无信号报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_TPMSNosignal_Sta(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSNosignal;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎传感器故障信息   7   8   9
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_SensorErrorWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSSensorfault;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎压力报警状态
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_TPMSPresure_Alarm(TPMSNUM_t TPMSTyreID)
{
    uint8_t TPMSLowpressure = 0u;
    uint8_t TPMSHighpressure = 0u;
    uint8_t TPMSRapidleakage = 0u;
    uint8_t Ret = 0;

    TPMSLowpressure = TPMS_Out[TPMSTyreID].TPMSLowpressure;
    TPMSHighpressure = TPMS_Out[TPMSTyreID].TPMSHighpressure;
    TPMSRapidleakage = TPMS_Out[TPMSTyreID].TPMSRapidleakage;

    if ((TPMSLowpressure == 1u) || (TPMSHighpressure == 1u) || (TPMSRapidleakage == 1u))
    {
        Ret = 1u;
    }
    else
    {
        Ret = 0u;
    }

    return Ret;
}

/******************************************************************************
  Function： Get_TPMSLow_Presure_Sta
  Description：获取所有轮胎胎压低状态
  Input:
  Output:
 ******************************************************************************/
uint8_t Get_TPMSLow_Presure_Sta(void)
{
    uint8_t Low_Presure = 0u;

    if ((Get_TPMSLowpressure_Sta(FirstLOut) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(FirstROut) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(SecondLIn) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(SecondRIn) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(ThirdLOut) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(ThirdLIn) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(ThirdRIn) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(ThirdROut) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(FourthLOut) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(FourthLIn) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(FourthRIn) == 0x01u) ||
            (Get_TPMSLowpressure_Sta(FourthROut) == 0x01u))
    {
        Low_Presure = 0x01u;
    }
    else
    {
        Low_Presure = 0x00u;
    }

    return Low_Presure;
}

/******************************************************************************
  Function： Get_TPMSHigh_Presure_Sta
  Description：获取所有轮胎胎压高状态
  Input:
  Output:
 ******************************************************************************/
uint8_t Get_TPMSHigh_Presure_Sta(void)
{
    uint8_t High_Presure = 8u;

    if ((Get_TPMSHighpressure_Sta(FirstLOut) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(FirstROut) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(SecondLIn) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(SecondRIn) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(ThirdLOut) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(ThirdLIn) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(ThirdRIn) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(ThirdROut) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(FourthLOut) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(FourthLIn) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(FourthRIn) == 0x01u) ||
            (Get_TPMSHighpressure_Sta(FourthROut) == 0x01u))
    {
        High_Presure = 0x01u;
    }
    else
    {
        High_Presure = 0x00u;
    }

    return High_Presure;
}

/******************************************************************************
  Function： Get_TPMSHigh_Temperature_Sta
  Description：获取所有轮胎胎温高状态
  Input:
  Output:
 ******************************************************************************/
uint8_t Get_TPMSHigh_Temperature_Sta(void)
{
    uint8_t High_Temperature = 0u;

    if ((Get_TPMSHigTemp_Sta(FirstLOut) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(FirstROut) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(SecondLIn) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(SecondRIn) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(ThirdLOut) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(ThirdLIn) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(ThirdRIn) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(ThirdROut) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(FourthLOut) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(FourthLIn) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(FourthRIn) == 0x01u) ||
            (Get_TPMSHigTemp_Sta(FourthROut) == 0x01u))
    {
        High_Temperature = 0x01u;
    }
    else
    {
        High_Temperature = 0x00u;
    }

    return High_Temperature ;
}

/******************************************************************************
  Function： Get_TPMSFast_air_leakage
  Description：
  Input:
  Output:
 ******************************************************************************/
uint8_t Get_TPMSFast_air_leakage(void)
{
    uint8_t Fast_air_leakage = 0u;

    if ((Get_DataTPMS_RapidLeakWarningSig_Value(FirstLOut) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(FirstROut) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(SecondLIn) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(SecondRIn) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(ThirdLOut) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(ThirdLIn) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(ThirdRIn) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(ThirdROut) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(FourthLOut) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(FourthLIn) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(FourthRIn) == 0x01u) ||
            (Get_DataTPMS_RapidLeakWarningSig_Value(FourthROut) == 0x01u))
    {
        Fast_air_leakage = 0x01u;
    }
    else
    {
        Fast_air_leakage = 0x00u;
    }

    return Fast_air_leakage ;
}


/******************************************************************************
  Function： Get_TPMSLow_Voltage_Sta
  Description：
  Input:
  Output:
 ******************************************************************************/
uint8_t Get_TPMSLow_Voltage_Sta(void)
{
    uint8_t Low_Voltage = 0x00u;

    if ((Get_TPMSLowvoltage_Sta(FirstLOut) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(FirstROut) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(SecondLIn) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(SecondRIn) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(ThirdLOut) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(ThirdLIn) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(ThirdRIn) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(ThirdROut) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(FourthLOut) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(FourthLIn) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(FourthRIn) == 0x01u) ||
            (Get_TPMSLowvoltage_Sta(FourthROut) == 0x01u))
    {
        Low_Voltage = 0x01u;
    }
    else
    {
        Low_Voltage = 0x00u;
    }

    return Low_Voltage ;
}

/******************************************************************************
  Function： Get_TPMSNo_signal_Sta
  Description：
  Input:
  Output:
 ******************************************************************************/
uint8_t Get_TPMSNo_signal_Sta(void)
{
    uint8_t No_signal = 0x00u;

    if ((Get_TPMSNosignal_Sta(FirstLOut) == 0x01u) ||
            (Get_TPMSNosignal_Sta(FirstROut) == 0x01u) ||
            (Get_TPMSNosignal_Sta(SecondLIn) == 0x01u) ||
            (Get_TPMSNosignal_Sta(SecondRIn) == 0x01u) ||
            (Get_TPMSNosignal_Sta(ThirdLOut) == 0x01u) ||
            (Get_TPMSNosignal_Sta(ThirdLIn) == 0x01u) ||
            (Get_TPMSNosignal_Sta(ThirdRIn) == 0x01u) ||
            (Get_TPMSNosignal_Sta(ThirdROut) == 0x01u) ||
            (Get_TPMSNosignal_Sta(FourthLOut) == 0x01u) ||
            (Get_TPMSNosignal_Sta(FourthLIn) == 0x01u) ||
            (Get_TPMSNosignal_Sta(FourthRIn) == 0x01u) ||
            (Get_TPMSNosignal_Sta(FourthROut) == 0x01u))
    {
        No_signal = 0x01u;
    }
    else
    {
        No_signal = 0x00u;
    }

    return No_signal;
}

/******************************************************************************
  Function： Get_TPMSSensor_fault_Sta
  Description：
  Input:
  Output:
 ******************************************************************************/
uint8_t Get_TPMSSensor_fault_Sta(void)
{
    uint8_t Sensor_fault = 0x00u;

    if (
        (Get_DataTPMS_SensorErrorWarningSig_Value(FirstLOut) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FirstLOut) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FirstLOut) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(FirstROut) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FirstROut) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FirstROut) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(SecondLIn) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(SecondLIn) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(SecondLIn) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(SecondRIn) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(SecondRIn) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(SecondRIn) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdLOut) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdLOut) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdLOut) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdLIn) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdLIn) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdLIn) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdRIn) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdRIn) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdRIn) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdROut) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdROut) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(ThirdROut) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(FourthLOut) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthLOut) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthLOut) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(FourthLIn) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthLIn) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthLIn) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(FourthRIn) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthRIn) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthRIn) == 0x09u) ||
        (Get_DataTPMS_SensorErrorWarningSig_Value(FourthROut) == 0x07u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthROut) == 0x08u) || (Get_DataTPMS_SensorErrorWarningSig_Value(FourthROut) == 0x09u))
    {
        Sensor_fault = 0x01u;
    }
    else
    {
        Sensor_fault = 0x00u;
    }

    return Sensor_fault ;
}
