/******************************************************************************
文 件 名：Buzzer.c
功能描述：蜂鸣器驱动库头文件
作    者：张暄
版    本：V1.0
日    期：2016.5.18
******************************************************************************/

#ifndef _BUZZER_H_
#define _BUZZER_H_

#include "GPIO.h"
#include "r_typedefs.h"
/*****************************************************************************
音轨总数
*****************************************************************************/
#define BUZZER_TRACK_CNT                         ((uint8_t)10)

/*****************************************************************************
声音重定义
*****************************************************************************/
#define BUZZER_SOUND_TIC                         ((uint8_t)0)
#define BUZZER_SOUND_TAC                         ((uint8_t)1)
#define BUZZER_SOUND_DONG                        ((uint8_t)2)
#define BUZZER_SOUND_PLING                       ((uint8_t)3)
#define BUZZER_SOUND_PLONG                       ((uint8_t)4)
#define BUZZER_SOUND_PARK_BEEP                   ((uint8_t)5)
#define BUZZER_SOUND_PLING_PLONG                 ((uint8_t)6)

/*****************************************************************************
单音重定义
*****************************************************************************/
#define BUZZER_SINGLE_SOUND_TIC                  ((uint8_t)0)
#define BUZZER_SINGLE_SOUND_TAC                  ((uint8_t)1)
#define BUZZER_SINGLE_SOUND_DONG                 ((uint8_t)2)
#define BUZZER_SINGLE_SOUND_PLING                ((uint8_t)3)
#define BUZZER_SINGLE_SOUND_PLONG                ((uint8_t)4)
#define BUZZER_SINGLE_SOUND_PARK_BEEP            ((uint8_t)5)

typedef enum
{
    BUZZER_Track_Index_Tic          = 0x00,
    BUZZER_Track_Index_Tac          ,
    BUZZER_Track_Index_Dong         ,
    BUZZER_Track_Index_Pling        ,
    BUZZER_Track_Index_Plong        ,
    BUZZER_Track_Index_ParkBeep     ,
    BUZZER_Track_Index_3900hz_500Dty,				  
    BUZZER_Track_Index_2300hz_500Dty,				  
    BUZZER_Track_Index_3900hz_280Dty,						  
    BUZZER_Track_Index_2300hz_280Dty,
    BUZZER_Track_Index_3900hz_190Dty,    
    BUZZER_Track_Index_2600hz_167Dty,				  
    BUZZER_Track_Index_2000hz_500Dty,
    BUZZER_Track_Index_0800hz_500Dty,				  
    
    BUZZER_Track_Index_MAX,
} BUZZER_Track_Index_en_t;

/*****************************************************************************
播放类型
*****************************************************************************/
#define BUZZER_SOUND_PLAY_IDLE                   ((uint8_t)0)
#define BUZZER_SOUND_PLAY_REPEAT                 ((uint8_t)1)
#define BUZZER_SOUND_PLAY_NONSTOP                ((uint8_t)2)

/******************************************************************************
信号重定义
******************************************************************************/
#define LINE_BUZZER  BUZZER_ACC_OUT_EN
//#define BUZZER_PWM_EN     PWME_PWME4
//#define BUZZER_FREQ_CTRL  PWMPER4     //蜂鸣器频率 = 100kHz / BUZZER_FREQ_CTRL
//#define BUZZER_DUTY_CTRL  PWMDTY4

/******************************************************************************
结构定义
******************************************************************************/
typedef struct
{
    uint16_t  Freq;             //频率控制字     设定值 = 100kHz / 单音频率
    uint16_t  Duty;
    uint16_t PlayTime;         //单音播放时间   设定值 = 单音播放时间 / 64us
    uint16_t FadeOutTime;      //单音淡出时间   设定值 = 单音淡出时间 / 64us
} SingleSoundStruct;

typedef struct
{
    uint8_t  SoundTable[7];    //复合音各单音列表
    uint8_t  SoundCnt;         //复合音包含的单音总数
} ComplexSoundStruct;

typedef struct
{
    uint8_t  Mode;
    uint8_t  SoundID;
    uint8_t  RepeatNum;
    uint8_t  RepeatCnt;
    uint8_t  RepeatCycle;
    uint8_t  RepeatTimer;
} TrackInfoStruct;

/******************************************************************************
函数声明
******************************************************************************/
void    Buzzer_Init ( void );
void    Buzzer_Shutdown ( void );
void    Buzzer_Play_ISR ( void );              //嵌入到64us中断中
void    Warning_Sound_Init ( void );
void    Buzzer_Stop_All_Track ( void );
void    Buzzer_Track_Play_Service ( void );   //每20ms调用一次
void    Buzzer_Track_Play ( uint8_t TrackID );
void    Buzzer_Track_Stop ( uint8_t TrackID );
void    Buzzer_Track_Pause ( uint8_t TrackID );
void    Buzzer_Play_Sound ( uint8_t SoundID );
void    Buzzer_Set_Track_Remaining_Repeat_Num ( uint8_t TrackID, uint8_t RepeatNum );
void    Buzzer_Track_Init ( uint8_t TrackID, uint8_t SoundID, uint8_t RepeatNum, uint8_t RepeatCycle );
uint8_t Buzzer_Get_All_Track_Status ( void );
uint8_t Buzzer_Get_Track_Status ( uint8_t TrackID );
uint8_t Buzzer_Get_Track_Remaining_Repeat_Num ( uint8_t TrackID );
#endif

