#include "RTE_TIME.h"

uint16_t RTE_RTC_YEAR;
uint8_t RTE_RTC_MONTH;
uint8_t RTE_RTC_DATE;
uint8_t RTE_RTC_HOUR;
uint8_t RTE_RTC_MINUTE;
uint8_t RTE_RTC_SECOND;

void RTE_RTC_KL30_Init(void)
{
    RTC_Pre_Init();
}

void RTE_RTC_Wakeup_Init(void)
{
    RTC_Init();
}

void RTE_RTC_Services_100Ms_Cbk(void)
{
    RTC_Timing_Service();
}



void RTE_RTC_Set_Secone(uint8_t m_Second)
{
    RTE_RTC_SECOND = m_Second;
}

void RTE_RTC_Set_Hour(uint8_t m_Hour)
{
    RTE_RTC_HOUR = m_Hour;
}

void RTE_RTC_Set_Minute(uint8_t m_Minute)
{
    RTE_RTC_MINUTE = m_Minute;
}

void RTE_RTC_Set_Date(uint8_t m_Date)
{
    RTE_RTC_DATE = m_Date;
}

void RTE_RTC_Set_Month(uint8_t m_Month)
{
    RTE_RTC_MONTH = m_Month;
}

void RTE_RTC_Set_Year(uint16_t m_Year)
{
    RTE_RTC_YEAR = m_Year;
}

void RTE_RTC_Confirm_Overwrite(void)
{
    RTC_Information_st_t mTimmerSetting;

    mTimmerSetting.u8RTCYear = RTE_RTC_YEAR - 2000u;   /*00~~99 in Dec*/
    mTimmerSetting.u8RTCMonth = RTE_RTC_MONTH;    /*01~~12 in Dec*/
    mTimmerSetting.u8RTCDayOfMonth = RTE_RTC_DATE; /*01~~31 in Dec*/
    mTimmerSetting.u8RTCHour = RTE_RTC_HOUR;     /*fix 24Hour Format 00~~23 in  Dec*/
    mTimmerSetting.u8RTCMinute = RTE_RTC_MINUTE;   /*0~~59 in Dec*/
    mTimmerSetting.u8RTCSecond = RTE_RTC_SECOND;   /*0~~59 in Dec*/

    RTC_Set_Time(&mTimmerSetting);
}



uint16_t Get_RTC_YEAR(void)
{
    return RTC_YEAR;
}

uint8_t Get_RTC_MONTH(void)
{
    return RTC_MONTH;
}

uint8_t Get_RTC_DATE(void)
{
    return RTC_DATE;
}

uint8_t Get_RTC_HOUR(void)
{
    return RTC_HOUR;
}

uint8_t Get_RTC_MINUTE(void)
{
    return RTC_MINUTE;
}

uint8_t Get_RTC_SECOND(void)
{
    return RTC_SECOND;
}

uint8_t Get_RTC_WEEK(void)
{
    return RTC_WEEK ;
}
