#ifndef __CD4051_H_
#define __CD4051_H_

#include "r_typedefs.h"

#define CD4051_PIN_HIGH 1
#define CD4051_PIN_LOW 0

typedef enum
{
    ID_COM1 = 0,
    ID_COM2,
    ID_COM3,
    ID_COM4,
    ID_COM5,
    ID_COM6,
    ID_COM7,
    ID_MAX
} em_CD4051_ID;

typedef union
{
    struct
    {
        uint8_t X0 : 1;
        uint8_t X1 : 1;
        uint8_t X2 : 1;
        uint8_t X3 : 1;
        uint8_t X4 : 1;
        uint8_t X5 : 1;
        uint8_t X6 : 1;
        uint8_t X7 : 1;
    } Bits;
    uint8_t Byte;
} u_CD4051_Input;

extern volatile u_CD4051_Input CD4051_Input[ID_MAX];

//-----------------外部应用需要时调用---------------wangboyu-------
/*COM1映射PCB*/
#define CD4051_COM1_X0_IN CD4051_Input[ID_COM1].Bits.X0 /*A36*/
#define CD4051_COM1_X1_IN CD4051_Input[ID_COM1].Bits.X1 /*   */
#define CD4051_COM1_X2_IN CD4051_Input[ID_COM1].Bits.X2 /*   */
#define CD4051_COM1_X3_IN CD4051_Input[ID_COM1].Bits.X3 /*A34*/
#define CD4051_COM1_X4_IN CD4051_Input[ID_COM1].Bits.X4 /*A21*/
#define CD4051_COM1_X5_IN CD4051_Input[ID_COM1].Bits.X5 /*A25*/
#define CD4051_COM1_X6_IN CD4051_Input[ID_COM1].Bits.X6 /*A22*/
#define CD4051_COM1_X7_IN CD4051_Input[ID_COM1].Bits.X7 /*A23*/
/*COM2映射PCB*/
#define CD4051_COM2_X0_IN CD4051_Input[ID_COM2].Bits.X0 /*A31*/
#define CD4051_COM2_X1_IN CD4051_Input[ID_COM2].Bits.X1 /*A32*/
#define CD4051_COM2_X2_IN CD4051_Input[ID_COM2].Bits.X2 /*A33*/
#define CD4051_COM2_X3_IN CD4051_Input[ID_COM2].Bits.X3 /*A30*/
#define CD4051_COM2_X4_IN CD4051_Input[ID_COM2].Bits.X4 /*A26*/
#define CD4051_COM2_X5_IN CD4051_Input[ID_COM2].Bits.X5 /*A29*/
#define CD4051_COM2_X6_IN CD4051_Input[ID_COM2].Bits.X6 /*A27*/
#define CD4051_COM2_X7_IN CD4051_Input[ID_COM2].Bits.X7 /*A28*/
/*COM3映射PCB*/
#define CD4051_COM3_X0_IN CD4051_Input[ID_COM3].Bits.X0 /*A19*/
#define CD4051_COM3_X1_IN CD4051_Input[ID_COM3].Bits.X1 /*B19*/
#define CD4051_COM3_X2_IN CD4051_Input[ID_COM3].Bits.X2 /*B18*/
#define CD4051_COM3_X3_IN CD4051_Input[ID_COM3].Bits.X3 /*A15*/
#define CD4051_COM3_X4_IN CD4051_Input[ID_COM3].Bits.X4 /*A10*/
#define CD4051_COM3_X5_IN CD4051_Input[ID_COM3].Bits.X5 /*A20*/
#define CD4051_COM3_X6_IN CD4051_Input[ID_COM3].Bits.X6 /*A06*/
#define CD4051_COM3_X7_IN CD4051_Input[ID_COM3].Bits.X7 /*A03*/
/*COM4映射PCB*/
#define CD4051_COM4_X0_IN CD4051_Input[ID_COM4].Bits.X0 /*B35*/
#define CD4051_COM4_X1_IN CD4051_Input[ID_COM4].Bits.X1 /*B34*/
#define CD4051_COM4_X2_IN CD4051_Input[ID_COM4].Bits.X2 /*B33*/
#define CD4051_COM4_X3_IN CD4051_Input[ID_COM4].Bits.X3 /*B36*/
#define CD4051_COM4_X4_IN CD4051_Input[ID_COM4].Bits.X4 /*B20*/
#define CD4051_COM4_X5_IN CD4051_Input[ID_COM4].Bits.X5 /*B37*/
#define CD4051_COM4_X6_IN CD4051_Input[ID_COM4].Bits.X6 /*B40*/
#define CD4051_COM4_X7_IN CD4051_Input[ID_COM4].Bits.X7 /*B38*/
/*COM5映射PCB*/
#define CD4051_COM5_X0_IN CD4051_Input[ID_COM5].Bits.X0 /*B23*/
#define CD4051_COM5_X1_IN CD4051_Input[ID_COM5].Bits.X1 /*B22*/
#define CD4051_COM5_X2_IN CD4051_Input[ID_COM5].Bits.X2 /*B21*/
#define CD4051_COM5_X3_IN CD4051_Input[ID_COM5].Bits.X3 /*B24*/
#define CD4051_COM5_X4_IN CD4051_Input[ID_COM5].Bits.X4 /*B32*/
#define CD4051_COM5_X5_IN CD4051_Input[ID_COM5].Bits.X5 /*B26*/
#define CD4051_COM5_X6_IN CD4051_Input[ID_COM5].Bits.X6 /*B31*/
#define CD4051_COM5_X7_IN CD4051_Input[ID_COM5].Bits.X7 /*B30*/
/*COM6映射PCB*/
#define CD4051_COM6_X0_IN CD4051_Input[ID_COM6].Bits.X0 /*A06*/
#define CD4051_COM6_X1_IN CD4051_Input[ID_COM6].Bits.X1 /*B07*/
#define CD4051_COM6_X2_IN CD4051_Input[ID_COM6].Bits.X2 /*B08*/
#define CD4051_COM6_X3_IN CD4051_Input[ID_COM6].Bits.X3 /*B05*/
#define CD4051_COM6_X4_IN CD4051_Input[ID_COM6].Bits.X4 /*B01*/
#define CD4051_COM6_X5_IN CD4051_Input[ID_COM6].Bits.X5 /*B04*/
#define CD4051_COM6_X6_IN CD4051_Input[ID_COM6].Bits.X6 /*B02*/
#define CD4051_COM6_X7_IN CD4051_Input[ID_COM6].Bits.X7 /*B03*/
/*COM7映射PCB*/
#define CD4051_COM7_X0_IN CD4051_Input[ID_COM7].Bits.X0 /*B15*/
#define CD4051_COM7_X1_IN CD4051_Input[ID_COM7].Bits.X1 /*B16*/
#define CD4051_COM7_X2_IN CD4051_Input[ID_COM7].Bits.X2 /*B17*/
#define CD4051_COM7_X3_IN CD4051_Input[ID_COM7].Bits.X3 /*B14*/
#define CD4051_COM7_X4_IN CD4051_Input[ID_COM7].Bits.X4 /*B10*/
#define CD4051_COM7_X5_IN CD4051_Input[ID_COM7].Bits.X5 /*B13*/
#define CD4051_COM7_X6_IN CD4051_Input[ID_COM7].Bits.X6 /*B11*/
#define CD4051_COM7_X7_IN CD4051_Input[ID_COM7].Bits.X7 /*B12*/

void CD4051_Pin_Init(void);
void CD4051_GetInputStatus(unsigned char Channel);
void CD4051_GetInputStatusProc(void);

#endif
