#include "UDS_11Service_Main.h"

/**
  *11服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_11_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_NRC11();                                            /*11服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_NRC7F();                                            /*11服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC13_MinLengthCheck();                         /*11服务最小长度验证*/
    }    
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC12();                                        /*11服务子功能是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC7E();                                        /*11服务子功能会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_NRC13_TotalLengthCheck();                           /*11服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_NRC33();                                            /*11服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_NRC22();                                            /*11服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC24();                                        /*11服务子功能请求顺序验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_NRC31();                                            /*11服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_11Service_Sub();                                                    /*11服务子功能*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *11服务子功能
  */
void UDS_11Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    /*if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC13_MinLengthCheck();                         /*11服务子功能最小长度验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC12();                                        /*11服务子功能是否支持验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC7E();                                        /*11服务子功能会话是否支持验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC31();                                        /*11服务子功能超出请求范围验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC13_TotalLengthCheck();                       /*11服务子功能总长度长度验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC24();                                        /*11服务子功能请求顺序验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_11Service_Sub_NRC22();                                        /*11服务子功能条件验证*/
    /*}*/
    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.SidDetail.SubID)                                 /*子服务判断*/
        {
        case HardReset:
            UDS_11Service_Sub01();                                              /*11服务01子功能*/
            break;
        case SoftReset:
            UDS_11Service_Sub03();                                              /*11服务03子功能*/
            break;
        default:
            break;
        }
    }
}

/**
  *11服务01子功能
  */
void UDS_11Service_Sub01(void)
{
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        /*复位*/
        UDS_S11_Sand(0x01u);
    }
    else
    {
        UDS_RESET();
    }
}

/**
  *11服务03子功能
  */
void UDS_11Service_Sub03(void)
{
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        /*复位*/
        UDS_S11_Sand(0x03u);
    }
    else
    {
        UDS_RESET();
    }
}