/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : C basic type declarations
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 4771 $
 *  $Date: 2015-02-10 12:01:30 +0100 (Di, 10. Feb 2015) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_TYPES_H_INCLUDED
#define DAVEHD_TYPES_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------------------------------------*/

#include "davehd_settings.h"
#include "davehd_platform.h"

/*----------------------------------------------------------------------------------------------------------*/
#define DHD_INVALID_JOB     ((dhd_jobid_t) 0)                  /* special token thats invalid as jobId*/
#define DHD_INVALID_HANDLE  ((dhd_handle_t) 0)                 /* special token thats invalid as handle*/
#define DHD_INVALID_PCID    0xff                               /* invalid performance counter id*/
#define DHD_NOT_ASSIGNED    0                                  /* pending jobs get assigned this syncID*/

#define DHD_TRUE  ((dhd_bool_t) 1)                             /* boolean true*/
#define DHD_FALSE ((dhd_bool_t) 0)                             /* boolean false*/

/*----------------------------------------------------------------------------------------------------------                                                             */
/* compare two unsigned 32bit numbers and test for a < b. works even under the presence of wrap-arounds, as */
/* long as the absolut distance between both can be represented as signed int32.*/
#define DHD_LESS_WRAPAROUND(a, b) ( (dhd_int32_t) ((dhd_uint32_t)(a) - (dhd_uint32_t)(b)) < 0 ) 

/*----------------------------------------------------------------------------------------------------------*/
/* helper macro to increment a pointer in a misra safe way*/
#define DHD_INC_PTR( base, inc ) (&((dhd_uint8_t *)(base))[ (inc) ])

/*----------------------------------------------------------------------------------------------------------*/
/* determine the number of cache lines that are required to store 's' bytes*/
#define DHD_CSIZE( s )   (((s) + (DHD_CACHELINE_SIZE - 1)) / DHD_CACHELINE_SIZE)

/*----------------------------------------------------------------------------------------------------------*/
/* basic types*/

typedef unsigned long long dhd_uint64_t;      /* 64 bit unsigned integer type*/
typedef          long long dhd_int64_t;       /* 64 bit signed integer type*/

typedef unsigned int       dhd_uint32_t;      /* 32 bit unsigned integer type*/
typedef int                dhd_int32_t;       /* 32 bit signed integer type*/

typedef dhd_int32_t        dhd_fx28_4_t;      /* 28.4 bit signed fixed point type*/
typedef dhd_int32_t        dhd_fx14_18_t;     /* 14.18 bit signed fixed point type*/
typedef dhd_int32_t        dhd_fx2_18_t;      /* 2.18 bit signed fixed point type*/
                           
typedef unsigned short     dhd_uint16_t;      /* 16 bit unsigned integer type*/
typedef short              dhd_int16_t;       /* 16 bit signed integer type*/
                           
typedef unsigned char      dhd_uint8_t;       /*  8 bit unsigned integer type*/
typedef signed char        dhd_int8_t;        /*  8 bit signed integer type*/
                           
typedef float              dhd_float32_t;     /* 32 bit float*/

/*----------------------------------------------------------------------------------------------------------*/
/**/

typedef char             dhd_char_t;        /* type for ascii string chars*/
typedef unsigned int     dhd_bool_t;        /* type for boolean parameter or return values*/
typedef unsigned int     dhd_enum_t;        /* generic type for input/output enums*/
typedef void *           dhd_handle_t;      /* generic handle type*/
typedef void *           dhd_jobid_t;       /* gpu job identifier*/
typedef void *           dhd_gpu_ptr_t;     /* pointer to video memory*/
struct        tagdhd_gpu_vidmem_block;      /* internal struct of video memory block*/

/*----------------------------------------------------------------------------------------------------------*/
/* Error codes.*/
typedef enum {
  E_DHD_OK = 0,                             /* no error (must be 0)*/
  E_DHD_ERROR,
  E_DHD_ERROR_INTERNAL,
  E_DHD_ERROR_HW_REVISION_MISMATCH,
  E_DHD_ERROR_INVALID_PTR,
  E_DHD_ERROR_INVALID_ARGUMENT,
  E_DHD_ERROR_NO_MEMORY,
  E_DHD_ERROR_NO_JOB,
  E_DHD_ERROR_NO_COUNTER,
  E_DHD_ERROR_NO_BUFFER,
  E_DHD_ERROR_NOT_SUPPORTED,
  E_DHD_ERROR_ALREADY_RUNNING,
  E_DHD_ERROR_ALREADY_LOCKED,
  E_DHD_ERROR_ACCESS_DENIED,
  E_DHD_ERROR_RESOURCE_LEAK,
  E_DHD_ERROR_SCHEDULE_FOR_WAIT,
  E_DHD_ERROR_TIMEOUT,
  E_DHD_ERROR_FATAL

} dhd_error_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Buffer lock access mode.*/
/**/
typedef enum {  
  E_DHD_READ_ACCESS = 1,
  E_DHD_WRITE_ACCESS = 2

} dhd_access_mode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Videomemory usage flags.*/
/**/
typedef enum tagdhd_memory_usage {
  E_DHD_MEMORY_GENERIC,
  E_DHD_MEMORY_STREAM,
  E_DHD_MEMORY_TEXTURE,
  E_DHD_MEMORY_TARGET,
  E_DHD_MEMORY_DUMP

} dhd_memory_usage_t;

/*----------------------------------------------------------------------------------------------------------*/
/* General information about hw device.*/
/**/
typedef struct tagdhd_device_description {
  dhd_uint32_t  m_vidmem_capacity;

  dhd_uint16_t  m_default_jobcount;                       /* copies from gpu_config*/
  dhd_uint16_t  m_default_jobsize;

  dhd_uint16_t  m_num_clut_entries;                       /* total size of CLUT memory */
  dhd_uint16_t  m_zsaread_fifo_depth;                     /* depth of the zsaread pixel FIFO*/

  dhd_uint8_t   m_force_synchronous;                      /* copy from gpu_config -> sorted here for better alignment of struct*/
  dhd_uint8_t   m_hw_version_major;                       /* HW revision*/
  dhd_uint8_t   m_hw_version_minor;
  dhd_uint8_t   m_hw_revision;
  dhd_uint8_t   m_num_tex_units;                          /* number of texture units*/
  dhd_uint8_t   m_num_col_units;                          /* number of color unit stages*/
  dhd_uint8_t   m_num_const_cols;                         /* number of constant colors*/
  dhd_uint8_t   m_num_edges;                              /* number of geometry limiters*/
  dhd_uint8_t   m_num_pipelines;                          /* number of pipelines*/
  dhd_uint8_t   m_num_perfcounters;                       /* number of HW performance counters*/
  dhd_uint8_t   m_bus_width;                              /* number of bytes in one bus word    */

} dhd_device_description_t;


/*----------------------------------------------------------------------------------------------------------*/
/* Handle for video memory allocations.*/
/**/
typedef struct tagdhd_vidmem {

  dhd_gpu_ptr_t                    m_gpu_address;          /* video memory pointer (gpu accessible)*/
  dhd_uint8_t                     *m_cpu_address;          /* only present if memory is mapped (null otherwise)*/
  struct tagdhd_gpu_vidmem_block  *m_block;                /* internal structure*/
  dhd_uint32_t                     m_size;                 /* size in bytes*/
    
} dhd_vidmem_t;


/*----------------------------------------------------------------------------------------------------------*/
/* Driver panic callback function.*/
/**/
typedef void (*dhd_panic_callback_t)(const dhd_char_t *a_message, const dhd_char_t *a_file, dhd_uint32_t a_line);

/*----------------------------------------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif 

#endif /*DAVEHD_TYPES_H_INCLUDED*/
