

#ifndef _SOUND_TRACKS_H_
#define _SOUND_TRACKS_H_
#include "r_typedefs.h"
/******************************************************************************
单一音轨最大音符数量
******************************************************************************/
#define   SND_TRACK_MAX_NOTE_NUM            4




/******************************************************************************
音符属性结构
******************************************************************************/
typedef struct
{
    uint16_t   Freq;            //声音频率(Hz),0表示静音(休止符)
    uint16_t    Duty;            //声音占空比(%)
    uint16_t   Interval;        //声音长度(ms)
    uint16_t   Fade;            //声音淡出时间(ms)
} SndTrackNoteStruct;

/******************************************************************************
音轨属性结构
******************************************************************************/
typedef struct
{
    uint8_t             NoteNum;         //总音符数
    uint8_t             PreCharge;       //预充电时间(ms),影响第一个音符的播放力度
    SndTrackNoteStruct  Note[SND_TRACK_MAX_NOTE_NUM];
} SndTrackStruct;

/******************************************************************************
音轨属性表
******************************************************************************/
static const SndTrackStruct SndTracks[] =
{
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              000 |  1000ms |  BUZZER_Track_Index_3900hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           2500,         500,      300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              001 |  500ms |  BUZZER_Track_Index_2300hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           3900,        500,       300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              002 |  500ms |  BUZZER_Track_Index_3900hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           2500,        280,       300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              003 |  500ms |  BUZZER_Track_Index_2300hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           3900,        280,       300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              004 |  500ms |  BUZZER_Track_Index_3900hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           3900,        190,       300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              005 |  500ms |  BUZZER_Track_Index_2600hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           2600,        167,       300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              006 |  500ms |  BUZZER_Track_Index_2000hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           2000,        500,       300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              007 |  500ms |  BUZZER_Track_Index_800hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            800,        500,       300,         100,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              000 |  500ms |  BUZZER_Track_Index_3900hz_500Dty
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           2380,        210,       450,           0,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              001 |  980ms |                                   2kHz淡出
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           2300,         500,       930,         850,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              002 |  550ms |                     长雷达提示音,800Hz长鸣
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            800,         500,       500,           0,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              003 |  300ms |                     中雷达提示音,800Hz长鸣
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            800,         500,       250,           0,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              004 |  175ms |                     短雷达提示音,800Hz长鸣
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            800,         500,       125,           0,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              005 |   53ms |                             转向提示音Tick
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            780,         500,         3,           0,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              006 |   52ms |                             转向提示音Tock
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            780,         250,         3,           0,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              007 |  980ms |                       通用提示音,660Hz淡出
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            660,         500,       930,         850,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              008 |  980ms |                       通用提示音,784Hz淡出
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            784,         500,       930,         850,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              009 |  980ms |                      通用提示音,1000Hz淡出
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           1000,         500,       930,         850,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              010 |  980ms |              双音提示音,1000Hz + 784Hz淡出
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        3,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */           1000,         500,       200,         150,
        /*  2  */              0,          0,        20,           0,
        /*  3  */            784,         50,       710,         620,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },

    {
        /*==============================================================
         音轨编号 | 总长度 |                  描述
        ----------+--------+--------------------------------------------
              011 |  500ms |                                  850Hz长鸣
        ----------------------------------------------------------------
         总音符数 | 预充电时间(ms) |
        --------------------------------------------------------------*/
        1,              50,
        /*--------------------------------------------------------------
         音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
        --------------------------------------------------------------*/
        /*  1  */            850,         500,       450,           0,
        /*  2  */              0,          0,         0,           0,
        /*  3  */              0,          0,         0,           0,
        /*  4  */              0,          0,         0,           0,
        /*============================================================*/
    },
};



/******************************************************************************
音轨总数
******************************************************************************/
#define   SND_TRACK_TOTAL_NUM               (sizeof(SndTracks) / sizeof(SndTrackStruct))





#endif
