#include "RTE_ADC.h"

#include "Analog_Signals.h"

void RTE_ADC_Init(void)
{
    Analog_Signal_Conv_Init();
}


/*-------------------------------------------------------------------------
 * Function Name  : RTE_ForceRead_KL15_Voltage
 * Description    : 强制读一次KL15电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_ForceRead_KL15_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Conv_Single_Channel(ADC_CH_KL30_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_ForceRead_KL30_Voltage
 * Description    : 强制读一次KL30电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_ForceRead_KL30_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Conv_Single_Channel(ADC_CH_KL30_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_KL15_Voltage
 * Description    : 读KL15电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_KL15_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_KL30_Voltage
 * Description    : 读KL30电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_KL30_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_PRIMARY_AIR_Voltage
 * Description    : 读主气压 电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_PRIMARY_AIR_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_PRIMARY_AIR_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_SECONDARY_AIR_Voltage
 * Description    : 读副气压 电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_SECONDARY_AIR_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_SECONDARY_AIR_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_WET_AIR_Voltage
 * Description    : 读WET
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_WET_AIR_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_WETAIR_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_FUEL_REF_Voltage
 * Description    : 读燃油基准电压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_FUEL_REF_Voltage(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_FUEL_REF_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_FUEL_R
 * Description    : 读燃油电阻 10倍
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_FUEL_R(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_FUEL_R);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_KEY_R
 * Description    : 读按键阻值
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_KEY_R(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_KEY);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_NTC_R
 * Description    : 读热敏电阻阻值
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t RTE_Read_NTC_R(void)
{
    uint32_t Result = 0x00ul;
    Result = ADC_Read_Signal(ADC_CH_NTC_R);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_KL15_Valid
 * Description    : 读KL15 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_KL15_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_KL30_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_KL30_Valid
 * Description    : 读KL30 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_KL30_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_KL30_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_PRIMARY_AIR_Valid
 * Description    : 读主气压 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_PRIMARY_AIR_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_PRIMARY_AIR_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_SECONDARY_AIR_Valid
 * Description    : 读副气压 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_SECONDARY_AIR_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_SECONDARY_AIR_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_FUEL_REF_Valid
 * Description    : 读燃油基准电压 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_FUEL_REF_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_FUEL_REF_VOLTAGE);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_FUEL_R_Valid
 * Description    : 读燃油电阻 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_FUEL_R_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_FUEL_R);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_KEY_R_Valid
 * Description    : 读按键 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_KEY_R_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_KEY);
    return Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_NTC_R_Valid
 * Description    : 读热敏电阻阻值 有效
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_NTC_R_Valid(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_NTC_R);
    return Result;
}

/*-------------------------------------------------------------------------
 * Function Name  : RTE_Read_WET_AIR_Value
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t RTE_Read_WET_AIR_Value(void)
{
    uint8_t Result = 0x00u;
    Result = ADC_Read_Signal_Valid(ADC_CH_WETAIR_VOLTAGE);
    return Result;
}
