/**********************************************************************************************************
* @file    loc_graphics_data.h
* @author  HZS
* @version V1.0.0
* @date    2021.04.09
* @brief   c header file
********************************************************************************************************/
#ifndef LOC_GRAPHICS_DATA_H_
#define LOC_GRAPHICS_DATA_H_

#include "loc_graphics_def.h"
#include "images.h"
#include "DisplaySch_user.h"

/*区域1 WET*/
#define MAX_WET_SUP_LAYER        20
MultiBufferSprite_t WETSpriteBuf;
uint8_t             WETIndex = 0u;
uint8_t             WETUpdate = 0u;
uint8_t             WETEn = 0u;
LogicLayerAttr_t    WETLogicLayerAttr[MAX_WET_SUP_LAYER];

/*区域1 AdBlue*/
#define MAX_ADBLUE_SUP_LAYER        10
MultiBufferSprite_t AdBlueSpriteBuf;
uint8_t             AdBlueIndex = 0u;
uint8_t             AdBlueUpdate = 0u;
uint8_t             AdBlueEn = 0u;
LogicLayerAttr_t    AdBlueLogicLayerAttr[MAX_ADBLUE_SUP_LAYER];

/*区域2 TRIP*/
#define MAX_TRIP_SUP_LAYER        10
MultiBufferSprite_t TRIPSpriteBuf;
uint8_t             TRIPIndex = 0u;
uint8_t             TRIPUpdate = 0u;
uint8_t             TRIPEn = 0u;
LogicLayerAttr_t    TRIPLogicLayerAttr[MAX_TRIP_SUP_LAYER];

/*区域2 ODO*/
#define MAX_ODO_SUP_LAYER        10
MultiBufferSprite_t ODOSpriteBuf;
uint8_t             ODOIndex = 0u;
uint8_t             ODOUpdate = 0u;
uint8_t             ODOEn = 0u;
LogicLayerAttr_t    ODOLogicLayerAttr[MAX_ODO_SUP_LAYER];

/*区域3 警告灯*/
#define MAX_WARNINGLIGHT_SUP_LAYER        10
MultiBufferSprite_t WarningLightSpriteBuf;
uint8_t             WarningLightIndex = 0u;
uint8_t             WarningLightUpdate = 0u;
uint8_t             WarningLightEn = 0u;
LogicLayerAttr_t    WarningLightLogicLayerAttr[MAX_WARNINGLIGHT_SUP_LAYER];

/*区域4 ADAS*/
#define MAX_ADAS_SUP_LAYER        15
MultiBufferSprite_t ADASSpriteBuf;
uint8_t             ADASIndex = 0u;
uint8_t             ADASUpdate = 0u;
uint8_t             ADASEn = 0u;
LogicLayerAttr_t    ADASLogicLayerAttr[MAX_ADAS_SUP_LAYER];

/*区域5 行车电脑*/
#define MAX_MULTIPURPOSE_SUP_LAYER        20
MultiBufferSprite_t MultiPurposeSpriteBuf;
uint8_t             MultiPurposeIndex = 0u;
uint8_t             MultiPurposeUpdate = 0u;
uint8_t             MultiPurposeEn = 0u;
LogicLayerAttr_t    MultiPurposeLogicLayerAttr[MAX_MULTIPURPOSE_SUP_LAYER];

/*区域6 定速巡航图标*/
#define MAX_CRUISE_SUP_LAYER        6
MultiBufferSprite_t CruiseSpriteBuf;
uint8_t             CruiseIndex = 0u;
uint8_t             CruiseUpdate = 0u;
uint8_t             CruiseEn = 0u;
LogicLayerAttr_t    CruiseLogicLayerAttr[MAX_CRUISE_SUP_LAYER];

/*区域7 挡位*/
#define MAX_GEAR_SUP_LAYER        5
MultiBufferSprite_t GearSpriteBuf;
uint8_t             GearIndex = 0u;
uint8_t             GearUpdate = 0u;
uint8_t             GearEn = 0u;
LogicLayerAttr_t    GearLogicLayerAttr[MAX_GEAR_SUP_LAYER];

/*区域8 室外温度*/
#define MAX_TEMP_SUP_LAYER        10
MultiBufferSprite_t TempSpriteBuf;
uint8_t             TempIndex = 0u;
uint8_t             TempUpdate = 0u;
uint8_t             TempEn = 0u;
LogicLayerAttr_t    TempLogicLayerAttr[MAX_TEMP_SUP_LAYER];

/*区域8 时间*/
#define MAX_TIME_SUP_LAYER        5
MultiBufferSprite_t TimeSpriteBuf;
uint8_t             TimeIndex = 0u;
uint8_t             TimeUpdate = 0u;
uint8_t             TimeEn = 0u;
LogicLayerAttr_t    TimeLogicLayerAttr[MAX_TIME_SUP_LAYER];

/*区域8 年月日*/
#define MAX_CALENDAR_SUP_LAYER        15
MultiBufferSprite_t CalendarSpriteBuf;
uint8_t             CalendarIndex = 0u;
uint8_t             CalendarUpdate = 0u;
uint8_t             CalendarEn = 0u;
LogicLayerAttr_t    CalendarLogicLayerAttr[MAX_CALENDAR_SUP_LAYER];

static const SpritesHandler_t SpriteHandler[Max_Sprite] =
{
    {WET_Sprite,          { 38, 364, 326,  60, 1}, TARGET_SDRAM, &WETSpriteBuf,          &WETIndex,          WETLogicLayerAttr,          MAX_WET_SUP_LAYER         , &WETUpdate,            &WETEn,          GUI_DisplayServices},
    {AdBlue_Sprite,       { 38, 428, 326,  48, 1}, TARGET_SDRAM, &AdBlueSpriteBuf,       &AdBlueIndex,       AdBlueLogicLayerAttr,       MAX_ADBLUE_SUP_LAYER      , &AdBlueUpdate,         &AdBlueEn,       R_NULL},
    {TRIP_Sprite,         {438, 374, 322,  48, 1}, TARGET_SDRAM, &TRIPSpriteBuf,         &TRIPIndex,         TRIPLogicLayerAttr,         MAX_TRIP_SUP_LAYER        , &TRIPUpdate,           &TRIPEn,         R_NULL},
    {ODO_Sprite,          {438, 424, 324,  42, 1}, TARGET_SDRAM, &ODOSpriteBuf,          &ODOIndex,          ODOLogicLayerAttr,          MAX_ODO_SUP_LAYER         , &ODOUpdate,            &ODOEn,          R_NULL},
    {WarningLight_Sprite, {  8,  88,  82, 264, 1}, TARGET_SDRAM, &WarningLightSpriteBuf, &WarningLightIndex, WarningLightLogicLayerAttr, MAX_WARNINGLIGHT_SUP_LAYER, &WarningLightUpdate,   &WarningLightEn, R_NULL},
    {ADAS_Sprite,         {112,  94, 254, 260, 1}, TARGET_SDRAM, &ADASSpriteBuf,         &ADASIndex,         ADASLogicLayerAttr,         MAX_ADAS_SUP_LAYER        , &ADASUpdate,           &ADASEn,         R_NULL},
    {MultiPurpose_Sprite, {382, 182, 410, 170, 1}, TARGET_SDRAM, &MultiPurposeSpriteBuf, &MultiPurposeIndex, MultiPurposeLogicLayerAttr, MAX_MULTIPURPOSE_SUP_LAYER, &MultiPurposeUpdate ,  &MultiPurposeEn, R_NULL},
    {Cruise_Sprite,       {382,  84, 230,  92, 1}, TARGET_SDRAM, &CruiseSpriteBuf,       &CruiseIndex,       CruiseLogicLayerAttr,       MAX_CRUISE_SUP_LAYER      , &CruiseUpdate,         &CruiseEn,       R_NULL},
    {Gear_Sprite,         {622,  86, 170,  94, 1}, TARGET_SDRAM, &GearSpriteBuf,         &GearIndex,         GearLogicLayerAttr,         MAX_GEAR_SUP_LAYER        , &GearUpdate,           &GearEn,         R_NULL},
    {Temp_Sprite,         { 26,  12, 258,  70, 1}, TARGET_SDRAM, &TempSpriteBuf,         &TempIndex,         TempLogicLayerAttr,         MAX_TEMP_SUP_LAYER        , &TempUpdate,           &TempEn,         R_NULL},
    {Time_Sprite,         {330,  14, 140,  66, 1}, TARGET_SDRAM, &TimeSpriteBuf,         &TimeIndex,         TimeLogicLayerAttr,         MAX_TIME_SUP_LAYER        , &TimeUpdate,           &TimeEn,         R_NULL},
    {Calendar_Sprite,     {508,  16, 284,  64, 1}, TARGET_SDRAM, &CalendarSpriteBuf,     &CalendarIndex,     CalendarLogicLayerAttr,     MAX_CALENDAR_SUP_LAYER    , &CalendarUpdate,       &CalendarEn,     R_NULL},
};

/*AutoCreateEnd*/
static const r_screen_attr_t ScreenAttr =
{
    800, 480, 896,      /* JEPG Window*/
    800, 480, 896,      /* Loc Window*/
    5,                  /* 刷新时间，50ms*/
    12,                 /* 主屏幕Sprite数量*/
    Max_Sprite,         /* 全部Sprite数量*/
    SpriteSize          /* 最大的图片数量*/
};

#endif