
#ifndef GAUGES_INTERFACE_H_
#define GAUGES_INTERFACE_H_


#include "Gauges.h"

typedef enum
{
    VehGauges = 0u,
    RevGauges,
    TempGauges,
    PRIGasGauges, /*PRI气压*/
    SECGasGauges, /*SEC气压*/
    WETGasGauges, /*WET气压*/
    VoltGauges ,  /*电压计*/
    GaugesTotal,
} _GaugesNum;

extern _GaugesInfoInit GaugesInfo_Init_Table[GaugesTotal];
extern const uint16_t SeftTest_Gauges_Times[GaugesTotal];
typedef struct
{
    uint16_t Count;
    uint16_t DataBuf[15];
    uint16_t DataDisplay;
    uint8_t  Valid;
    uint16_t LostTimer;
    uint8_t  Status;
} DataStruct;

extern DataStruct DataStrGas1;
extern DataStruct DataStrGas2;
extern DataStruct DataStrVoltage;


extern uint16_t      RealDataIn[GaugesTotal];
extern void SetGaugesPara(uint8_t GaugesID, uint16_t GaugesVal); /* 传递表头参数 */
extern void UserGaugeSchedule(void);/*在主循环中调用*/
extern void UserGaugeK30Init(void);/*30电调用*/
extern void UserGaugeK15Init(void) ;/*15电调用*/
extern uint16_t VehSpeedAmplification(uint16_t Speed);/* 车速放大函数 */
extern uint16_t RevSpeedManage(uint16_t Speed);/* 转速数据处理数据 */
extern uint16_t GetGaugesMaxOutVal(uint8_t GaugesID);/*传递表头ID获取仪表最大指示值*/
extern void SetGaugesUpVal(uint8_t GaugesID, uint16_t GaugesUpVal[]); /*调表设置参数用*/
extern void SetGaugesDownVal(uint8_t GaugesID, uint16_t GaugesDownVal[]); /*调表设置参数用*/
extern void SetGaugesOutVal(uint8_t GaugesID, uint16_t GaugesOutVal[]); /*调表设置参数用*/

/**以下为GaugesDataAnalysis.c中函数声明不同仪表不同用户自己定义**/
/*设置FreeMoveType模式仪表走动时间*/
extern void SetFreeMoveTimes(uint16_t GaugesMoveTimes);
/*通过车速目标步得到实际车速*/
extern uint16_t GetVehDisVal(uint16_t VehCurPos, _GaugesInfoInit *GParam);
/*车速频率计算初始化*/
extern void Veh_Fre_Init(uint32_t PPK);
/*计算周期*/
extern void Cal_Veh_Cycle(uint8_t VehInput);
/*计算车速频率*/
extern uint16_t Cal_Veh_Fre(void);
/*通过频率计算车速*/
extern uint16_t Cal_Veh_Val(void);

extern uint16_t Cal_Veh_Frequency(void) ;

extern void App_SortNByte(uint16_t *SortData, uint8_t len);

extern void Fre_SortShort(volatile uint32_t SortData[], uint8_t len);

#endif