#ifndef _SERVICE_TPMS_H_
#define _SERVICE_TPMS_H_

#include "TYW_stdint.h"

/******************************************************************************
VC66对应关系

        []           []              No1

        []           []              No2
        
        [] []     [] []              No3

        [] []     [] []              No4


TPMS    FirstLOutID                   左前轮(No1)           
        FirstROutID                   右前轮(No1)           
        SecondLInID                   左中前轮(No2)
        SecondRInID                   右中前轮(No2)
        ThirdLOutID                   左中后轮_外侧(No3)
        ThirdLInID                    左中后轮_内侧(No3)
        ThirdRInID                    右中后轮_内侧(No3)
        ThirdROutID                   右中后轮_外侧(No3)
        FourthLOutID                  左后轮_外侧(No4)
        FourthLInID                   左后轮_内侧(No4)
        FourthRInID                   右后轮_内侧(No4)
        FourthROutID                  右后轮_外侧(No4)
        
            
******************************************************************************/

#define     FirstLOutID     0x12u    
#define     FirstROutID     0x13u
#define     SecondLInID     0x22u
#define     SecondRInID     0x23u
#define     ThirdLOutID     0x31u
#define     ThirdLInID      0x32u
#define     ThirdRInID      0x33u
#define     ThirdROutID     0x34u
#define     FourthLOutID    0x41u
#define     FourthLInID     0x42u
#define     FourthRInID     0x43u
#define     FourthROutID    0x44u



#define     TYRETEMP_OFFSET_VALUE     (273u)  /*胎温数据偏移量*/

typedef enum
{
    FirstLOut       =       0   , 
    FirstROut                   ,
    SecondLIn                   ,
    SecondRIn                   ,
    ThirdLOut                   ,
    ThirdLIn                    ,
    ThirdRIn                    ,
    ThirdROut                   ,
    FourthLOut                  ,
    FourthLIn                   ,
    FourthRIn                   ,
    FourthROut                  ,

    TPMSNumMax                  ,
} TPMSNUM_t;

typedef enum
{
    SOLID_GRAY          =    0  ,
    WHITEBOX_GRAY               ,
    YELLOW_FLASH                ,
    SOLID_GREEN                 ,
}en_TPMSGUI;



typedef struct
{
    uint8_t  TPMSTyreID                     ; /*轮胎位置            */
    uint16_t TPMSPressure                   ; /*轮胎气压            */
    uint8_t  TPMSTemp                       ; /*轮胎温度            */
    uint8_t  TPMSTempSign                   ; /*轮胎温度正负        */
    uint8_t  TPMSLowpressure                ; /*低气压报警          */
    uint8_t  TPMSHighpressure               ; /*高气压报警          */
    uint8_t  TPMSHightemperature            ; /*高温报警            */
    uint8_t  TPMSRapidleakage               ; /*快速漏气报警        */
    uint8_t  TPMSLowvoltage                 ; /*低电压报警          */
    uint8_t  TPMSNosignal                   ; /*无信号报警           */
    uint8_t  TPMSSensorfault                ; /*传感器故障信息       */

    uint8_t  TPMSPressureThresholdDetection ; /*压力检测            */
    uint8_t  TPMSStandarTempSetSts          ; /*轮胎标准温度设置状态  */
    uint8_t  TPMSInvaliddata                ; /*标识报警信号的有效性  */
    uint8_t  TPMSDataupdating               ; /*数据有效性           */
    
    
    
    
    
    
    
    //uint8_t  TPMSLostWarningSig             ; /*轮胎被盗报警信号      */
    //uint8_t  TPMSTemporaryNoSignal          ; /*短时无信号           */ 
    //uint8_t  TPMSTempSigStat                ; /*轮胎温度符号状态      */
    uint16_t TPMSDataInvalidTime              ; /*数据无效计时器       */
    //uint16_t TPMSValueSta                   ; /*数据返回状态         */

    uint8_t CurPoxID                          ; /*当前光标位置*/
    en_TPMSGUI TPMSGuiSta                     ; /*轮子显示状态*/
    uint8_t PairSuccess                       ;
    uint8_t PairEn                            ;
    uint8_t PairTimer                         ;
    uint8_t PairCmd                           ; /*TxID 18033317 Byte1*/
    uint8_t TireNumber                        ; /*TxID 18033317 Byte2*/



} _USER_TPMS;

extern _USER_TPMS TPMS_Out[TPMSNumMax];

void Data_TPMS_KL30_Init(void);
void Data_TPMS_KL15_ON_Init(void);

void Get_Data_TPMS_Value(TPMSNUM_t TPMSTyreID);
void Get_Data_TPMS_Status(TPMSNUM_t TPMSTyreID);
void Get_Data_TPMS_Pair(TPMSNUM_t TPMSTyreID);

void Data_TPMS_Value_Processing(void );

uint16_t Get_DataTPMS_Pressure_Value(TPMSNUM_t TPMSTyreID);
uint16_t Get_DataTPMS_Pressure_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Pressure_FLashSta(TPMSNUM_t TPMSTyreID);

uint16_t Get_DataTPMS_Temp_Value(TPMSNUM_t TPMSTyreID);
uint16_t Get_DataTPMS_Temp_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Temp_FLashSta(TPMSNUM_t TPMSTyreID);

uint16_t Get_DataTPMS_Leakrate_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Highpressure_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Lowpressure_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_SensorErrorWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TyresLostWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_SensorVoltWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TireStandarPressureSettingSts_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TireStandarTemperatureSettingSts_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_RapidLeakWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TyreTempWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TemporaryNoSignal_Value(TPMSNUM_t TPMSTyreID);


uint8_t Get_DataTPMS_Tyre_Red_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Tyre_FLASH_Sta(TPMSNUM_t TPMSTyreID);

/*key 调用*/
extern void ChooseKey_TPMS_Event(TPMSNUM_t TPMSTyreID);
extern void EnterKey_TPMS_Event(TPMSNUM_t TPMSTyreID);
extern void ReturnKey_TPMS_Event(TPMSNUM_t TPMSTyreID);

/*Gui 调用*/
/*轮子的式样 
SOLID_GRAY      -   全灰色
WHITEBOX_GRAY   -   灰色白框
YELLOW_FLASH    -   黄色闪烁
SOLID_GREEN     -   绿色
*/
extern en_TPMSGUI Get_TPMSSetGui_Sta(TPMSNUM_t TPMSTyreID);
/*
配对状态  0 - 失败  1 - 成功
*/
extern uint8_t Get_PairSuccess(TPMSNUM_t TPMSTyreID);

#endif